/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.AtomicBooleanDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.AtomicIntegerDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.AtomicLongDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.ByteBufferDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StackTraceElementDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.UUIDDeserializer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    @Deprecated
    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        return JdkDeserializers.find(null, clazz, string);
    }

    public static JsonDeserializer<?> find(DeserializationContext deserializationContext, Class<?> clazz, String fromStringDeserializer) {
        if (_classNames.contains(fromStringDeserializer)) {
            fromStringDeserializer = FromStringDeserializer.findDeserializer(clazz);
            if (fromStringDeserializer != null) {
                return fromStringDeserializer;
            }
            if (clazz == UUID.class) {
                return new UUIDDeserializer();
            }
            if (clazz == StackTraceElement.class) {
                return StackTraceElementDeserializer.construct(deserializationContext);
            }
            if (clazz == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (clazz == AtomicInteger.class) {
                return new AtomicIntegerDeserializer();
            }
            if (clazz == AtomicLong.class) {
                return new AtomicLongDeserializer();
            }
            if (clazz == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (clazz == Void.class) {
                return NullifyingDeserializer.instance;
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> clazz) {
        return _classNames.contains(clazz.getName());
    }

    static {
        int n2;
        _classNames = new HashSet();
        int n3 = 7;
        Class[] classArray = new Class[7];
        Class[] classArray2 = classArray;
        classArray[0] = UUID.class;
        classArray[1] = AtomicBoolean.class;
        classArray[2] = AtomicInteger.class;
        classArray[3] = AtomicLong.class;
        classArray[4] = StackTraceElement.class;
        classArray[5] = ByteBuffer.class;
        classArray[6] = Void.class;
        for (n2 = 0; n2 < n3; ++n2) {
            _classNames.add(classArray2[n2].getName());
        }
        Class<?>[] classArray3 = FromStringDeserializer.types();
        int n4 = classArray3.length;
        for (n2 = 0; n2 < n4; ++n2) {
            _classNames.add(classArray3[n2].getName());
        }
    }
}

