/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.deser.CreatorProperty;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import java.io.Serializable;

public class JsonLocationInstantiator
extends ValueInstantiator.Base {
    private static final long serialVersionUID = 1L;

    public JsonLocationInstantiator() {
        super(JsonLocation.class);
    }

    private static CreatorProperty creatorProp(String object, JavaType javaType, int n2) {
        PropertyName propertyName = PropertyName.construct((String)object);
        object = PropertyMetadata.STD_REQUIRED;
        return CreatorProperty.construct(propertyName, javaType, null, null, null, null, n2, null, (PropertyMetadata)object);
    }

    private static final long _long(Object object) {
        return object == null ? 0L : ((Number)object).longValue();
    }

    private static final int _int(Object object) {
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        DeserializationConfig deserializationConfig2 = deserializationConfig;
        Serializable serializable = deserializationConfig2.constructType(Integer.TYPE);
        JavaType javaType = deserializationConfig2.constructType(Long.TYPE);
        return new SettableBeanProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", deserializationConfig.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", javaType, 1), JsonLocationInstantiator.creatorProp("charOffset", javaType, 2), JsonLocationInstantiator.creatorProp("lineNr", (JavaType)serializable, 3), JsonLocationInstantiator.creatorProp("columnNr", (JavaType)serializable, 4)};
    }

    @Override
    public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) {
        Serializable serializable = ContentReference.rawReference(objectArray[0]);
        long l2 = JsonLocationInstantiator._long(objectArray[1]);
        long l3 = JsonLocationInstantiator._long(objectArray[2]);
        int n2 = JsonLocationInstantiator._int(objectArray[3]);
        int n3 = JsonLocationInstantiator._int(objectArray[4]);
        return new JsonLocation((ContentReference)serializable, l2, l3, n2, n3);
    }
}

