/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import java.util.AbstractMap;
import java.util.Map;

@JacksonStdImpl
public class MapEntryDeserializer
extends ContainerDeserializerBase<Map.Entry<Object, Object>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final KeyDeserializer _keyDeserializer;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public MapEntryDeserializer(JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType);
        if (javaType.containedTypeCount() == 2) {
            MapEntryDeserializer mapEntryDeserializer = this;
            mapEntryDeserializer._keyDeserializer = keyDeserializer;
            mapEntryDeserializer._valueDeserializer = jsonDeserializer;
            mapEntryDeserializer._valueTypeDeserializer = typeDeserializer;
            return;
        }
        throw new IllegalArgumentException("Missing generic type information for " + javaType);
    }

    public MapEntryDeserializer(MapEntryDeserializer mapEntryDeserializer) {
        super(mapEntryDeserializer);
        this._keyDeserializer = mapEntryDeserializer._keyDeserializer;
        this._valueDeserializer = mapEntryDeserializer._valueDeserializer;
        this._valueTypeDeserializer = mapEntryDeserializer._valueTypeDeserializer;
    }

    public MapEntryDeserializer(MapEntryDeserializer mapEntryDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(mapEntryDeserializer);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
    }

    public MapEntryDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        if (this._keyDeserializer == keyDeserializer && this._valueDeserializer == jsonDeserializer && this._valueTypeDeserializer == typeDeserializer) {
            return this;
        }
        return new MapEntryDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext jsonDeserializer, BeanProperty beanProperty) {
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = ((DeserializationContext)((Object)jsonDeserializer)).findKeyDeserializer(this._containerType.containedType(0), beanProperty);
        } else if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual((DeserializationContext)((Object)jsonDeserializer), beanProperty);
        }
        Object object = this.findConvertingContentDeserializer((DeserializationContext)((Object)jsonDeserializer), beanProperty, this._valueDeserializer);
        JavaType javaType = this._containerType.containedType(1);
        jsonDeserializer = object == null ? ((DeserializationContext)((Object)jsonDeserializer)).findContextualValueDeserializer(javaType, beanProperty) : ((DeserializationContext)((Object)jsonDeserializer)).handleSecondaryContextualization((JsonDeserializer<?>)object, beanProperty, javaType);
        object = this._valueTypeDeserializer;
        if (object != null) {
            object = ((TypeDeserializer)object).forProperty(beanProperty);
        }
        return this.withResolved(keyDeserializer, (TypeDeserializer)object, jsonDeserializer);
    }

    @Override
    public JavaType getContentType() {
        return this._containerType.containedType(1);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext objectArray) {
        Object object;
        Object object2;
        Object object3;
        block9: {
            Exception exception2;
            String string;
            block8: {
                Object object4;
                object3 = jsonParser.currentToken();
                if (object3 == JsonToken.START_OBJECT) {
                    object3 = jsonParser.nextToken();
                } else if (object3 != JsonToken.FIELD_NAME && object3 != JsonToken.END_OBJECT) {
                    if (object3 != JsonToken.START_ARRAY) return (Map.Entry)objectArray.handleUnexpectedToken(this.getValueType((DeserializationContext)objectArray), jsonParser);
                    return (Map.Entry)this._deserializeFromArray(jsonParser, (DeserializationContext)objectArray);
                }
                if (object3 != JsonToken.FIELD_NAME) {
                    if (object3 != JsonToken.END_OBJECT) return (Map.Entry)objectArray.handleUnexpectedToken(this.handledType(), jsonParser);
                    return (Map.Entry)objectArray.reportInputMismatch(this, "Cannot deserialize a Map.Entry out of empty JSON Object", new Object[0]);
                }
                MapEntryDeserializer mapEntryDeserializer = this;
                object3 = mapEntryDeserializer._valueDeserializer;
                TypeDeserializer typeDeserializer = mapEntryDeserializer._valueTypeDeserializer;
                string = jsonParser.currentName();
                object2 = this._keyDeserializer.deserializeKey(string, (DeserializationContext)objectArray);
                object = null;
                try {
                    object4 = jsonParser.nextToken() == JsonToken.VALUE_NULL ? ((JsonDeserializer)object3).getNullValue((DeserializationContext)objectArray) : (typeDeserializer == null ? ((JsonDeserializer)object3).deserialize(jsonParser, (DeserializationContext)objectArray) : ((JsonDeserializer)object3).deserializeWithType(jsonParser, (DeserializationContext)objectArray, typeDeserializer));
                }
                catch (Exception exception2) {
                    break block8;
                }
                object = object3 = object4;
                break block9;
            }
            this.wrapAndThrow((DeserializationContext)objectArray, exception2, Map.Entry.class, string);
        }
        object3 = jsonParser.nextToken();
        if (object3 == JsonToken.END_OBJECT) return new AbstractMap.SimpleEntry<Object, JsonToken>(object2, (JsonToken)((Object)object));
        if (object3 == JsonToken.FIELD_NAME) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = jsonParser.currentName();
            objectArray2.reportInputMismatch(this, "Problem binding JSON into Map.Entry: more than one entry in JSON (second field: '%s')", objectArray);
            return null;
        }
        objectArray.reportInputMismatch(this, "Problem binding JSON into Map.Entry: unexpected content after JSON Object entry: " + (Object)object3, new Object[0]);
        return null;
    }

    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Map.Entry<Object, Object> entry) {
        throw new IllegalStateException("Cannot update Map.Entry values");
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }
}

