/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.m;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;

public class NumberDeserializers {
    private static final HashSet<String> _classNames = new HashSet();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return IntegerDeserializer.primitiveInstance;
            }
            if (clazz == Boolean.TYPE) {
                return BooleanDeserializer.primitiveInstance;
            }
            if (clazz == Long.TYPE) {
                return LongDeserializer.primitiveInstance;
            }
            if (clazz == Double.TYPE) {
                return DoubleDeserializer.primitiveInstance;
            }
            if (clazz == Character.TYPE) {
                return CharacterDeserializer.primitiveInstance;
            }
            if (clazz == Byte.TYPE) {
                return ByteDeserializer.primitiveInstance;
            }
            if (clazz == Short.TYPE) {
                return ShortDeserializer.primitiveInstance;
            }
            if (clazz == Float.TYPE) {
                return FloatDeserializer.primitiveInstance;
            }
            if (clazz != Void.TYPE) throw new IllegalArgumentException("Internal error: can't find deserializer for ".concat(clazz.getName()));
            return NullifyingDeserializer.instance;
        }
        if (!_classNames.contains(string)) return null;
        if (clazz == Integer.class) {
            return IntegerDeserializer.wrapperInstance;
        }
        if (clazz == Boolean.class) {
            return BooleanDeserializer.wrapperInstance;
        }
        if (clazz == Long.class) {
            return LongDeserializer.wrapperInstance;
        }
        if (clazz == Double.class) {
            return DoubleDeserializer.wrapperInstance;
        }
        if (clazz == Character.class) {
            return CharacterDeserializer.wrapperInstance;
        }
        if (clazz == Byte.class) {
            return ByteDeserializer.wrapperInstance;
        }
        if (clazz == Short.class) {
            return ShortDeserializer.wrapperInstance;
        }
        if (clazz == Float.class) {
            return FloatDeserializer.wrapperInstance;
        }
        if (clazz == Number.class) {
            return NumberDeserializer.instance;
        }
        if (clazz == BigDecimal.class) {
            return BigDecimalDeserializer.instance;
        }
        if (clazz != BigInteger.class) throw new IllegalArgumentException("Internal error: can't find deserializer for ".concat(clazz.getName()));
        return BigIntegerDeserializer.instance;
    }

    static {
        int n2 = 11;
        Class[] classArray = new Class[11];
        Class[] classArray2 = classArray;
        classArray[0] = Boolean.class;
        classArray[1] = Byte.class;
        classArray[2] = Short.class;
        classArray[3] = Character.class;
        classArray[4] = Integer.class;
        classArray[5] = Long.class;
        classArray[6] = Float.class;
        classArray[7] = Double.class;
        classArray[8] = Number.class;
        classArray[9] = BigDecimal.class;
        classArray[10] = BigInteger.class;
        for (int i2 = 0; i2 < n2; ++i2) {
            _classNames.add(classArray2[i2].getName());
        }
    }

    @JacksonStdImpl
    public static final class IntegerDeserializer
    extends PrimitiveOrWrapperDeserializer<Integer> {
        private static final long serialVersionUID = 1L;
        static final IntegerDeserializer primitiveInstance = new IntegerDeserializer(Integer.TYPE, 0);
        static final IntegerDeserializer wrapperInstance = new IntegerDeserializer(Integer.class, null);

        public IntegerDeserializer(Class<Integer> clazz, Integer n2) {
            IntegerDeserializer integerDeserializer = serializable;
            Serializable serializable = Integer.valueOf(0);
            super(clazz, LogicalType.Integer, n2, serializable);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getIntValue();
            }
            if (this._primitive) {
                return this._parseIntPrimitive(jsonParser, deserializationContext);
            }
            return this._parseInteger(jsonParser, deserializationContext, Integer.class);
        }

        @Override
        public Integer deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getIntValue();
            }
            if (this._primitive) {
                return this._parseIntPrimitive(jsonParser, deserializationContext);
            }
            return this._parseInteger(jsonParser, deserializationContext, Integer.class);
        }
    }

    @JacksonStdImpl
    public static final class BooleanDeserializer
    extends PrimitiveOrWrapperDeserializer<Boolean> {
        private static final long serialVersionUID = 1L;
        static final BooleanDeserializer primitiveInstance = new BooleanDeserializer(Boolean.TYPE, Boolean.FALSE);
        static final BooleanDeserializer wrapperInstance = new BooleanDeserializer(Boolean.class, null);

        public BooleanDeserializer(Class<Boolean> clazz, Boolean bl) {
            BooleanDeserializer booleanDeserializer = serializable;
            Serializable serializable = Boolean.FALSE;
            super(clazz, LogicalType.Boolean, bl, serializable);
        }

        @Override
        public Boolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            JsonToken jsonToken = jsonParser.currentToken();
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (this._primitive) {
                return this._parseBooleanPrimitive(jsonParser, deserializationContext);
            }
            return this._parseBoolean(jsonParser, deserializationContext, this._valueClass);
        }

        @Override
        public Boolean deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer object) {
            object = jsonParser.currentToken();
            if (object == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (object == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (this._primitive) {
                return this._parseBooleanPrimitive(jsonParser, deserializationContext);
            }
            return this._parseBoolean(jsonParser, deserializationContext, this._valueClass);
        }
    }

    @JacksonStdImpl
    public static final class LongDeserializer
    extends PrimitiveOrWrapperDeserializer<Long> {
        private static final long serialVersionUID = 1L;
        static final LongDeserializer primitiveInstance = new LongDeserializer(Long.TYPE, 0L);
        static final LongDeserializer wrapperInstance = new LongDeserializer(Long.class, null);

        public LongDeserializer(Class<Long> clazz, Long l2) {
            LongDeserializer longDeserializer = serializable;
            Serializable serializable = Long.valueOf(0L);
            super(clazz, LogicalType.Integer, l2, serializable);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Long deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getLongValue();
            }
            if (this._primitive) {
                return this._parseLongPrimitive(jsonParser, deserializationContext);
            }
            return this._parseLong(jsonParser, deserializationContext, Long.class);
        }
    }

    @JacksonStdImpl
    public static class DoubleDeserializer
    extends PrimitiveOrWrapperDeserializer<Double> {
        private static final long serialVersionUID = 1L;
        static final DoubleDeserializer primitiveInstance = new DoubleDeserializer(Double.TYPE, 0.0);
        static final DoubleDeserializer wrapperInstance = new DoubleDeserializer(Double.class, null);

        public DoubleDeserializer(Class<Double> clazz, Double d2) {
            DoubleDeserializer doubleDeserializer = serializable;
            Serializable serializable = Double.valueOf(0.0);
            super(clazz, LogicalType.Float, d2, serializable);
        }

        @Override
        public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return jsonParser.getDoubleValue();
            }
            if (this._primitive) {
                return this._parseDoublePrimitive(jsonParser, deserializationContext);
            }
            return this._parseDouble(jsonParser, deserializationContext);
        }

        @Override
        public Double deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return jsonParser.getDoubleValue();
            }
            if (this._primitive) {
                return this._parseDoublePrimitive(jsonParser, deserializationContext);
            }
            return this._parseDouble(jsonParser, deserializationContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) {
            Object object;
            int n2 = jsonParser.currentTokenId();
            if (n2 != 1) {
                if (n2 == 3) return (Double)this._deserializeFromArray(jsonParser, deserializationContext);
                if (n2 == 11) return (Double)this.getNullValue(deserializationContext);
                switch (n2) {
                    default: {
                        return (Double)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                    }
                    case 7: {
                        CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                        if (coercionAction == CoercionAction.AsNull) {
                            return (Double)this.getNullValue(deserializationContext);
                        }
                        if (coercionAction == CoercionAction.AsEmpty) {
                            return (Double)this.getEmptyValue(deserializationContext);
                        }
                    }
                    case 8: {
                        return jsonParser.getDoubleValue();
                    }
                    case 6: 
                }
                object = jsonParser.getText();
            } else {
                object = this._valueClass;
                object = deserializationContext.extractScalarFromObject(jsonParser, this, (Class<?>)object);
            }
            Double d2 = this._checkDoubleSpecialValue((String)object);
            if (d2 != null) {
                return d2;
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Double)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Double)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
                return (Double)this.getNullValue(deserializationContext);
            }
            try {
                return StdDeserializer._parseDouble((String)object, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Double)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid `Double` value", new Object[0]);
            }
        }
    }

    @JacksonStdImpl
    public static class CharacterDeserializer
    extends PrimitiveOrWrapperDeserializer<Character> {
        private static final long serialVersionUID = 1L;
        static final CharacterDeserializer primitiveInstance = new CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000'));
        static final CharacterDeserializer wrapperInstance = new CharacterDeserializer(Character.class, null);

        public CharacterDeserializer(Class<Character> clazz, Character c2) {
            CharacterDeserializer characterDeserializer = serializable;
            Serializable serializable = Character.valueOf('\u0000');
            super(clazz, LogicalType.Integer, c2, serializable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Character deserialize(JsonParser object, DeserializationContext deserializationContext) {
            block16: {
                int n2 = ((JsonParser)object).currentTokenId();
                if (n2 != 1) {
                    if (n2 == 3) {
                        return (Character)objectArray._deserializeFromArray((JsonParser)object, deserializationContext);
                    }
                    if (n2 != 11) {
                        if (n2 != 6) {
                            if (n2 != 7) {
                                return (Character)deserializationContext.handleUnexpectedToken(objectArray.getValueType(deserializationContext), (JsonParser)object);
                            }
                            CharacterDeserializer characterDeserializer = objectArray;
                            Enum enum_ = characterDeserializer.logicalType();
                            Class<?> clazz = characterDeserializer._valueClass;
                            int n3 = m.a[(enum_ = deserializationContext.findCoercionAction((LogicalType)enum_, clazz, CoercionInputShape.Integer)).ordinal()];
                            if (n3 != 1) {
                                if (n3 == 2) return (Character)objectArray.getNullValue(deserializationContext);
                                if (n3 == 3) {
                                    return (Character)objectArray.getEmptyValue(deserializationContext);
                                }
                                int n4 = ((JsonParser)object).getIntValue();
                                if (n4 >= 0 && n4 <= 65535) {
                                    return Character.valueOf((char)n4);
                                }
                                Object[] objectArray = objectArray.handledType();
                                Integer n5 = n4;
                                Serializable serializable = objectArray;
                                objectArray = new Object[]{};
                                return (Character)deserializationContext.handleWeirdNumberValue((Class<?>)serializable, n5, "value outside valid Character range (0x0000 - 0xFFFF)", objectArray);
                            } else {
                                Class<?> clazz2 = objectArray._valueClass;
                                Number number = ((JsonParser)object).getNumberValue();
                                object = "Integer value (" + ((JsonParser)object).getText() + ")";
                                objectArray._checkCoercionFail(deserializationContext, (CoercionAction)enum_, clazz2, number, (String)object);
                            }
                            return (Character)objectArray.getNullValue(deserializationContext);
                        }
                        object = ((JsonParser)object).getText();
                        break block16;
                    } else {
                        if (!objectArray._primitive) return (Character)objectArray.getNullValue(deserializationContext);
                        objectArray._verifyNullForPrimitive(deserializationContext);
                        return (Character)objectArray.getNullValue(deserializationContext);
                    }
                }
                Class<?> clazz = objectArray._valueClass;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)objectArray, clazz);
            }
            if (((String)object).length() == 1) {
                return Character.valueOf(((String)object).charAt(0));
            }
            CoercionAction coercionAction = objectArray._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Character)objectArray.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Character)objectArray.getEmptyValue(deserializationContext);
            }
            if (!objectArray._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) return (Character)deserializationContext.handleWeirdStringValue(objectArray.handledType(), (String)object, "Expected either Integer value code or 1-character String", new Object[0]);
            return (Character)objectArray.getNullValue(deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class ByteDeserializer
    extends PrimitiveOrWrapperDeserializer<Byte> {
        private static final long serialVersionUID = 1L;
        static final ByteDeserializer primitiveInstance = new ByteDeserializer(Byte.TYPE, (byte)0);
        static final ByteDeserializer wrapperInstance = new ByteDeserializer(Byte.class, null);

        public ByteDeserializer(Class<Byte> clazz, Byte by) {
            ByteDeserializer byteDeserializer = serializable;
            Serializable serializable = Byte.valueOf((byte)0);
            super(clazz, LogicalType.Integer, by, serializable);
        }

        @Override
        public Byte deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getByteValue();
            }
            if (this._primitive) {
                return this._parseBytePrimitive(jsonParser, deserializationContext);
            }
            return this._parseByte(jsonParser, deserializationContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Byte _parseByte(JsonParser object, DeserializationContext deserializationContext) {
            int n2 = ((JsonParser)object).currentTokenId();
            if (n2 != 1) {
                if (n2 == 3) return (Byte)this._deserializeFromArray((JsonParser)object, deserializationContext);
                if (n2 == 11) return (Byte)this.getNullValue(deserializationContext);
                switch (n2) {
                    default: {
                        return (Byte)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                    }
                    case 8: {
                        CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                        if (coercionAction == CoercionAction.AsNull) {
                            return (Byte)this.getNullValue(deserializationContext);
                        }
                        if (coercionAction != CoercionAction.AsEmpty) return ((JsonParser)object).getByteValue();
                        return (Byte)this.getEmptyValue(deserializationContext);
                    }
                    case 7: {
                        return ((JsonParser)object).getByteValue();
                    }
                    case 6: 
                }
                object = ((JsonParser)object).getText();
            } else {
                Class<?> clazz = this._valueClass;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, clazz);
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Byte)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Byte)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
                return (Byte)this.getNullValue(deserializationContext);
            }
            try {
                int n3 = NumberInput.parseInt((String)object);
                if (!this._byteOverflow(n3)) return (byte)n3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid Byte value", new Object[0]);
            }
            return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "overflow, value cannot be represented as 8-bit value", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static class ShortDeserializer
    extends PrimitiveOrWrapperDeserializer<Short> {
        private static final long serialVersionUID = 1L;
        static final ShortDeserializer primitiveInstance = new ShortDeserializer(Short.TYPE, (short)0);
        static final ShortDeserializer wrapperInstance = new ShortDeserializer(Short.class, null);

        public ShortDeserializer(Class<Short> clazz, Short s2) {
            ShortDeserializer shortDeserializer = serializable;
            Serializable serializable = Short.valueOf((short)0);
            super(clazz, LogicalType.Integer, s2, serializable);
        }

        @Override
        public Short deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getShortValue();
            }
            if (this._primitive) {
                return this._parseShortPrimitive(jsonParser, deserializationContext);
            }
            return this._parseShort(jsonParser, deserializationContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Short _parseShort(JsonParser object, DeserializationContext deserializationContext) {
            int n2 = ((JsonParser)object).currentTokenId();
            if (n2 != 1) {
                if (n2 == 3) return (Short)this._deserializeFromArray((JsonParser)object, deserializationContext);
                if (n2 == 11) return (Short)this.getNullValue(deserializationContext);
                switch (n2) {
                    default: {
                        return (Short)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                    }
                    case 8: {
                        CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                        if (coercionAction == CoercionAction.AsNull) {
                            return (Short)this.getNullValue(deserializationContext);
                        }
                        if (coercionAction != CoercionAction.AsEmpty) return ((JsonParser)object).getShortValue();
                        return (Short)this.getEmptyValue(deserializationContext);
                    }
                    case 7: {
                        return ((JsonParser)object).getShortValue();
                    }
                    case 6: 
                }
                object = ((JsonParser)object).getText();
            } else {
                Class<?> clazz = this._valueClass;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, clazz);
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Short)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Short)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
                return (Short)this.getNullValue(deserializationContext);
            }
            try {
                int n3 = NumberInput.parseInt((String)object);
                if (!this._shortOverflow(n3)) return (short)n3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid Short value", new Object[0]);
            }
            return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "overflow, value cannot be represented as 16-bit value", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static class FloatDeserializer
    extends PrimitiveOrWrapperDeserializer<Float> {
        private static final long serialVersionUID = 1L;
        static final FloatDeserializer primitiveInstance = new FloatDeserializer(Float.TYPE, Float.valueOf(0.0f));
        static final FloatDeserializer wrapperInstance = new FloatDeserializer(Float.class, null);

        public FloatDeserializer(Class<Float> clazz, Float f2) {
            FloatDeserializer floatDeserializer = serializable;
            Serializable serializable = Float.valueOf(0.0f);
            super(clazz, LogicalType.Float, f2, serializable);
        }

        @Override
        public Float deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return Float.valueOf(jsonParser.getFloatValue());
            }
            if (this._primitive) {
                return Float.valueOf(this._parseFloatPrimitive(jsonParser, deserializationContext));
            }
            return this._parseFloat(jsonParser, deserializationContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) {
            Object object;
            int n2 = jsonParser.currentTokenId();
            if (n2 != 1) {
                if (n2 == 3) return (Float)this._deserializeFromArray(jsonParser, deserializationContext);
                if (n2 == 11) return (Float)this.getNullValue(deserializationContext);
                switch (n2) {
                    default: {
                        return (Float)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                    }
                    case 7: {
                        CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                        if (coercionAction == CoercionAction.AsNull) {
                            return (Float)this.getNullValue(deserializationContext);
                        }
                        if (coercionAction == CoercionAction.AsEmpty) {
                            return (Float)this.getEmptyValue(deserializationContext);
                        }
                    }
                    case 8: {
                        return Float.valueOf(jsonParser.getFloatValue());
                    }
                    case 6: 
                }
                object = jsonParser.getText();
            } else {
                object = this._valueClass;
                object = deserializationContext.extractScalarFromObject(jsonParser, this, (Class<?>)object);
            }
            Float f2 = this._checkFloatSpecialValue((String)object);
            if (f2 != null) {
                return f2;
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Float)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Float)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
                return (Float)this.getNullValue(deserializationContext);
            }
            try {
                return Float.valueOf(NumberInput.parseFloat((String)object, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Float)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid `Float` value", new Object[0]);
            }
        }
    }

    @JacksonStdImpl
    public static class NumberDeserializer
    extends StdScalarDeserializer<Object> {
        public static final NumberDeserializer instance = new NumberDeserializer();

        public NumberDeserializer() {
            super(Number.class);
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Integer;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            Object object;
            int n2 = jsonParser.currentTokenId();
            if (n2 != 1) {
                if (n2 == 3) return this._deserializeFromArray(jsonParser, deserializationContext);
                switch (n2) {
                    default: {
                        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                    }
                    case 8: {
                        if (!deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) return jsonParser.getNumberValue();
                        if (jsonParser.isNaN()) return jsonParser.getNumberValue();
                        return jsonParser.getDecimalValue();
                    }
                    case 7: {
                        if (!deserializationContext.hasSomeOfFeatures(StdDeserializer.F_MASK_INT_COERCIONS)) return jsonParser.getNumberValue();
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    case 6: 
                }
                object = jsonParser.getText();
            } else {
                object = this._valueClass;
                object = deserializationContext.extractScalarFromObject(jsonParser, this, (Class<?>)object);
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull((String)(object = ((String)object).trim()))) {
                return this.getNullValue(deserializationContext);
            }
            if (this._isPosInf((String)object)) {
                return Double.POSITIVE_INFINITY;
            }
            if (this._isNegInf((String)object)) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this._isNaN((String)object)) {
                return Double.NaN;
            }
            try {
                if (!this._isIntNumber((String)object)) {
                    if (!deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) return NumberInput.parseDouble((String)object, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                    return NumberInput.parseBigDecimal((String)object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid number", new Object[0]);
            }
            {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return NumberInput.parseBigInteger((String)object);
                }
                long l2 = NumberInput.parseLong((String)object);
                if (deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS)) return l2;
                if (l2 > Integer.MAX_VALUE) return l2;
                if (l2 < Integer.MIN_VALUE) return l2;
                return (int)l2;
            }
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            switch (jsonParser.currentTokenId()) {
                default: {
                    return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
                }
                case 6: 
                case 7: 
                case 8: 
            }
            return this.deserialize(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class BigDecimalDeserializer
    extends StdScalarDeserializer<BigDecimal> {
        public static final BigDecimalDeserializer instance = new BigDecimalDeserializer();

        public BigDecimalDeserializer() {
            super(BigDecimal.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigDecimal.ZERO;
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Float;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public BigDecimal deserialize(JsonParser object, DeserializationContext deserializationContext) {
            int n2 = ((JsonParser)object).currentTokenId();
            if (n2 != 1) {
                if (n2 == 3) return (BigDecimal)this._deserializeFromArray((JsonParser)object, deserializationContext);
                switch (n2) {
                    default: {
                        return (BigDecimal)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                    }
                    case 7: {
                        CoercionAction coercionAction = this._checkIntToFloatCoercion((JsonParser)object, deserializationContext, this._valueClass);
                        if (coercionAction == CoercionAction.AsNull) {
                            return (BigDecimal)this.getNullValue(deserializationContext);
                        }
                        if (coercionAction == CoercionAction.AsEmpty) {
                            return (BigDecimal)this.getEmptyValue(deserializationContext);
                        }
                    }
                    case 8: {
                        return ((JsonParser)object).getDecimalValue();
                    }
                    case 6: 
                }
                object = ((JsonParser)object).getText();
            } else {
                Class<?> clazz = this._valueClass;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, clazz);
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (BigDecimal)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (BigDecimal)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull((String)(object = ((String)object).trim()))) {
                return (BigDecimal)this.getNullValue(deserializationContext);
            }
            try {
                return NumberInput.parseBigDecimal((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (BigDecimal)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid representation", new Object[0]);
            }
        }
    }

    @JacksonStdImpl
    public static class BigIntegerDeserializer
    extends StdScalarDeserializer<BigInteger> {
        public static final BigIntegerDeserializer instance = new BigIntegerDeserializer();

        public BigIntegerDeserializer() {
            super(BigInteger.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigInteger.ZERO;
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Integer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public BigInteger deserialize(JsonParser object, DeserializationContext deserializationContext) {
            if (((JsonParser)object).isExpectedNumberIntToken()) {
                return ((JsonParser)object).getBigIntegerValue();
            }
            int n2 = ((JsonParser)object).currentTokenId();
            if (n2 != 1) {
                if (n2 == 3) return (BigInteger)this._deserializeFromArray((JsonParser)object, deserializationContext);
                if (n2 != 6) {
                    if (n2 != 8) {
                        return (BigInteger)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                    }
                    CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (BigInteger)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction != CoercionAction.AsEmpty) return ((JsonParser)object).getDecimalValue().toBigInteger();
                    return (BigInteger)this.getEmptyValue(deserializationContext);
                }
                object = ((JsonParser)object).getText();
            } else {
                Class<?> clazz = this._valueClass;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, clazz);
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (BigInteger)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (BigInteger)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull((String)(object = ((String)object).trim()))) {
                return (BigInteger)this.getNullValue(deserializationContext);
            }
            try {
                return NumberInput.parseBigInteger((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (BigInteger)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid representation", new Object[0]);
            }
        }
    }

    public static abstract class PrimitiveOrWrapperDeserializer<T>
    extends StdScalarDeserializer<T> {
        private static final long serialVersionUID = 1L;
        protected final LogicalType _logicalType;
        protected final T _nullValue;
        protected final T _emptyValue;
        protected final boolean _primitive;

        public PrimitiveOrWrapperDeserializer(Class<T> clazz, LogicalType logicalType, T t2, T t3) {
            super(clazz);
            this._logicalType = logicalType;
            this._nullValue = t2;
            this._emptyValue = t3;
            this._primitive = clazz.isPrimitive();
        }

        @Deprecated
        public PrimitiveOrWrapperDeserializer(Class<T> clazz, T t2, T t3) {
            this(clazz, LogicalType.OtherScalar, t2, t3);
        }

        @Override
        public AccessPattern getNullAccessPattern() {
            if (this._primitive) {
                return AccessPattern.DYNAMIC;
            }
            if (this._nullValue == null) {
                return AccessPattern.ALWAYS_NULL;
            }
            return AccessPattern.CONSTANT;
        }

        @Override
        public final T getNullValue(DeserializationContext objectArray) {
            if (this._primitive && objectArray.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = ClassUtil.classNameOf(this.handledType());
                objectArray2.reportInputMismatch(this, "Cannot map `null` into type %s (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)", objectArray);
            }
            return this._nullValue;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return this._emptyValue;
        }

        @Override
        public final LogicalType logicalType() {
            return this._logicalType;
        }
    }
}

