/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.ArrayType;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import java.lang.reflect.Array;
import java.util.Objects;

@JacksonStdImpl
public class ObjectArrayDeserializer
extends ContainerDeserializerBase<Object[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _untyped;
    protected final Class<?> _elementClass;
    protected JsonDeserializer<Object> _elementDeserializer;
    protected final TypeDeserializer _elementTypeDeserializer;
    protected final Object[] _emptyValue;

    public ObjectArrayDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType, null, null);
        javaType = (ArrayType)javaType;
        this._elementClass = ((ArrayType)javaType).getContentType().getRawClass();
        boolean bl = this._elementClass == Object.class;
        this._untyped = bl;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
        this._emptyValue = ((ArrayType)javaType).getEmptyArray();
    }

    public ObjectArrayDeserializer(ObjectArrayDeserializer objectArrayDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        super(objectArrayDeserializer, nullValueProvider, bl);
        this._elementClass = objectArrayDeserializer._elementClass;
        this._untyped = objectArrayDeserializer._untyped;
        this._emptyValue = objectArrayDeserializer._emptyValue;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
    }

    public ObjectArrayDeserializer withDeserializer(TypeDeserializer object, JsonDeserializer<?> jsonDeserializer) {
        ObjectArrayDeserializer objectArrayDeserializer = nullValueProvider;
        TypeDeserializer typeDeserializer = object;
        ObjectArrayDeserializer objectArrayDeserializer2 = nullValueProvider;
        NullValueProvider nullValueProvider = objectArrayDeserializer2._nullProvider;
        object = objectArrayDeserializer2._unwrapSingle;
        return objectArrayDeserializer.withResolved(typeDeserializer, jsonDeserializer, nullValueProvider, (Boolean)object);
    }

    public ObjectArrayDeserializer withResolved(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        if (Objects.equals(bl, this._unwrapSingle) && nullValueProvider == this._nullProvider && jsonDeserializer == this._elementDeserializer && typeDeserializer == this._elementTypeDeserializer) {
            return this;
        }
        return new ObjectArrayDeserializer(this, jsonDeserializer, typeDeserializer, nullValueProvider, bl);
    }

    @Override
    public boolean isCachable() {
        return this._elementDeserializer == null && this._elementTypeDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        ObjectArrayDeserializer objectArrayDeserializer = this;
        JsonDeserializer<Object> jsonDeserializer = objectArrayDeserializer._elementDeserializer;
        Object object = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY;
        object = this.findFormatFeature(deserializationContext, beanProperty, objectArrayDeserializer._containerType.getRawClass(), (JsonFormat.Feature)((Object)object));
        jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer);
        Object object2 = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer((JavaType)object2, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)object2);
        object2 = this._elementTypeDeserializer;
        if (object2 != null) {
            object2 = ((TypeDeserializer)object2).forProperty(beanProperty);
        }
        return this.withResolved((TypeDeserializer)object2, jsonDeserializer, this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer), (Boolean)object);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._elementDeserializer;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this._emptyValue;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] deserialize(JsonParser var1_1, DeserializationContext var2_2) {
        if (!var1_1.isExpectedStartArrayToken()) {
            return this.handleNonArray(var1_1, var2_2);
        }
        var3_3 = var2_2.leaseObjectBuffer();
        var4_4 = var3_3.resetAndStart();
        var5_5 = 0;
        var6_6 = this._elementTypeDeserializer;
        while (true) {
            block10: {
                block11: {
                    block9: {
                        try {
                            var7_7 /* !! */  = var1_1.nextToken();
                        }
                        catch (Exception v0) {
                            throw JsonMappingException.wrapWithPath((Throwable)v0, (Object)var4_4, var3_3.bufferedSize() + var5_5);
                        }
                        {
                            if (var7_7 /* !! */  == JsonToken.END_ARRAY) break;
                        }
                        {
                            if (var7_7 /* !! */  != JsonToken.VALUE_NULL) break block9;
                        }
                        if (this._skipNullValues) continue;
                        v1 /* !! */  = var7_7 /* !! */  = this._nullProvider.getNullValue(var2_2);
lbl17:
                        // 3 sources

                        while (var5_5 >= var4_4.length) {
                            break block10;
                        }
                        ** GOTO lbl-1000
                    }
                    if (var6_6 != null) break block11;
                    v1 /* !! */  = this._elementDeserializer.deserialize(var1_1, var2_2);
                    ** GOTO lbl17
                }
                v1 /* !! */  = this._elementDeserializer.deserializeWithType(var1_1, var2_2, var6_6);
                ** GOTO lbl17
            }
            var4_4 = var3_3.appendCompletedChunk(var4_4);
            var5_5 = 0;
lbl-1000:
            // 2 sources

            {
                var4_4[var5_5++] = var7_7 /* !! */ ;
                continue;
            }
            break;
        }
        v2 = this._untyped != false ? var3_3.completeAndClearBuffer(var4_4, var5_5) : var3_3.completeAndClearBuffer(var4_4, var5_5, this._elementClass);
        var2_2.returnObjectBuffer(var3_3);
        return v2;
    }

    public Object[] deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return (Object[])typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] deserialize(JsonParser var1_2, DeserializationContext var2_4, Object[] var3_5) {
        if (!var1_2.isExpectedStartArrayToken()) {
            if ((this = this.handleNonArray(var1_2, (DeserializationContext)var2_4)) == null) {
                return var3_5;
            }
            var1_3 = var3_5.length;
            var2_4 = new Object[var1_3 + this.length];
            System.arraycopy(var3_5, 0, var2_4, 0, var1_3);
            var0_1 = this.length;
            System.arraycopy(this, 0, var2_4, var1_3, var0_1);
            return var2_4;
        }
        var4_8 = var2_4.leaseObjectBuffer();
        var3_6 = var3_5.length;
        var5_9 = var4_8.resetAndStart(var3_5, var3_6);
        var6_11 = this._elementTypeDeserializer;
        while (true) {
            block11: {
                block12: {
                    block10: {
                        try {
                            var7_12 /* !! */  = var1_2.nextToken();
                        }
                        catch (Exception v0) {
                            throw JsonMappingException.wrapWithPath((Throwable)v0, (Object)var5_9, var4_8.bufferedSize() + var3_6);
                        }
                        {
                            if (var7_12 /* !! */  == JsonToken.END_ARRAY) break;
                        }
                        {
                            if (var7_12 /* !! */  != JsonToken.VALUE_NULL) break block10;
                        }
                        if (this._skipNullValues) continue;
                        v1 /* !! */  = var7_12 /* !! */  = this._nullProvider.getNullValue((DeserializationContext)var2_4);
lbl24:
                        // 3 sources

                        while (var3_6 >= var5_9.length) {
                            break block11;
                        }
                        ** GOTO lbl-1000
                    }
                    if (var6_11 != null) break block12;
                    v1 /* !! */  = this._elementDeserializer.deserialize(var1_2, (DeserializationContext)var2_4);
                    ** GOTO lbl24
                }
                v1 /* !! */  = this._elementDeserializer.deserializeWithType(var1_2, (DeserializationContext)var2_4, var6_11);
                ** GOTO lbl24
            }
            var3_7 = var4_8.appendCompletedChunk(var5_9);
            var3_6 = var5_10 = 0;
            var5_9 = var3_7;
lbl-1000:
            // 2 sources

            {
                var5_9[var3_6++] = var7_12 /* !! */ ;
                continue;
            }
            break;
        }
        v2 = this._untyped != false ? var4_8.completeAndClearBuffer(var5_9, var3_6) : var4_8.completeAndClearBuffer(var5_9, var3_6, this._elementClass);
        var2_4.returnObjectBuffer(var4_8);
        return v2;
    }

    public Byte[] deserializeFromBase64(JsonParser byteArray, DeserializationContext deserializationContext) {
        byte[] byArray = byteArray.getBinaryValue(deserializationContext.getBase64Variant());
        Object object = byArray;
        byteArray = new Byte[byArray.length];
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byteArray[i2] = (byte)object[i2];
        }
        return byteArray;
    }

    public Object[] handleNonArray(JsonParser object, DeserializationContext deserializationContext) {
        Object object2 = this._unwrapSingle;
        if (!(object2 == Boolean.TRUE || object2 == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY))) {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                if (this._elementClass == Byte.class) {
                    return this.deserializeFromBase64((JsonParser)object, deserializationContext);
                }
                return (Object[])this._deserializeFromString((JsonParser)object, deserializationContext);
            }
            return (Object[])deserializationContext.handleUnexpectedToken(this._containerType, (JsonParser)object);
        }
        if (((JsonParser)object).hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNullValues) {
                return this._emptyValue;
            }
            object = this._nullProvider.getNullValue(deserializationContext);
        } else {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                object2 = ((JsonParser)object).getText();
                if (((String)object2).isEmpty()) {
                    object2 = deserializationContext.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyString);
                    if (object2 != CoercionAction.Fail) {
                        Class<?> clazz = this.handledType();
                        return (Object[])this._deserializeFromEmptyString((JsonParser)object, deserializationContext, (CoercionAction)((Object)object2), clazz, "empty String (\"\")");
                    }
                } else if (StdDeserializer._isBlank((String)object2)) {
                    object2 = CoercionAction.Fail;
                    CoercionAction coercionAction = deserializationContext.findCoercionFromBlankString(this.logicalType(), this.handledType(), (CoercionAction)((Object)object2));
                    if (coercionAction != object2) {
                        object2 = this.handledType();
                        return (Object[])this._deserializeFromEmptyString((JsonParser)object, deserializationContext, coercionAction, (Class<?>)object2, "blank String (all whitespace)");
                    }
                }
            }
            object = (object2 = this._elementTypeDeserializer) == null ? this._elementDeserializer.deserialize((JsonParser)object, deserializationContext) : this._elementDeserializer.deserializeWithType((JsonParser)object, deserializationContext, (TypeDeserializer)object2);
        }
        Object[] objectArray = this._untyped ? new Object[1] : (Object[])Array.newInstance(this._elementClass, 1);
        objectArray[0] = object;
        return objectArray;
    }
}

