/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.Nulls;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.privatefasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.n;
import com.privatefasterxml.jackson.databind.deser.std.o;
import com.privatefasterxml.jackson.databind.deser.std.p;
import com.privatefasterxml.jackson.databind.deser.std.q;
import com.privatefasterxml.jackson.databind.deser.std.r;
import com.privatefasterxml.jackson.databind.deser.std.s;
import com.privatefasterxml.jackson.databind.deser.std.t;
import com.privatefasterxml.jackson.databind.deser.std.u;
import com.privatefasterxml.jackson.databind.exc.InvalidNullException;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import java.lang.reflect.Array;
import java.util.Objects;

public abstract class PrimitiveArrayDeserializers<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final Boolean _unwrapSingle;
    private transient Object _emptyValue;
    protected final NullValueProvider _nuller;

    public PrimitiveArrayDeserializers(Class<T> clazz) {
        super(clazz);
        this._unwrapSingle = null;
        this._nuller = null;
    }

    public PrimitiveArrayDeserializers(PrimitiveArrayDeserializers<?> primitiveArrayDeserializers, NullValueProvider nullValueProvider, Boolean bl) {
        super(primitiveArrayDeserializers._valueClass);
        this._unwrapSingle = bl;
        this._nuller = nullValueProvider;
    }

    public static JsonDeserializer<?> forType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return s.a;
        }
        if (clazz == Long.TYPE) {
            return t.a;
        }
        if (clazz == Byte.TYPE) {
            return new o();
        }
        if (clazz == Short.TYPE) {
            return new u();
        }
        if (clazz == Float.TYPE) {
            return new r();
        }
        if (clazz == Double.TYPE) {
            return new q();
        }
        if (clazz == Boolean.TYPE) {
            return new n();
        }
        if (clazz == Character.TYPE) {
            return new p();
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        Object object = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY;
        object = this.findFormatFeature(deserializationContext, beanProperty, this._valueClass, (JsonFormat.Feature)((Object)object));
        NullValueProvider nullValueProvider = null;
        Nulls nulls = this.findContentNullStyle(deserializationContext, beanProperty);
        if (nulls == Nulls.SKIP) {
            nullValueProvider = NullsConstantProvider.skipper();
        } else if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                nullValueProvider = NullsFailProvider.constructForRootValue(deserializationContext.constructType(this._valueClass.getComponentType()));
            } else {
                BeanProperty beanProperty2 = beanProperty;
                nullValueProvider = NullsFailProvider.constructForProperty(beanProperty2, beanProperty2.getType().getContentType());
            }
        }
        if (Objects.equals(object, this._unwrapSingle) && nullValueProvider == this._nuller) {
            return this;
        }
        return this.withResolved(nullValueProvider, (Boolean)object);
    }

    public abstract T _concat(T var1, T var2);

    public abstract T handleSingleElementUnwrapped(JsonParser var1, DeserializationContext var2);

    public abstract PrimitiveArrayDeserializers<?> withResolved(NullValueProvider var1, Boolean var2);

    public abstract T _constructEmpty();

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext object) {
        object = this._emptyValue;
        if (object == null) {
            this._emptyValue = object = this._constructEmpty();
        }
        return object;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, T t2) {
        jsonParser = this.deserialize(jsonParser, deserializationContext);
        if (t2 == null) {
            return (T)jsonParser;
        }
        if (Array.getLength(t2) == 0) {
            return (T)jsonParser;
        }
        return (T)this._concat(t2, jsonParser);
    }

    public T handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._deserializeFromString(jsonParser, deserializationContext);
        }
        Boolean bl = this._unwrapSingle;
        if (!(bl == Boolean.TRUE || bl == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY))) {
            return (T)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
        return this.handleSingleElementUnwrapped(jsonParser, deserializationContext);
    }

    public void _failOnNull(DeserializationContext deserializationContext) {
        DeserializationContext deserializationContext2 = deserializationContext;
        throw InvalidNullException.from(deserializationContext2, null, deserializationContext2.constructType(this._valueClass));
    }
}

