/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;

public abstract class ReferenceTypeDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    protected final JavaType _fullType;
    protected final ValueInstantiator _valueInstantiator;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final JsonDeserializer<Object> _valueDeserializer;

    public ReferenceTypeDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        super(javaType);
        this._valueInstantiator = valueInstantiator;
        this._fullType = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
    }

    @Deprecated
    public ReferenceTypeDeserializer(JavaType javaType, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        this(javaType, null, typeDeserializer, jsonDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext jsonDeserializer, BeanProperty beanProperty) {
        Object object = this._valueDeserializer;
        jsonDeserializer = object == null ? ((DeserializationContext)((Object)jsonDeserializer)).findContextualValueDeserializer(this._fullType.getReferencedType(), beanProperty) : ((DeserializationContext)((Object)jsonDeserializer)).handleSecondaryContextualization((JsonDeserializer<?>)object, beanProperty, this._fullType.getReferencedType());
        object = this._valueTypeDeserializer;
        if (object != null) {
            object = ((TypeDeserializer)object).forProperty(beanProperty);
        }
        if (jsonDeserializer == this._valueDeserializer && object == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved((TypeDeserializer)object, jsonDeserializer);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    public abstract ReferenceTypeDeserializer<T> withResolved(TypeDeserializer var1, JsonDeserializer<?> var2);

    @Override
    public abstract T getNullValue(DeserializationContext var1);

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this.getNullValue(deserializationContext);
    }

    public abstract T referenceValue(Object var1);

    public abstract T updateReference(T var1, Object var2);

    public abstract Object getReferenced(T var1);

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public JavaType getValueType() {
        return this._fullType;
    }

    @Override
    public LogicalType logicalType() {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        if (jsonDeserializer != null) {
            return jsonDeserializer.logicalType();
        }
        return super.logicalType();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        JsonDeserializer jsonDeserializer = ((ReferenceTypeDeserializer)jsonDeserializer)._valueDeserializer;
        return jsonDeserializer == null ? null : jsonDeserializer.supportsUpdate(deserializationConfig);
    }

    @Override
    public T deserialize(JsonParser object, DeserializationContext deserializationContext) {
        Object object2 = this._valueInstantiator;
        if (object2 != null) {
            return (T)this.deserialize((JsonParser)object, deserializationContext, ((ValueInstantiator)object2).createUsingDefault(deserializationContext));
        }
        object2 = this._valueTypeDeserializer;
        object = object2 == null ? this._valueDeserializer.deserialize((JsonParser)object, deserializationContext) : this._valueDeserializer.deserializeWithType((JsonParser)object, deserializationContext, (TypeDeserializer)object2);
        return this.referenceValue(object);
    }

    @Override
    public T deserialize(JsonParser object, DeserializationContext deserializationContext, T object2) {
        if (!this._valueDeserializer.supportsUpdate(deserializationContext.getConfig()).equals(Boolean.FALSE) && this._valueTypeDeserializer == null) {
            Object object3 = this.getReferenced(object2);
            if (object3 == null) {
                object2 = this._valueTypeDeserializer;
                object = object2 == null ? this._valueDeserializer.deserialize((JsonParser)object, deserializationContext) : this._valueDeserializer.deserializeWithType((JsonParser)object, deserializationContext, (TypeDeserializer)object2);
                return this.referenceValue(object);
            }
            object = this._valueDeserializer.deserialize((JsonParser)object, deserializationContext, object3);
        } else {
            TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
            object = typeDeserializer == null ? this._valueDeserializer.deserialize((JsonParser)object, deserializationContext) : this._valueDeserializer.deserializeWithType((JsonParser)object, deserializationContext, typeDeserializer);
        }
        return this.updateReference(object2, object);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return this.getNullValue(deserializationContext);
        }
        typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer == null) {
            return this.deserialize(jsonParser, deserializationContext);
        }
        return this.referenceValue(typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext));
    }
}

