/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import java.io.Serializable;

public class StdDelegatingDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Converter<Object, T> _converter;
    protected final JavaType _delegateType;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public StdDelegatingDeserializer(Converter<?, T> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateDeserializer = null;
    }

    public StdDelegatingDeserializer(Converter<Object, T> converter, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        super(javaType);
        this._converter = converter;
        this._delegateType = javaType;
        this._delegateDeserializer = jsonDeserializer;
    }

    public StdDelegatingDeserializer(StdDelegatingDeserializer<T> stdDelegatingDeserializer) {
        super(stdDelegatingDeserializer);
        this._converter = stdDelegatingDeserializer._converter;
        this._delegateType = stdDelegatingDeserializer._delegateType;
        this._delegateDeserializer = stdDelegatingDeserializer._delegateDeserializer;
    }

    public StdDelegatingDeserializer<T> withDelegate(Converter<Object, T> converter, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        ClassUtil.verifyMustOverride(StdDelegatingDeserializer.class, this, "withDelegate");
        return new StdDelegatingDeserializer<T>(converter, javaType, jsonDeserializer);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) {
        JsonDeserializer jsonDeserializer = jsonDeserializer._delegateDeserializer;
        if (jsonDeserializer != null && jsonDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(deserializationContext);
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext converter, BeanProperty object) {
        Object object2;
        JsonDeserializer<Object> jsonDeserializer = ((StdDelegatingDeserializer)object2)._delegateDeserializer;
        if (jsonDeserializer != null) {
            if ((converter = ((DeserializationContext)((Object)converter)).handleSecondaryContextualization(jsonDeserializer, (BeanProperty)object, ((StdDelegatingDeserializer)object2)._delegateType)) != ((StdDelegatingDeserializer)object2)._delegateDeserializer) {
                Serializable serializable = object2;
                object2 = ((StdDelegatingDeserializer)serializable)._converter;
                return ((StdDelegatingDeserializer)serializable).withDelegate((Converter<Object, T>)object2, ((StdDelegatingDeserializer)serializable)._delegateType, (JsonDeserializer<?>)((Object)converter));
            }
            return object2;
        }
        StdDelegatingDeserializer stdDelegatingDeserializer = object2;
        DeserializationContext deserializationContext = converter;
        StdDelegatingDeserializer stdDelegatingDeserializer2 = object2;
        object2 = stdDelegatingDeserializer2._converter.getInputType(((DeserializationContext)((Object)converter)).getTypeFactory());
        converter = stdDelegatingDeserializer2._converter;
        object = deserializationContext.findContextualValueDeserializer((JavaType)object2, (BeanProperty)object);
        return stdDelegatingDeserializer.withDelegate(converter, (JavaType)object2, (JsonDeserializer<?>)object);
    }

    @Override
    public JsonDeserializer<?> getDelegatee() {
        return this._delegateDeserializer;
    }

    @Override
    public Class<?> handledType() {
        return this._delegateDeserializer.handledType();
    }

    @Override
    public LogicalType logicalType() {
        return this._delegateDeserializer.logicalType();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._delegateDeserializer.supportsUpdate(deserializationConfig);
    }

    @Override
    public T deserialize(JsonParser object, DeserializationContext deserializationContext) {
        if ((object = this._delegateDeserializer.deserialize((JsonParser)object, deserializationContext)) == null) {
            return null;
        }
        return this.convertValue(object);
    }

    @Override
    public Object deserializeWithType(JsonParser object, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        if ((object = this._delegateDeserializer.deserialize((JsonParser)object, deserializationContext)) == null) {
            return null;
        }
        return this.convertValue(object);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        if (this._delegateType.getRawClass().isAssignableFrom(object.getClass())) {
            return (T)this._delegateDeserializer.deserialize(jsonParser, deserializationContext, object);
        }
        return (T)this._handleIncompatibleUpdateValue(jsonParser, deserializationContext, object);
    }

    public Object _handleIncompatibleUpdateValue(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        throw new UnsupportedOperationException(String.format("Cannot update object of type %s (using deserializer for type %s)".concat(object.getClass().getName()), this._delegateType));
    }

    public T convertValue(Object object) {
        return this._converter.convert(object);
    }
}

