/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.Nulls;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.exc.StreamReadException;
import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.core.type.ResolvedType;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.NullsAsEmptyProvider;
import com.privatefasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.privatefasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.privatefasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.v;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable,
ValueInstantiator.Gettable {
    private static final long serialVersionUID = 1L;
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    @Deprecated
    protected static final int F_MASK_ACCEPT_ARRAYS = DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS.getMask() | DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT.getMask();
    protected final Class<?> _valueClass;
    protected final JavaType _valueType;

    public StdDeserializer(Class<?> clazz) {
        this._valueClass = clazz;
        this._valueType = null;
    }

    public StdDeserializer(JavaType javaType) {
        Class clazz = javaType == null ? Object.class : javaType.getRawClass();
        StdDeserializer stdDeserializer = this;
        stdDeserializer._valueClass = clazz;
        stdDeserializer._valueType = javaType;
    }

    public StdDeserializer(StdDeserializer<?> stdDeserializer) {
        this._valueClass = stdDeserializer._valueClass;
        this._valueType = stdDeserializer._valueType;
    }

    public static final double _parseDouble(String string) {
        return StdDeserializer._parseDouble(string, false);
    }

    public static final double _parseDouble(String string, boolean bl) {
        return NumberInput.parseDouble(string, bl);
    }

    public static final boolean _isBlank(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static final boolean _neitherNull(Object object, Object object2) {
        return object != null && object2 != null;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    public JavaType getValueType(DeserializationContext deserializationContext) {
        JavaType javaType = this._valueType;
        if (javaType != null) {
            return javaType;
        }
        return deserializationContext.constructType(this._valueClass);
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return null;
    }

    public boolean isDefaultDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer);
    }

    public boolean isDefaultKeyDeserializer(KeyDeserializer keyDeserializer) {
        return ClassUtil.isJacksonStdImpl(keyDeserializer);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        CoercionAction coercionAction = this._findCoercionFromEmptyArray(deserializationContext);
        boolean bl = deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (!bl && coercionAction == CoercionAction.Fail) return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
        JsonToken jsonToken = JsonToken.END_ARRAY;
        if (jsonParser.nextToken() == jsonToken) {
            int n2 = v.a[coercionAction.ordinal()];
            if (n2 == 1) return (T)this.getEmptyValue(deserializationContext);
            if (n2 != 2 && n2 != 3) return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
            return this.getNullValue(deserializationContext);
        }
        if (!bl) return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
        T t2 = this._deserializeWrappedValue(jsonParser, deserializationContext);
        if (jsonParser.nextToken() == jsonToken) return t2;
        this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
        return t2;
    }

    @Deprecated
    public T _deserializeFromEmpty(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.START_ARRAY) && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return null;
            }
            return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
        }
        return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    public T _deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        ValueInstantiator valueInstantiator = object.getValueInstantiator();
        Class<?> clazz = object.handledType();
        String string = jsonParser.getValueAsString();
        if (valueInstantiator != null && valueInstantiator.canCreateFromString()) {
            return (T)valueInstantiator.createFromString(deserializationContext, string);
        }
        if (string.isEmpty()) {
            DeserializationContext deserializationContext2 = deserializationContext;
            return (T)object._deserializeFromEmptyString(jsonParser, deserializationContext2, deserializationContext2.findCoercionAction(object.logicalType(), clazz, CoercionInputShape.EmptyString), clazz, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(string)) {
            DeserializationContext deserializationContext3 = deserializationContext;
            return (T)object._deserializeFromEmptyString(jsonParser, deserializationContext3, deserializationContext3.findCoercionFromBlankString(object.logicalType(), clazz, CoercionAction.Fail), clazz, "blank String (all whitespace)");
        }
        if (valueInstantiator != null) {
            string = string.trim();
            if (valueInstantiator.canCreateFromInt() && deserializationContext.findCoercionAction(LogicalType.Integer, Integer.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)valueInstantiator.createFromInt(deserializationContext, object._parseIntPrimitive(deserializationContext, string));
            }
            if (valueInstantiator.canCreateFromLong() && deserializationContext.findCoercionAction(LogicalType.Integer, Long.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)valueInstantiator.createFromLong(deserializationContext, object._parseLongPrimitive(deserializationContext, string));
            }
            if (valueInstantiator.canCreateFromBoolean() && deserializationContext.findCoercionAction(LogicalType.Boolean, Boolean.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                object = string.trim();
                if ("true".equals(object)) {
                    return (T)valueInstantiator.createFromBoolean(deserializationContext, true);
                }
                if ("false".equals(object)) {
                    return (T)valueInstantiator.createFromBoolean(deserializationContext, false);
                }
            }
        }
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = string;
        return (T)deserializationContext.handleMissingInstantiator(clazz, valueInstantiator, deserializationContext.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", object);
    }

    public Object _deserializeFromEmptyString(JsonParser jsonParser, DeserializationContext deserializationContext, CoercionAction coercionAction, Class<?> clazz, String string) {
        int n2 = v.a[coercionAction.ordinal()];
        if (n2 != 1) {
            if (n2 == 4) {
                this._checkCoercionFail(deserializationContext, coercionAction, clazz, "", "empty String (\"\")");
            }
            return null;
        }
        return this.getEmptyValue(deserializationContext);
    }

    public T _deserializeWrappedValue(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return (T)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
        }
        return this.deserialize(jsonParser, deserializationContext);
    }

    @Deprecated
    public final boolean _parseBooleanPrimitive(DeserializationContext deserializationContext, JsonParser jsonParser, Class<?> clazz) {
        return this._parseBooleanPrimitive(jsonParser, deserializationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean _parseBooleanPrimitive(JsonParser object, DeserializationContext deserializationContext) {
        Class<Boolean> clazz;
        block17: {
            switch (((JsonParser)object).currentTokenId()) {
                default: {
                    return (Boolean)deserializationContext.handleUnexpectedToken(Boolean.TYPE, (JsonParser)object);
                }
                case 11: {
                    objectArray._verifyNullForPrimitive(deserializationContext);
                    return false;
                }
                case 10: {
                    return false;
                }
                case 9: {
                    return true;
                }
                case 7: {
                    return Boolean.TRUE.equals(objectArray._coerceBooleanFromInt((JsonParser)object, deserializationContext, Boolean.TYPE));
                }
                case 6: {
                    object = ((JsonParser)object).getText();
                    break block17;
                }
                case 3: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) return (Boolean)deserializationContext.handleUnexpectedToken(Boolean.TYPE, (JsonParser)object);
                    if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                        return (Boolean)objectArray.handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                    }
                    boolean bl = objectArray._parseBooleanPrimitive((JsonParser)object, deserializationContext);
                    objectArray._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                    return bl;
                }
                case 1: 
            }
            clazz = Boolean.TYPE;
            object = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)objectArray, clazz);
        }
        clazz = Boolean.TYPE;
        CoercionAction coercionAction = objectArray._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Boolean, clazz);
        if (coercionAction == CoercionAction.AsNull) {
            objectArray._verifyNullForPrimitive(deserializationContext);
            return false;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return false;
        }
        int n2 = ((String)(object = ((String)object).trim())).length();
        if (n2 == 4) {
            if (objectArray._isTrue((String)object)) {
                return true;
            }
        } else if (n2 == 5 && objectArray._isFalse((String)object)) {
            return false;
        }
        if (objectArray._hasTextualNull((String)object)) {
            objectArray._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
            return false;
        }
        Object[] objectArray = new Object[]{};
        return Boolean.TRUE.equals((Boolean)deserializationContext.handleWeirdStringValue(clazz, (String)object, "only \"true\"/\"True\"/\"TRUE\" or \"false\"/\"False\"/\"FALSE\" recognized", objectArray));
    }

    public boolean _isTrue(String string) {
        char c2 = string.charAt(0);
        if (c2 == 't') {
            return "true".equals(string);
        }
        if (c2 == 'T') {
            return "TRUE".equals(string) || "True".equals(string);
        }
        return false;
    }

    public boolean _isFalse(String string) {
        char c2 = string.charAt(0);
        if (c2 == 'f') {
            return "false".equals(string);
        }
        if (c2 == 'F') {
            return "FALSE".equals(string) || "False".equals(string);
        }
        return false;
    }

    public final Boolean _parseBoolean(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        switch (((JsonParser)object).currentTokenId()) {
            default: {
                return (Boolean)deserializationContext.handleUnexpectedToken(clazz, (JsonParser)object);
            }
            case 11: {
                return null;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 7: {
                return objectArray._coerceBooleanFromInt((JsonParser)object, deserializationContext, clazz);
            }
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 3: {
                return (Boolean)objectArray._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            case 1: {
                object = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)objectArray, clazz);
            }
        }
        CoercionAction coercionAction = objectArray._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Boolean, clazz);
        if (coercionAction == CoercionAction.AsNull) {
            return null;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return Boolean.FALSE;
        }
        int n2 = ((String)(object = ((String)object).trim())).length();
        if (n2 == 4) {
            if (objectArray._isTrue((String)object)) {
                return Boolean.TRUE;
            }
        } else if (n2 == 5 && objectArray._isFalse((String)object)) {
            return Boolean.FALSE;
        }
        if (objectArray._checkTextualNull(deserializationContext, (String)object)) {
            return null;
        }
        Object[] objectArray = new Object[]{};
        return (Boolean)deserializationContext.handleWeirdStringValue(clazz, (String)object, "only \"true\" or \"false\" recognized", objectArray);
    }

    public final byte _parseBytePrimitive(JsonParser object, DeserializationContext deserializationContext) {
        int n2;
        block14: {
            block19: {
                block15: {
                    block18: {
                        block16: {
                            block17: {
                                int n3 = ((JsonParser)object).currentTokenId();
                                if (n3 == 1) break block15;
                                if (n3 == 3) break block16;
                                if (n3 == 11) break block17;
                                switch (n3) {
                                    default: {
                                        break block18;
                                    }
                                    case 8: {
                                        CoercionAction coercionAction = ((StdDeserializer)((Object)coercionAction))._checkFloatToIntCoercion((JsonParser)object, deserializationContext, Byte.TYPE);
                                        if (coercionAction == CoercionAction.AsNull) {
                                            return 0;
                                        }
                                        if (coercionAction == CoercionAction.AsEmpty) {
                                            return 0;
                                        }
                                        return ((JsonParser)object).getByteValue();
                                    }
                                    case 7: {
                                        return ((JsonParser)object).getByteValue();
                                    }
                                    case 6: {
                                        object = ((JsonParser)object).getText();
                                        break;
                                    }
                                }
                                break block19;
                            }
                            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
                            return 0;
                        }
                        if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                            if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                                return (Byte)((StdDeserializer)((Object)coercionAction)).handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                            }
                            byte by = ((StdDeserializer)((Object)coercionAction))._parseBytePrimitive((JsonParser)object, deserializationContext);
                            ((StdDeserializer)((Object)coercionAction))._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                            return by;
                        }
                    }
                    DeserializationContext deserializationContext2 = deserializationContext;
                    return (Byte)deserializationContext2.handleUnexpectedToken(deserializationContext2.constructType(Byte.TYPE), (JsonParser)object);
                }
                Class<Byte> clazz = Byte.TYPE;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)((Object)coercionAction), clazz);
            }
            Object object2 = Byte.TYPE;
            if ((object2 = ((StdDeserializer)((Object)coercionAction))._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Integer, (Class<?>)object2)) == CoercionAction.AsNull) {
                ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            if (object2 == CoercionAction.AsEmpty) {
                return 0;
            }
            if (((StdDeserializer)((Object)coercionAction))._hasTextualNull((String)(object = ((String)object).trim()))) {
                ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
                return 0;
            }
            try {
                n2 = NumberInput.parseInt((String)object);
                if (!((StdDeserializer)((Object)coercionAction))._byteOverflow(n2)) break block14;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Byte)deserializationContext.handleWeirdStringValue(((StdDeserializer)((Object)coercionAction))._valueClass, (String)object, "not a valid `byte` value", new Object[0]);
            }
            return (Byte)deserializationContext.handleWeirdStringValue(((StdDeserializer)((Object)coercionAction))._valueClass, (String)object, "overflow, value cannot be represented as 8-bit value", new Object[0]);
        }
        return (byte)n2;
    }

    public final short _parseShortPrimitive(JsonParser object, DeserializationContext deserializationContext) {
        int n2;
        block14: {
            Class<Short> clazz;
            CoercionAction coercionAction;
            block19: {
                block15: {
                    block18: {
                        block16: {
                            block17: {
                                int n3 = ((JsonParser)object).currentTokenId();
                                if (n3 == 1) break block15;
                                if (n3 == 3) break block16;
                                if (n3 == 11) break block17;
                                switch (n3) {
                                    default: {
                                        break block18;
                                    }
                                    case 8: {
                                        CoercionAction coercionAction2 = ((StdDeserializer)((Object)coercionAction2))._checkFloatToIntCoercion((JsonParser)object, deserializationContext, Short.TYPE);
                                        if (coercionAction2 == CoercionAction.AsNull) {
                                            return 0;
                                        }
                                        if (coercionAction2 == CoercionAction.AsEmpty) {
                                            return 0;
                                        }
                                        return ((JsonParser)object).getShortValue();
                                    }
                                    case 7: {
                                        return ((JsonParser)object).getShortValue();
                                    }
                                    case 6: {
                                        object = ((JsonParser)object).getText();
                                        break;
                                    }
                                }
                                break block19;
                            }
                            ((StdDeserializer)((Object)coercionAction2))._verifyNullForPrimitive(deserializationContext);
                            return 0;
                        }
                        if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                            if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                                return (Short)((StdDeserializer)((Object)coercionAction2)).handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                            }
                            short s2 = ((StdDeserializer)((Object)coercionAction2))._parseShortPrimitive((JsonParser)object, deserializationContext);
                            ((StdDeserializer)((Object)coercionAction2))._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                            return s2;
                        }
                    }
                    DeserializationContext deserializationContext2 = deserializationContext;
                    return (Short)deserializationContext2.handleUnexpectedToken(deserializationContext2.constructType(Short.TYPE), (JsonParser)object);
                }
                Class<Short> clazz2 = Short.TYPE;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)((Object)coercionAction2), clazz2);
            }
            if ((coercionAction = ((StdDeserializer)((Object)coercionAction2))._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Integer, clazz = Short.TYPE)) == CoercionAction.AsNull) {
                ((StdDeserializer)((Object)coercionAction2))._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return 0;
            }
            if (((StdDeserializer)((Object)coercionAction2))._hasTextualNull((String)(object = ((String)object).trim()))) {
                ((StdDeserializer)((Object)coercionAction2))._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
                return 0;
            }
            try {
                n2 = NumberInput.parseInt((String)object);
                if (!((StdDeserializer)((Object)coercionAction2))._shortOverflow(n2)) break block14;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Short)deserializationContext.handleWeirdStringValue(Short.TYPE, (String)object, "not a valid `short` value", new Object[0]);
            }
            Object[] objectArray = new Object[]{};
            return (Short)deserializationContext.handleWeirdStringValue(clazz, (String)object, "overflow, value cannot be represented as 16-bit value", objectArray);
        }
        return (short)n2;
    }

    public final int _parseIntPrimitive(JsonParser object, DeserializationContext deserializationContext) {
        block16: {
            block12: {
                block15: {
                    block13: {
                        block14: {
                            int n2 = ((JsonParser)object).currentTokenId();
                            if (n2 == 1) break block12;
                            if (n2 == 3) break block13;
                            if (n2 == 11) break block14;
                            switch (n2) {
                                default: {
                                    break block15;
                                }
                                case 8: {
                                    CoercionAction coercionAction = ((StdDeserializer)((Object)coercionAction))._checkFloatToIntCoercion((JsonParser)object, deserializationContext, Integer.TYPE);
                                    if (coercionAction == CoercionAction.AsNull) {
                                        return 0;
                                    }
                                    if (coercionAction == CoercionAction.AsEmpty) {
                                        return 0;
                                    }
                                    return ((JsonParser)object).getValueAsInt();
                                }
                                case 7: {
                                    return ((JsonParser)object).getIntValue();
                                }
                                case 6: {
                                    object = ((JsonParser)object).getText();
                                    break;
                                }
                            }
                            break block16;
                        }
                        ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
                        return 0;
                    }
                    if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                        if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                            return (Integer)((StdDeserializer)((Object)coercionAction)).handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                        }
                        int n3 = ((StdDeserializer)((Object)coercionAction))._parseIntPrimitive((JsonParser)object, deserializationContext);
                        ((StdDeserializer)((Object)coercionAction))._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                        return n3;
                    }
                }
                return ((Number)deserializationContext.handleUnexpectedToken(Integer.TYPE, (JsonParser)object)).intValue();
            }
            Class<Integer> clazz = Integer.TYPE;
            object = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)((Object)coercionAction), clazz);
        }
        Object object2 = Integer.TYPE;
        if ((object2 = ((StdDeserializer)((Object)coercionAction))._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Integer, (Class<?>)object2)) == CoercionAction.AsNull) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
            return 0;
        }
        if (object2 == CoercionAction.AsEmpty) {
            return 0;
        }
        if (((StdDeserializer)((Object)coercionAction))._hasTextualNull((String)(object = ((String)object).trim()))) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
            return 0;
        }
        return ((StdDeserializer)((Object)coercionAction))._parseIntPrimitive(deserializationContext, (String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int _parseIntPrimitive(DeserializationContext deserializationContext, String string) {
        block5: {
            Object[] objectArray;
            String string2;
            String string3;
            Class<Integer> clazz;
            DeserializationContext deserializationContext2;
            StdDeserializer stdDeserializer;
            try {
                if (string.length() <= 9) break block5;
                long l2 = NumberInput.parseLong(string);
                if (!this._intOverflow(l2)) return (int)l2;
                stdDeserializer = this;
                deserializationContext2 = deserializationContext;
                clazz = Integer.TYPE;
                string3 = string;
                string2 = "Overflow: numeric value (%s) out of range of int (%d -%d)";
                objectArray = new Object[3];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this._nonNullNumber((Number)deserializationContext.handleWeirdStringValue(Integer.TYPE, string, "not a valid `int` value", new Object[0])).intValue();
            }
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = Integer.MIN_VALUE;
            objectArray[2] = Integer.MAX_VALUE;
            return stdDeserializer._nonNullNumber((Number)deserializationContext2.handleWeirdStringValue(clazz, string3, string2, objectArray2)).intValue();
        }
        return NumberInput.parseInt(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Integer _parseInteger(JsonParser object, DeserializationContext deserializationContext, Class<?> object2) {
        int n2 = ((JsonParser)object).currentTokenId();
        if (n2 != 1) {
            if (n2 == 3) return (Integer)this._deserializeFromArray((JsonParser)object, deserializationContext);
            if (n2 == 11) return (Integer)this.getNullValue(deserializationContext);
            switch (n2) {
                default: {
                    return (Integer)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, (Class<?>)object2);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Integer)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction != CoercionAction.AsEmpty) return ((JsonParser)object).getValueAsInt();
                    return (Integer)this.getEmptyValue(deserializationContext);
                }
                case 7: {
                    return ((JsonParser)object).getIntValue();
                }
                case 6: 
            }
            object = ((JsonParser)object).getText();
        } else {
            object = deserializationContext.extractScalarFromObject((JsonParser)object, this, (Class<?>)object2);
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (coercionAction == CoercionAction.AsNull) {
            return (Integer)this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (Integer)this.getEmptyValue(deserializationContext);
        }
        if (!this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) return this._parseInteger(deserializationContext, (String)object);
        return (Integer)this.getNullValue(deserializationContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Integer _parseInteger(DeserializationContext deserializationContext, String string) {
        Object object;
        block7: {
            block5: {
                long l2;
                block6: {
                    Object[] objectArray;
                    String string2;
                    Class<Integer> clazz;
                    DeserializationContext deserializationContext2;
                    try {
                        if (string.length() <= 9) break block5;
                        l2 = NumberInput.parseLong(string);
                        if (!object._intOverflow(l2)) break block6;
                        deserializationContext2 = deserializationContext;
                        clazz = Integer.class;
                        string2 = string;
                        object = "Overflow: numeric value (%s) out of range of `java.lang.Integer` (%d -%d)";
                        objectArray = new Object[3];
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = string;
                    objectArray[1] = Integer.MIN_VALUE;
                    objectArray[2] = Integer.MAX_VALUE;
                    return (Integer)deserializationContext2.handleWeirdStringValue(clazz, string2, (String)object, objectArray2);
                }
                return (int)l2;
                break block7;
            }
            return NumberInput.parseInt(string);
        }
        object = new Object[]{};
        return (Integer)deserializationContext.handleWeirdStringValue(Integer.class, string, "not a valid `java.lang.Integer` value", object);
    }

    public final long _parseLongPrimitive(JsonParser object, DeserializationContext deserializationContext) {
        block16: {
            block12: {
                block15: {
                    block13: {
                        block14: {
                            int n2 = ((JsonParser)object).currentTokenId();
                            if (n2 == 1) break block12;
                            if (n2 == 3) break block13;
                            if (n2 == 11) break block14;
                            switch (n2) {
                                default: {
                                    break block15;
                                }
                                case 8: {
                                    CoercionAction coercionAction = ((StdDeserializer)((Object)coercionAction))._checkFloatToIntCoercion((JsonParser)object, deserializationContext, Long.TYPE);
                                    if (coercionAction == CoercionAction.AsNull) {
                                        return 0L;
                                    }
                                    if (coercionAction == CoercionAction.AsEmpty) {
                                        return 0L;
                                    }
                                    return ((JsonParser)object).getValueAsLong();
                                }
                                case 7: {
                                    return ((JsonParser)object).getLongValue();
                                }
                                case 6: {
                                    object = ((JsonParser)object).getText();
                                    break;
                                }
                            }
                            break block16;
                        }
                        ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
                        return 0L;
                    }
                    if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                        if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                            return (Long)((StdDeserializer)((Object)coercionAction)).handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                        }
                        long l2 = ((StdDeserializer)((Object)coercionAction))._parseLongPrimitive((JsonParser)object, deserializationContext);
                        ((StdDeserializer)((Object)coercionAction))._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                        return l2;
                    }
                }
                return ((Number)deserializationContext.handleUnexpectedToken(Long.TYPE, (JsonParser)object)).longValue();
            }
            Class<Long> clazz = Long.TYPE;
            object = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)((Object)coercionAction), clazz);
        }
        Object object2 = Long.TYPE;
        if ((object2 = ((StdDeserializer)((Object)coercionAction))._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Integer, (Class<?>)object2)) == CoercionAction.AsNull) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
            return 0L;
        }
        if (object2 == CoercionAction.AsEmpty) {
            return 0L;
        }
        if (((StdDeserializer)((Object)coercionAction))._hasTextualNull((String)(object = ((String)object).trim()))) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
            return 0L;
        }
        return ((StdDeserializer)((Object)coercionAction))._parseLongPrimitive(deserializationContext, (String)object);
    }

    public final long _parseLongPrimitive(DeserializationContext deserializationContext, String string) {
        try {
            return NumberInput.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this._nonNullNumber((Number)deserializationContext.handleWeirdStringValue(Long.TYPE, string, "not a valid `long` value", new Object[0])).longValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Long _parseLong(JsonParser object, DeserializationContext deserializationContext, Class<?> object2) {
        int n2 = ((JsonParser)object).currentTokenId();
        if (n2 != 1) {
            if (n2 == 3) return (Long)this._deserializeFromArray((JsonParser)object, deserializationContext);
            if (n2 == 11) return (Long)this.getNullValue(deserializationContext);
            switch (n2) {
                default: {
                    return (Long)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, (Class<?>)object2);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Long)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction != CoercionAction.AsEmpty) return ((JsonParser)object).getValueAsLong();
                    return (Long)this.getEmptyValue(deserializationContext);
                }
                case 7: {
                    return ((JsonParser)object).getLongValue();
                }
                case 6: 
            }
            object = ((JsonParser)object).getText();
        } else {
            object = deserializationContext.extractScalarFromObject((JsonParser)object, this, (Class<?>)object2);
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (coercionAction == CoercionAction.AsNull) {
            return (Long)this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (Long)this.getEmptyValue(deserializationContext);
        }
        if (!this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) return this._parseLong(deserializationContext, (String)object);
        return (Long)this.getNullValue(deserializationContext);
    }

    public final Long _parseLong(DeserializationContext deserializationContext, String string) {
        try {
            return NumberInput.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{};
            return (Long)deserializationContext.handleWeirdStringValue(Long.class, string, "not a valid `java.lang.Long` value", objectArray);
        }
    }

    public final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        Object object2;
        block17: {
            block13: {
                block16: {
                    block14: {
                        block15: {
                            int n2 = jsonParser.currentTokenId();
                            if (n2 == 1) break block13;
                            if (n2 == 3) break block14;
                            if (n2 == 11) break block15;
                            switch (n2) {
                                default: {
                                    break block16;
                                }
                                case 7: {
                                    CoercionAction coercionAction = ((StdDeserializer)((Object)coercionAction))._checkIntToFloatCoercion(jsonParser, deserializationContext, Float.TYPE);
                                    if (coercionAction == CoercionAction.AsNull) {
                                        return 0.0f;
                                    }
                                    if (coercionAction == CoercionAction.AsEmpty) {
                                        return 0.0f;
                                    }
                                }
                                case 8: {
                                    return jsonParser.getFloatValue();
                                }
                                case 6: {
                                    object2 = jsonParser.getText();
                                    break;
                                }
                            }
                            break block17;
                        }
                        ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
                        return 0.0f;
                    }
                    if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                        if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                            return ((Float)((StdDeserializer)((Object)coercionAction)).handleNestedArrayForSingle(jsonParser, deserializationContext)).floatValue();
                        }
                        float f2 = ((StdDeserializer)((Object)coercionAction))._parseFloatPrimitive(jsonParser, deserializationContext);
                        ((StdDeserializer)((Object)coercionAction))._verifyEndArrayForSingle(jsonParser, deserializationContext);
                        return f2;
                    }
                }
                return ((Number)deserializationContext.handleUnexpectedToken(Float.TYPE, jsonParser)).floatValue();
            }
            object2 = Float.TYPE;
            object2 = deserializationContext.extractScalarFromObject(jsonParser, (JsonDeserializer<?>)((Object)coercionAction), (Class<?>)object2);
        }
        if ((object = ((StdDeserializer)((Object)coercionAction))._checkFloatSpecialValue((String)object2)) != null) {
            return object.floatValue();
        }
        object = Float.TYPE;
        if ((object = ((StdDeserializer)((Object)coercionAction))._checkFromStringCoercion(deserializationContext, (String)object2, LogicalType.Integer, (Class<?>)object)) == CoercionAction.AsNull) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
            return 0.0f;
        }
        if (object == CoercionAction.AsEmpty) {
            return 0.0f;
        }
        if (((StdDeserializer)((Object)coercionAction))._hasTextualNull((String)(object2 = ((String)object2).trim()))) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitiveCoercion(deserializationContext, (String)object2);
            return 0.0f;
        }
        return ((StdDeserializer)((Object)coercionAction))._parseFloatPrimitive(jsonParser, deserializationContext, (String)object2);
    }

    public final float _parseFloatPrimitive(DeserializationContext deserializationContext, String string) {
        try {
            return NumberInput.parseFloat(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this._nonNullNumber((Number)deserializationContext.handleWeirdStringValue(Float.TYPE, string, "not a valid `float` value", new Object[0])).floatValue();
        }
    }

    public final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext, String string) {
        try {
            return NumberInput.parseFloat(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this._nonNullNumber((Number)deserializationContext.handleWeirdStringValue(Float.TYPE, string, "not a valid `float` value", new Object[0])).floatValue();
        }
    }

    public Float _checkFloatSpecialValue(String string) {
        if (!string.isEmpty()) {
            char c2 = string.charAt(0);
            if (c2 != '-') {
                if (c2 != 'I') {
                    if (c2 == 'N' && this._isNaN(string)) {
                        return Float.valueOf(Float.NaN);
                    }
                } else if (this._isPosInf(string)) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
            } else if (this._isNegInf(string)) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return null;
    }

    public final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        Object object2;
        block17: {
            block13: {
                block16: {
                    block14: {
                        block15: {
                            int n2 = jsonParser.currentTokenId();
                            if (n2 == 1) break block13;
                            if (n2 == 3) break block14;
                            if (n2 == 11) break block15;
                            switch (n2) {
                                default: {
                                    break block16;
                                }
                                case 7: {
                                    CoercionAction coercionAction = ((StdDeserializer)((Object)coercionAction))._checkIntToFloatCoercion(jsonParser, deserializationContext, Double.TYPE);
                                    if (coercionAction == CoercionAction.AsNull) {
                                        return 0.0;
                                    }
                                    if (coercionAction == CoercionAction.AsEmpty) {
                                        return 0.0;
                                    }
                                }
                                case 8: {
                                    return jsonParser.getDoubleValue();
                                }
                                case 6: {
                                    object2 = jsonParser.getText();
                                    break;
                                }
                            }
                            break block17;
                        }
                        ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
                        return 0.0;
                    }
                    if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                        if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                            return (Double)((StdDeserializer)((Object)coercionAction)).handleNestedArrayForSingle(jsonParser, deserializationContext);
                        }
                        double d2 = ((StdDeserializer)((Object)coercionAction))._parseDoublePrimitive(jsonParser, deserializationContext);
                        ((StdDeserializer)((Object)coercionAction))._verifyEndArrayForSingle(jsonParser, deserializationContext);
                        return d2;
                    }
                }
                return ((Number)deserializationContext.handleUnexpectedToken(Double.TYPE, jsonParser)).doubleValue();
            }
            object2 = Double.TYPE;
            object2 = deserializationContext.extractScalarFromObject(jsonParser, (JsonDeserializer<?>)((Object)coercionAction), (Class<?>)object2);
        }
        if ((object = ((StdDeserializer)((Object)coercionAction))._checkDoubleSpecialValue((String)object2)) != null) {
            return object;
        }
        object = Double.TYPE;
        if ((object = ((StdDeserializer)((Object)coercionAction))._checkFromStringCoercion(deserializationContext, (String)object2, LogicalType.Integer, (Class<?>)object)) == CoercionAction.AsNull) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitive(deserializationContext);
            return 0.0;
        }
        if (object == CoercionAction.AsEmpty) {
            return 0.0;
        }
        if (((StdDeserializer)((Object)coercionAction))._hasTextualNull((String)(object2 = ((String)object2).trim()))) {
            ((StdDeserializer)((Object)coercionAction))._verifyNullForPrimitiveCoercion(deserializationContext, (String)object2);
            return 0.0;
        }
        return ((StdDeserializer)((Object)coercionAction))._parseDoublePrimitive(jsonParser, deserializationContext, (String)object2);
    }

    public final double _parseDoublePrimitive(DeserializationContext deserializationContext, String string) {
        try {
            return StdDeserializer._parseDouble(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this._nonNullNumber((Number)deserializationContext.handleWeirdStringValue(Double.TYPE, string, "not a valid `double` value (as String to convert)", new Object[0])).doubleValue();
        }
    }

    public final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext, String string) {
        try {
            return StdDeserializer._parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this._nonNullNumber((Number)deserializationContext.handleWeirdStringValue(Double.TYPE, string, "not a valid `double` value (as String to convert)", new Object[0])).doubleValue();
        }
    }

    public Double _checkDoubleSpecialValue(String string) {
        if (!string.isEmpty()) {
            char c2 = string.charAt(0);
            if (c2 != '-') {
                if (c2 != 'I') {
                    if (c2 == 'N' && this._isNaN(string)) {
                        return Double.NaN;
                    }
                } else if (this._isPosInf(string)) {
                    return Double.POSITIVE_INFINITY;
                }
            } else if (this._isNegInf(string)) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date _parseDate(JsonParser object, DeserializationContext deserializationContext) {
        String string;
        int n2 = ((JsonParser)object).currentTokenId();
        if (n2 != 1) {
            if (n2 == 3) return objectArray._parseDateFromArray((JsonParser)object, deserializationContext);
            if (n2 == 11) return (Date)objectArray.getNullValue(deserializationContext);
            if (n2 != 6) {
                long l2;
                if (n2 != 7) {
                    return (Date)deserializationContext.handleUnexpectedToken(objectArray._valueClass, (JsonParser)object);
                }
                try {
                    l2 = ((JsonParser)object).getLongValue();
                    return new Date(l2);
                }
                catch (StreamReadException streamReadException) {
                    Object[] objectArray = objectArray._valueClass;
                    object = ((JsonParser)object).getNumberValue();
                    Serializable serializable = objectArray;
                    objectArray = new Object[]{};
                    l2 = ((Number)deserializationContext.handleWeirdNumberValue((Class<?>)serializable, (Number)object, "not a valid 64-bit `long` for creating `java.util.Date`", objectArray)).longValue();
                }
                return new Date(l2);
            }
            string = ((JsonParser)object).getText();
            return objectArray._parseDate(string.trim(), deserializationContext);
        }
        Class<?> clazz = objectArray._valueClass;
        string = deserializationContext.extractScalarFromObject((JsonParser)object, (JsonDeserializer<?>)objectArray, clazz);
        return objectArray._parseDate(string.trim(), deserializationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date _parseDateFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        CoercionAction coercionAction = this._findCoercionFromEmptyArray(deserializationContext);
        boolean bl = deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (!bl && coercionAction == CoercionAction.Fail) return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken == JsonToken.END_ARRAY) {
            int n2 = v.a[coercionAction.ordinal()];
            if (n2 == 1) return (Date)this.getEmptyValue(deserializationContext);
            if (n2 != 2 && n2 != 3) return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
            return (Date)this.getNullValue(deserializationContext);
        }
        if (!bl) return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
        if (jsonToken == JsonToken.START_ARRAY) {
            return (Date)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
        }
        Date date = this._parseDate(jsonParser, deserializationContext);
        this._verifyEndArrayForSingle(jsonParser, deserializationContext);
        return date;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date _parseDate(String string, DeserializationContext deserializationContext) {
        IllegalArgumentException illegalArgumentException2;
        block5: {
            try {
                if (string.isEmpty()) {
                    if (v.a[objectArray2._checkFromStringCoercion(deserializationContext, string).ordinal()] != 1) {
                        return null;
                    }
                    return new Date(0L);
                }
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                break block5;
            }
            if (objectArray2._hasTextualNull(string)) {
                return null;
            }
            return deserializationContext.parseDate(string);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ClassUtil.exceptionMessage(illegalArgumentException2);
        return (Date)deserializationContext.handleWeirdStringValue(objectArray2._valueClass, string, "not a valid representation (error: %s)", objectArray2);
    }

    @Deprecated
    public final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._parseString(jsonParser, deserializationContext, NullsConstantProvider.nuller());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final String _parseString(JsonParser var1_1, DeserializationContext var2_2, NullValueProvider var3_3) {
        block11: {
            block12: {
                var4_4 /* !! */  = CoercionAction.TryConvert;
                var5_5 = var1_1.currentTokenId();
                if (var5_5 == 1) break block11;
                if (var5_5 == 12) break block12;
                switch (var5_5) {
                    default: {
                        ** GOTO lbl22
                    }
                    case 9: 
                    case 10: {
                        v0 = this;
                        var4_4 /* !! */  = v0._valueClass;
                        var4_4 /* !! */  = v0._checkBooleanToStringCoercion(var1_1, var2_2, (Class<?>)var4_4 /* !! */ );
                        ** GOTO lbl22
                    }
                    case 8: {
                        v1 = this;
                        var4_4 /* !! */  = v1._valueClass;
                        var4_4 /* !! */  = v1._checkFloatToStringCoercion(var1_1, var2_2, (Class<?>)var4_4 /* !! */ );
                        ** GOTO lbl22
                    }
                    case 7: {
                        v2 = this;
                        var4_4 /* !! */  = v2._valueClass;
                        var4_4 /* !! */  = v2._checkIntToStringCoercion(var1_1, var2_2, (Class<?>)var4_4 /* !! */ );
lbl22:
                        // 4 sources

                        if (var4_4 /* !! */  == CoercionAction.AsNull) {
                            return (String)var3_3.getNullValue(var2_2);
                        }
                        if (var4_4 /* !! */  == CoercionAction.AsEmpty) {
                            return "";
                        }
                        if (var1_1.currentToken().isScalarValue() && (var3_3 = var1_1.getValueAsString()) != null) {
                            return var3_3;
                        }
                        return (String)var2_2.handleUnexpectedToken(this.getValueType(var2_2), var1_1);
                    }
                    case 6: 
                }
                return var1_1.getText();
            }
            this = var1_1.getEmbeddedObject();
            if (this instanceof byte[]) {
                return var2_2.getBase64Variant().encode((byte[])this, false);
            }
            if (this == null) {
                return null;
            }
            return this.toString();
        }
        return var2_2.extractScalarFromObject(var1_1, (JsonDeserializer<?>)this, this._valueClass);
    }

    public boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    public final boolean _isNegInf(String string) {
        return "-Infinity".equals(string) || "-INF".equals(string);
    }

    public final boolean _isPosInf(String string) {
        return "Infinity".equals(string) || "INF".equals(string);
    }

    public final boolean _isNaN(String string) {
        return "NaN".equals(string);
    }

    public CoercionAction _checkFromStringCoercion(DeserializationContext serializable, String string) {
        StdDeserializer stdDeserializer = object;
        DeserializationContext deserializationContext = serializable;
        StdDeserializer stdDeserializer2 = object;
        Object object = stdDeserializer2.logicalType();
        serializable = stdDeserializer2.handledType();
        return stdDeserializer._checkFromStringCoercion(deserializationContext, string, (LogicalType)((Object)object), (Class<?>)serializable);
    }

    public CoercionAction _checkFromStringCoercion(DeserializationContext objectArray, String string, LogicalType enum_, Class<?> clazz) {
        if (string.isEmpty()) {
            return this._checkCoercionFail((DeserializationContext)objectArray, objectArray.findCoercionAction((LogicalType)enum_, clazz, CoercionInputShape.EmptyString), clazz, string, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(string)) {
            return this._checkCoercionFail((DeserializationContext)objectArray, objectArray.findCoercionFromBlankString((LogicalType)enum_, clazz, CoercionAction.Fail), clazz, string, "blank String (all whitespace)");
        }
        if (objectArray.isEnabled(StreamReadCapability.UNTYPED_SCALARS)) {
            return CoercionAction.TryConvert;
        }
        if ((enum_ = objectArray.findCoercionAction((LogicalType)enum_, clazz, CoercionInputShape.String)) == CoercionAction.Fail) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = string;
            objectArray3[1] = this._coercedTypeDesc();
            objectArray2.reportInputMismatch(this, "Cannot coerce String value (\"%s\") to %s (but might if coercion using `CoercionConfig` was enabled)", objectArray);
        }
        return enum_;
    }

    public CoercionAction _checkFloatToIntCoercion(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Integer, clazz, CoercionInputShape.Float);
        if (coercionAction == CoercionAction.Fail) {
            StdDeserializer stdDeserializer = serializable;
            Serializable serializable = ((JsonParser)object).getNumberValue();
            object = "Floating-point value (" + ((JsonParser)object).getText() + ")";
            return stdDeserializer._checkCoercionFail(deserializationContext, coercionAction, clazz, serializable, (String)object);
        }
        return coercionAction;
    }

    public CoercionAction _checkIntToStringCoercion(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        StdDeserializer stdDeserializer = serializable;
        JsonParser jsonParser = object;
        Serializable serializable = jsonParser.getNumberValue();
        object = CoercionInputShape.Integer;
        return stdDeserializer._checkToStringCoercion(jsonParser, deserializationContext, clazz, serializable, (CoercionInputShape)((Object)object));
    }

    public CoercionAction _checkFloatToStringCoercion(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        StdDeserializer stdDeserializer = serializable;
        JsonParser jsonParser = object;
        Serializable serializable = jsonParser.getNumberValue();
        object = CoercionInputShape.Float;
        return stdDeserializer._checkToStringCoercion(jsonParser, deserializationContext, clazz, serializable, (CoercionInputShape)((Object)object));
    }

    public CoercionAction _checkBooleanToStringCoercion(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        StdDeserializer stdDeserializer = serializable;
        JsonParser jsonParser = object;
        Serializable serializable = Boolean.valueOf(jsonParser.getBooleanValue());
        object = CoercionInputShape.Boolean;
        return stdDeserializer._checkToStringCoercion(jsonParser, deserializationContext, clazz, serializable, (CoercionInputShape)((Object)object));
    }

    public CoercionAction _checkToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz, Object object, CoercionInputShape coercionInputShape) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Textual, clazz, coercionInputShape);
        if (coercionAction == CoercionAction.Fail) {
            StdDeserializer stdDeserializer = string;
            String string = coercionInputShape.name() + " value (" + jsonParser.getText() + ")";
            return stdDeserializer._checkCoercionFail(deserializationContext, coercionAction, clazz, object, string);
        }
        return coercionAction;
    }

    public CoercionAction _checkIntToFloatCoercion(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Float, clazz, CoercionInputShape.Integer);
        if (coercionAction == CoercionAction.Fail) {
            StdDeserializer stdDeserializer = serializable;
            Serializable serializable = ((JsonParser)object).getNumberValue();
            object = "Integer value (" + ((JsonParser)object).getText() + ")";
            return stdDeserializer._checkCoercionFail(deserializationContext, coercionAction, clazz, serializable, (String)object);
        }
        return coercionAction;
    }

    public Boolean _coerceBooleanFromInt(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Boolean, clazz, CoercionInputShape.Integer);
        int n2 = v.a[coercionAction.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (((JsonParser)object).getNumberType() == JsonParser.NumberType.INT) {
                        return ((JsonParser)object).getIntValue() != 0;
                    }
                    return "0".equals(((JsonParser)object).getText()) ^ true;
                }
                StdDeserializer stdDeserializer = serializable;
                Serializable serializable = ((JsonParser)object).getNumberValue();
                object = "Integer value (" + ((JsonParser)object).getText() + ")";
                stdDeserializer._checkCoercionFail(deserializationContext, coercionAction, clazz, serializable, (String)object);
                return Boolean.FALSE;
            }
            return null;
        }
        return Boolean.FALSE;
    }

    public CoercionAction _checkCoercionFail(DeserializationContext objectArray, CoercionAction coercionAction, Class<?> clazz, Object object, String string) {
        if (coercionAction == CoercionAction.Fail) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = string;
            objectArray3[1] = this._coercedTypeDesc();
            objectArray2.reportBadCoercion(this, clazz, object, "Cannot coerce %s to %s (but could if coercion was enabled using `CoercionConfig`)", objectArray);
        }
        return coercionAction;
    }

    public boolean _checkTextualNull(DeserializationContext deserializationContext, String object) {
        if (this._hasTextualNull((String)object)) {
            object = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            if (!deserializationContext.isEnabled((MapperFeature)object)) {
                this._reportFailedNullCoerce(deserializationContext, true, (Enum<?>)object, "String \"null\"");
            }
            return true;
        }
        return false;
    }

    public Object _coerceIntegral(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
            return jsonParser.getBigIntegerValue();
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS)) {
            return jsonParser.getLongValue();
        }
        return jsonParser.getNumberValue();
    }

    public final void _verifyNullForPrimitive(DeserializationContext objectArray) {
        if (objectArray.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = this._coercedTypeDesc();
            objectArray2.reportInputMismatch(this, "Cannot coerce `null` to %s (disable `DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES` to allow)", objectArray);
        }
    }

    public final void _verifyNullForPrimitiveCoercion(DeserializationContext deserializationContext, String string) {
        block7: {
            boolean bl;
            Enum enum_;
            block6: {
                block5: {
                    enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
                    if (deserializationContext.isEnabled((MapperFeature)enum_)) break block5;
                    bl = true;
                    break block6;
                }
                enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
                if (!deserializationContext.isEnabled((DeserializationFeature)enum_)) break block7;
                bl = false;
            }
            if (string.isEmpty()) {
                string = "empty String (\"\")";
            } else {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                string = String.format("String \"%s\"", objectArray2);
            }
            this._reportFailedNullCoerce(deserializationContext, bl, enum_, string);
            return;
        }
    }

    public void _reportFailedNullCoerce(DeserializationContext objectArray, boolean bl, Enum<?> enum_, String string) {
        String string2 = bl ? "enable" : "disable";
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[5];
        objectArray = objectArray3;
        objectArray[0] = string;
        objectArray[1] = this._coercedTypeDesc();
        objectArray[2] = string2;
        objectArray[3] = enum_.getDeclaringClass().getSimpleName();
        objectArray3[4] = enum_.name();
        objectArray2.reportInputMismatch(this, "Cannot coerce %s to Null value as %s (%s `%s.%s` to allow)", objectArray);
    }

    public String _coercedTypeDesc() {
        boolean bl;
        Object object = ((StdDeserializer)this).getValueType();
        if (object != null && !((JavaType)object).isPrimitive()) {
            bl = ((JavaType)object).isContainerType() || ((ResolvedType)object).isReferenceType();
            object = ClassUtil.getTypeDescription((JavaType)object);
        } else {
            boolean bl2 = ((Class)(this = ((StdDeserializer)this).handledType())).isArray() || Collection.class.isAssignableFrom((Class<?>)this) || Map.class.isAssignableFrom((Class<?>)this);
            object = this = ClassUtil.getClassDescription(this);
            bl = bl2;
        }
        if (bl) {
            return "element of " + (String)object;
        }
        return (String)object + " value";
    }

    @Deprecated
    public boolean _parseBooleanFromInt(JsonParser jsonParser, DeserializationContext deserializationContext) {
        this._verifyNumberForScalarCoercion(deserializationContext, jsonParser);
        return "0".equals(jsonParser.getText()) ^ true;
    }

    @Deprecated
    public void _verifyStringForScalarCoercion(DeserializationContext objectArray, String string) {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!objectArray.isEnabled(mapperFeature)) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[4];
            objectArray = objectArray3;
            objectArray[0] = string;
            objectArray[1] = this._coercedTypeDesc();
            objectArray[2] = mapperFeature.getDeclaringClass().getSimpleName();
            objectArray3[3] = mapperFeature.name();
            objectArray2.reportInputMismatch(this, "Cannot coerce String \"%s\" to %s (enable `%s.%s` to allow)", objectArray);
        }
    }

    @Deprecated
    public Object _coerceEmptyString(DeserializationContext deserializationContext, boolean bl) {
        block4: {
            Enum enum_;
            block3: {
                block2: {
                    enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
                    if (deserializationContext.isEnabled((MapperFeature)enum_)) break block2;
                    bl = true;
                    break block3;
                }
                if (!bl || !deserializationContext.isEnabled((DeserializationFeature)(enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES))) break block4;
                bl = false;
            }
            this._reportFailedNullCoerce(deserializationContext, bl, enum_, "empty String (\"\")");
            return null;
        }
        return this.getNullValue(deserializationContext);
    }

    @Deprecated
    public void _failDoubleToIntCoercion(JsonParser jsonParser, DeserializationContext objectArray, String string) {
        Object[] objectArray2 = objectArray;
        Serializable serializable = serializable.handledType();
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray3[0] = jsonParser.getValueAsString();
        objectArray3[1] = string;
        objectArray2.reportInputMismatch((Class<?>)serializable, "Cannot coerce a floating-point value ('%s') into %s (enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow)", objectArray);
    }

    @Deprecated
    public final void _verifyNullForScalarCoercion(DeserializationContext deserializationContext, String string) {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!deserializationContext.isEnabled(mapperFeature)) {
            if (string.isEmpty()) {
                string = "empty String (\"\")";
            } else {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                string = String.format("String \"%s\"", objectArray2);
            }
            this._reportFailedNullCoerce(deserializationContext, true, mapperFeature, string);
        }
    }

    @Deprecated
    public void _verifyNumberForScalarCoercion(DeserializationContext object, JsonParser objectArray) {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!((DeserializationContext)object).isEnabled(mapperFeature)) {
            DeserializationContext deserializationContext = object;
            object = objectArray.getText();
            Object[] objectArray2 = new Object[4];
            objectArray = objectArray2;
            objectArray[0] = object;
            objectArray[1] = this._coercedTypeDesc();
            objectArray[2] = mapperFeature.getDeclaringClass().getSimpleName();
            objectArray2[3] = mapperFeature.name();
            deserializationContext.reportInputMismatch(this, "Cannot coerce Number (%s) to %s (enable `%s.%s` to allow)", objectArray);
        }
    }

    @Deprecated
    public Object _coerceNullToken(DeserializationContext deserializationContext, boolean bl) {
        if (bl) {
            this._verifyNullForPrimitive(deserializationContext);
        }
        return this.getNullValue(deserializationContext);
    }

    @Deprecated
    public Object _coerceTextualNull(DeserializationContext deserializationContext, boolean bl) {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!deserializationContext.isEnabled(mapperFeature)) {
            this._reportFailedNullCoerce(deserializationContext, true, mapperFeature, "String \"null\"");
        }
        return this.getNullValue(deserializationContext);
    }

    @Deprecated
    public boolean _isEmptyOrTextualNull(String string) {
        return string.isEmpty() || "null".equals(string);
    }

    public JsonDeserializer<Object> findDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanProperty beanProperty) {
        return deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
    }

    public final boolean _isIntNumber(String string) {
        int n2 = string.length();
        if (n2 > 0) {
            int n3 = string.charAt(0);
            if (n3 != 45 && n3 != 43) {
                n3 = 0;
            } else {
                if (n2 == 1) {
                    return false;
                }
                n3 = 1;
            }
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (c2 <= '9' && c2 >= '0') {
                    ++n3;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) {
        Serializable serializable;
        Object object = deserializationContext.getAnnotationIntrospector();
        if (StdDeserializer._neitherNull(object, beanProperty) && (serializable = beanProperty.getMember()) != null && (object = ((AnnotationIntrospector)object).findDeserializationContentConverter((AnnotatedMember)serializable)) != null) {
            object = deserializationContext.converterInstance(beanProperty.getMember(), object);
            serializable = object.getInputType(deserializationContext.getTypeFactory());
            if (jsonDeserializer == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer((JavaType)serializable, beanProperty);
            }
            return new StdDelegatingDeserializer<Object>((Converter<Object, Object>)object, (JavaType)serializable, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public JsonFormat.Value findFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(deserializationContext.getConfig(), clazz);
        }
        return deserializationContext.getDefaultPropertyFormat(clazz);
    }

    public Boolean findFormatFeature(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        if ((this = ((StdDeserializer)this).findFormatOverrides(deserializationContext, beanProperty, clazz)) != null) {
            return ((JsonFormat.Value)this).getFeature(feature);
        }
        return null;
    }

    public final NullValueProvider findValueNullProvider(DeserializationContext object, SettableBeanProperty settableBeanProperty, PropertyMetadata propertyMetadata) {
        if (settableBeanProperty != null) {
            StdDeserializer stdDeserializer = object2;
            DeserializationContext deserializationContext = object;
            Object object2 = propertyMetadata.getValueNulls();
            object = settableBeanProperty.getValueDeserializer();
            return stdDeserializer._findNullProvider(deserializationContext, settableBeanProperty, (Nulls)((Object)object2), (JsonDeserializer<?>)object);
        }
        return null;
    }

    public NullValueProvider findContentNullProvider(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) {
        Nulls nulls = ((StdDeserializer)object).findContentNullStyle(deserializationContext, beanProperty);
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                Object object = deserializationContext.constructType(jsonDeserializer.handledType());
                if (((JavaType)object).isContainerType()) {
                    object = ((JavaType)object).getContentType();
                }
                return NullsFailProvider.constructForRootValue((JavaType)object);
            }
            BeanProperty beanProperty2 = beanProperty;
            return NullsFailProvider.constructForProperty(beanProperty2, beanProperty2.getType().getContentType());
        }
        if ((object = ((StdDeserializer)object)._findNullProvider(deserializationContext, beanProperty, nulls, jsonDeserializer)) != null) {
            return object;
        }
        return jsonDeserializer;
    }

    public Nulls findContentNullStyle(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        if (beanProperty != null) {
            return beanProperty.getMetadata().getContentNulls();
        }
        return deserializationContext.getConfig().getDefaultSetterInfo().getContentNulls();
    }

    public final NullValueProvider _findNullProvider(DeserializationContext objectArray, BeanProperty beanProperty, Nulls nulls, JsonDeserializer<?> jsonDeserializer) {
        Object object;
        if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                object = jsonDeserializer == null ? Object.class : jsonDeserializer.handledType();
                return NullsFailProvider.constructForRootValue(objectArray.constructType((Class<?>)object));
            }
            return NullsFailProvider.constructForProperty(beanProperty);
        }
        if (nulls == Nulls.AS_EMPTY) {
            if (jsonDeserializer == null) {
                return null;
            }
            if (jsonDeserializer instanceof BeanDeserializerBase && !((BeanDeserializerBase)(object = (BeanDeserializerBase)jsonDeserializer)).getValueInstantiator().canCreateUsingDefault()) {
                object = beanProperty == null ? ((BeanDeserializerBase)object).getValueType() : beanProperty.getType();
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = object;
                return (NullValueProvider)objectArray2.reportBadDefinition((JavaType)object, String.format("Cannot create empty instance of %s, no default Creator", objectArray));
            }
            object = jsonDeserializer.getEmptyAccessPattern();
            if (object == AccessPattern.ALWAYS_NULL) {
                return NullsConstantProvider.nuller();
            }
            if (object == AccessPattern.CONSTANT) {
                return NullsConstantProvider.forValue(jsonDeserializer.getEmptyValue((DeserializationContext)objectArray));
            }
            return new NullsAsEmptyProvider(jsonDeserializer);
        }
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        return null;
    }

    public CoercionAction _findCoercionFromEmptyString(DeserializationContext serializable) {
        DeserializationContext deserializationContext = serializable;
        StdDeserializer stdDeserializer = object;
        Object object = stdDeserializer.logicalType();
        serializable = stdDeserializer.handledType();
        return deserializationContext.findCoercionAction((LogicalType)((Object)object), (Class<?>)serializable, CoercionInputShape.EmptyString);
    }

    public CoercionAction _findCoercionFromEmptyArray(DeserializationContext serializable) {
        DeserializationContext deserializationContext = serializable;
        StdDeserializer stdDeserializer = object;
        Object object = stdDeserializer.logicalType();
        serializable = stdDeserializer.handledType();
        return deserializationContext.findCoercionAction((LogicalType)((Object)object), (Class<?>)serializable, CoercionInputShape.EmptyArray);
    }

    public CoercionAction _findCoercionFromBlankString(DeserializationContext serializable) {
        DeserializationContext deserializationContext = serializable;
        StdDeserializer stdDeserializer = object;
        Object object = stdDeserializer.logicalType();
        serializable = stdDeserializer.handledType();
        return deserializationContext.findCoercionFromBlankString((LogicalType)((Object)object), (Class<?>)serializable, CoercionAction.Fail);
    }

    public void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object clazz, String string) {
        if (clazz == null) {
            clazz = this.handledType();
        }
        if (deserializationContext.handleUnknownProperty(jsonParser, this, clazz, string)) {
            return;
        }
        jsonParser.skipChildren();
    }

    public void handleMissingEndArrayForSingle(JsonParser object, DeserializationContext objectArray) {
        Object[] objectArray2 = objectArray;
        object = JsonToken.END_ARRAY;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = this.handledType().getName();
        objectArray2.reportWrongTokenException(this, (JsonToken)((Object)object), "Attempted to unwrap '%s' value from an array (with `DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS`) but it contains more than one value", objectArray);
    }

    public Object handleNestedArrayForSingle(JsonParser jsonParser, DeserializationContext objectArray) {
        Object[] objectArray2 = objectArray;
        StdDeserializer stdDeserializer = string;
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = new Object[3];
        objectArray = objectArray4;
        objectArray4[0] = ClassUtil.nameOf(((StdDeserializer)((Object)string))._valueClass);
        objectArray4[1] = JsonToken.START_ARRAY;
        objectArray4[2] = "DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS";
        String string = String.format("Cannot deserialize instance of %s out of %s token: nested Arrays not allowed with %s", objectArray);
        objectArray = stdDeserializer.getValueType((DeserializationContext)objectArray3);
        JsonToken jsonToken = jsonParser.currentToken();
        Object[] objectArray5 = objectArray;
        objectArray = new Object[]{};
        return objectArray2.handleUnexpectedToken((JavaType)objectArray5, jsonToken, jsonParser, string, objectArray);
    }

    public void _verifyEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
        }
    }

    public final boolean _byteOverflow(int n2) {
        return n2 < -128 || n2 > 255;
    }

    public final boolean _shortOverflow(int n2) {
        return n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE;
    }

    public final boolean _intOverflow(long l2) {
        return l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE;
    }

    public Number _nonNullNumber(Number number) {
        if (number == null) {
            number = 0;
        }
        return number;
    }
}

