/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.a0;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

@JacksonStdImpl
public class StdKeyDeserializer
extends KeyDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_BYTE = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_CHAR = 4;
    public static final int TYPE_INT = 5;
    public static final int TYPE_LONG = 6;
    public static final int TYPE_FLOAT = 7;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_LOCALE = 9;
    public static final int TYPE_DATE = 10;
    public static final int TYPE_CALENDAR = 11;
    public static final int TYPE_UUID = 12;
    public static final int TYPE_URI = 13;
    public static final int TYPE_URL = 14;
    public static final int TYPE_CLASS = 15;
    public static final int TYPE_CURRENCY = 16;
    public static final int TYPE_BYTE_ARRAY = 17;
    protected final int _kind;
    protected final Class<?> _keyClass;
    protected final FromStringDeserializer<?> _deser;

    public StdKeyDeserializer(int n2, Class<?> clazz) {
        this(n2, clazz, null);
    }

    public StdKeyDeserializer(int n2, Class<?> clazz, FromStringDeserializer<?> fromStringDeserializer) {
        this._kind = n2;
        this._keyClass = clazz;
        this._deser = fromStringDeserializer;
    }

    public static StdKeyDeserializer forType(Class<?> serializable) {
        block9: {
            block25: {
                int n2;
                block11: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            block14: {
                                                                block13: {
                                                                    block12: {
                                                                        block10: {
                                                                            if (serializable == String.class || serializable == Object.class || serializable == CharSequence.class || serializable == Serializable.class) break block9;
                                                                            if (serializable != UUID.class) break block10;
                                                                            n2 = 12;
                                                                            break block11;
                                                                        }
                                                                        if (serializable != Integer.class) break block12;
                                                                        n2 = 5;
                                                                        break block11;
                                                                    }
                                                                    if (serializable != Long.class) break block13;
                                                                    n2 = 6;
                                                                    break block11;
                                                                }
                                                                if (serializable != Date.class) break block14;
                                                                n2 = 10;
                                                                break block11;
                                                            }
                                                            if (serializable != Calendar.class) break block15;
                                                            n2 = 11;
                                                            break block11;
                                                        }
                                                        if (serializable != Boolean.class) break block16;
                                                        n2 = 1;
                                                        break block11;
                                                    }
                                                    if (serializable != Byte.class) break block17;
                                                    n2 = 2;
                                                    break block11;
                                                }
                                                if (serializable != Character.class) break block18;
                                                n2 = 4;
                                                break block11;
                                            }
                                            if (serializable != Short.class) break block19;
                                            n2 = 3;
                                            break block11;
                                        }
                                        if (serializable != Float.class) break block20;
                                        n2 = 7;
                                        break block11;
                                    }
                                    if (serializable != Double.class) break block21;
                                    n2 = 8;
                                    break block11;
                                }
                                if (serializable != URI.class) break block22;
                                n2 = 13;
                                break block11;
                            }
                            if (serializable != URL.class) break block23;
                            n2 = 14;
                            break block11;
                        }
                        if (serializable != Class.class) break block24;
                        n2 = 15;
                        break block11;
                    }
                    if (serializable == Locale.class) {
                        FromStringDeserializer<Locale> fromStringDeserializer = FromStringDeserializer.findDeserializer(Locale.class);
                        return new StdKeyDeserializer(9, (Class<?>)serializable, fromStringDeserializer);
                    }
                    if (serializable == Currency.class) {
                        FromStringDeserializer<Currency> fromStringDeserializer = FromStringDeserializer.findDeserializer(Currency.class);
                        return new StdKeyDeserializer(16, (Class<?>)serializable, fromStringDeserializer);
                    }
                    if (serializable != byte[].class) break block25;
                    n2 = 17;
                }
                return new StdKeyDeserializer(n2, (Class<?>)serializable);
            }
            return null;
        }
        if (serializable == String.class) {
            serializable = a0.a;
        } else if (serializable == Object.class) {
            serializable = a0.b;
        } else {
            a0 a02;
            a0 a03 = a02;
            a02 = new a0((Class)serializable);
            serializable = a03;
        }
        return serializable;
    }

    @Override
    public Object deserializeKey(String string, DeserializationContext deserializationContext) {
        block4: {
            if (string == null) {
                return null;
            }
            try {
                Object object = objectArray2._parse(string, deserializationContext);
                if (object == null) break block4;
                return object;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = exception.getClass().getName();
                objectArray[1] = ClassUtil.exceptionMessage(exception);
                return deserializationContext.handleWeirdKey(objectArray2._keyClass, string, "not a valid representation, problem: (%s) %s", objectArray2);
            }
        }
        if (ClassUtil.isEnumType(objectArray2._keyClass) && deserializationContext.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        return deserializationContext.handleWeirdKey(objectArray2._keyClass, string, "not a valid representation", new Object[0]);
    }

    public Class<?> getKeyClass() {
        return this._keyClass;
    }

    public Object _parse(String string, DeserializationContext deserializationContext) {
        Object[] objectArray;
        switch (objectArray._kind) {
            default: {
                throw new IllegalStateException("Internal error: unknown key type " + objectArray._keyClass);
            }
            case 17: {
                try {
                    return deserializationContext.getConfig().getBase64Variant().decode(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return objectArray._weirdKey(deserializationContext, string, illegalArgumentException);
                }
            }
            case 16: {
                try {
                    return objectArray._deser._deserialize(string, deserializationContext);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return objectArray._weirdKey(deserializationContext, string, illegalArgumentException);
                }
            }
            case 15: {
                try {
                    return deserializationContext.findClass(string);
                }
                catch (Exception exception) {
                    objectArray = new Object[]{};
                    return deserializationContext.handleWeirdKey(objectArray._keyClass, string, "unable to parse key as Class", objectArray);
                }
            }
            case 14: {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    return objectArray._weirdKey(deserializationContext, string, malformedURLException);
                }
            }
            case 13: {
                try {
                    return URI.create(string);
                }
                catch (Exception exception) {
                    return objectArray._weirdKey(deserializationContext, string, exception);
                }
            }
            case 12: {
                try {
                    return UUID.fromString(string);
                }
                catch (Exception exception) {
                    return objectArray._weirdKey(deserializationContext, string, exception);
                }
            }
            case 11: {
                DeserializationContext deserializationContext2 = deserializationContext;
                return deserializationContext2.constructCalendar(deserializationContext2.parseDate(string));
            }
            case 10: {
                return deserializationContext.parseDate(string);
            }
            case 9: {
                try {
                    return objectArray._deser._deserialize(string, deserializationContext);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return objectArray._weirdKey(deserializationContext, string, illegalArgumentException);
                }
            }
            case 8: {
                return objectArray._parseDouble(string);
            }
            case 7: {
                return Float.valueOf((float)objectArray._parseDouble(string));
            }
            case 6: {
                return objectArray._parseLong(string);
            }
            case 5: {
                return objectArray._parseInt(string);
            }
            case 4: {
                if (string.length() == 1) {
                    return Character.valueOf(string.charAt(0));
                }
                objectArray = new Object[]{};
                return deserializationContext.handleWeirdKey(objectArray._keyClass, string, "can only convert 1-character Strings", objectArray);
            }
            case 3: {
                int n2 = objectArray._parseInt(string);
                if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
                    return (short)n2;
                }
                objectArray = new Object[]{};
                return deserializationContext.handleWeirdKey(objectArray._keyClass, string, "overflow, value cannot be represented as 16-bit value", objectArray);
            }
            case 2: {
                int n3 = objectArray._parseInt(string);
                if (n3 >= -128 && n3 <= 255) {
                    return (byte)n3;
                }
                objectArray = new Object[]{};
                return deserializationContext.handleWeirdKey(objectArray._keyClass, string, "overflow, value cannot be represented as 8-bit value", objectArray);
            }
            case 1: 
        }
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        objectArray = new Object[]{};
        return deserializationContext.handleWeirdKey(objectArray._keyClass, string, "value not 'true' or 'false'", objectArray);
    }

    public int _parseInt(String string) {
        return NumberInput.parseInt(string);
    }

    public long _parseLong(String string) {
        return NumberInput.parseLong(string);
    }

    public double _parseDouble(String string) {
        return NumberInput.parseDouble(string);
    }

    public Object _weirdKey(DeserializationContext deserializationContext, String string, Exception exception) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ClassUtil.exceptionMessage(exception);
        return deserializationContext.handleWeirdKey(objectArray2._keyClass, string, "problem: %s", objectArray2);
    }
}

