/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonCreator;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.deser.KeyDeserializers;
import com.privatefasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.w;
import com.privatefasterxml.jackson.databind.deser.std.x;
import com.privatefasterxml.jackson.databind.deser.std.y;
import com.privatefasterxml.jackson.databind.deser.std.z;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new x(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod annotatedMethod) {
        return new x(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        return new w(javaType.getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig deserializationConfig, JavaType list) {
        AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> annotatedAndMetadata2 = StdKeyDeserializers._findStringConstructor((BeanDescription)((Object)(list = deserializationConfig.introspectForCreation((JavaType)((Object)list)))));
        if (annotatedAndMetadata2 != null && annotatedAndMetadata2.metadata != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        list = ((BeanDescription)((Object)list)).getFactoryMethodsWithMode();
        list.removeIf(annotatedAndMetadata -> ((AnnotatedMethod)annotatedAndMetadata.annotated).getParameterCount() != 1 || ((AnnotatedMethod)annotatedAndMetadata.annotated).getRawParameterType(0) != String.class || annotatedAndMetadata.metadata == JsonCreator.Mode.PROPERTIES);
        AnnotatedMethod annotatedMethod = StdKeyDeserializers._findExplicitStringFactoryMethod(list);
        if (annotatedMethod != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, annotatedMethod);
        }
        if (annotatedAndMetadata2 != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        if (!list.isEmpty()) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)list.get((int)0).annotated);
        }
        return null;
    }

    private static KeyDeserializer _constructCreatorKeyDeserializer(DeserializationConfig deserializationConfig, AnnotatedMember object) {
        if (object instanceof AnnotatedConstructor) {
            object = ((AnnotatedConstructor)object).getAnnotated();
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess((Member)object, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new y((Constructor)object);
        }
        object = ((AnnotatedMethod)object).getAnnotated();
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess((Member)object, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new z((Method)object);
    }

    private static AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> _findStringConstructor(BeanDescription object) {
        for (AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> annotatedAndMetadata : ((BeanDescription)((Object)object)).getConstructorsWithMode()) {
            AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)annotatedAndMetadata.annotated;
            if (annotatedConstructor.getParameterCount() != 1 || String.class != annotatedConstructor.getRawParameterType(0)) continue;
            return annotatedAndMetadata;
        }
        return null;
    }

    private static AnnotatedMethod _findExplicitStringFactoryMethod(List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> clazz) {
        List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> list = clazz;
        clazz = null;
        for (AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> annotatedAndMetadata : list) {
            if (annotatedAndMetadata.metadata == null) continue;
            if (clazz == null) {
                clazz = (AnnotatedMethod)annotatedAndMetadata.annotated;
                continue;
            }
            clazz = ((AnnotatedMethod)annotatedAndMetadata.annotated).getDeclaringClass();
            throw new IllegalArgumentException("Multiple suitable annotated Creator factory methods to be used as the Key deserializer for type " + ClassUtil.nameOf(clazz));
        }
        return clazz;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Serializable serializable = javaType.getRawClass();
        if (((Class)serializable).isPrimitive()) {
            serializable = ClassUtil.wrapperType(serializable);
        }
        return StdKeyDeserializer.forType(serializable);
    }
}

