/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class StdValueInstantiator
extends ValueInstantiator
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String _valueTypeDesc;
    protected final Class<?> _valueClass;
    protected AnnotatedWithParams _defaultCreator;
    protected AnnotatedWithParams _withArgsCreator;
    protected SettableBeanProperty[] _constructorArguments;
    protected JavaType _delegateType;
    protected AnnotatedWithParams _delegateCreator;
    protected SettableBeanProperty[] _delegateArguments;
    protected JavaType _arrayDelegateType;
    protected AnnotatedWithParams _arrayDelegateCreator;
    protected SettableBeanProperty[] _arrayDelegateArguments;
    protected AnnotatedWithParams _fromStringCreator;
    protected AnnotatedWithParams _fromIntCreator;
    protected AnnotatedWithParams _fromLongCreator;
    protected AnnotatedWithParams _fromBigIntegerCreator;
    protected AnnotatedWithParams _fromDoubleCreator;
    protected AnnotatedWithParams _fromBigDecimalCreator;
    protected AnnotatedWithParams _fromBooleanCreator;

    @Deprecated
    public StdValueInstantiator(DeserializationConfig deserializationConfig, Class<?> clazz) {
        this._valueTypeDesc = ClassUtil.nameOf(clazz);
        if (clazz == null) {
            clazz = Object.class;
        }
        this._valueClass = clazz;
    }

    public StdValueInstantiator(DeserializationConfig object, JavaType javaType) {
        object = javaType == null ? "UNKNOWN TYPE" : javaType.toString();
        this._valueTypeDesc = object;
        object = javaType == null ? Object.class : javaType.getRawClass();
        this._valueClass = object;
    }

    public StdValueInstantiator(StdValueInstantiator stdValueInstantiator) {
        this._valueTypeDesc = stdValueInstantiator._valueTypeDesc;
        this._valueClass = stdValueInstantiator._valueClass;
        this._defaultCreator = stdValueInstantiator._defaultCreator;
        this._constructorArguments = stdValueInstantiator._constructorArguments;
        this._withArgsCreator = stdValueInstantiator._withArgsCreator;
        this._delegateType = stdValueInstantiator._delegateType;
        this._delegateCreator = stdValueInstantiator._delegateCreator;
        this._delegateArguments = stdValueInstantiator._delegateArguments;
        this._arrayDelegateType = stdValueInstantiator._arrayDelegateType;
        this._arrayDelegateCreator = stdValueInstantiator._arrayDelegateCreator;
        this._arrayDelegateArguments = stdValueInstantiator._arrayDelegateArguments;
        this._fromStringCreator = stdValueInstantiator._fromStringCreator;
        this._fromIntCreator = stdValueInstantiator._fromIntCreator;
        this._fromLongCreator = stdValueInstantiator._fromLongCreator;
        this._fromBigIntegerCreator = stdValueInstantiator._fromBigIntegerCreator;
        this._fromDoubleCreator = stdValueInstantiator._fromDoubleCreator;
        this._fromBigDecimalCreator = stdValueInstantiator._fromBigDecimalCreator;
        this._fromBooleanCreator = stdValueInstantiator._fromBooleanCreator;
    }

    public static Double tryConvertToDouble(BigDecimal bigDecimal) {
        double d2 = bigDecimal.doubleValue();
        return Double.isInfinite(d2) ? null : Double.valueOf(d2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object _createUsingDelegate(AnnotatedWithParams annotatedWithParams, SettableBeanProperty[] settableBeanPropertyArray, DeserializationContext deserializationContext, Object object) {
        if (annotatedWithParams == null) throw new IllegalStateException("No delegate constructor for " + this.getValueTypeDesc());
        if (settableBeanPropertyArray == null) {
            try {
                return annotatedWithParams.call1(object);
            }
            catch (Throwable throwable) {
                throw this.rewrapCtorProblem(deserializationContext, throwable);
            }
        }
        int n2 = settableBeanPropertyArray.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
            objectArray[i2] = settableBeanProperty == null ? object : deserializationContext.findInjectableValue(settableBeanProperty.getInjectableValueId(), settableBeanProperty, null);
            {
                continue;
            }
        }
        return annotatedWithParams.call(objectArray);
    }

    public void configureFromObjectSettings(AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2, JavaType javaType, SettableBeanProperty[] settableBeanPropertyArray, AnnotatedWithParams annotatedWithParams3, SettableBeanProperty[] settableBeanPropertyArray2) {
        StdValueInstantiator stdValueInstantiator = this;
        stdValueInstantiator._defaultCreator = annotatedWithParams;
        stdValueInstantiator._delegateCreator = annotatedWithParams2;
        stdValueInstantiator._delegateType = javaType;
        stdValueInstantiator._delegateArguments = settableBeanPropertyArray;
        stdValueInstantiator._withArgsCreator = annotatedWithParams3;
        stdValueInstantiator._constructorArguments = settableBeanPropertyArray2;
    }

    public void configureFromArraySettings(AnnotatedWithParams annotatedWithParams, JavaType javaType, SettableBeanProperty[] settableBeanPropertyArray) {
        StdValueInstantiator stdValueInstantiator = this;
        stdValueInstantiator._arrayDelegateCreator = annotatedWithParams;
        stdValueInstantiator._arrayDelegateType = javaType;
        stdValueInstantiator._arrayDelegateArguments = settableBeanPropertyArray;
    }

    public void configureFromStringCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromStringCreator = annotatedWithParams;
    }

    public void configureFromIntCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromIntCreator = annotatedWithParams;
    }

    public void configureFromLongCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromLongCreator = annotatedWithParams;
    }

    public void configureFromBigIntegerCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromBigIntegerCreator = annotatedWithParams;
    }

    public void configureFromDoubleCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromDoubleCreator = annotatedWithParams;
    }

    public void configureFromBigDecimalCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromBigDecimalCreator = annotatedWithParams;
    }

    public void configureFromBooleanCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromBooleanCreator = annotatedWithParams;
    }

    @Override
    public String getValueTypeDesc() {
        return this._valueTypeDesc;
    }

    @Override
    public Class<?> getValueClass() {
        return this._valueClass;
    }

    @Override
    public boolean canCreateFromString() {
        return this._fromStringCreator != null;
    }

    @Override
    public boolean canCreateFromInt() {
        return this._fromIntCreator != null;
    }

    @Override
    public boolean canCreateFromLong() {
        return this._fromLongCreator != null;
    }

    @Override
    public boolean canCreateFromBigInteger() {
        return this._fromBigIntegerCreator != null;
    }

    @Override
    public boolean canCreateFromDouble() {
        return this._fromDoubleCreator != null;
    }

    @Override
    public boolean canCreateFromBigDecimal() {
        return this._fromBigDecimalCreator != null;
    }

    @Override
    public boolean canCreateFromBoolean() {
        return this._fromBooleanCreator != null;
    }

    @Override
    public boolean canCreateUsingDefault() {
        return this._defaultCreator != null;
    }

    @Override
    public boolean canCreateUsingDelegate() {
        return this._delegateType != null;
    }

    @Override
    public boolean canCreateUsingArrayDelegate() {
        return this._arrayDelegateType != null;
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return this._withArgsCreator != null;
    }

    @Override
    public boolean canInstantiate() {
        return this.canCreateUsingDefault() || this.canCreateUsingDelegate() || this.canCreateUsingArrayDelegate() || this.canCreateFromObjectWith() || this.canCreateFromString() || this.canCreateFromInt() || this.canCreateFromLong() || this.canCreateFromDouble() || this.canCreateFromBoolean();
    }

    @Override
    public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
        return this._delegateType;
    }

    @Override
    public JavaType getArrayDelegateType(DeserializationConfig deserializationConfig) {
        return this._arrayDelegateType;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        return this._constructorArguments;
    }

    @Override
    public Object createUsingDefault(DeserializationContext serializable) {
        AnnotatedWithParams annotatedWithParams = serializable2._defaultCreator;
        if (annotatedWithParams == null) {
            return super.createUsingDefault((DeserializationContext)serializable);
        }
        try {
            return annotatedWithParams.call();
        }
        catch (Exception exception) {
            DeserializationContext deserializationContext = serializable;
            StdValueInstantiator stdValueInstantiator = serializable2;
            Serializable serializable2 = serializable2._valueClass;
            serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, exception);
            return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, null, (Throwable)serializable);
        }
    }

    @Override
    public Object createFromObjectWith(DeserializationContext serializable, Object[] objectArray) {
        AnnotatedWithParams annotatedWithParams = serializable2._withArgsCreator;
        if (annotatedWithParams == null) {
            return super.createFromObjectWith((DeserializationContext)serializable, objectArray);
        }
        try {
            return annotatedWithParams.call(objectArray);
        }
        catch (Exception exception) {
            DeserializationContext deserializationContext = serializable;
            StdValueInstantiator stdValueInstantiator = serializable2;
            Serializable serializable2 = serializable2._valueClass;
            serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, exception);
            return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, objectArray, (Throwable)serializable);
        }
    }

    @Override
    public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) {
        AnnotatedWithParams annotatedWithParams;
        AnnotatedWithParams annotatedWithParams2 = this._delegateCreator;
        if (annotatedWithParams2 == null && (annotatedWithParams = this._arrayDelegateCreator) != null) {
            return this._createUsingDelegate(annotatedWithParams, this._arrayDelegateArguments, deserializationContext, object);
        }
        return this._createUsingDelegate(annotatedWithParams2, this._delegateArguments, deserializationContext, object);
    }

    @Override
    public Object createUsingArrayDelegate(DeserializationContext deserializationContext, Object object) {
        AnnotatedWithParams annotatedWithParams = this._arrayDelegateCreator;
        if (annotatedWithParams == null && this._delegateCreator != null) {
            return this.createUsingDelegate(deserializationContext, object);
        }
        return this._createUsingDelegate(annotatedWithParams, this._arrayDelegateArguments, deserializationContext, object);
    }

    @Override
    public Object createFromString(DeserializationContext serializable, String string) {
        AnnotatedWithParams annotatedWithParams = serializable2._fromStringCreator;
        if (annotatedWithParams != null) {
            try {
                return annotatedWithParams.call1(string);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                Serializable serializable2 = serializable2._fromStringCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, string, (Throwable)serializable);
            }
        }
        return super.createFromString((DeserializationContext)serializable, string);
    }

    @Override
    public Object createFromInt(DeserializationContext serializable, int n2) {
        Serializable serializable2;
        if (serializable2._fromIntCreator != null) {
            Integer n3 = n2;
            try {
                return serializable2._fromIntCreator.call1(n3);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                serializable2 = serializable2._fromIntCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, n3, (Throwable)serializable);
            }
        }
        if (serializable2._fromLongCreator != null) {
            Long l2 = n2;
            try {
                return serializable2._fromLongCreator.call1(l2);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                serializable2 = serializable2._fromLongCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, l2, (Throwable)serializable);
            }
        }
        if (serializable2._fromBigIntegerCreator != null) {
            BigInteger bigInteger = BigInteger.valueOf(n2);
            try {
                return serializable2._fromBigIntegerCreator.call1(bigInteger);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                Serializable serializable3 = serializable2;
                serializable2 = serializable2._fromBigIntegerCreator.getDeclaringClass();
                serializable = ((StdValueInstantiator)serializable3).rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, bigInteger, (Throwable)serializable);
            }
        }
        return super.createFromInt((DeserializationContext)serializable, n2);
    }

    @Override
    public Object createFromLong(DeserializationContext serializable, long l2) {
        Serializable serializable2;
        if (serializable2._fromLongCreator != null) {
            Long l3 = l2;
            try {
                return serializable2._fromLongCreator.call1(l3);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                serializable2 = serializable2._fromLongCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, l3, (Throwable)serializable);
            }
        }
        if (serializable2._fromBigIntegerCreator != null) {
            BigInteger bigInteger = BigInteger.valueOf(l2);
            try {
                return serializable2._fromBigIntegerCreator.call1(bigInteger);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                serializable2 = serializable2._fromBigIntegerCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, bigInteger, (Throwable)serializable);
            }
        }
        return super.createFromLong((DeserializationContext)serializable, l2);
    }

    @Override
    public Object createFromBigInteger(DeserializationContext serializable, BigInteger bigInteger) {
        AnnotatedWithParams annotatedWithParams = serializable2._fromBigIntegerCreator;
        if (annotatedWithParams != null) {
            try {
                return annotatedWithParams.call1(bigInteger);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                Serializable serializable2 = serializable2._fromBigIntegerCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, bigInteger, (Throwable)serializable);
            }
        }
        return super.createFromBigInteger((DeserializationContext)serializable, bigInteger);
    }

    @Override
    public Object createFromDouble(DeserializationContext serializable, double d2) {
        Serializable serializable2;
        if (serializable2._fromDoubleCreator != null) {
            Double d3 = d2;
            try {
                return serializable2._fromDoubleCreator.call1(d3);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                serializable2 = serializable2._fromDoubleCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, d3, (Throwable)serializable);
            }
        }
        if (serializable2._fromBigDecimalCreator != null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(d2);
            try {
                return serializable2._fromBigDecimalCreator.call1(bigDecimal);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                serializable2 = serializable2._fromBigDecimalCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, bigDecimal, (Throwable)serializable);
            }
        }
        return super.createFromDouble((DeserializationContext)serializable, d2);
    }

    @Override
    public Object createFromBigDecimal(DeserializationContext serializable, BigDecimal bigDecimal) {
        Serializable serializable2;
        Serializable serializable3 = serializable2._fromBigDecimalCreator;
        if (serializable3 != null) {
            try {
                return serializable3.call1(bigDecimal);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                StdValueInstantiator stdValueInstantiator = serializable2;
                serializable2 = serializable2._fromBigDecimalCreator.getDeclaringClass();
                serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, bigDecimal, (Throwable)serializable);
            }
        }
        if (serializable2._fromDoubleCreator != null && (serializable3 = StdValueInstantiator.tryConvertToDouble(bigDecimal)) != null) {
            try {
                return serializable2._fromDoubleCreator.call1(serializable3);
            }
            catch (Throwable throwable) {
                DeserializationContext deserializationContext = serializable;
                Serializable serializable4 = serializable2;
                serializable2 = serializable2._fromDoubleCreator.getDeclaringClass();
                serializable = ((StdValueInstantiator)serializable4).rewrapCtorProblem((DeserializationContext)serializable, throwable);
                return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, serializable3, (Throwable)serializable);
            }
        }
        return super.createFromBigDecimal((DeserializationContext)serializable, bigDecimal);
    }

    @Override
    public Object createFromBoolean(DeserializationContext serializable, boolean bl) {
        if (serializable2._fromBooleanCreator == null) {
            return super.createFromBoolean((DeserializationContext)serializable, bl);
        }
        Boolean bl2 = bl;
        try {
            return serializable2._fromBooleanCreator.call1(bl2);
        }
        catch (Throwable throwable) {
            DeserializationContext deserializationContext = serializable;
            StdValueInstantiator stdValueInstantiator = serializable2;
            Serializable serializable2 = serializable2._fromBooleanCreator.getDeclaringClass();
            serializable = stdValueInstantiator.rewrapCtorProblem((DeserializationContext)serializable, throwable);
            return deserializationContext.handleInstantiationProblem((Class<?>)serializable2, bl2, (Throwable)serializable);
        }
    }

    @Override
    public AnnotatedWithParams getDelegateCreator() {
        return this._delegateCreator;
    }

    @Override
    public AnnotatedWithParams getArrayDelegateCreator() {
        return this._arrayDelegateCreator;
    }

    @Override
    public AnnotatedWithParams getDefaultCreator() {
        return this._defaultCreator;
    }

    @Override
    public AnnotatedWithParams getWithArgsCreator() {
        return this._withArgsCreator;
    }

    @Deprecated
    public JsonMappingException wrapException(Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof JsonMappingException)) continue;
            return (JsonMappingException)throwable2;
        }
        return new JsonMappingException(null, "Instantiation of " + this.getValueTypeDesc() + " value failed: " + ClassUtil.exceptionMessage(throwable), throwable);
    }

    @Deprecated
    public JsonMappingException unwrapAndWrapException(DeserializationContext deserializationContext, Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof JsonMappingException)) continue;
            return (JsonMappingException)throwable2;
        }
        return deserializationContext.instantiationException(this.getValueClass(), throwable);
    }

    public JsonMappingException wrapAsJsonMappingException(DeserializationContext deserializationContext, Throwable throwable) {
        if (throwable instanceof JsonMappingException) {
            return (JsonMappingException)throwable;
        }
        return deserializationContext.instantiationException(this.getValueClass(), throwable);
    }

    public JsonMappingException rewrapCtorProblem(DeserializationContext deserializationContext, Throwable throwable) {
        Throwable throwable2;
        if ((throwable instanceof ExceptionInInitializerError || throwable instanceof InvocationTargetException) && (throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
        }
        return this.wrapAsJsonMappingException(deserializationContext, throwable);
    }
}

