/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import com.privatefasterxml.jackson.databind.util.ObjectBuffer;
import java.util.Objects;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    private static final String[] NO_STRINGS = new String[0];
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;
    protected final NullValueProvider _nullProvider;
    protected final Boolean _unwrapSingle;
    protected final boolean _skipNullValues;

    public StringArrayDeserializer() {
        this(null, null, null);
    }

    public StringArrayDeserializer(JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        super(String[].class);
        this._elementDeserializer = jsonDeserializer;
        this._nullProvider = nullValueProvider;
        this._unwrapSingle = bl;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    private final String[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Class<?> clazz;
        Object object = ((StringArrayDeserializer)((Object)clazz))._unwrapSingle;
        if (!(object == Boolean.TRUE || object == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY))) {
            if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                return (String[])((StdDeserializer)((Object)clazz))._deserializeFromString(jsonParser, deserializationContext);
            }
            return (String[])deserializationContext.handleUnexpectedToken(((StdDeserializer)((Object)clazz))._valueClass, jsonParser);
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            clazz = (String)((StringArrayDeserializer)((Object)clazz))._nullProvider.getNullValue(deserializationContext);
        } else {
            if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                object = jsonParser.getText();
                if (((String)object).isEmpty()) {
                    Class<?> clazz2 = clazz;
                    object = ((StringArrayDeserializer)((Object)clazz2)).logicalType();
                    Class<?> clazz3 = ((StdDeserializer)((Object)clazz2)).handledType();
                    if ((object = deserializationContext.findCoercionAction((LogicalType)((Object)object), clazz3, CoercionInputShape.EmptyString)) != CoercionAction.Fail) {
                        Class<?> clazz4 = clazz;
                        clazz = ((StdDeserializer)((Object)clazz)).handledType();
                        return (String[])((StdDeserializer)((Object)clazz4))._deserializeFromEmptyString(jsonParser, deserializationContext, (CoercionAction)((Object)object), clazz, "empty String (\"\")");
                    }
                } else if (StdDeserializer._isBlank((String)object)) {
                    Class<?> clazz5 = clazz;
                    object = ((StringArrayDeserializer)((Object)clazz5)).logicalType();
                    CoercionAction coercionAction = CoercionAction.Fail;
                    if ((object = deserializationContext.findCoercionFromBlankString((LogicalType)((Object)object), ((StdDeserializer)((Object)clazz5)).handledType(), coercionAction)) != coercionAction) {
                        Class<?> clazz6 = clazz;
                        clazz = ((StdDeserializer)((Object)clazz)).handledType();
                        return (String[])((StdDeserializer)((Object)clazz6))._deserializeFromEmptyString(jsonParser, deserializationContext, (CoercionAction)((Object)object), clazz, "blank String (all whitespace)");
                    }
                }
            }
            StringArrayDeserializer stringArrayDeserializer = clazz;
            clazz = stringArrayDeserializer._nullProvider;
            clazz = stringArrayDeserializer._parseString(jsonParser, deserializationContext, (NullValueProvider)((Object)clazz));
        }
        return new String[]{clazz};
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return NO_STRINGS;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) {
        StringArrayDeserializer stringArrayDeserializer = this;
        JsonDeserializer<Object> jsonDeserializer = stringArrayDeserializer._elementDeserializer;
        jsonDeserializer = stringArrayDeserializer.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer);
        Object object2 = ((DeserializationContext)object).constructType(String.class);
        jsonDeserializer = jsonDeserializer == null ? ((DeserializationContext)object).findContextualValueDeserializer((JavaType)object2, beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)object2);
        StringArrayDeserializer stringArrayDeserializer2 = this;
        object2 = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY;
        object2 = stringArrayDeserializer2.findFormatFeature((DeserializationContext)object, beanProperty, String[].class, (JsonFormat.Feature)((Object)object2));
        object = stringArrayDeserializer2.findContentNullProvider((DeserializationContext)object, beanProperty, jsonDeserializer);
        if (jsonDeserializer != null && this.isDefaultDeserializer(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        if (this._elementDeserializer == jsonDeserializer && Objects.equals(this._unwrapSingle, object2) && this._nullProvider == object) {
            return this;
        }
        return new StringArrayDeserializer(jsonDeserializer, (NullValueProvider)object, (Boolean)object2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] deserialize(JsonParser var1_1, DeserializationContext var2_2) {
        if (!var1_1.isExpectedStartArrayToken()) {
            return this.handleNonArray(var1_1, var2_2);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(var1_1, var2_2, null);
        }
        var3_3 = var2_2.leaseObjectBuffer();
        var4_4 = var3_3.resetAndStart();
        var5_5 = 0;
        while (true) {
            block12: {
                block13: {
                    try {
                        var6_6 /* !! */  = var1_1.nextTextValue();
                        if (var6_6 /* !! */  != null) break block12;
                    }
                    catch (Exception v0) {
                        throw JsonMappingException.wrapWithPath((Throwable)v0, (Object)var4_4, var3_3.bufferedSize() + var5_5);
                    }
                    {
                        var6_6 /* !! */  = var1_1.currentToken();
                    }
                    {
                        if (var6_6 /* !! */  != JsonToken.END_ARRAY) ** GOTO lbl-1000
                        var2_2.returnObjectBuffer(var3_3);
                        return var3_3.completeAndClearBuffer(var4_4, var5_5, String.class);
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var6_6 /* !! */  != JsonToken.VALUE_NULL) break block13;
                    }
                    if (this._skipNullValues) continue;
                    v1 = (String)this._nullProvider.getNullValue(var2_2);
lbl22:
                    // 2 sources

                    while (true) {
                        var6_6 /* !! */  = v1;
                        break block12;
                        break;
                    }
                }
                v2 = this;
                var6_6 /* !! */  = v2._nullProvider;
                v1 = v2._parseString(var1_1, var2_2, (NullValueProvider)var6_6 /* !! */ );
                ** continue;
            }
            if (var5_5 >= var4_4.length) {
                var4_4 = var3_3.appendCompletedChunk(var4_4);
                var5_5 = 0;
            }
            {
                var4_4[var5_5++] = var6_6 /* !! */ ;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] _deserializeCustom(JsonParser jsonParser, DeserializationContext deserializationContext, String[] objectArray) {
        Object[] objectArray2;
        int n2;
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        if (objectArray == null) {
            n2 = 0;
            objectArray2 = objectBuffer.resetAndStart();
        } else {
            int n3 = objectArray.length;
            objectArray = objectBuffer.resetAndStart(objectArray, n3);
            objectArray2 = objectArray;
            n2 = n3;
        }
        JsonDeserializer<String> jsonDeserializer = this._elementDeserializer;
        while (true) {
            Exception exception2;
            Object object;
            block14: {
                Object object2;
                block12: {
                    block13: {
                        try {
                            if (jsonParser.nextTextValue() != null) break block12;
                            object = jsonParser.currentToken();
                            if (object == JsonToken.END_ARRAY) {
                                deserializationContext.returnObjectBuffer(objectBuffer);
                                return objectBuffer.completeAndClearBuffer(objectArray2, n2, String.class);
                            }
                            if (object != JsonToken.VALUE_NULL) break block13;
                        }
                        catch (Exception exception2) {
                            throw JsonMappingException.wrapWithPath((Throwable)exception2, String.class, n2);
                        }
                        if (this._skipNullValues) continue;
                        object2 = this._nullProvider.getNullValue(deserializationContext);
                    }
                    object2 = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                    break block14;
                }
                object2 = object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
            }
            if (n2 >= objectArray2.length) {
                int n4;
                Object[] objectArray3 = objectBuffer.appendCompletedChunk(objectArray2);
                n2 = n4 = 0;
                objectArray2 = objectArray3;
            }
            int n5 = n2 + 1;
            try {
                objectArray2[n2] = object;
                n2 = n5;
            }
            catch (Exception exception2) {
                n2 = n5;
                throw JsonMappingException.wrapWithPath((Throwable)exception2, String.class, n2);
            }
        }
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] deserialize(JsonParser var1_2, DeserializationContext var2_4, String[] var3_5) {
        if (!var1_2.isExpectedStartArrayToken()) {
            if ((this = this.handleNonArray(var1_2, (DeserializationContext)var2_4)) == null) {
                return var3_5;
            }
            var1_3 = var3_5.length;
            var2_4 = new String[var1_3 + this.length];
            System.arraycopy(var3_5, 0, var2_4, 0, var1_3);
            var0_1 = this.length;
            System.arraycopy(this, 0, var2_4, var1_3, var0_1);
            return var2_4;
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(var1_2, (DeserializationContext)var2_4, var3_5);
        }
        var4_8 = var2_4.leaseObjectBuffer();
        var3_6 = var3_5.length;
        var5_9 = var4_8.resetAndStart(var3_5, var3_6);
        while (true) {
            block14: {
                block15: {
                    try {
                        var6_11 /* !! */  = var1_2.nextTextValue();
                        if (var6_11 /* !! */  != null) break block14;
                    }
                    catch (Exception v0) {
                        throw JsonMappingException.wrapWithPath((Throwable)v0, (Object)var5_9, var4_8.bufferedSize() + var3_6);
                    }
                    {
                        var6_11 /* !! */  = var1_2.currentToken();
                    }
                    {
                        if (var6_11 /* !! */  != JsonToken.END_ARRAY) ** GOTO lbl-1000
                        var2_4.returnObjectBuffer(var4_8);
                        return var4_8.completeAndClearBuffer(var5_9, var3_6, String.class);
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var6_11 /* !! */  != JsonToken.VALUE_NULL) break block15;
                    }
                    if (this._skipNullValues) {
                        return StringArrayDeserializer.NO_STRINGS;
                    }
                    v1 = (String)this._nullProvider.getNullValue((DeserializationContext)var2_4);
lbl30:
                    // 2 sources

                    while (true) {
                        var6_11 /* !! */  = v1;
                        break block14;
                        break;
                    }
                }
                var6_11 /* !! */  = this._nullProvider;
                v1 = this._parseString(var1_2, (DeserializationContext)var2_4, (NullValueProvider)var6_11 /* !! */ );
                ** continue;
            }
            if (var3_6 >= var5_9.length) {
                var3_7 = var4_8.appendCompletedChunk(var5_9);
                var3_6 = var5_10 = 0;
                var5_9 = var3_7;
            }
            {
                var5_9[var3_6++] = var6_11 /* !! */ ;
                continue;
            }
            break;
        }
    }
}

