/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.Base64Variants;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.privatefasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Arrays;
import java.util.UUID;

public class UUIDDeserializer
extends FromStringDeserializer<UUID> {
    private static final long serialVersionUID = 1L;
    static final int[] HEX_DIGITS;

    public UUIDDeserializer() {
        super(UUID.class);
    }

    private UUID _badFormat(String string, DeserializationContext deserializationContext) {
        return (UUID)deserializationContext.handleWeirdStringValue(this.handledType(), string, "UUID has to be represented by standard 36-char representation", new Object[0]);
    }

    private UUID _fromBytes(byte[] byArray, DeserializationContext serializable) {
        if (byArray.length == 16) {
            long l2 = UUIDDeserializer._long(byArray, 0);
            long l3 = UUIDDeserializer._long(byArray, 8);
            return new UUID(l2, l3);
        }
        JsonParser jsonParser = serializable.getParser();
        UUIDDeserializer uUIDDeserializer = string;
        String string = "Can only construct UUIDs from byte[16]; got " + byArray.length + " bytes";
        serializable = uUIDDeserializer.handledType();
        throw InvalidFormatException.from(jsonParser, string, byArray, serializable);
    }

    private static long _long(byte[] byArray, int n2) {
        return (long)UUIDDeserializer._int(byArray, n2) << 32 | (long)UUIDDeserializer._int(byArray, n2 + 4) << 32 >>> 32;
    }

    private static int _int(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static {
        int n2;
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (n2 = 0; n2 < 10; ++n2) {
            UUIDDeserializer.HEX_DIGITS[n2 + 48] = n2;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            int n3;
            UUIDDeserializer.HEX_DIGITS[n2 + 97] = n3 = n2 + 10;
            UUIDDeserializer.HEX_DIGITS[n2 + 65] = n3;
        }
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return new UUID(0L, 0L);
    }

    @Override
    public UUID _deserialize(String string, DeserializationContext deserializationContext) {
        if (string.length() != 36) {
            if (string.length() == 24) {
                return this._fromBytes(Base64Variants.getDefaultVariant().decode(string), deserializationContext);
            }
            return this._badFormat(string, deserializationContext);
        }
        if (string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            this._badFormat(string, deserializationContext);
        }
        long l2 = ((long)this.intFromChars(string, 0, deserializationContext) << 32) + ((long)this.shortFromChars(string, 9, deserializationContext) << 16 | (long)this.shortFromChars(string, 14, deserializationContext));
        long l3 = (long)(this.shortFromChars(string, 19, deserializationContext) << 16 | this.shortFromChars(string, 24, deserializationContext)) << 32 | (long)this.intFromChars(string, 28, deserializationContext) << 32 >>> 32;
        return new UUID(l2, l3);
    }

    @Override
    public UUID _deserializeEmbedded(Object object, DeserializationContext deserializationContext) {
        if (object instanceof byte[]) {
            return this._fromBytes((byte[])object, deserializationContext);
        }
        return (UUID)super._deserializeEmbedded(object, deserializationContext);
    }

    public int intFromChars(String string, int n2, DeserializationContext deserializationContext) {
        int n3 = (this.byteFromChars(string, n2, deserializationContext) << 24) + (this.byteFromChars(string, n2 + 2, deserializationContext) << 16) + (this.byteFromChars(string, n2 + 4, deserializationContext) << 8);
        return this.byteFromChars(string, n2 + 6, deserializationContext) + n3;
    }

    public int shortFromChars(String string, int n2, DeserializationContext deserializationContext) {
        int n3 = this.byteFromChars(string, n2, deserializationContext) << 8;
        return this.byteFromChars(string, n2 + 2, deserializationContext) + n3;
    }

    public int byteFromChars(String string, int n2, DeserializationContext deserializationContext) {
        int[] nArray;
        int n3;
        char c2 = string.charAt(n2);
        int n4 = n2 + 1;
        char c3 = string.charAt(n4);
        if (c2 <= '\u007f' && c3 <= '\u007f' && (n3 = HEX_DIGITS[c2] << 4 | (nArray = HEX_DIGITS)[c3]) >= 0) {
            return n3;
        }
        if (c2 <= '\u007f' && HEX_DIGITS[c2] >= 0) {
            return this._badChar(string, n4, deserializationContext, c3);
        }
        return this._badChar(string, n2, deserializationContext, c2);
    }

    public int _badChar(String string, int n2, DeserializationContext deserializationContext, char c2) {
        Class<?> clazz = objectArray2.handledType();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = Character.valueOf(c2);
        objectArray[1] = Integer.toHexString(c2);
        throw deserializationContext.weirdStringException(string, clazz, String.format("Non-hex character '%c' (value 0x%s), not valid for UUID String", objectArray2));
    }
}

