/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.c0;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.ObjectBuffer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JacksonStdImpl
public class UntypedObjectDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer,
ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected JsonDeserializer<Object> _mapDeserializer;
    protected JsonDeserializer<Object> _listDeserializer;
    protected JsonDeserializer<Object> _stringDeserializer;
    protected JsonDeserializer<Object> _numberDeserializer;
    protected JavaType _listType;
    protected JavaType _mapType;
    protected final boolean _nonMerging;

    @Deprecated
    public UntypedObjectDeserializer() {
        this(null, null);
    }

    public UntypedObjectDeserializer(JavaType javaType, JavaType javaType2) {
        super(Object.class);
        this._listType = javaType;
        this._mapType = javaType2;
        this._nonMerging = false;
    }

    public UntypedObjectDeserializer(UntypedObjectDeserializer untypedObjectDeserializer, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, JsonDeserializer<?> jsonDeserializer3, JsonDeserializer<?> jsonDeserializer4) {
        super(Object.class);
        this._mapDeserializer = jsonDeserializer;
        this._listDeserializer = jsonDeserializer2;
        this._stringDeserializer = jsonDeserializer3;
        this._numberDeserializer = jsonDeserializer4;
        this._listType = untypedObjectDeserializer._listType;
        this._mapType = untypedObjectDeserializer._mapType;
        this._nonMerging = untypedObjectDeserializer._nonMerging;
    }

    public UntypedObjectDeserializer(UntypedObjectDeserializer untypedObjectDeserializer, boolean bl) {
        super(Object.class);
        this._mapDeserializer = untypedObjectDeserializer._mapDeserializer;
        this._listDeserializer = untypedObjectDeserializer._listDeserializer;
        this._stringDeserializer = untypedObjectDeserializer._stringDeserializer;
        this._numberDeserializer = untypedObjectDeserializer._numberDeserializer;
        this._listType = untypedObjectDeserializer._listType;
        this._mapType = untypedObjectDeserializer._mapType;
        this._nonMerging = bl;
    }

    private void _squashDups(Map<String, Object> map, String string, Object object, Object object2) {
        if (object instanceof List) {
            ((List)object).add(object2);
            map.put(string, object);
        } else {
            ArrayList<Object> arrayList;
            Serializable serializable = arrayList;
            new ArrayList<Object>().add(object);
            ((ArrayList)serializable).add(object2);
            map.put(string, serializable);
        }
    }

    @Override
    public void resolve(DeserializationContext serializable) {
        DeserializationContext deserializationContext = serializable;
        JavaType javaType = deserializationContext.constructType(Object.class);
        JavaType javaType2 = deserializationContext.constructType(String.class);
        TypeFactory typeFactory = deserializationContext.getTypeFactory();
        JavaType javaType3 = this._listType;
        if (javaType3 == null) {
            javaType3 = typeFactory.constructCollectionType(List.class, javaType);
            this._listDeserializer = this._clearIfStdImpl(this._findCustomDeser((DeserializationContext)serializable, javaType3));
        } else {
            this._listDeserializer = this._findCustomDeser((DeserializationContext)serializable, javaType3);
        }
        javaType3 = this._mapType;
        if (javaType3 == null) {
            javaType = typeFactory.constructMapType(Map.class, javaType2, javaType);
            this._mapDeserializer = this._clearIfStdImpl(this._findCustomDeser((DeserializationContext)serializable, javaType));
        } else {
            this._mapDeserializer = this._findCustomDeser((DeserializationContext)serializable, javaType3);
        }
        DeserializationContext deserializationContext2 = serializable;
        this._stringDeserializer = this._clearIfStdImpl(this._findCustomDeser((DeserializationContext)serializable, javaType2));
        javaType = typeFactory.constructType((Type)((Object)Number.class));
        this._numberDeserializer = this._clearIfStdImpl(this._findCustomDeser((DeserializationContext)serializable, javaType));
        serializable = TypeFactory.unknownType();
        this._mapDeserializer = deserializationContext2.handleSecondaryContextualization(this._mapDeserializer, null, (JavaType)serializable);
        this._listDeserializer = deserializationContext2.handleSecondaryContextualization(this._listDeserializer, null, (JavaType)serializable);
        this._stringDeserializer = deserializationContext2.handleSecondaryContextualization(this._stringDeserializer, null, (JavaType)serializable);
        this._numberDeserializer = deserializationContext2.handleSecondaryContextualization(this._numberDeserializer, null, (JavaType)serializable);
    }

    public JsonDeserializer<Object> _findCustomDeser(DeserializationContext deserializationContext, JavaType javaType) {
        return deserializationContext.findNonContextualValueDeserializer(javaType);
    }

    public JsonDeserializer<Object> _clearIfStdImpl(JsonDeserializer<Object> jsonDeserializer) {
        if (ClassUtil.isJacksonStdImpl(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        boolean bl = beanProperty == null && Boolean.FALSE.equals(deserializationContext.getConfig().getDefaultMergeable(Object.class));
        if (stdDeserializer._stringDeserializer == null && stdDeserializer._numberDeserializer == null && stdDeserializer._mapDeserializer == null && stdDeserializer._listDeserializer == null && stdDeserializer.getClass() == UntypedObjectDeserializer.class) {
            StdDeserializer stdDeserializer;
            if (bl) {
                c0 c02;
                stdDeserializer = c02;
                c02 = new c0(true);
            } else {
                stdDeserializer = c0.c;
            }
            return stdDeserializer;
        }
        if (bl != stdDeserializer._nonMerging) {
            return new UntypedObjectDeserializer((UntypedObjectDeserializer)stdDeserializer, bl);
        }
        return stdDeserializer;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return null;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        switch (jsonParser.currentTokenId()) {
            default: {
                return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 11: {
                return null;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 8: {
                JsonDeserializer jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._numberDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 7: {
                JsonDeserializer<Object> jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._numberDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(StdDeserializer.F_MASK_INT_COERCIONS)) {
                    return ((StdDeserializer)jsonDeserializer)._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 6: {
                JsonDeserializer jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._stringDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return ((UntypedObjectDeserializer)jsonDeserializer).mapArrayToArray(jsonParser, deserializationContext);
                }
                JsonDeserializer<Object> jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._listDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return ((UntypedObjectDeserializer)jsonDeserializer).mapArray(jsonParser, deserializationContext);
            }
            case 1: 
            case 2: 
            case 5: 
        }
        JsonDeserializer<Object> jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._mapDeserializer;
        if (jsonDeserializer != null) {
            return jsonDeserializer.deserialize(jsonParser, deserializationContext);
        }
        return ((UntypedObjectDeserializer)jsonDeserializer).mapObject(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer object) {
        switch (jsonParser.currentTokenId()) {
            default: {
                return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 11: {
                return null;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 8: {
                JsonDeserializer jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._numberDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 7: {
                object = ((UntypedObjectDeserializer)jsonDeserializer)._numberDeserializer;
                if (object != null) {
                    return ((JsonDeserializer)object).deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(StdDeserializer.F_MASK_INT_COERCIONS)) {
                    return ((StdDeserializer)jsonDeserializer)._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 6: {
                JsonDeserializer jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._stringDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 1: 
            case 3: 
            case 5: 
        }
        return ((TypeDeserializer)object).deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        if (((UntypedObjectDeserializer)jsonDeserializer)._nonMerging) {
            return ((UntypedObjectDeserializer)jsonDeserializer).deserialize(jsonParser, deserializationContext);
        }
        switch (jsonParser.currentTokenId()) {
            default: {
                return ((UntypedObjectDeserializer)jsonDeserializer).deserialize(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 11: {
                return null;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 8: {
                JsonDeserializer jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._numberDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 7: {
                JsonDeserializer<Object> jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._numberDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (deserializationContext.hasSomeOfFeatures(StdDeserializer.F_MASK_INT_COERCIONS)) {
                    return ((StdDeserializer)jsonDeserializer)._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 6: {
                JsonDeserializer jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._stringDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                return jsonParser.getText();
            }
            case 3: {
                JsonDeserializer<Object> jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._listDeserializer;
                if (jsonDeserializer != null) {
                    return jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (object instanceof Collection) {
                    return ((UntypedObjectDeserializer)jsonDeserializer).mapArray(jsonParser, deserializationContext, (Collection)object);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return ((UntypedObjectDeserializer)jsonDeserializer).mapArrayToArray(jsonParser, deserializationContext);
                }
                return ((UntypedObjectDeserializer)jsonDeserializer).mapArray(jsonParser, deserializationContext);
            }
            case 1: 
            case 2: 
            case 5: 
        }
        JsonDeserializer<Object> jsonDeserializer = ((UntypedObjectDeserializer)jsonDeserializer)._mapDeserializer;
        if (jsonDeserializer != null) {
            return jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
        }
        if (object instanceof Map) {
            return ((UntypedObjectDeserializer)jsonDeserializer).mapObject(jsonParser, deserializationContext, (Map)object);
        }
        return ((UntypedObjectDeserializer)jsonDeserializer).mapObject(jsonParser, deserializationContext);
    }

    public Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        ArrayList arrayList;
        Object object = JsonToken.END_ARRAY;
        if (jsonParser.nextToken() == object) {
            return new ArrayList(2);
        }
        Object object2 = serializable.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() == object) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
            arrayList2.add(object2);
            return arrayList2;
        }
        Object object3 = serializable.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() == object) {
            ArrayList<Object> arrayList3 = new ArrayList<Object>(2);
            arrayList3.add(object2);
            arrayList3.add(object3);
            return arrayList3;
        }
        object = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = ((ObjectBuffer)object).resetAndStart();
        Object[] objectArray2 = objectArray;
        objectArray[0] = object2;
        int n2 = 2;
        objectArray[1] = object3;
        int n3 = n2;
        do {
            Object object4 = serializable.deserialize(jsonParser, deserializationContext);
            ++n2;
            if (n3 >= objectArray2.length) {
                int n4;
                Object[] objectArray3 = ((ObjectBuffer)object).appendCompletedChunk(objectArray2);
                n3 = n4 = 0;
                objectArray2 = objectArray3;
            }
            objectArray2[n3++] = object4;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        Serializable serializable = arrayList;
        ((ArrayList)serializable)(n2);
        ((ObjectBuffer)object).completeAndClearBuffer(objectArray2, n3, (List<Object>)((Object)serializable));
        deserializationContext.returnObjectBuffer((ObjectBuffer)object);
        return arrayList;
    }

    public Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            collection.add(this.deserialize(jsonParser, deserializationContext));
        }
        return collection;
    }

    public Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        LinkedHashMap<String, Object> linkedHashMap;
        Object object = jsonParser.currentToken();
        if (object == JsonToken.START_OBJECT) {
            object = jsonParser.nextFieldName();
        } else if (object == JsonToken.FIELD_NAME) {
            object = jsonParser.currentName();
        } else {
            if (object != JsonToken.END_OBJECT) {
                return deserializationContext.handleUnexpectedToken(((StdDeserializer)((Object)string3)).handledType(), jsonParser);
            }
            object = null;
        }
        if (object == null) {
            return new LinkedHashMap(2);
        }
        jsonParser.nextToken();
        Object object2 = ((UntypedObjectDeserializer)((Object)string3)).deserialize(jsonParser, deserializationContext);
        String string = jsonParser.nextFieldName();
        if (string == null) {
            LinkedHashMap<JsonToken, Object> linkedHashMap2 = new LinkedHashMap<JsonToken, Object>(2);
            ((AbstractMap)linkedHashMap2).put(object, object2);
            return linkedHashMap2;
        }
        jsonParser.nextToken();
        Object object3 = ((UntypedObjectDeserializer)((Object)string3)).deserialize(jsonParser, deserializationContext);
        String string2 = jsonParser.nextFieldName();
        if (string2 == null) {
            LinkedHashMap<String, Object> linkedHashMap3;
            LinkedHashMap<String, Object> linkedHashMap4 = linkedHashMap3;
            linkedHashMap4(4);
            ((AbstractMap)linkedHashMap4).put((String)object, object2);
            if (((AbstractMap)linkedHashMap3).put(string, object3) != null) {
                return ((UntypedObjectDeserializer)((Object)string3))._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap4, (String)object, object2, object3, string2);
            }
            return linkedHashMap4;
        }
        LinkedHashMap<String, Object> linkedHashMap5 = linkedHashMap;
        linkedHashMap5();
        ((AbstractMap)linkedHashMap5).put((String)object, object2);
        if (((AbstractMap)linkedHashMap).put(string, object3) != null) {
            return ((UntypedObjectDeserializer)((Object)string3))._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap5, (String)object, object2, object3, string2);
        }
        do {
            jsonParser.nextToken();
            object = ((UntypedObjectDeserializer)((Object)string3)).deserialize(jsonParser, deserializationContext);
            object2 = ((AbstractMap)linkedHashMap5).put(string2, (Object)object);
            if (object2 == null) continue;
            UntypedObjectDeserializer untypedObjectDeserializer = string3;
            JsonParser jsonParser2 = jsonParser;
            String string3 = jsonParser2.nextFieldName();
            return untypedObjectDeserializer._mapObjectWithDups(jsonParser2, deserializationContext, linkedHashMap5, string2, object2, object, string3);
        } while ((string2 = jsonParser.nextFieldName()) != null);
        return linkedHashMap5;
    }

    public Object _mapObjectWithDups(JsonParser jsonParser, DeserializationContext deserializationContext, Map<String, Object> map, String string, Object object, Object object2, String string2) {
        boolean bl = deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
        if (bl) {
            this._squashDups(map, string, object, object2);
        }
        while (string2 != null) {
            jsonParser.nextToken();
            object = this.deserialize(jsonParser, deserializationContext);
            object2 = map.put(string2, object);
            if (object2 != null && bl) {
                this._squashDups(map, string, object2, object);
            }
            string2 = jsonParser.nextFieldName();
        }
        return map;
    }

    public Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return NO_OBJECTS;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        do {
            Object object = this.deserialize(jsonParser, deserializationContext);
            if (n2 >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n2 = 0;
            }
            objectArray[n2++] = object;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        Object[] objectArray2 = objectBuffer.completeAndClearBuffer(objectArray, n2);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return objectArray2;
    }

    public Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) {
        Object object = jsonParser.currentToken();
        if (object == JsonToken.START_OBJECT) {
            object = jsonParser.nextToken();
        }
        if (object == JsonToken.END_OBJECT) {
            return map;
        }
        object = jsonParser.currentName();
        do {
            jsonParser.nextToken();
            Object object2 = map.get(object);
            Object object3 = object2 != null ? this.deserialize(jsonParser, deserializationContext, object2) : this.deserialize(jsonParser, deserializationContext);
            if (object3 == object2) continue;
            map.put(object, object3);
        } while ((object = jsonParser.nextFieldName()) != null);
        return map;
    }

    @JacksonStdImpl
    @Deprecated
    public static class Vanilla
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        public static final Vanilla std = new Vanilla();
        protected final boolean _nonMerging;

        public Vanilla() {
            this(false);
        }

        public Vanilla(boolean bl) {
            super(Object.class);
            this._nonMerging = bl;
        }

        public static Vanilla instance(boolean bl) {
            if (bl) {
                return new Vanilla(true);
            }
            return std;
        }

        private void _squashDups(Map<String, Object> map, String string, Object object, Object object2) {
            if (object instanceof List) {
                ((List)object).add(object2);
                map.put(string, object);
            } else {
                ArrayList<Object> arrayList;
                Serializable serializable = arrayList;
                new ArrayList<Object>().add(object);
                ((ArrayList)serializable).add(object2);
                map.put(string, serializable);
            }
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.Untyped;
        }

        @Override
        public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
            return this._nonMerging ? Boolean.FALSE : null;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            switch (jsonParser.currentTokenId()) {
                default: {
                    return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
                }
                case 12: {
                    return jsonParser.getEmbeddedObject();
                }
                case 11: {
                    return null;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 7: {
                    if (deserializationContext.hasSomeOfFeatures(StdDeserializer.F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    return jsonParser.getNumberValue();
                }
                case 6: {
                    return jsonParser.getText();
                }
                case 3: {
                    if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                        if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                            return NO_OBJECTS;
                        }
                        return new ArrayList(2);
                    }
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                        return this.mapArrayToArray(jsonParser, deserializationContext);
                    }
                    return this.mapArray(jsonParser, deserializationContext);
                }
                case 2: {
                    return new LinkedHashMap(2);
                }
                case 1: {
                    if (jsonParser.nextToken() != JsonToken.END_OBJECT) break;
                    return new LinkedHashMap(2);
                }
                case 5: 
            }
            return this.mapObject(jsonParser, deserializationContext);
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            switch (jsonParser.currentTokenId()) {
                default: {
                    return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
                }
                case 12: {
                    return jsonParser.getEmbeddedObject();
                }
                case 11: {
                    return null;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 7: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                        return jsonParser.getBigIntegerValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 6: {
                    return jsonParser.getText();
                }
                case 1: 
                case 3: 
                case 5: 
            }
            return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
            if (this._nonMerging) {
                return this.deserialize(jsonParser, deserializationContext);
            }
            switch (jsonParser.currentTokenId()) {
                default: {
                    break;
                }
                case 3: {
                    if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                        return object;
                    }
                    if (!(object instanceof Collection)) break;
                    Collection collection = (Collection)object;
                    do {
                        collection.add(this.deserialize(jsonParser, deserializationContext));
                    } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
                    return object;
                }
                case 2: 
                case 4: {
                    return object;
                }
                case 1: {
                    if (jsonParser.nextToken() == JsonToken.END_OBJECT) {
                        return object;
                    }
                }
                case 5: {
                    if (!(object instanceof Map)) break;
                    Map map = (Map)object;
                    String string = jsonParser.currentName();
                    do {
                        jsonParser.nextToken();
                        Object v2 = map.get(string);
                        Object object2 = v2 != null ? this.deserialize(jsonParser, deserializationContext, v2) : this.deserialize(jsonParser, deserializationContext);
                        if (object2 == v2) continue;
                        map.put(string, object2);
                    } while ((string = jsonParser.nextFieldName()) != null);
                    return object;
                }
            }
            return this.deserialize(jsonParser, deserializationContext);
        }

        public Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
            ArrayList arrayList;
            Object object = serializable.deserialize(jsonParser, deserializationContext);
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add(object);
                return arrayList2;
            }
            ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
            Object[] objectArray = objectBuffer.resetAndStart();
            Object[] objectArray2 = objectArray;
            int n2 = 1;
            objectArray[0] = object;
            int n3 = n2;
            do {
                Object object2 = serializable.deserialize(jsonParser, deserializationContext);
                ++n2;
                if (n3 >= objectArray2.length) {
                    int n4;
                    Object[] objectArray3 = objectBuffer.appendCompletedChunk(objectArray2);
                    n3 = n4 = 0;
                    objectArray2 = objectArray3;
                }
                objectArray2[n3++] = object2;
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            Serializable serializable = arrayList;
            ((ArrayList)serializable)(n2);
            objectBuffer.completeAndClearBuffer(objectArray2, n3, (List<Object>)((Object)serializable));
            deserializationContext.returnObjectBuffer(objectBuffer);
            return arrayList;
        }

        public Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
            ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
            Object[] objectArray = objectBuffer.resetAndStart();
            int n2 = 0;
            do {
                Object object = this.deserialize(jsonParser, deserializationContext);
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            Object[] objectArray2 = objectBuffer.completeAndClearBuffer(objectArray, n2);
            deserializationContext.returnObjectBuffer(objectBuffer);
            return objectArray2;
        }

        public Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
            LinkedHashMap<String, Object> linkedHashMap;
            JsonParser jsonParser2 = jsonParser;
            Object object = jsonParser2.currentName();
            jsonParser2.nextToken();
            Object object2 = ((Vanilla)((Object)string2)).deserialize(jsonParser, deserializationContext);
            String string = jsonParser.nextFieldName();
            if (string == null) {
                LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>(2);
                ((AbstractMap)linkedHashMap2).put((String)object, object2);
                return linkedHashMap2;
            }
            LinkedHashMap<String, Object> linkedHashMap3 = linkedHashMap;
            ((AbstractMap)new LinkedHashMap<String, Object>()).put((String)object, object2);
            do {
                jsonParser.nextToken();
                object = ((Vanilla)((Object)string2)).deserialize(jsonParser, deserializationContext);
                object2 = ((AbstractMap)linkedHashMap3).put(string, object);
                if (object2 == null) continue;
                Vanilla vanilla = string2;
                JsonParser jsonParser3 = jsonParser;
                String string2 = jsonParser3.nextFieldName();
                return vanilla._mapObjectWithDups(jsonParser3, deserializationContext, linkedHashMap3, string, object2, object, string2);
            } while ((string = jsonParser.nextFieldName()) != null);
            return linkedHashMap3;
        }

        public Object _mapObjectWithDups(JsonParser jsonParser, DeserializationContext deserializationContext, Map<String, Object> map, String object, Object object2, Object object3, String string) {
            boolean bl = deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
            if (bl) {
                this._squashDups(map, (String)object, object2, object3);
            }
            while (string != null) {
                jsonParser.nextToken();
                object = this.deserialize(jsonParser, deserializationContext);
                object2 = map.put(string, object);
                if (object2 != null && bl) {
                    this._squashDups(map, string, object2, object);
                }
                string = jsonParser.nextFieldName();
            }
            return map;
        }
    }
}

