/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.exc;

import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.exc.MismatchedInputException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class PropertyBindingException
extends MismatchedInputException {
    private static final int MAX_DESC_LENGTH = 1000;
    protected final Class<?> _referringClass;
    protected final String _propertyName;
    protected final Collection<Object> _propertyIds;
    protected transient String _propertiesAsString;

    public PropertyBindingException(JsonParser jsonParser, String string, JsonLocation jsonLocation, Class<?> clazz, String string2, Collection<Object> collection) {
        super(jsonParser, string, jsonLocation);
        this._referringClass = clazz;
        this._propertyName = string2;
        this._propertyIds = collection;
    }

    @Deprecated
    public PropertyBindingException(String string, JsonLocation jsonLocation, Class<?> clazz, String string2, Collection<Object> collection) {
        this(null, string, jsonLocation, clazz, string2, collection);
    }

    @Override
    public String getMessageSuffix() {
        CharSequence charSequence = this._propertiesAsString;
        if (charSequence == null && this._propertyIds != null) {
            StringBuilder stringBuilder;
            charSequence = stringBuilder;
            stringBuilder = new StringBuilder(100);
            int n2 = this._propertyIds.size();
            if (n2 == 1) {
                CharSequence charSequence2 = charSequence;
                ((StringBuilder)charSequence).append(" (one known property: \"");
                ((StringBuilder)charSequence2).append(String.valueOf(this._propertyIds.iterator().next()));
                ((StringBuilder)charSequence2).append('\"');
            } else {
                ((StringBuilder)charSequence).append(" (").append(n2).append(" known properties: ");
                Iterator<Object> iterator = this._propertyIds.iterator();
                while (iterator.hasNext()) {
                    CharSequence charSequence3 = charSequence;
                    ((StringBuilder)charSequence).append('\"');
                    ((StringBuilder)charSequence3).append(String.valueOf(iterator.next()));
                    ((StringBuilder)charSequence3).append('\"');
                    if (((StringBuilder)charSequence3).length() > 1000) {
                        ((StringBuilder)charSequence).append(" [truncated]");
                        break;
                    }
                    if (!iterator.hasNext()) continue;
                    ((StringBuilder)charSequence).append(", ");
                }
            }
            CharSequence charSequence4 = charSequence;
            ((StringBuilder)charSequence4).append("])");
            charSequence = ((StringBuilder)charSequence4).toString();
            this._propertiesAsString = charSequence;
        }
        return charSequence;
    }

    public Class<?> getReferringClass() {
        return this._referringClass;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Collection<Object> getKnownPropertyIds() {
        Collection<Object> collection = ((PropertyBindingException)((Object)collection))._propertyIds;
        if (collection == null) {
            return null;
        }
        return Collections.unmodifiableCollection(collection);
    }
}

