/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ext;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.deser.Deserializers;
import com.privatefasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLDeserializers
extends Deserializers.Base {
    static final DatatypeFactory _dataTypeFactory;
    protected static final int TYPE_DURATION = 1;
    protected static final int TYPE_G_CALENDAR = 2;
    protected static final int TYPE_QNAME = 3;

    static {
        try {
            _dataTypeFactory = DatatypeFactory.newInstance();
            return;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz == QName.class) {
            return new Std(clazz, 3);
        }
        if (clazz == XMLGregorianCalendar.class) {
            return new Std(clazz, 2);
        }
        if (clazz == Duration.class) {
            return new Std(clazz, 1);
        }
        return null;
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return clazz == QName.class || clazz == XMLGregorianCalendar.class || clazz == Duration.class;
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        protected final int _kind;

        public Std(Class<?> clazz, int n2) {
            super(clazz);
            this._kind = n2;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (this._kind == 2 && jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return this._gregorianFromDate(deserializationContext, this._parseDate(jsonParser, deserializationContext));
            }
            return super.deserialize(jsonParser, deserializationContext);
        }

        @Override
        public Object _deserialize(String string, DeserializationContext deserializationContext) {
            int n2 = this._kind;
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 == 3) {
                        return QName.valueOf(string);
                    }
                    throw new IllegalStateException();
                }
                try {
                    return this._gregorianFromDate(deserializationContext, this._parseDate(string, deserializationContext));
                }
                catch (JsonMappingException jsonMappingException) {
                    return _dataTypeFactory.newXMLGregorianCalendar(string);
                }
            }
            return _dataTypeFactory.newDuration(string);
        }

        public XMLGregorianCalendar _gregorianFromDate(DeserializationContext serializable, Date date) {
            GregorianCalendar gregorianCalendar;
            if (date == null) {
                return null;
            }
            Serializable serializable2 = gregorianCalendar;
            new GregorianCalendar().setTime(date);
            serializable = serializable.getTimeZone();
            if (serializable != null) {
                ((GregorianCalendar)serializable2).setTimeZone((TimeZone)serializable);
            }
            return _dataTypeFactory.newXMLGregorianCalendar((GregorianCalendar)serializable2);
        }
    }
}

