/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ext;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.Serializers;
import com.privatefasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.Calendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        if (!Duration.class.isAssignableFrom(clazz) && !QName.class.isAssignableFrom(clazz)) {
            if (XMLGregorianCalendar.class.isAssignableFrom(clazz)) {
                return XMLGregorianCalendarSerializer.instance;
            }
            return null;
        }
        return ToStringSerializer.instance;
    }

    public static class XMLGregorianCalendarSerializer
    extends StdSerializer<XMLGregorianCalendar>
    implements ContextualSerializer {
        static final XMLGregorianCalendarSerializer instance = new XMLGregorianCalendarSerializer();
        final JsonSerializer<Object> _delegate;

        public XMLGregorianCalendarSerializer() {
            this(CalendarSerializer.instance);
        }

        public XMLGregorianCalendarSerializer(JsonSerializer<?> jsonSerializer) {
            super(XMLGregorianCalendar.class);
            this._delegate = jsonSerializer;
        }

        @Override
        public JsonSerializer<?> getDelegatee() {
            return this._delegate;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, XMLGregorianCalendar xMLGregorianCalendar) {
            return this._delegate.isEmpty(serializerProvider, this._convert(xMLGregorianCalendar));
        }

        @Override
        public void serialize(XMLGregorianCalendar xMLGregorianCalendar, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            this._delegate.serialize(this._convert(xMLGregorianCalendar), jsonGenerator, serializerProvider);
        }

        @Override
        public void serializeWithType(XMLGregorianCalendar xMLGregorianCalendar, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
            XMLGregorianCalendarSerializer xMLGregorianCalendarSerializer = object;
            TypeSerializer typeSerializer2 = typeSerializer;
            Object object = JsonToken.VALUE_STRING;
            object = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId((Object)xMLGregorianCalendar, XMLGregorianCalendar.class, (JsonToken)((Object)object)));
            xMLGregorianCalendarSerializer.serialize(xMLGregorianCalendar, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            this._delegate.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, null);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
            if ((object = ((SerializerProvider)object).handlePrimaryContextualization(this._delegate, beanProperty)) != this._delegate) {
                return new XMLGregorianCalendarSerializer((JsonSerializer<?>)object);
            }
            return this;
        }

        public Calendar _convert(XMLGregorianCalendar xMLGregorianCalendar) {
            return xMLGregorianCalendar == null ? null : xMLGregorianCalendar.toGregorianCalendar();
        }
    }
}

