/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ext;

import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class DOMDeserializer<T>
extends FromStringDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private static final DocumentBuilderFactory DEFAULT_PARSER_FACTORY;

    public DOMDeserializer(Class<T> clazz) {
        super(clazz);
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Error error) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Throwable throwable) {}
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Throwable throwable) {}
        DEFAULT_PARSER_FACTORY = documentBuilderFactory;
    }

    @Override
    public abstract T _deserialize(String var1, DeserializationContext var2);

    public final Document parse(String string) {
        try {
            return this.documentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to parse JSON String as XML: " + exception.getMessage(), exception);
        }
    }

    public DocumentBuilder documentBuilder() {
        return DEFAULT_PARSER_FACTORY.newDocumentBuilder();
    }

    public static class DocumentDeserializer
    extends DOMDeserializer<Document> {
        private static final long serialVersionUID = 1L;

        public DocumentDeserializer() {
            super(Document.class);
        }

        @Override
        public Document _deserialize(String string, DeserializationContext deserializationContext) {
            return this.parse(string);
        }
    }

    public static class NodeDeserializer
    extends DOMDeserializer<Node> {
        private static final long serialVersionUID = 1L;

        public NodeDeserializer() {
            super(Node.class);
        }

        @Override
        public Node _deserialize(String string, DeserializationContext deserializationContext) {
            return this.parse(string);
        }
    }
}

