/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ext;

import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.deser.Deserializers;
import com.privatefasterxml.jackson.databind.ext.Java7Handlers;
import com.privatefasterxml.jackson.databind.ser.Serializers;
import com.privatefasterxml.jackson.databind.ser.std.DateSerializer;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "com.privatefasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "com.privatefasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String SERIALIZER_FOR_DOM_NODE = "com.privatefasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "com.privatefasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "com.privatefasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    private static final Class<?> CLASS_DOM_NODE;
    private static final Class<?> CLASS_DOM_DOCUMENT;
    private static final Java7Handlers _jdk7Helper;
    public static final OptionalHandlerFactory instance;
    private static final String CLS_NAME_JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String CLS_NAME_JAVA_SQL_DATE = "java.sql.Date";
    private static final String CLS_NAME_JAVA_SQL_TIME = "java.sql.Time";
    private static final String CLS_NAME_JAVA_SQL_BLOB = "java.sql.Blob";
    private static final String CLS_NAME_JAVA_SQL_SERIALBLOB = "javax.sql.rowset.serial.SerialBlob";
    private final Map<String, String> _sqlDeserializers;
    private final Map<String, Object> _sqlSerializers;

    public OptionalHandlerFactory() {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2;
        hashMap3();
        this._sqlDeserializers = hashMap3;
        hashMap2.put(CLS_NAME_JAVA_SQL_DATE, "com.privatefasterxml.jackson.databind.deser.std.DateDeserializers$SqlDateDeserializer");
        hashMap2.put(CLS_NAME_JAVA_SQL_TIMESTAMP, "com.privatefasterxml.jackson.databind.deser.std.DateDeserializers$TimestampDeserializer");
        hashMap3 = hashMap;
        hashMap3();
        this._sqlSerializers = hashMap3;
        hashMap.put(CLS_NAME_JAVA_SQL_TIMESTAMP, DateSerializer.instance);
        hashMap.put(CLS_NAME_JAVA_SQL_DATE, "com.privatefasterxml.jackson.databind.ser.std.SqlDateSerializer");
        hashMap.put(CLS_NAME_JAVA_SQL_TIME, "com.privatefasterxml.jackson.databind.ser.std.SqlTimeSerializer");
        hashMap.put(CLS_NAME_JAVA_SQL_BLOB, "com.privatefasterxml.jackson.databind.ext.SqlBlobSerializer");
        hashMap.put(CLS_NAME_JAVA_SQL_SERIALBLOB, "com.privatefasterxml.jackson.databind.ext.SqlBlobSerializer");
    }

    private boolean _IsXOfY(Class<?> clazz, Class<?> clazz2) {
        return clazz2 != null && clazz2.isAssignableFrom(clazz);
    }

    private Object instantiate(String string, JavaType javaType) {
        try {
            return this.instantiate(Class.forName(string), javaType);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to find class `" + string + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable.getClass().getName() + ") " + throwable.getMessage());
        }
    }

    private Object instantiate(Class<?> clazz, JavaType javaType) {
        try {
            return ClassUtil.createInstance(clazz, false);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to create instance of `" + clazz.getName() + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable.getClass().getName() + ") " + throwable.getMessage());
        }
    }

    private boolean hasSuperClassStartingWith(Class<?> clazz, String string) {
        for (Serializable serializable = clazz.getSuperclass(); serializable != null; serializable = ((Class)serializable).getSuperclass()) {
            if (serializable == Object.class) {
                return false;
            }
            if (!((Class)serializable).getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    static {
        Object object = null;
        Class<Node> clazz = null;
        try {
            clazz = Node.class;
        }
        catch (Throwable throwable) {}
        object = Document.class;
        CLASS_DOM_NODE = clazz;
        CLASS_DOM_DOCUMENT = object;
        object = null;
        try {
            object = Java7Handlers.instance();
        }
        catch (Throwable throwable) {}
        _jdk7Helper = object;
        instance = new OptionalHandlerFactory();
    }

    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        if (((OptionalHandlerFactory)this)._IsXOfY(clazz, CLASS_DOM_NODE)) {
            return (JsonSerializer)((OptionalHandlerFactory)this).instantiate(SERIALIZER_FOR_DOM_NODE, javaType);
        }
        Object object = _jdk7Helper;
        if (object != null && (object = ((Java7Handlers)object).getSerializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        object = clazz.getName();
        Object object2 = ((OptionalHandlerFactory)this)._sqlSerializers.get(object);
        if (object2 != null) {
            if (object2 instanceof JsonSerializer) {
                return (JsonSerializer)object2;
            }
            return (JsonSerializer)((OptionalHandlerFactory)this).instantiate((String)object2, javaType);
        }
        if (!((String)object).startsWith(PACKAGE_PREFIX_JAVAX_XML) && !((OptionalHandlerFactory)this).hasSuperClassStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        if ((this = ((OptionalHandlerFactory)this).instantiate(SERIALIZERS_FOR_JAVAX_XML, javaType)) == null) {
            return null;
        }
        return ((Serializers)this).findSerializer(serializationConfig, javaType, beanDescription);
    }

    public JsonDeserializer<?> findDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        Object object = _jdk7Helper;
        if (object != null && (object = ((Java7Handlers)object).getDeserializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        if (((OptionalHandlerFactory)this)._IsXOfY(clazz, CLASS_DOM_NODE)) {
            return (JsonDeserializer)((OptionalHandlerFactory)this).instantiate(DESERIALIZER_FOR_DOM_NODE, javaType);
        }
        if (((OptionalHandlerFactory)this)._IsXOfY(clazz, CLASS_DOM_DOCUMENT)) {
            return (JsonDeserializer)((OptionalHandlerFactory)this).instantiate(DESERIALIZER_FOR_DOM_DOCUMENT, javaType);
        }
        object = clazz.getName();
        String string = ((OptionalHandlerFactory)this)._sqlDeserializers.get(object);
        if (string != null) {
            return (JsonDeserializer)((OptionalHandlerFactory)this).instantiate(string, javaType);
        }
        if (!((String)object).startsWith(PACKAGE_PREFIX_JAVAX_XML) && !((OptionalHandlerFactory)this).hasSuperClassStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        if ((this = ((OptionalHandlerFactory)this).instantiate(DESERIALIZERS_FOR_JAVAX_XML, javaType)) == null) {
            return null;
        }
        return ((Deserializers)this).findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }

    public boolean hasDeserializerFor(Class<?> clazz) {
        if (this._IsXOfY(clazz, CLASS_DOM_NODE)) {
            return true;
        }
        if (this._IsXOfY(clazz, CLASS_DOM_DOCUMENT)) {
            return true;
        }
        String string = clazz.getName();
        if (!string.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            return this._sqlDeserializers.containsKey(string);
        }
        return true;
    }
}

