/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ext;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

@JacksonStdImpl
public class SqlBlobSerializer
extends StdScalarSerializer<Blob> {
    public SqlBlobSerializer() {
        super(Blob.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Blob blob) {
        return blob == null;
    }

    @Override
    public void serialize(Blob blob, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        this._writeValue(blob, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(Blob blob, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        SqlBlobSerializer sqlBlobSerializer = writableTypeId;
        TypeSerializer typeSerializer2 = typeSerializer;
        WritableTypeId writableTypeId = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId(blob, JsonToken.VALUE_EMBEDDED_OBJECT));
        sqlBlobSerializer._writeValue(blob, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    public void _writeValue(Blob blob, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object = null;
        try {
            object = blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            Object[] objectArray = new Object[]{};
            serializerProvider.reportMappingProblem(sQLException, "Failed to access `java.sql.Blob` value to write as binary value", objectArray);
        }
        jsonGenerator.writeBinary(serializerProvider.getConfig().getBase64Variant(), (InputStream)object, -1);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType);
        if (jsonArrayFormatVisitor != null) {
            jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

