/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotationCollector;
import com.privatefasterxml.jackson.databind.introspect.ClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.privatefasterxml.jackson.databind.type.TypeBindings;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnnotatedClassResolver {
    private static final Annotations NO_ANNOTATIONS = AnnotationCollector.emptyAnnotations();
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_ENUM = Enum.class;
    private static final Class<?> CLS_LIST = List.class;
    private static final Class<?> CLS_MAP = Map.class;
    private final MapperConfig<?> _config;
    private final AnnotationIntrospector _intr;
    private final ClassIntrospector.MixInResolver _mixInResolver;
    private final TypeBindings _bindings;
    private final JavaType _type;
    private final Class<?> _class;
    private final Class<?> _primaryMixin;
    private final boolean _collectAnnotations;

    public AnnotatedClassResolver(MapperConfig<?> serializable, JavaType javaType, ClassIntrospector.MixInResolver object) {
        this._config = serializable;
        this._type = javaType;
        Class<?> clazz = javaType.getRawClass();
        this._class = clazz;
        this._mixInResolver = object;
        this._bindings = javaType.getBindings();
        serializable = serializable.isAnnotationProcessingEnabled() ? serializable.getAnnotationIntrospector() : null;
        this._intr = serializable;
        object = object == null ? null : object.findMixInClassFor(clazz);
        this._primaryMixin = object;
        boolean bl = serializable != null && (!ClassUtil.isJDKClass(clazz) || !javaType.isContainerType());
        this._collectAnnotations = bl;
    }

    public AnnotatedClassResolver(MapperConfig<?> serializable, Class<?> clazz, ClassIntrospector.MixInResolver mixInResolver) {
        AnnotatedClassResolver annotatedClassResolver = this;
        AnnotatedClassResolver annotatedClassResolver2 = this;
        annotatedClassResolver2._config = serializable;
        annotatedClassResolver2._type = null;
        this._class = clazz;
        annotatedClassResolver._mixInResolver = mixInResolver;
        annotatedClassResolver._bindings = TypeBindings.emptyBindings();
        if (serializable == null) {
            AnnotatedClassResolver annotatedClassResolver3 = this;
            annotatedClassResolver3._intr = null;
            annotatedClassResolver3._primaryMixin = null;
        } else {
            serializable = serializable.isAnnotationProcessingEnabled() ? serializable.getAnnotationIntrospector() : null;
            this._intr = serializable;
            serializable = mixInResolver == null ? null : mixInResolver.findMixInClassFor(clazz);
            this._primaryMixin = serializable;
        }
        boolean bl = this._intr != null;
        this._collectAnnotations = bl;
    }

    public static AnnotatedClass resolve(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        if (javaType.isArrayType() && AnnotatedClassResolver.skippableArray(mapperConfig, javaType.getRawClass())) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, javaType.getRawClass());
        }
        return new AnnotatedClassResolver(mapperConfig, javaType, mixInResolver).resolveFully();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, clazz, mapperConfig);
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        if (javaType.isArrayType() && AnnotatedClassResolver.skippableArray(mapperConfig, javaType.getRawClass())) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, javaType.getRawClass());
        }
        return new AnnotatedClassResolver(mapperConfig, javaType, mixInResolver).resolveWithoutSuperTypes();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, Class<?> clazz, ClassIntrospector.MixInResolver mixInResolver) {
        if (clazz.isArray() && AnnotatedClassResolver.skippableArray(mapperConfig, clazz)) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, clazz);
        }
        return new AnnotatedClassResolver(mapperConfig, clazz, mixInResolver).resolveWithoutSuperTypes();
    }

    private static boolean skippableArray(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return mapperConfig == null || mapperConfig.findMixInClassFor(clazz) == null;
    }

    public static AnnotatedClass createPrimordial(Class<?> clazz) {
        return new AnnotatedClass(clazz);
    }

    public static AnnotatedClass createArrayType(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return new AnnotatedClass(clazz);
    }

    private static void _addSuperTypes(JavaType javaType, List<JavaType> list, boolean bl) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz != CLS_OBJECT && clazz != CLS_ENUM) {
            if (bl) {
                if (AnnotatedClassResolver._contains(list, clazz)) {
                    return;
                }
                list.add(javaType);
            }
            Iterator<JavaType> iterator = javaType.getInterfaces().iterator();
            while (iterator.hasNext()) {
                AnnotatedClassResolver._addSuperInterfaces(iterator.next(), list, true);
            }
            if ((javaType = javaType.getSuperClass()) != null) {
                AnnotatedClassResolver._addSuperTypes(javaType, list, true);
            }
            return;
        }
    }

    private static void _addSuperInterfaces(JavaType object, List<JavaType> list, boolean bl) {
        Class<?> clazz = ((JavaType)object).getRawClass();
        if (bl) {
            if (AnnotatedClassResolver._contains(list, clazz)) {
                return;
            }
            list.add((JavaType)object);
            if (clazz == CLS_LIST || clazz == CLS_MAP) {
                return;
            }
        }
        object = ((JavaType)object).getInterfaces().iterator();
        while (object.hasNext()) {
            AnnotatedClassResolver._addSuperInterfaces((JavaType)object.next(), list, true);
        }
    }

    private static boolean _contains(List<JavaType> list, Class<?> clazz) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2).getRawClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private Annotations resolveClassAnnotations(List<JavaType> object) {
        if (this._intr == null) {
            return NO_ANNOTATIONS;
        }
        ClassIntrospector.MixInResolver mixInResolver = this._mixInResolver;
        boolean bl = mixInResolver != null && (!(mixInResolver instanceof SimpleMixInResolver) || ((SimpleMixInResolver)mixInResolver).hasMixIns());
        if (!bl && !this._collectAnnotations) {
            return NO_ANNOTATIONS;
        }
        Object object2 = AnnotationCollector.emptyCollector();
        Type type = this._primaryMixin;
        if (type != null) {
            AnnotatedClassResolver annotatedClassResolver = this;
            object2 = annotatedClassResolver._addClassMixIns((AnnotationCollector)object2, annotatedClassResolver._class, (Class<?>)type);
        }
        if (this._collectAnnotations) {
            object2 = this._addAnnotationsIfNotPresent((AnnotationCollector)object2, ClassUtil.findClassAnnotations(this._class));
        }
        object = object.iterator();
        while (object.hasNext()) {
            type = (JavaType)object.next();
            if (bl) {
                AnnotationCollector annotationCollector = object2;
                object2 = ((JavaType)type).getRawClass();
                object2 = this._addClassMixIns(annotationCollector, (Class<?>)object2, this._mixInResolver.findMixInClassFor((Class<?>)object2));
            }
            if (!this._collectAnnotations) continue;
            object2 = this._addAnnotationsIfNotPresent((AnnotationCollector)object2, ClassUtil.findClassAnnotations(((JavaType)type).getRawClass()));
        }
        if (bl) {
            object2 = this._addClassMixIns((AnnotationCollector)object2, Object.class, this._mixInResolver.findMixInClassFor(Object.class));
        }
        return ((AnnotationCollector)object2).asAnnotations();
    }

    private AnnotationCollector _addClassMixIns(AnnotationCollector annotationCollector, Class<?> object, Class<?> clazz) {
        if (clazz != null) {
            annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(clazz));
            object = ClassUtil.findSuperClasses(clazz, object, false).iterator();
            while (object.hasNext()) {
                annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations((Class)object.next()));
            }
        }
        return annotationCollector;
    }

    private AnnotationCollector _addAnnotationsIfNotPresent(AnnotationCollector annotationCollector, Annotation[] annotationArray) {
        if (annotationArray != null) {
            for (Annotation annotation : annotationArray) {
                if (annotationCollector.isPresent(annotation)) continue;
                annotationCollector = annotationCollector.addOrOverride(annotation);
                if (!this._intr.isAnnotationBundle(annotation)) continue;
                annotationCollector = this._addFromBundleIfNotPresent(annotationCollector, annotation);
            }
        }
        return annotationCollector;
    }

    private AnnotationCollector _addFromBundleIfNotPresent(AnnotationCollector annotationCollector, Annotation annotationArray) {
        for (Annotation annotation : ClassUtil.findClassAnnotations(annotationArray.annotationType())) {
            if (annotation instanceof Target || annotation instanceof Retention || annotationCollector.isPresent(annotation)) continue;
            annotationCollector = annotationCollector.addOrOverride(annotation);
            if (!this._intr.isAnnotationBundle(annotation)) continue;
            annotationCollector = this._addFromBundleIfNotPresent(annotationCollector, annotation);
        }
        return annotationCollector;
    }

    public AnnotatedClass resolveFully() {
        ArrayList<JavaType> arrayList;
        ArrayList<JavaType> arrayList2 = arrayList;
        arrayList = new ArrayList<JavaType>(8);
        if (!((AnnotatedClassResolver)((Object)javaType))._type.hasRawClass(Object.class)) {
            if (((AnnotatedClassResolver)((Object)javaType))._type.isInterface()) {
                AnnotatedClassResolver._addSuperInterfaces(((AnnotatedClassResolver)((Object)javaType))._type, arrayList2, false);
            } else {
                AnnotatedClassResolver._addSuperTypes(((AnnotatedClassResolver)((Object)javaType))._type, arrayList2, false);
            }
        }
        AnnotatedClassResolver annotatedClassResolver = javaType;
        AnnotatedClassResolver annotatedClassResolver2 = javaType;
        JavaType javaType = annotatedClassResolver2._type;
        Class<?> clazz = annotatedClassResolver2._class;
        Class<?> clazz2 = annotatedClassResolver2._primaryMixin;
        Annotations annotations = annotatedClassResolver.resolveClassAnnotations(arrayList2);
        TypeBindings typeBindings = annotatedClassResolver._bindings;
        AnnotationIntrospector annotationIntrospector = annotatedClassResolver._intr;
        ClassIntrospector.MixInResolver mixInResolver = annotatedClassResolver._mixInResolver;
        TypeFactory typeFactory = annotatedClassResolver._config.getTypeFactory();
        boolean bl = annotatedClassResolver._collectAnnotations;
        return new AnnotatedClass(javaType, clazz, arrayList2, clazz2, annotations, typeBindings, annotationIntrospector, mixInResolver, typeFactory, bl);
    }

    public AnnotatedClass resolveWithoutSuperTypes() {
        List<JavaType> list = Collections.emptyList();
        AnnotatedClassResolver annotatedClassResolver = clazz;
        AnnotatedClassResolver annotatedClassResolver2 = clazz;
        Class<?> clazz = annotatedClassResolver2._class;
        Class<?> clazz2 = annotatedClassResolver2._primaryMixin;
        Annotations annotations = annotatedClassResolver.resolveClassAnnotations(list);
        TypeBindings typeBindings = annotatedClassResolver._bindings;
        AnnotationIntrospector annotationIntrospector = annotatedClassResolver._intr;
        ClassIntrospector.MixInResolver mixInResolver = annotatedClassResolver._mixInResolver;
        TypeFactory typeFactory = annotatedClassResolver._config.getTypeFactory();
        boolean bl = annotatedClassResolver._collectAnnotations;
        return new AnnotatedClass(null, clazz, list, clazz2, annotations, typeBindings, annotationIntrospector, mixInResolver, typeFactory, bl);
    }
}

