/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.privatefasterxml.jackson.databind.introspect.AnnotationMap;
import com.privatefasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.privatefasterxml.jackson.databind.introspect.a;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Type;

public final class AnnotatedConstructor
extends AnnotatedWithParams {
    private static final long serialVersionUID = 1L;
    protected final Constructor<?> _constructor;
    protected a _serialization;

    public AnnotatedConstructor(TypeResolutionContext typeResolutionContext, Constructor<?> constructor, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(typeResolutionContext, annotationMap, annotationMapArray);
        if (constructor != null) {
            this._constructor = constructor;
            return;
        }
        throw new IllegalArgumentException("Null constructor not allowed");
    }

    public AnnotatedConstructor(a a2) {
        super(null, null, null);
        this._constructor = null;
        this._serialization = a2;
    }

    @Override
    public AnnotatedConstructor withAnnotations(AnnotationMap annotationMap) {
        AnnotatedConstructor annotatedConstructor = typeResolutionContext;
        TypeResolutionContext typeResolutionContext = annotatedConstructor._typeContext;
        Constructor<?> constructor = annotatedConstructor._constructor;
        AnnotationMap[] annotationMapArray = annotatedConstructor._paramAnnotations;
        return new AnnotatedConstructor(typeResolutionContext, constructor, annotationMap, annotationMapArray);
    }

    @Override
    public Constructor<?> getAnnotated() {
        return this._constructor;
    }

    @Override
    public int getModifiers() {
        return this._constructor.getModifiers();
    }

    @Override
    public String getName() {
        return this._constructor.getName();
    }

    @Override
    public JavaType getType() {
        return this._typeContext.resolveType(this.getRawType());
    }

    @Override
    public Class<?> getRawType() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public int getParameterCount() {
        return this._constructor.getParameterCount();
    }

    @Override
    public Class<?> getRawParameterType(int n2) {
        Class<?>[] classArray = classArray._constructor.getParameterTypes();
        return n2 >= classArray.length ? null : classArray[n2];
    }

    @Override
    public JavaType getParameterType(int n2) {
        Type[] typeArray = this._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return this._typeContext.resolveType(typeArray[n2]);
    }

    @Override
    @Deprecated
    public Type getGenericParameterType(int n2) {
        Type[] typeArray = typeArray._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return typeArray[n2];
    }

    @Override
    public final Object call() {
        return this._constructor.newInstance(null);
    }

    @Override
    public final Object call(Object[] objectArray) {
        return this._constructor.newInstance(objectArray);
    }

    @Override
    public final Object call1(Object object) {
        return this._constructor.newInstance(object);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this._constructor;
    }

    @Override
    public void setValue(Object object, Object object2) {
        throw new UnsupportedOperationException("Cannot call setValue() on constructor of ".concat(this.getDeclaringClass().getName()));
    }

    @Override
    public Object getValue(Object object) {
        throw new UnsupportedOperationException("Cannot call getValue() on constructor of ".concat(this.getDeclaringClass().getName()));
    }

    @Override
    public String toString() {
        int n2 = this._constructor.getParameterCount();
        int n3 = n2;
        String string = "[constructor for %s (%d arg%s), annotations: %s";
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ClassUtil.nameOf(this._constructor.getDeclaringClass());
        objectArray[1] = n3;
        n3 = 2;
        String string2 = n2 == 1 ? "" : "s";
        objectArray2[n3] = string2;
        objectArray2[3] = this._annotations;
        return String.format(string, objectArray2);
    }

    @Override
    public int hashCode() {
        return this._constructor.getName().hashCode();
    }

    @Override
    public boolean equals(Object constructor) {
        if (constructor == this) {
            return true;
        }
        if (!ClassUtil.hasClass(constructor, AnnotatedConstructor.class)) {
            return false;
        }
        constructor = ((AnnotatedConstructor)((Object)constructor))._constructor;
        if (constructor == null) {
            return this._constructor == null;
        }
        return constructor.equals(this._constructor);
    }

    public Object writeReplace() {
        return new AnnotatedConstructor(new a(this._constructor));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readResolve() {
        Object object = this._serialization;
        Class clazz = ((a)object).a;
        try {
            object = clazz.getDeclaredConstructor(((a)object).b);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find constructor with " + this._serialization.b.length + " args from Class '" + clazz.getName());
        }
        {
            if (((AccessibleObject)object).isAccessible()) return new AnnotatedConstructor(null, (Constructor<?>)object, null, null);
            ClassUtil.checkAndFixAccess((Member)object, false);
            return new AnnotatedConstructor(null, (Constructor<?>)object, null, null);
        }
    }
}

