/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotationMap;
import com.privatefasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.privatefasterxml.jackson.databind.introspect.c;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class AnnotatedField
extends AnnotatedMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Field _field;
    protected c _serialization;

    public AnnotatedField(TypeResolutionContext typeResolutionContext, Field field, AnnotationMap annotationMap) {
        super(typeResolutionContext, annotationMap);
        this._field = field;
    }

    public AnnotatedField(c c2) {
        super(null, null);
        this._field = null;
        this._serialization = c2;
    }

    @Override
    public AnnotatedField withAnnotations(AnnotationMap annotationMap) {
        AnnotatedField annotatedField = typeResolutionContext;
        TypeResolutionContext typeResolutionContext = annotatedField._typeContext;
        return new AnnotatedField(typeResolutionContext, annotatedField._field, annotationMap);
    }

    @Override
    public Field getAnnotated() {
        return this._field;
    }

    @Override
    public int getModifiers() {
        return this._field.getModifiers();
    }

    @Override
    public String getName() {
        return this._field.getName();
    }

    @Override
    public Class<?> getRawType() {
        return this._field.getType();
    }

    @Override
    public JavaType getType() {
        return this._typeContext.resolveType(this._field.getGenericType());
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this._field;
    }

    @Override
    public void setValue(Object object, Object object2) {
        try {
            this._field.set(object, object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to setValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    @Override
    public Object getValue(Object object) {
        try {
            return this._field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to getValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    public int getAnnotationCount() {
        return this._annotations.size();
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    @Override
    public int hashCode() {
        return this._field.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, AnnotatedField.class)) {
            return false;
        }
        object = ((AnnotatedField)object)._field;
        if (object == null) {
            return this._field == null;
        }
        return ((Field)object).equals(this._field);
    }

    @Override
    public String toString() {
        return "[field " + this.getFullName() + "]";
    }

    public Object writeReplace() {
        return new AnnotatedField(new c(this._field));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readResolve() {
        Object object = this._serialization;
        Class clazz = ((c)object).a;
        try {
            object = clazz.getDeclaredField(((c)object).b);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find method '" + this._serialization.b + "' from Class '" + clazz.getName());
        }
        {
            if (((AccessibleObject)object).isAccessible()) return new AnnotatedField(null, (Field)object, null);
            ClassUtil.checkAndFixAccess((Member)object, false);
            return new AnnotatedField(null, (Field)object, null);
        }
    }
}

