/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotationCollector;
import com.privatefasterxml.jackson.databind.introspect.ClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.privatefasterxml.jackson.databind.introspect.d;
import com.privatefasterxml.jackson.databind.introspect.j;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnotatedFieldCollector
extends j {
    private final TypeFactory _typeFactory;
    private final ClassIntrospector.MixInResolver _mixInResolver;
    private final boolean _collectAnnotations;

    public AnnotatedFieldCollector(AnnotationIntrospector annotationIntrospector, TypeFactory typeFactory, ClassIntrospector.MixInResolver mixInResolver, boolean bl) {
        super(annotationIntrospector);
        this._typeFactory = typeFactory;
        if (annotationIntrospector == null) {
            mixInResolver = null;
        }
        AnnotatedFieldCollector annotatedFieldCollector = this;
        annotatedFieldCollector._mixInResolver = mixInResolver;
        annotatedFieldCollector._collectAnnotations = bl;
    }

    public static List<AnnotatedField> collectFields(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, JavaType javaType, boolean bl) {
        return new AnnotatedFieldCollector(annotationIntrospector, typeFactory, mixInResolver, bl).collect(typeResolutionContext, javaType);
    }

    private Map<String, d> _findFields(TypeResolutionContext clazz, JavaType type, Map<String, d> linkedHashMap) {
        TypeResolutionContext.Basic basic;
        Field[] fieldArray = type.getSuperClass();
        if (fieldArray == null) {
            return linkedHashMap;
        }
        type = type.getRawClass();
        TypeResolutionContext.Basic basic2 = basic;
        TypeFactory typeFactory = this._typeFactory;
        basic = new TypeResolutionContext.Basic(typeFactory, fieldArray.getBindings());
        linkedHashMap = this._findFields(basic2, (JavaType)fieldArray, linkedHashMap);
        for (Field field : ((Class)type).getDeclaredFields()) {
            d d2;
            if (!this._isIncludableField(field)) continue;
            if (linkedHashMap == null) {
                LinkedHashMap<String, d> linkedHashMap2;
                linkedHashMap = linkedHashMap2;
                linkedHashMap2 = new LinkedHashMap<String, d>();
            }
            d d3 = d2;
            d2 = new d((TypeResolutionContext)((Object)clazz), field);
            if (this._collectAnnotations) {
                AnnotationCollector annotationCollector = d3.c;
                d3.c = this.collectAnnotations(annotationCollector, field.getDeclaredAnnotations());
            }
            linkedHashMap.put(field.getName(), d3);
        }
        if (linkedHashMap != null && (clazz = this._mixInResolver) != null && (clazz = clazz.findMixInClassFor((Class<?>)type)) != null) {
            this._addFieldMixIns(clazz, (Class<?>)type, (Map<String, d>)linkedHashMap);
        }
        return linkedHashMap;
    }

    private void _addFieldMixIns(Class<?> object, Class<?> fieldArray, Map<String, d> map) {
        object = ClassUtil.findSuperClasses(object, fieldArray, true).iterator();
        while (object.hasNext()) {
            for (Field field : object.next().getDeclaredFields()) {
                d d2;
                if (!this._isIncludableField(field) || (d2 = map.get(field.getName())) == null) continue;
                AnnotationCollector annotationCollector = d2.c;
                d2.c = this.collectAnnotations(annotationCollector, field.getDeclaredAnnotations());
            }
        }
    }

    private boolean _isIncludableField(Field field) {
        if (field.isSynthetic()) {
            return false;
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    public List<AnnotatedField> collect(TypeResolutionContext object, JavaType object2) {
        ArrayList arrayList;
        if ((iterator = ((AnnotatedFieldCollector)((Object)iterator))._findFields((TypeResolutionContext)object, (JavaType)object2, null)) == null) {
            return Collections.emptyList();
        }
        object = arrayList;
        arrayList = new ArrayList(iterator.size());
        Iterator iterator = iterator.values().iterator();
        while (iterator.hasNext()) {
            Object object3 = object2 = (d)iterator.next();
            TypeResolutionContext typeResolutionContext = ((d)object3).a;
            Field field = ((d)object3).b;
            ((ArrayList)object).add(new AnnotatedField(typeResolutionContext, field, ((d)object2).c.asAnnotationMap()));
        }
        return object;
    }
}

