/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotationMap;
import com.privatefasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collections;

public abstract class AnnotatedMember
extends Annotated
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient TypeResolutionContext _typeContext;
    protected final transient AnnotationMap _annotations;

    public AnnotatedMember(TypeResolutionContext typeResolutionContext, AnnotationMap annotationMap) {
        this._typeContext = typeResolutionContext;
        this._annotations = annotationMap;
    }

    public AnnotatedMember(AnnotatedMember annotatedMember) {
        this._typeContext = annotatedMember._typeContext;
        this._annotations = annotatedMember._annotations;
    }

    public abstract Annotated withAnnotations(AnnotationMap var1);

    public abstract Class<?> getDeclaringClass();

    public abstract Member getMember();

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName();
    }

    @Deprecated
    public TypeResolutionContext getTypeContext() {
        return this._typeContext;
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        AnnotationMap annotationMap = ((AnnotatedMember)((Object)annotationMap))._annotations;
        if (annotationMap == null) {
            return null;
        }
        return annotationMap.get(clazz);
    }

    @Override
    public final boolean hasAnnotation(Class<?> clazz) {
        AnnotationMap annotationMap = ((AnnotatedMember)((Object)annotationMap))._annotations;
        if (annotationMap == null) {
            return false;
        }
        return annotationMap.has(clazz);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
        AnnotationMap annotationMap = ((AnnotatedMember)((Object)annotationMap))._annotations;
        if (annotationMap == null) {
            return false;
        }
        return annotationMap.hasOneOf(classArray);
    }

    @Override
    @Deprecated
    public Iterable<Annotation> annotations() {
        AnnotationMap annotationMap = ((AnnotatedMember)((Object)annotationMap))._annotations;
        if (annotationMap == null) {
            return Collections.emptyList();
        }
        return annotationMap.annotations();
    }

    public AnnotationMap getAllAnnotations() {
        return this._annotations;
    }

    public final void fixAccess(boolean bl) {
        if ((this = ((AnnotatedMember)this).getMember()) != null) {
            ClassUtil.checkAndFixAccess((Member)this, bl);
        }
    }

    public abstract void setValue(Object var1, Object var2);

    public abstract Object getValue(Object var1);
}

