/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.privatefasterxml.jackson.databind.introspect.AnnotationMap;
import com.privatefasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.privatefasterxml.jackson.databind.introspect.e;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class AnnotatedMethod
extends AnnotatedWithParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Method _method;
    protected Class<?>[] _paramClasses;
    protected e _serialization;

    public AnnotatedMethod(TypeResolutionContext typeResolutionContext, Method method, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(typeResolutionContext, annotationMap, annotationMapArray);
        if (method != null) {
            this._method = method;
            return;
        }
        throw new IllegalArgumentException("Cannot construct AnnotatedMethod with null Method");
    }

    public AnnotatedMethod(e e2) {
        super(null, null, null);
        this._method = null;
        this._serialization = e2;
    }

    @Override
    public AnnotatedMethod withAnnotations(AnnotationMap annotationMap) {
        AnnotatedMethod annotatedMethod = typeResolutionContext;
        TypeResolutionContext typeResolutionContext = annotatedMethod._typeContext;
        Method method = annotatedMethod._method;
        AnnotationMap[] annotationMapArray = annotatedMethod._paramAnnotations;
        return new AnnotatedMethod(typeResolutionContext, method, annotationMap, annotationMapArray);
    }

    @Override
    public Method getAnnotated() {
        return this._method;
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public JavaType getType() {
        return this._typeContext.resolveType(this._method.getGenericReturnType());
    }

    @Override
    public Class<?> getRawType() {
        return this._method.getReturnType();
    }

    @Override
    public final Object call() {
        return this._method.invoke(null, new Object[0]);
    }

    @Override
    public final Object call(Object[] objectArray) {
        return this._method.invoke(null, objectArray);
    }

    @Override
    public final Object call1(Object object) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        return objectArray2._method.invoke(null, objectArray2);
    }

    public final Object callOn(Object object) {
        return this._method.invoke(object, null);
    }

    public final Object callOnWith(Object object, Object ... objectArray) {
        return this._method.invoke(object, objectArray);
    }

    @Override
    public int getParameterCount() {
        return this._method.getParameterCount();
    }

    @Override
    public Class<?> getRawParameterType(int n2) {
        return n2 >= (this = this.getRawParameterTypes()).length ? null : this[n2];
    }

    @Override
    public JavaType getParameterType(int n2) {
        Type[] typeArray = this._method.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return this._typeContext.resolveType(typeArray[n2]);
    }

    @Override
    @Deprecated
    public Type getGenericParameterType(int n2) {
        if (n2 >= (this = this.getGenericParameterTypes()).length) {
            return null;
        }
        return this[n2];
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    @Override
    public Method getMember() {
        return this._method;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setValue(Object objectArray, Object object) {
        void var1_4;
        block4: {
            Method method = this._method;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            try {
                objectArray3[0] = object;
                method.invoke((Object)objectArray2, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                break block4;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return;
        }
        throw new IllegalArgumentException("Failed to setValue() with method " + this.getFullName() + ": " + ClassUtil.exceptionMessage((Throwable)var1_4), (Throwable)var1_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getValue(Object object) {
        void var1_4;
        Method method = this._method;
        try {
            return method.invoke(object, null);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Failed to getValue() with method " + this.getFullName() + ": " + ClassUtil.exceptionMessage((Throwable)var1_4), (Throwable)var1_4);
    }

    @Override
    public String getFullName() {
        AnnotatedMethod annotatedMethod = this;
        Object[] objectArray = super.getFullName();
        int n2 = annotatedMethod.getParameterCount();
        if (n2 != 0) {
            if (n2 != 1) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = super.getFullName();
                objectArray2[1] = this.getParameterCount();
                return String.format("%s(%d params)", objectArray);
            }
            return (String)objectArray + "(" + this.getRawParameterType(0).getName() + ")";
        }
        return (String)objectArray + "()";
    }

    public Class<?>[] getRawParameterTypes() {
        if (this._paramClasses == null) {
            this._paramClasses = this._method.getParameterTypes();
        }
        return this._paramClasses;
    }

    @Deprecated
    public Type[] getGenericParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    public Class<?> getRawReturnType() {
        return this._method.getReturnType();
    }

    @Deprecated
    public boolean hasReturnType() {
        return this.getRawReturnType() != Void.TYPE;
    }

    @Override
    public String toString() {
        return "[method " + this.getFullName() + "]";
    }

    @Override
    public int hashCode() {
        return this._method.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, AnnotatedMethod.class)) {
            return false;
        }
        object = ((AnnotatedMethod)object)._method;
        if (object == null) {
            return this._method == null;
        }
        return ((Method)object).equals(this._method);
    }

    public Object writeReplace() {
        return new AnnotatedMethod(new e(this._method));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readResolve() {
        Object object = this._serialization;
        Class clazz = ((e)object).a;
        try {
            e e2 = object;
            object = e2.b;
            object = clazz.getDeclaredMethod((String)object, e2.c);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find method '" + this._serialization.b + "' from Class '" + clazz.getName());
        }
        {
            if (((AccessibleObject)object).isAccessible()) return new AnnotatedMethod(null, (Method)object, null, null);
            ClassUtil.checkAndFixAccess((Member)object, false);
            return new AnnotatedMethod(null, (Method)object, null, null);
        }
    }
}

