/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.introspect.AnnotationMap;
import com.privatefasterxml.jackson.databind.introspect.g;
import com.privatefasterxml.jackson.databind.util.Annotations;
import java.io.Serializable;
import java.lang.annotation.Annotation;

public abstract class AnnotationCollector {
    protected static final Annotations NO_ANNOTATIONS = new NoAnnotations();
    protected final Object _data;

    public AnnotationCollector(Object object) {
        this._data = object;
    }

    public static Annotations emptyAnnotations() {
        return NO_ANNOTATIONS;
    }

    public static AnnotationCollector emptyCollector() {
        return g.a;
    }

    public static AnnotationCollector emptyCollector(Object object) {
        return new g(object);
    }

    public abstract Annotations asAnnotations();

    public abstract AnnotationMap asAnnotationMap();

    public Object getData() {
        return this._data;
    }

    public abstract boolean isPresent(Annotation var1);

    public abstract AnnotationCollector addOrOverride(Annotation var1);

    public static class NoAnnotations
    implements Annotations,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return false;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static class TwoAnnotations
    implements Annotations,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?> _type1;
        private final Class<?> _type2;
        private final Annotation _value1;
        private final Annotation _value2;

        public TwoAnnotations(Class<?> clazz, Annotation annotation, Class<?> clazz2, Annotation annotation2) {
            this._type1 = clazz;
            this._value1 = annotation;
            this._type2 = clazz2;
            this._value2 = annotation2;
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            if (this._type1 == clazz) {
                return (A)this._value1;
            }
            if (this._type2 == clazz) {
                return (A)this._value2;
            }
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return this._type1 == clazz || this._type2 == clazz;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            for (Class<? extends Annotation> clazz : classArray) {
                if (clazz != this._type1 && clazz != this._type2) {
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 2;
        }
    }

    public static class OneAnnotation
    implements Annotations,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?> _type;
        private final Annotation _value;

        public OneAnnotation(Class<?> clazz, Annotation annotation) {
            this._type = clazz;
            this._value = annotation;
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            if (this._type == clazz) {
                return (A)this._value;
            }
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return this._type == clazz;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (classArray[i2] != this._type) continue;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 1;
        }
    }
}

