/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.annotation.JsonCreator;
import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.privatefasterxml.jackson.databind.type.TypeBindings;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    private static final Class<?>[] NO_VIEWS = new Class[0];
    protected final POJOPropertiesCollector _propCollector;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected Class<?>[] _defaultViews;
    protected boolean _defaultViewsResolved;
    protected List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;

    public BasicBeanDescription(POJOPropertiesCollector object, JavaType javaType, AnnotatedClass annotatedClass) {
        super(javaType);
        this._propCollector = object;
        this._config = object = ((POJOPropertiesCollector)object).getConfig();
        this._annotationIntrospector = object == null ? null : ((MapperConfig)object).getAnnotationIntrospector();
        this._classInfo = annotatedClass;
    }

    public BasicBeanDescription(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass, List<BeanPropertyDefinition> list) {
        super(javaType);
        this._propCollector = null;
        this._config = mapperConfig;
        this._annotationIntrospector = mapperConfig == null ? null : mapperConfig.getAnnotationIntrospector();
        BasicBeanDescription basicBeanDescription = this;
        basicBeanDescription._classInfo = annotatedClass;
        basicBeanDescription._properties = list;
    }

    public BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector) {
        BasicBeanDescription basicBeanDescription = javaType;
        BasicBeanDescription basicBeanDescription2 = javaType;
        POJOPropertiesCollector pOJOPropertiesCollector2 = pOJOPropertiesCollector;
        JavaType javaType = pOJOPropertiesCollector2.getType();
        basicBeanDescription2(pOJOPropertiesCollector2, javaType, pOJOPropertiesCollector2.getClassDef());
        basicBeanDescription._objectIdInfo = pOJOPropertiesCollector.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass) {
        List<BeanPropertyDefinition> list = Collections.emptyList();
        return new BasicBeanDescription(mapperConfig, javaType, annotatedClass, list);
    }

    public List<BeanPropertyDefinition> _properties() {
        if (this._properties == null) {
            this._properties = this._propCollector.getProperties();
        }
        return this._properties;
    }

    public boolean removeProperty(String string) {
        Iterator<BeanPropertyDefinition> iterator = ((BasicBeanDescription)((Object)iterator))._properties().iterator();
        while (iterator.hasNext()) {
            if (!((BeanPropertyDefinition)iterator.next()).getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean addProperty(BeanPropertyDefinition beanPropertyDefinition) {
        if (this.hasProperty(beanPropertyDefinition.getFullName())) {
            return false;
        }
        this._properties().add(beanPropertyDefinition);
        return true;
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public BeanPropertyDefinition findProperty(PropertyName propertyName) {
        for (BeanPropertyDefinition beanPropertyDefinition : ((BasicBeanDescription)this)._properties()) {
            if (!beanPropertyDefinition.hasName(propertyName)) continue;
            return beanPropertyDefinition;
        }
        return null;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties();
    }

    @Override
    public AnnotatedMember findJsonKeyAccessor() {
        POJOPropertiesCollector pOJOPropertiesCollector = ((BasicBeanDescription)((Object)pOJOPropertiesCollector))._propCollector;
        return pOJOPropertiesCollector == null ? null : pOJOPropertiesCollector.getJsonKeyAccessor();
    }

    @Override
    @Deprecated
    public AnnotatedMethod findJsonValueMethod() {
        POJOPropertiesCollector pOJOPropertiesCollector = ((BasicBeanDescription)((Object)pOJOPropertiesCollector))._propCollector;
        return pOJOPropertiesCollector == null ? null : pOJOPropertiesCollector.getJsonValueMethod();
    }

    @Override
    public AnnotatedMember findJsonValueAccessor() {
        POJOPropertiesCollector pOJOPropertiesCollector = ((BasicBeanDescription)((Object)pOJOPropertiesCollector))._propCollector;
        return pOJOPropertiesCollector == null ? null : pOJOPropertiesCollector.getJsonValueAccessor();
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        Object object = ((BasicBeanDescription)object)._propCollector;
        object = object == null ? null : ((POJOPropertiesCollector)object).getIgnoredPropertyNames();
        if (object == null) {
            return Collections.emptySet();
        }
        return object;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    @Deprecated
    public TypeBindings bindingsForBeanType() {
        return this._type.getBindings();
    }

    @Override
    @Deprecated
    public JavaType resolveType(Type type) {
        return this._config.getTypeFactory().resolveMemberType(type, this._type.getBindings());
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMember findAnySetterAccessor() {
        Object object = ((BasicBeanDescription)((Object)serializable))._propCollector;
        if (object != null) {
            Serializable serializable;
            if ((object = object.getAnySetterMethod()) != null) {
                serializable = object.getRawParameterType(0);
                if (serializable != String.class && serializable != Object.class) {
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = object.getName();
                    objectArray[1] = serializable.getName();
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on method '%s()': first argument not of type String or Object, but %s", objectArray2));
                }
                return object;
            }
            serializable = ((BasicBeanDescription)((Object)serializable))._propCollector.getAnySetterField();
            if (serializable != null) {
                object = ((Annotated)((Object)serializable)).getRawType();
                if (!Map.class.isAssignableFrom((Class<?>)object) && !JsonNode.class.isAssignableFrom((Class<?>)object)) {
                    Object[] objectArray = new Object[1];
                    object = objectArray;
                    objectArray[0] = ((Annotated)((Object)serializable)).getName();
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on field '%s': type is not instance of `java.util.Map` or `JsonNode`", object));
                }
                return serializable;
            }
        }
        return null;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        POJOPropertiesCollector pOJOPropertiesCollector = ((BasicBeanDescription)((Object)pOJOPropertiesCollector))._propCollector;
        if (pOJOPropertiesCollector != null) {
            return pOJOPropertiesCollector.getInjectables();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> getConstructorsWithMode() {
        ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> arrayList;
        ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> arrayList2 = this._classInfo.getConstructors();
        if (arrayList2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> arrayList3 = arrayList2;
        arrayList2 = arrayList;
        arrayList = new ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>>();
        for (AnnotatedConstructor annotatedConstructor : arrayList3) {
            JsonCreator.Mode mode = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedConstructor);
            if (mode == JsonCreator.Mode.DISABLED) continue;
            arrayList2.add(AnnotatedAndMetadata.of(annotatedConstructor, mode));
        }
        return arrayList2;
    }

    @Override
    public Object instantiateBean(boolean bl) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl) {
            annotatedConstructor.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        try {
            return annotatedConstructor.call();
        }
        catch (Exception exception) {
            Throwable throwable;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            void v0 = throwable;
            ClassUtil.throwIfError((Throwable)v0);
            ClassUtil.throwIfRTE((Throwable)v0);
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + throwable.getClass().getName() + ") " + ClassUtil.exceptionMessage(throwable), throwable);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        return this._classInfo.findMethod(string, classArray);
    }

    @Override
    public JsonFormat.Value findExpectedFormat(JsonFormat.Value object) {
        Serializable serializable = ((BasicBeanDescription)this)._annotationIntrospector;
        if (serializable != null && (serializable = serializable.findFormat(((BasicBeanDescription)this)._classInfo)) != null) {
            object = object == null ? serializable : ((JsonFormat.Value)object).withOverrides((JsonFormat.Value)serializable);
        }
        if ((this = ((BasicBeanDescription)this)._config.getDefaultPropertyFormat(((BasicBeanDescription)this)._classInfo.getRawType())) != null) {
            object = object == null ? this : ((JsonFormat.Value)object).withOverrides((JsonFormat.Value)this);
        }
        return object;
    }

    @Override
    public Class<?>[] findDefaultViews() {
        if (!this._defaultViewsResolved) {
            BasicBeanDescription basicBeanDescription = this;
            basicBeanDescription._defaultViewsResolved = true;
            Object object = basicBeanDescription._annotationIntrospector;
            object = basicBeanDescription._annotationIntrospector == null ? null : object.findViews(this._classInfo);
            if (object == null && !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                object = NO_VIEWS;
            }
            this._defaultViews = object;
        }
        return this._defaultViews;
    }

    @Override
    public Converter<Object, Object> findSerializationConverter() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        if (annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(annotationIntrospector.findSerializationConverter(this._classInfo));
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(JsonInclude.Value value) {
        AnnotationIntrospector annotationIntrospector = ((BasicBeanDescription)object)._annotationIntrospector;
        if (annotationIntrospector != null && (object = annotationIntrospector.findPropertyInclusion(((BasicBeanDescription)object)._classInfo)) != null) {
            if (value != null) {
                Object object = value.withOverrides((JsonInclude.Value)object);
            }
            return object;
        }
        return value;
    }

    @Override
    public AnnotatedMember findAnyGetter() {
        Object object = object2._propCollector;
        if (object != null) {
            Object object2;
            if ((object = object.getAnyGetterMethod()) != null) {
                if (Map.class.isAssignableFrom(object.getRawType())) {
                    return object;
                }
                Object[] objectArray = new Object[1];
                object2 = objectArray;
                objectArray[0] = object.getName();
                throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on method %s(): return type is not instance of java.util.Map", object2));
            }
            object2 = object2._propCollector.getAnyGetterField();
            if (object2 != null) {
                if (Map.class.isAssignableFrom(object2.getRawType())) {
                    return object2;
                }
                Object[] objectArray = new Object[1];
                object = objectArray;
                objectArray[0] = object2.getName();
                throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on field '%s': type is not instance of java.util.Map", object));
            }
        }
        return null;
    }

    @Override
    public List<BeanPropertyDefinition> findBackReferences() {
        BasicBeanDescription basicBeanDescription = object;
        Object object = null;
        HashSet hashSet = null;
        for (BeanPropertyDefinition beanPropertyDefinition : basicBeanDescription._properties()) {
            Object object2;
            block5: {
                block4: {
                    block3: {
                        HashSet<Object> hashSet2;
                        ArrayList arrayList;
                        object2 = beanPropertyDefinition.findReferenceType();
                        if (object2 == null || !((AnnotationIntrospector.ReferenceProperty)object2).isBackReference()) continue;
                        object2 = ((AnnotationIntrospector.ReferenceProperty)object2).getName();
                        if (object != null) break block3;
                        object = arrayList;
                        arrayList = new ArrayList();
                        hashSet = hashSet2;
                        new HashSet<Object>().add(object2);
                        break block4;
                    }
                    if (!hashSet.add(object2)) break block5;
                }
                object.add(beanPropertyDefinition);
                continue;
            }
            throw new IllegalArgumentException("Multiple back-reference properties with name " + ClassUtil.name((String)object2));
        }
        return object;
    }

    @Override
    @Deprecated
    public Map<String, AnnotatedMember> findBackReferenceProperties() {
        HashMap hashMap;
        if ((object2 = ((BasicBeanDescription)object2).findBackReferences()) == null) {
            return null;
        }
        Object object = object2;
        Object object2 = hashMap;
        hashMap = new HashMap();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)iterator.next();
            String string = beanPropertyDefinition.getName();
            ((HashMap)object2).put(string, beanPropertyDefinition.getMutator());
        }
        return object2;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        ArrayList<AnnotatedMethod> arrayList = this._classInfo.getFactoryMethods();
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        ArrayList<AnnotatedMethod> arrayList2 = arrayList;
        arrayList = null;
        for (AnnotatedMethod annotatedMethod : arrayList2) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            if (arrayList == null) {
                ArrayList<AnnotatedMethod> arrayList3;
                arrayList = arrayList3;
                arrayList3 = new ArrayList<AnnotatedMethod>();
            }
            arrayList.add(annotatedMethod);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> getFactoryMethodsWithMode() {
        ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> arrayList = this._classInfo.getFactoryMethods();
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> arrayList2 = arrayList;
        arrayList = null;
        Iterator<AnnotatedMethod> iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> annotatedAndMetadata = this.findFactoryMethodMetadata(iterator.next());
            if (annotatedAndMetadata == null) continue;
            if (arrayList == null) {
                ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> arrayList3;
                arrayList = arrayList3;
                arrayList3 = new ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>>();
            }
            arrayList.add(annotatedAndMetadata);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public Constructor<?> findSingleArgConstructor(Class<?> ... classArray) {
        for (AnnotatedConstructor annotatedConstructor : ((BasicBeanDescription)this)._classInfo.getConstructors()) {
            if (annotatedConstructor.getParameterCount() != 1) continue;
            Class<?> clazz = annotatedConstructor.getRawParameterType(0);
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (classArray[i2] != clazz) continue;
                return annotatedConstructor.getAnnotated();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Method findFactoryMethod(Class<?> ... classArray) {
        for (AnnotatedMethod annotatedMethod : this._classInfo.getFactoryMethods()) {
            if (!this.isFactoryMethod(annotatedMethod) || annotatedMethod.getParameterCount() != 1) continue;
            Class<?> clazz = annotatedMethod.getRawParameterType(0);
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!clazz.isAssignableFrom(classArray[i2])) continue;
                return annotatedMethod.getAnnotated();
            }
        }
        return null;
    }

    public boolean isFactoryMethod(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawReturnType();
        if (!object.getBeanClass().isAssignableFrom(clazz)) {
            return false;
        }
        Object object = object._annotationIntrospector.findCreatorAnnotation(object._config, annotatedMethod);
        if (object != null && object != JsonCreator.Mode.DISABLED) {
            return true;
        }
        object = annotatedMethod.getName();
        if ("valueOf".equals(object) && annotatedMethod.getParameterCount() == 1) {
            return true;
        }
        return "fromString".equals(object) && annotatedMethod.getParameterCount() == 1 && ((object = annotatedMethod.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom((Class<?>)object));
    }

    public AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> findFactoryMethodMetadata(AnnotatedMethod annotatedMethod) {
        Object object = annotatedMethod.getRawReturnType();
        if (!object2.getBeanClass().isAssignableFrom((Class<?>)object)) {
            return null;
        }
        Object object2 = object2._annotationIntrospector.findCreatorAnnotation(object2._config, annotatedMethod);
        if (object2 != null) {
            if (object2 == JsonCreator.Mode.DISABLED) {
                return null;
            }
            return AnnotatedAndMetadata.of(annotatedMethod, object2);
        }
        object = annotatedMethod.getName();
        if ("valueOf".equals(object) && annotatedMethod.getParameterCount() == 1) {
            return AnnotatedAndMetadata.of(annotatedMethod, object2);
        }
        if ("fromString".equals(object) && annotatedMethod.getParameterCount() == 1 && ((object = annotatedMethod.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom((Class<?>)object))) {
            return AnnotatedAndMetadata.of(annotatedMethod, object2);
        }
        return null;
    }

    @Deprecated
    public PropertyName _findCreatorPropertyName(AnnotatedParameter annotatedParameter) {
        PropertyName propertyName = ((BasicBeanDescription)this)._annotationIntrospector.findNameForDeserialization(annotatedParameter);
        if ((propertyName == null || propertyName.isEmpty()) && (this = ((BasicBeanDescription)this)._annotationIntrospector.findImplicitPropertyName(annotatedParameter)) != null && !((String)this).isEmpty()) {
            propertyName = PropertyName.construct((String)this);
        }
        return propertyName;
    }

    @Override
    public Class<?> findPOJOBuilder() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        return annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        return annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }

    @Override
    public Converter<Object, Object> findDeserializationConverter() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        if (annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(annotationIntrospector.findDeserializationConverter(this._classInfo));
    }

    @Override
    public String findClassDescription() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        return annotationIntrospector == null ? null : annotationIntrospector.findClassDescription(this._classInfo);
    }

    @Deprecated
    public LinkedHashMap<String, AnnotatedField> _findPropertyFields(Collection<String> collection, boolean bl) {
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        BasicBeanDescription basicBeanDescription = linkedHashMap2;
        linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (BeanPropertyDefinition beanPropertyDefinition : basicBeanDescription._properties()) {
            AnnotatedField annotatedField = beanPropertyDefinition.getField();
            if (annotatedField == null) continue;
            String string = beanPropertyDefinition.getName();
            if (collection != null && collection.contains(string)) continue;
            ((AbstractMap)linkedHashMap2).put(string, annotatedField);
        }
        return linkedHashMap2;
    }

    public Converter<Object, Object> _createConverter(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (object instanceof Class) {
            if ((object = (Class)object) != Converter.None.class && !ClassUtil.isBogusClass(object)) {
                if (Converter.class.isAssignableFrom((Class<?>)object)) {
                    Object object2 = this._config.getHandlerInstantiator();
                    if (object2 == null) {
                        object2 = null;
                    } else {
                        HandlerInstantiator handlerInstantiator = object2;
                        BasicBeanDescription basicBeanDescription = this;
                        object2 = basicBeanDescription._config;
                        object2 = handlerInstantiator.converterInstance((MapperConfig<?>)object2, basicBeanDescription._classInfo, (Class<?>)object);
                    }
                    if (object2 == null) {
                        object2 = (Converter)ClassUtil.createInstance(object, this._config.canOverrideAccessModifiers());
                    }
                    return object2;
                }
                throw new IllegalStateException(a.a((Class)object, new StringBuilder("AnnotationIntrospector returned Class "), "; expected Class<Converter>"));
            }
            return null;
        }
        throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
    }
}

