/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.privatefasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.privatefasterxml.jackson.databind.introspect.ClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.privatefasterxml.jackson.databind.type.SimpleType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_JSON_NODE = JsonNode.class;
    protected static final BasicBeanDescription STRING_DESC;
    protected static final BasicBeanDescription BOOLEAN_DESC;
    protected static final BasicBeanDescription INT_DESC;
    protected static final BasicBeanDescription LONG_DESC;
    protected static final BasicBeanDescription OBJECT_DESC;

    static {
        Object object = AnnotatedClassResolver.createPrimordial(String.class);
        STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), (AnnotatedClass)object);
        Class<Boolean> clazz = Boolean.TYPE;
        object = SimpleType.constructUnsafe(clazz);
        AnnotatedClass annotatedClass = AnnotatedClassResolver.createPrimordial(clazz);
        BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, (JavaType)object, annotatedClass);
        Class<Integer> clazz2 = Integer.TYPE;
        object = SimpleType.constructUnsafe(clazz2);
        annotatedClass = AnnotatedClassResolver.createPrimordial(clazz2);
        INT_DESC = BasicBeanDescription.forOtherUse(null, (JavaType)object, annotatedClass);
        Class<Long> clazz3 = Long.TYPE;
        object = SimpleType.constructUnsafe(clazz3);
        annotatedClass = AnnotatedClassResolver.createPrimordial(clazz3);
        LONG_DESC = BasicBeanDescription.forOtherUse(null, (JavaType)object, annotatedClass);
        object = AnnotatedClassResolver.createPrimordial(Object.class);
        OBJECT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Object.class), (AnnotatedClass)object);
    }

    @Override
    public ClassIntrospector copy() {
        return new BasicClassIntrospector();
    }

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(serializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(serializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, mixInResolver, true));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, BeanDescription beanDescription) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, beanDescription, false));
    }

    @Override
    @Deprecated
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, null, false));
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(mapperConfig, javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(mapperConfig, javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedWithoutSuperTypes(mapperConfig, javaType, mixInResolver));
        }
        return basicBeanDescription;
    }

    public POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver object, boolean bl) {
        object = this._resolveAnnotatedClass(mapperConfig, javaType, (ClassIntrospector.MixInResolver)object);
        AccessorNamingStrategy accessorNamingStrategy = javaType.isRecordType() ? mapperConfig.getAccessorNaming().forRecord(mapperConfig, (AnnotatedClass)object) : mapperConfig.getAccessorNaming().forPOJO(mapperConfig, (AnnotatedClass)object);
        return this.constructPropertyCollector(mapperConfig, (AnnotatedClass)object, javaType, bl, accessorNamingStrategy);
    }

    @Deprecated
    public POJOPropertiesCollector collectProperties(MapperConfig<?> object, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl, String string) {
        BasicClassIntrospector basicClassIntrospector = annotatedClass;
        MapperConfig<?> mapperConfig = object;
        AnnotatedClass annotatedClass = ((BasicClassIntrospector)((Object)annotatedClass))._resolveAnnotatedClass((MapperConfig<?>)object, javaType, mixInResolver);
        object = new DefaultAccessorNamingStrategy.Provider().withSetterPrefix(string).forPOJO((MapperConfig<?>)object, annotatedClass);
        return basicClassIntrospector.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, (AccessorNamingStrategy)object);
    }

    public POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> object, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, BeanDescription beanDescription, boolean bl) {
        BasicClassIntrospector basicClassIntrospector = annotatedClass;
        MapperConfig<?> mapperConfig = object;
        AnnotatedClass annotatedClass = ((BasicClassIntrospector)((Object)annotatedClass))._resolveAnnotatedClass((MapperConfig<?>)object, javaType, mixInResolver);
        object = mapperConfig.getAccessorNaming().forBuilder((MapperConfig<?>)object, annotatedClass, beanDescription);
        return basicClassIntrospector.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, (AccessorNamingStrategy)object);
    }

    @Deprecated
    public POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl) {
        return this.collectPropertiesWithBuilder(mapperConfig, javaType, mixInResolver, null, bl);
    }

    public POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl, AccessorNamingStrategy accessorNamingStrategy) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, accessorNamingStrategy);
    }

    @Deprecated
    public POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl, String string) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, string);
    }

    public BasicBeanDescription _findStdTypeDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        Serializable serializable = javaType.getRawClass();
        if (((Class)serializable).isPrimitive()) {
            if (serializable == Integer.TYPE) {
                return INT_DESC;
            }
            if (serializable == Long.TYPE) {
                return LONG_DESC;
            }
            if (serializable == Boolean.TYPE) {
                return BOOLEAN_DESC;
            }
        } else if (ClassUtil.isJDKClass(serializable)) {
            if (serializable == CLS_OBJECT) {
                return OBJECT_DESC;
            }
            if (serializable == CLS_STRING) {
                return STRING_DESC;
            }
            if (serializable == Integer.class) {
                return INT_DESC;
            }
            if (serializable == Long.class) {
                return LONG_DESC;
            }
            if (serializable == Boolean.class) {
                return BOOLEAN_DESC;
            }
        } else if (CLS_JSON_NODE.isAssignableFrom((Class<?>)serializable)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, AnnotatedClassResolver.createPrimordial(serializable));
        }
        return null;
    }

    public boolean _isStdJDKCollection(JavaType javaType) {
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            Serializable serializable = javaType.getRawClass();
            return ClassUtil.isJDKClass(serializable) && (Collection.class.isAssignableFrom((Class<?>)serializable) || Map.class.isAssignableFrom((Class<?>)serializable));
        }
        return false;
    }

    public BasicBeanDescription _findStdJdkCollectionDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        if (this._isStdJDKCollection(javaType)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mapperConfig));
        }
        return null;
    }

    public AnnotatedClass _resolveAnnotatedClass(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolve(mapperConfig, javaType, mixInResolver);
    }

    public AnnotatedClass _resolveAnnotatedWithoutSuperTypes(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, javaType, mixInResolver);
    }
}

