/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.jdk14.JDK14Util;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultAccessorNamingStrategy
extends AccessorNamingStrategy {
    protected final MapperConfig<?> _config;
    protected final AnnotatedClass _forClass;
    protected final BaseNameValidator _baseNameValidator;
    protected final boolean _stdBeanNaming;
    protected final boolean _isGettersNonBoolean;
    protected final String _getterPrefix;
    protected final String _isGetterPrefix;
    protected final String _mutatorPrefix;

    public DefaultAccessorNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, String string, String string2, String string3, BaseNameValidator baseNameValidator) {
        this._config = mapperConfig;
        this._forClass = annotatedClass;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
        this._isGettersNonBoolean = mapperConfig.isEnabled(MapperFeature.ALLOW_IS_GETTERS_FOR_NON_BOOLEAN);
        this._mutatorPrefix = string;
        this._getterPrefix = string2;
        this._isGetterPrefix = string3;
        this._baseNameValidator = baseNameValidator;
    }

    @Override
    public String findNameForIsGetter(AnnotatedMethod serializable, String string) {
        if (this._isGetterPrefix != null) {
            serializable = serializable.getRawType();
            if ((this._isGettersNonBoolean || serializable == Boolean.class || serializable == Boolean.TYPE) && string.startsWith(this._isGetterPrefix)) {
                return this._stdBeanNaming ? this.stdManglePropertyName(string, 2) : this.legacyManglePropertyName(string, 2);
            }
        }
        return null;
    }

    @Override
    public String findNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
        String string2 = this._getterPrefix;
        if (string2 != null && string.startsWith(string2)) {
            if ("getCallbacks".equals(string) ? this._isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && this._isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return this._stdBeanNaming ? this.stdManglePropertyName(string, this._getterPrefix.length()) : this.legacyManglePropertyName(string, this._getterPrefix.length());
        }
        return null;
    }

    @Override
    public String findNameForMutator(AnnotatedMethod object, String string) {
        object = this._mutatorPrefix;
        if (object != null && string.startsWith((String)object)) {
            return this._stdBeanNaming ? this.stdManglePropertyName(string, this._mutatorPrefix.length()) : this.legacyManglePropertyName(string, this._mutatorPrefix.length());
        }
        return null;
    }

    @Override
    public String modifyFieldName(AnnotatedField annotatedField, String string) {
        return string;
    }

    public String legacyManglePropertyName(String string, int n2) {
        StringBuilder stringBuilder;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        int n4 = string.charAt(n2);
        Object object = this._baseNameValidator;
        if (object != null && !object.accept((char)n4, string, n2)) {
            return null;
        }
        int n5 = n4;
        n4 = Character.toLowerCase((char)n5);
        if (n5 == n4) {
            return string.substring(n2);
        }
        object = stringBuilder;
        ((StringBuilder)object)(n3 - n2);
        stringBuilder.append((char)n4);
        for (n4 = n2 + 1; n4 < n3; ++n4) {
            char c2 = string.charAt(n4);
            char c3 = Character.toLowerCase(c2);
            n2 = c3;
            if (c2 == c3) {
                ((StringBuilder)object).append(string, n4, n3);
                break;
            }
            ((StringBuilder)object).append((char)n2);
        }
        return ((StringBuilder)object).toString();
    }

    public String stdManglePropertyName(String string, int n2) {
        StringBuilder stringBuilder;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c2 = string.charAt(n2);
        BaseNameValidator baseNameValidator = this._baseNameValidator;
        if (baseNameValidator != null && !baseNameValidator.accept(c2, string, n2)) {
            return null;
        }
        char c3 = c2;
        c2 = Character.toLowerCase(c3);
        if (c3 == c2) {
            return string.substring(n2);
        }
        int n4 = n2 + 1;
        if (n4 < n3 && Character.isUpperCase(string.charAt(n4))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(n3 - n2);
        stringBuilder2.append(c2);
        stringBuilder.append(string, n4, n3);
        return stringBuilder.toString();
    }

    public boolean _isCglibGetCallbacks(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawType();
        if (clazz.isArray() && ((String)((Object)(clazz = clazz.getComponentType().getName()))).contains(".cglib")) {
            return ((String)((Object)clazz)).startsWith("net.sf.cglib") || ((String)((Object)clazz)).startsWith("org.hibernate.repackage.cglib") || ((String)((Object)clazz)).startsWith("org.springframework.cglib");
        }
        return false;
    }

    public boolean _isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.getRawType().getName().startsWith("groovy.lang");
    }

    public static interface BaseNameValidator {
        public boolean accept(char var1, String var2, int var3);
    }

    public static class RecordNaming
    extends DefaultAccessorNamingStrategy {
        protected final Set<String> _fieldNames;

        public RecordNaming(MapperConfig<?> object, AnnotatedClass object2) {
            super((MapperConfig<?>)object, (AnnotatedClass)object2, null, "get", "is", null);
            object = JDK14Util.getRecordFieldNames(((AnnotatedClass)object2).getRawType());
            if (object == null) {
                object = Collections.emptySet();
            } else {
                HashSet<String> hashSet;
                object2 = hashSet;
                hashSet = new HashSet<String>(Arrays.asList(object));
                object = object2;
            }
            this._fieldNames = object;
        }

        @Override
        public String findNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
            if (this._fieldNames.contains(string)) {
                return string;
            }
            return super.findNameForRegularGetter(annotatedMethod, string);
        }
    }

    public static class FirstCharBasedValidator
    implements BaseNameValidator {
        private final boolean _allowLowerCaseFirstChar;
        private final boolean _allowNonLetterFirstChar;

        public FirstCharBasedValidator(boolean bl, boolean bl2) {
            this._allowLowerCaseFirstChar = bl;
            this._allowNonLetterFirstChar = bl2;
        }

        public static BaseNameValidator forFirstNameRule(boolean bl, boolean bl2) {
            if (!bl && !bl2) {
                return null;
            }
            return new FirstCharBasedValidator(bl, bl2);
        }

        @Override
        public boolean accept(char c2, String string, int n2) {
            if (Character.isLetter(c2)) {
                return this._allowLowerCaseFirstChar || !Character.isLowerCase(c2);
            }
            return this._allowNonLetterFirstChar;
        }
    }

    public static class Provider
    extends AccessorNamingStrategy.Provider
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final String _setterPrefix;
        protected final String _withPrefix;
        protected final String _getterPrefix;
        protected final String _isGetterPrefix;
        protected final BaseNameValidator _baseNameValidator;

        public Provider() {
            this("set", "with", "get", "is", null);
        }

        public Provider(Provider provider, String string, String string2, String string3, String string4) {
            Provider provider2 = baseNameValidator;
            BaseNameValidator baseNameValidator = provider._baseNameValidator;
            provider2(string, string2, string3, string4, baseNameValidator);
        }

        public Provider(Provider object, BaseNameValidator baseNameValidator) {
            Provider provider = string;
            Provider provider2 = object;
            String string = provider2._setterPrefix;
            object = provider2._withPrefix;
            String string2 = provider2._getterPrefix;
            String string3 = provider2._isGetterPrefix;
            provider(string, (String)object, string2, string3, baseNameValidator);
        }

        public Provider(String string, String string2, String string3, String string4, BaseNameValidator baseNameValidator) {
            this._setterPrefix = string;
            this._withPrefix = string2;
            this._getterPrefix = string3;
            this._isGetterPrefix = string4;
            this._baseNameValidator = baseNameValidator;
        }

        public Provider withSetterPrefix(String string) {
            Provider provider = this;
            String string2 = provider._withPrefix;
            String string3 = provider._getterPrefix;
            String string4 = provider._isGetterPrefix;
            return new Provider(this, string, string2, string3, string4);
        }

        public Provider withBuilderPrefix(String string) {
            Provider provider = this;
            String string2 = provider._setterPrefix;
            String string3 = provider._getterPrefix;
            String string4 = provider._isGetterPrefix;
            return new Provider(this, string2, string, string3, string4);
        }

        public Provider withGetterPrefix(String string) {
            Provider provider = this;
            String string2 = provider._setterPrefix;
            String string3 = provider._withPrefix;
            String string4 = provider._isGetterPrefix;
            return new Provider(this, string2, string3, string, string4);
        }

        public Provider withIsGetterPrefix(String string) {
            Provider provider = this;
            String string2 = provider._setterPrefix;
            String string3 = provider._withPrefix;
            String string4 = provider._getterPrefix;
            return new Provider(this, string2, string3, string4, string);
        }

        public Provider withFirstCharAcceptance(boolean bl, boolean bl2) {
            return this.withBaseNameValidator(FirstCharBasedValidator.forFirstNameRule(bl, bl2));
        }

        public Provider withBaseNameValidator(BaseNameValidator baseNameValidator) {
            return new Provider(this, baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forPOJO(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
            Provider provider = string;
            String string = provider._setterPrefix;
            String string2 = provider._getterPrefix;
            String string3 = provider._isGetterPrefix;
            BaseNameValidator baseNameValidator = provider._baseNameValidator;
            return new DefaultAccessorNamingStrategy(mapperConfig, annotatedClass, string, string2, string3, baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forBuilder(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, BeanDescription object) {
            object = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
            object = object == null ? null : ((AnnotationIntrospector)object).findPOJOBuilderConfig(annotatedClass);
            object = object == null ? ((Provider)((Object)string))._withPrefix : ((JsonPOJOBuilder.Value)object).withPrefix;
            Provider provider = string;
            String string = provider._getterPrefix;
            String string2 = provider._isGetterPrefix;
            BaseNameValidator baseNameValidator = provider._baseNameValidator;
            return new DefaultAccessorNamingStrategy(mapperConfig, annotatedClass, (String)object, string, string2, baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forRecord(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
            return new RecordNaming(mapperConfig, annotatedClass);
        }
    }
}

