/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.privatefasterxml.jackson.annotation.JacksonInject;
import com.privatefasterxml.jackson.annotation.JsonAlias;
import com.privatefasterxml.jackson.annotation.JsonAnyGetter;
import com.privatefasterxml.jackson.annotation.JsonAnySetter;
import com.privatefasterxml.jackson.annotation.JsonAutoDetect;
import com.privatefasterxml.jackson.annotation.JsonBackReference;
import com.privatefasterxml.jackson.annotation.JsonClassDescription;
import com.privatefasterxml.jackson.annotation.JsonCreator;
import com.privatefasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.privatefasterxml.jackson.annotation.JsonFilter;
import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonGetter;
import com.privatefasterxml.jackson.annotation.JsonIdentityInfo;
import com.privatefasterxml.jackson.annotation.JsonIdentityReference;
import com.privatefasterxml.jackson.annotation.JsonIgnore;
import com.privatefasterxml.jackson.annotation.JsonIgnoreProperties;
import com.privatefasterxml.jackson.annotation.JsonIgnoreType;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.annotation.JsonIncludeProperties;
import com.privatefasterxml.jackson.annotation.JsonKey;
import com.privatefasterxml.jackson.annotation.JsonManagedReference;
import com.privatefasterxml.jackson.annotation.JsonMerge;
import com.privatefasterxml.jackson.annotation.JsonProperty;
import com.privatefasterxml.jackson.annotation.JsonPropertyDescription;
import com.privatefasterxml.jackson.annotation.JsonPropertyOrder;
import com.privatefasterxml.jackson.annotation.JsonRawValue;
import com.privatefasterxml.jackson.annotation.JsonRootName;
import com.privatefasterxml.jackson.annotation.JsonSetter;
import com.privatefasterxml.jackson.annotation.JsonSubTypes;
import com.privatefasterxml.jackson.annotation.JsonTypeId;
import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.annotation.JsonTypeName;
import com.privatefasterxml.jackson.annotation.JsonUnwrapped;
import com.privatefasterxml.jackson.annotation.JsonValue;
import com.privatefasterxml.jackson.annotation.JsonView;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerators;
import com.privatefasterxml.jackson.annotation.ObjectIdResolver;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.annotation.JsonAppend;
import com.privatefasterxml.jackson.databind.annotation.JsonDeserialize;
import com.privatefasterxml.jackson.databind.annotation.JsonNaming;
import com.privatefasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.privatefasterxml.jackson.databind.annotation.JsonSerialize;
import com.privatefasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.privatefasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.privatefasterxml.jackson.databind.annotation.JsonValueInstantiator;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.VisibilityChecker;
import com.privatefasterxml.jackson.databind.introspect.k;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.privatefasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.privatefasterxml.jackson.databind.ser.std.RawSerializer;
import com.privatefasterxml.jackson.databind.type.MapLikeType;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import com.privatefasterxml.jackson.databind.util.LRUMap;
import com.privatefasterxml.jackson.databind.util.NameTransformer;
import com.privatefasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_SER = new Class[]{JsonSerialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonRawValue.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class};
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_DESER = new Class[]{JsonDeserialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class, JsonMerge.class};
    protected transient LRUMap<Class<?>, Boolean> _annotationsInside;
    protected boolean _cfgConstructorPropertiesImpliesCreator;

    public JacksonAnnotationIntrospector() {
        LRUMap lRUMap;
        Serializable serializable = lRUMap;
        lRUMap = new LRUMap(48, 48);
        v1._annotationsInside = serializable;
        v1._cfgConstructorPropertiesImpliesCreator = true;
    }

    private List<NamedType> findSubtypesCheckRepeatedNames(String string, JsonSubTypes.Type[] typeArray) {
        HashSet<Object> hashSet;
        ArrayList arrayList;
        Serializable serializable = arrayList;
        arrayList = new ArrayList(typeArray.length);
        HashSet<Object> hashSet2 = hashSet;
        hashSet = new HashSet<Object>();
        for (JsonSubTypes.Type type : typeArray) {
            String[] stringArray = type.name();
            if (!stringArray.isEmpty() && hashSet2.contains(stringArray)) {
                throw new IllegalArgumentException("Annotated type [" + string + "] got repeated subtype name [" + (String)stringArray + "]");
            }
            hashSet2.add(stringArray);
            ((ArrayList)serializable).add(new NamedType(type.value(), (String)stringArray));
            for (String string2 : type.names()) {
                if (!string2.isEmpty() && hashSet2.contains(string2)) {
                    throw new IllegalArgumentException("Annotated type [" + string + "] got repeated subtype name [" + string2 + "]");
                }
                hashSet2.add(string2);
                ((ArrayList)serializable).add(new NamedType(type.value(), string2));
            }
        }
        return serializable;
    }

    private JsonInclude.Value _refinePropertyInclusion(Annotated annotated, JsonInclude.Value value) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonSerialize.class)) != null) {
            switch (k.a[this.include().ordinal()]) {
                default: {
                    break;
                }
                case 4: {
                    return value.withValueInclusion(JsonInclude.Include.NON_EMPTY);
                }
                case 3: {
                    return value.withValueInclusion(JsonInclude.Include.NON_DEFAULT);
                }
                case 2: {
                    return value.withValueInclusion(JsonInclude.Include.NON_NULL);
                }
                case 1: {
                    return value.withValueInclusion(JsonInclude.Include.ALWAYS);
                }
            }
        }
        return value;
    }

    private final Boolean _findSortAlpha(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonPropertyOrder.class)) != null && this.alphabetic()) {
            return Boolean.TRUE;
        }
        return null;
    }

    private boolean _primitiveAndWrapper(Class<?> clazz, Class<?> clazz2) {
        if (clazz.isPrimitive()) {
            return clazz == ClassUtil.primitiveType(clazz2);
        }
        if (clazz2.isPrimitive()) {
            return clazz2 == ClassUtil.primitiveType(clazz);
        }
        return false;
    }

    private boolean _primitiveAndWrapper(JavaType javaType, Class<?> clazz) {
        if (javaType.isPrimitive()) {
            return javaType.hasRawClass(ClassUtil.primitiveType(clazz));
        }
        if (clazz.isPrimitive()) {
            return clazz == ClassUtil.primitiveType(javaType.getRawClass());
        }
        return false;
    }

    private JsonMappingException _databindException(String string) {
        return new JsonMappingException(null, string);
    }

    private JsonMappingException _databindException(Throwable throwable, String string) {
        return new JsonMappingException(null, string, throwable);
    }

    @Override
    public Version version() {
        return new Version(2, 14, 1, "applitools", "com.privatefasterxml", "artifact identification not set");
    }

    public Object readResolve() {
        if (this._annotationsInside == null) {
            LRUMap lRUMap;
            LRUMap lRUMap2 = lRUMap;
            lRUMap = new LRUMap(48, 48);
            this._annotationsInside = lRUMap2;
        }
        return this;
    }

    public JacksonAnnotationIntrospector setConstructorPropertiesImpliesCreator(boolean bl) {
        this._cfgConstructorPropertiesImpliesCreator = bl;
        return this;
    }

    @Override
    public boolean isAnnotationBundle(Annotation object) {
        Boolean bl = this._annotationsInside.get(object = object.annotationType());
        if (bl == null) {
            bl = ((Class)object).getAnnotation(JacksonAnnotationsInside.class) != null;
            this._annotationsInside.putIfAbsent((Class<?>)object, bl);
        }
        return bl;
    }

    @Override
    @Deprecated
    public String findEnumValue(Enum<?> enum_) {
        block7: {
            Object object = enum_.getDeclaringClass().getField(enum_.name());
            if (object == null) break block7;
            object = ((Field)object).getAnnotation(JsonProperty.class);
            if (object == null) break block7;
            object = object.value();
            if (object == null) break block7;
            try {
                if (!((String)object).isEmpty()) {
                    return object;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {}
        }
        return enum_.name();
    }

    @Override
    public String[] findEnumValues(Class<?> fieldArray, Enum<?>[] enumArray, String[] stringArray) {
        Serializable serializable = null;
        for (Field field : fieldArray.getDeclaredFields()) {
            Object object;
            if (!field.isEnumConstant() || (object = field.getAnnotation(JsonProperty.class)) == null || ((String)(object = object.value())).isEmpty()) continue;
            if (serializable == null) {
                HashMap hashMap;
                serializable = hashMap;
                hashMap = new HashMap();
            }
            ((HashMap)serializable).put(field.getName(), object);
        }
        if (serializable != null) {
            int n2 = enumArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = (String)((HashMap)serializable).get(enumArray[i2].name());
                if (string == null) continue;
                stringArray[i2] = string;
            }
        }
        return stringArray;
    }

    @Override
    public void findEnumAliases(Class<?> clazz, Enum<?>[] enumArray, String[][] stringArray) {
        for (Field field : clazz.getDeclaredFields()) {
            String[] stringArray2;
            if (!field.isEnumConstant() || (stringArray2 = field.getAnnotation(JsonAlias.class)) == null || (stringArray2 = stringArray2.value()).length == 0) continue;
            String string = field.getName();
            int n2 = enumArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!string.equals(enumArray[i2].name())) continue;
                stringArray[i2] = stringArray2;
            }
        }
    }

    @Override
    public Enum<?> findDefaultEnumValue(Class<Enum<?>> clazz) {
        return ClassUtil.findFirstAnnotatedEnumValue(clazz, JsonEnumDefaultValue.class);
    }

    @Override
    public PropertyName findRootName(AnnotatedClass object) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation((Annotated)object, JsonRootName.class)) == null) {
            return null;
        }
        object = this.namespace();
        if (object != null && ((String)object).isEmpty()) {
            object = null;
        }
        return PropertyName.construct(this.value(), (String)object);
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotatedClass, JsonIgnoreType.class)) == null ? null : Boolean.valueOf(this.value());
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> mapperConfig, Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonIgnoreProperties.class)) == null) {
            return JsonIgnoreProperties.Value.empty();
        }
        return JsonIgnoreProperties.Value.from((JsonIgnoreProperties)this);
    }

    @Override
    @Deprecated
    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated annotated) {
        return this.findPropertyIgnoralByName(null, annotated);
    }

    @Override
    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> mapperConfig, Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonIncludeProperties.class)) == null) {
            return JsonIncludeProperties.Value.all();
        }
        return JsonIncludeProperties.Value.from((JsonIncludeProperties)this);
    }

    @Override
    public Object findFilterId(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonFilter.class)) != null && !((String)(this = this.value())).isEmpty()) {
            return this;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass annotatedClass) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotatedClass, JsonNaming.class)) == null ? null : this.value();
    }

    @Override
    public String findClassDescription(AnnotatedClass annotatedClass) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotatedClass, JsonClassDescription.class)) == null ? null : this.value();
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotatedClass, JsonAutoDetect.class)) != null) {
            visibilityChecker = visibilityChecker.with((JsonAutoDetect)this);
        }
        return visibilityChecker;
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember annotatedMember) {
        return (this = ((JacksonAnnotationIntrospector)this)._findConstructorName(annotatedMember)) == null ? null : ((PropertyName)this).getSimpleName();
    }

    @Override
    public List<PropertyName> findPropertyAliases(Annotated annotated) {
        ArrayList<PropertyName> arrayList;
        if ((this = this._findAnnotation(annotated, JsonAlias.class)) == null) {
            return null;
        }
        int n2 = (this = this.value()).length;
        if (n2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<PropertyName> arrayList2 = arrayList;
        arrayList = new ArrayList<PropertyName>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(PropertyName.construct(this[i2]));
        }
        return arrayList2;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return this._isIgnorable(annotatedMember);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotatedMember, JsonProperty.class)) != null) {
            return this.required();
        }
        return null;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonProperty.class)) != null) {
            return this.access();
        }
        return null;
    }

    @Override
    public String findPropertyDescription(Annotated annotated) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonPropertyDescription.class)) == null ? null : this.value();
    }

    @Override
    public Integer findPropertyIndex(Annotated annotated) {
        int n2;
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonProperty.class)) != null && (n2 = this.index()) != -1) {
            return n2;
        }
        return null;
    }

    @Override
    public String findPropertyDefaultValue(Annotated annotated) {
        if ((object = ((AnnotationIntrospector)object)._findAnnotation(annotated, JsonProperty.class)) == null) {
            return null;
        }
        if (((String)(object = object.defaultValue())).isEmpty()) {
            Object object = null;
        }
        return object;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated annotated) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonFormat.class)) == null ? null : JsonFormat.Value.from((JsonFormat)this);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember annotatedMember) {
        JsonManagedReference jsonManagedReference = ((AnnotationIntrospector)this)._findAnnotation(annotatedMember, JsonManagedReference.class);
        if (jsonManagedReference != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(jsonManagedReference.value());
        }
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotatedMember, JsonBackReference.class)) != null) {
            return AnnotationIntrospector.ReferenceProperty.back(this.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember annotatedMember) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotatedMember, JsonUnwrapped.class)) != null && this.enabled()) {
            return NameTransformer.simpleTransformer(this.prefix(), this.suffix());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public JacksonInject.Value findInjectableValue(AnnotatedMember object) {
        AnnotatedMethod annotatedMethod;
        if ((this = ((AnnotationIntrospector)this)._findAnnotation((Annotated)object, JacksonInject.class)) == null) {
            return null;
        }
        if (((JacksonInject.Value)(this = JacksonInject.Value.from((JacksonInject)this))).hasId()) return this;
        object = !(object instanceof AnnotatedMethod) || (annotatedMethod = (AnnotatedMethod)object).getParameterCount() == 0 ? ((Annotated)object).getRawType().getName() : annotatedMethod.getRawParameterType(0).getName();
        return ((JacksonInject.Value)this).withId(object);
    }

    @Override
    @Deprecated
    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        return (this = ((JacksonAnnotationIntrospector)this).findInjectableValue(annotatedMember)) == null ? null : ((JacksonInject.Value)this).getId();
    }

    @Override
    public Class<?>[] findViews(Annotated annotated) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonView.class)) == null ? null : this.value();
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> serializable, AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        Serializable serializable2 = annotatedMethod.getRawParameterType(0);
        serializable = annotatedMethod2.getRawParameterType(0);
        if (((Class)serializable2).isPrimitive()) {
            if (!((Class)serializable).isPrimitive()) {
                return annotatedMethod;
            }
            return null;
        }
        if (((Class)serializable).isPrimitive()) {
            return annotatedMethod2;
        }
        if (serializable2 == String.class) {
            if (serializable != String.class) {
                return annotatedMethod;
            }
        } else if (serializable == String.class) {
            return annotatedMethod2;
        }
        return null;
    }

    @Override
    public PropertyName findRenameByField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, PropertyName propertyName) {
        return null;
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return this._findTypeResolver(mapperConfig, annotatedClass, javaType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (!javaType.isContainerType() && !javaType.isReferenceType()) {
            return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
        }
        return null;
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.getContentType() != null) {
            return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
        }
        throw new IllegalArgumentException("Must call method with a container or reference type (got " + javaType + ")");
    }

    @Override
    public List<NamedType> findSubtypes(Annotated annotated) {
        ArrayList arrayList;
        JsonSubTypes.Type[] typeArray = ((AnnotationIntrospector)serializable)._findAnnotation(annotated, JsonSubTypes.class);
        if (typeArray == null) {
            return null;
        }
        if ((typeArray = typeArray.value()).failOnRepeatedNames()) {
            return ((JacksonAnnotationIntrospector)serializable).findSubtypesCheckRepeatedNames(annotated.getName(), typeArray);
        }
        Serializable serializable = arrayList;
        arrayList = new ArrayList(typeArray.length);
        for (JsonSubTypes.Type type : typeArray) {
            String[] stringArray;
            String[] stringArray2 = stringArray;
            JsonSubTypes.Type type2 = type;
            Class<?> clazz = type2.value();
            stringArray = new NamedType(clazz, type2.name());
            ((ArrayList)serializable).add(stringArray2);
            for (String string : type.names()) {
                ((ArrayList)serializable).add(new NamedType(type.value(), string));
            }
        }
        return serializable;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotatedClass, JsonTypeName.class)) == null ? null : this.value();
    }

    @Override
    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        return this._hasAnnotation(annotatedMember, JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated clazz) {
        if ((clazz4 = ((AnnotationIntrospector)((Object)clazz4))._findAnnotation((Annotated)((Object)clazz), JsonIdentityInfo.class)) != null && clazz4.generator() != ObjectIdGenerators.None.class) {
            Class<ObjectIdGenerator<?>> clazz2 = clazz = PropertyName.construct(clazz4.property());
            Class<?> clazz3 = clazz4;
            Class<?> clazz4 = clazz3.scope();
            clazz = clazz3.generator();
            Class<? extends ObjectIdResolver> clazz5 = clazz3.resolver();
            return new ObjectIdInfo((PropertyName)((Object)clazz2), clazz4, (Class<? extends ObjectIdGenerator<?>>)clazz, clazz5);
        }
        return null;
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonIdentityReference.class)) == null) {
            return objectIdInfo;
        }
        if (objectIdInfo == null) {
            objectIdInfo = ObjectIdInfo.empty();
        }
        return objectIdInfo.withAlwaysAsId(this.alwaysAsId());
    }

    @Override
    public Object findSerializer(Annotated annotated) {
        Object object = ((AnnotationIntrospector)((Object)clazz))._findAnnotation(annotated, JsonSerialize.class);
        if (object != null && (object = object.using()) != JsonSerializer.None.class) {
            return object;
        }
        if ((clazz = ((AnnotationIntrospector)((Object)clazz))._findAnnotation(annotated, JsonRawValue.class)) != null && clazz.value()) {
            Class<?> clazz = annotated.getRawType();
            return new RawSerializer(clazz);
        }
        return null;
    }

    @Override
    public Object findKeySerializer(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)((Object)this))._findAnnotation(annotated, JsonSerialize.class)) != null && (this = this.keyUsing()) != JsonSerializer.None.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object findContentSerializer(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)((Object)this))._findAnnotation(annotated, JsonSerialize.class)) != null && (this = this.contentUsing()) != JsonSerializer.None.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object findNullSerializer(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)((Object)this))._findAnnotation(annotated, JsonSerialize.class)) != null && (this = this.nullsUsing()) != JsonSerializer.None.class) {
            return this;
        }
        return null;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(Annotated annotated) {
        Object object = this._findAnnotation(annotated, JsonInclude.class);
        object = object == null ? JsonInclude.Value.empty() : JsonInclude.Value.from((JsonInclude)object);
        if (((JsonInclude.Value)object).getValueInclusion() == JsonInclude.Include.USE_DEFAULTS) {
            object = this._refinePropertyInclusion(annotated, (JsonInclude.Value)object);
        }
        return object;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated annotated) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonSerialize.class)) == null ? null : this.typing();
    }

    @Override
    public Object findSerializationConverter(Annotated object) {
        return (object = this._findAnnotation((Annotated)object, JsonSerialize.class)) == null ? null : this._classIfExplicit(object.converter(), Converter.None.class);
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember object) {
        return (object = this._findAnnotation((Annotated)object, JsonSerialize.class)) == null ? null : this._classIfExplicit(object.contentConverter(), Converter.None.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JavaType refineSerializationType(MapperConfig<?> serializable, Annotated annotated, JavaType javaType) {
        IllegalArgumentException illegalArgumentException4;
        Object object;
        Type type;
        Object object2;
        block35: {
            Class<Object> clazz;
            block36: {
                block33: {
                    serializable = ((MapperConfig)serializable).getTypeFactory();
                    object2 = ((AnnotationIntrospector)object)._findAnnotation(annotated, JsonSerialize.class);
                    type = object2 == null ? null : ((JacksonAnnotationIntrospector)object)._classIfExplicit(object2.as());
                    if (type != null) {
                        if (javaType.hasRawClass((Class<?>)type)) {
                            javaType = javaType.withStaticTyping();
                        } else {
                            clazz = javaType.getRawClass();
                            try {
                                JavaType javaType2;
                                if (((Class)type).isAssignableFrom(clazz)) {
                                    javaType2 = ((TypeFactory)serializable).constructGeneralizedType(javaType, (Class<?>)type);
                                } else if (clazz.isAssignableFrom((Class<?>)type)) {
                                    javaType2 = ((TypeFactory)serializable).constructSpecializedType(javaType, (Class<?>)type);
                                } else if (super._primitiveAndWrapper(clazz, (Class<?>)type)) {
                                    javaType2 = javaType.withStaticTyping();
                                } else {
                                    Object[] objectArray = new Object[2];
                                    objectArray[0] = javaType;
                                    int n2 = 1;
                                    objectArray[n2] = ((Class)type).getName();
                                    throw super._databindException(String.format("Cannot refine serialization type %s into %s; types not related", objectArray));
                                }
                                javaType = javaType2;
                                break block33;
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {}
                            Object[] objectArray = object;
                            Object[] objectArray2 = new Object[4];
                            object = objectArray2;
                            object[0] = javaType;
                            object[1] = ((Class)type).getName();
                            object[2] = annotated.getName();
                            objectArray2[3] = illegalArgumentException2.getMessage();
                            throw super._databindException(illegalArgumentException2, String.format("Failed to widen type %s with annotation (value %s), from '%s': %s", (Object[])object));
                        }
                    }
                }
                if (javaType.isMapLikeType()) {
                    type = javaType.getKeyType();
                    clazz = object2 == null ? null : ((JacksonAnnotationIntrospector)object)._classIfExplicit(object2.keyAs());
                    if (clazz != null) {
                        Object[] objectArray;
                        String string;
                        Object object3;
                        block34: {
                            if (((JavaType)type).hasRawClass(clazz)) {
                                type = ((JavaType)type).withStaticTyping();
                            } else {
                                JavaType javaType3;
                                Class<?> clazz2 = ((JavaType)type).getRawClass();
                                if (clazz.isAssignableFrom(clazz2)) {
                                    javaType3 = ((TypeFactory)serializable).constructGeneralizedType((JavaType)type, clazz);
                                } else if (clazz2.isAssignableFrom(clazz)) {
                                    javaType3 = ((TypeFactory)serializable).constructSpecializedType((JavaType)type, clazz);
                                } else {
                                    if (!super._primitiveAndWrapper(clazz2, clazz)) break block34;
                                    javaType3 = ((JavaType)type).withStaticTyping();
                                }
                                type = javaType3;
                            }
                            javaType = ((MapLikeType)javaType).withKeyType((JavaType)type);
                            break block36;
                        }
                        try {
                            object3 = object;
                            string = "Cannot refine serialization key type %s into %s; types not related";
                            objectArray = new Object[2];
                        }
                        catch (IllegalArgumentException illegalArgumentException3) {}
                        objectArray[0] = type;
                        int n3 = 1;
                        objectArray[n3] = clazz.getName();
                        throw super._databindException(String.format(string, objectArray));
                        Object object4 = object;
                        Object[] objectArray3 = new Object[4];
                        object = objectArray3;
                        object[0] = javaType;
                        object[1] = clazz.getName();
                        object[2] = annotated.getName();
                        objectArray3[3] = illegalArgumentException3.getMessage();
                        throw super._databindException(illegalArgumentException3, String.format("Failed to widen key type of %s with concrete-type annotation (value %s), from '%s': %s", (Object[])object));
                    }
                }
            }
            if ((type = javaType.getContentType()) == null) return javaType;
            object2 = object2 == null ? null : ((JacksonAnnotationIntrospector)object)._classIfExplicit(object2.contentAs());
            if (object2 == null) return javaType;
            if (((JavaType)type).hasRawClass((Class<?>)object2)) {
                object = ((JavaType)type).withStaticTyping();
                return javaType.withContentType((JavaType)object);
            }
            clazz = ((JavaType)type).getRawClass();
            try {
                JavaType javaType4;
                if (((Class)object2).isAssignableFrom(clazz)) {
                    javaType4 = ((TypeFactory)serializable).constructGeneralizedType((JavaType)type, (Class<?>)object2);
                } else if (clazz.isAssignableFrom((Class<?>)object2)) {
                    javaType4 = ((TypeFactory)serializable).constructSpecializedType((JavaType)type, (Class<?>)object2);
                } else {
                    if (!super._primitiveAndWrapper(clazz, (Class<?>)object2)) break block35;
                    javaType4 = ((JavaType)type).withStaticTyping();
                }
                object = javaType4;
            }
            catch (IllegalArgumentException illegalArgumentException4) {}
            return javaType.withContentType((JavaType)object);
        }
        Object object5 = object;
        String string = "Cannot refine serialization content type %s into %s; types not related";
        Object[] objectArray = new Object[2];
        objectArray[0] = type;
        int n4 = 1;
        objectArray[n4] = ((Class)object2).getName();
        throw super._databindException(String.format(string, objectArray));
        Object object6 = object;
        Object[] objectArray4 = new Object[4];
        object = objectArray4;
        object[0] = javaType;
        object[1] = ((Class)object2).getName();
        object[2] = annotated.getName();
        objectArray4[3] = illegalArgumentException4.getMessage();
        throw super._databindException(illegalArgumentException4, String.format("Internal error: failed to refine value type of %s with concrete-type annotation (value %s), from '%s': %s", (Object[])object));
    }

    @Override
    @Deprecated
    public Class<?> findSerializationType(Annotated annotated) {
        return null;
    }

    @Override
    @Deprecated
    public Class<?> findSerializationKeyType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Override
    @Deprecated
    public Class<?> findSerializationContentType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotatedClass, JsonPropertyOrder.class)) == null ? null : this.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(Annotated annotated) {
        return this._findSortAlpha(annotated);
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<BeanPropertyWriter> list) {
        JsonAppend.Prop[] propArray = this._findAnnotation(annotatedClass, JsonAppend.class);
        if (propArray == null) {
            return;
        }
        boolean bl = propArray.prepend();
        JavaType javaType = null;
        JsonAppend.Attr[] attrArray = propArray.attrs();
        int n2 = attrArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (javaType == null) {
                javaType = mapperConfig.constructType(Object.class);
            }
            BeanPropertyWriter beanPropertyWriter = this._constructVirtualProperty(attrArray[i2], mapperConfig, annotatedClass, javaType);
            if (bl) {
                list.add(i2, beanPropertyWriter);
                continue;
            }
            list.add(beanPropertyWriter);
        }
        propArray = propArray.props();
        int n3 = propArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            BeanPropertyWriter beanPropertyWriter = this._constructVirtualProperty(propArray[i3], mapperConfig, annotatedClass);
            if (bl) {
                list.add(i3, beanPropertyWriter);
                continue;
            }
            list.add(beanPropertyWriter);
        }
    }

    public BeanPropertyWriter _constructVirtualProperty(JsonAppend.Attr object, MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        VirtualAnnotatedMember virtualAnnotatedMember;
        PropertyMetadata propertyMetadata = object.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        JacksonAnnotationIntrospector jacksonAnnotationIntrospector = object2;
        JsonAppend.Attr attr = object;
        Object object2 = attr.value();
        Object object3 = attr.propName();
        if (!((PropertyName)(object3 = jacksonAnnotationIntrospector._propertyName((String)object3, attr.propNamespace()))).hasSimpleName()) {
            object3 = PropertyName.construct((String)object2);
        }
        Object object4 = object2;
        JsonAppend.Attr attr2 = object;
        object = virtualAnnotatedMember;
        AnnotatedClass annotatedClass2 = annotatedClass;
        virtualAnnotatedMember = new VirtualAnnotatedMember(annotatedClass2, annotatedClass2.getRawType(), (String)object2, javaType);
        object2 = attr2.include();
        object2 = SimpleBeanPropertyDefinition.construct(mapperConfig, (AnnotatedMember)object, (PropertyName)object3, propertyMetadata, (JsonInclude.Include)((Object)object2));
        return AttributePropertyWriter.construct((String)object4, (BeanPropertyDefinition)object2, annotatedClass.getAnnotations(), javaType);
    }

    public BeanPropertyWriter _constructVirtualProperty(JsonAppend.Prop object, MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        VirtualAnnotatedMember virtualAnnotatedMember;
        Serializable serializable = object.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        JsonAppend.Prop prop = object;
        JsonAppend.Prop prop2 = object;
        JacksonAnnotationIntrospector jacksonAnnotationIntrospector = object2;
        JsonAppend.Prop prop3 = object;
        Object object2 = prop3.name();
        object2 = jacksonAnnotationIntrospector._propertyName((String)object2, prop3.namespace());
        object = mapperConfig.constructType(object.type());
        Object object3 = virtualAnnotatedMember;
        Object object4 = annotatedClass.getRawType();
        virtualAnnotatedMember = new VirtualAnnotatedMember(annotatedClass, (Class<?>)object4, ((PropertyName)object2).getSimpleName(), (JavaType)object);
        object4 = prop2.include();
        object2 = SimpleBeanPropertyDefinition.construct(mapperConfig, (AnnotatedMember)object3, (PropertyName)object2, serializable, object4);
        serializable = prop.value();
        object3 = mapperConfig.getHandlerInstantiator();
        if ((object3 = object3 == null ? null : ((HandlerInstantiator)object3).virtualPropertyWriterInstance(mapperConfig, (Class<?>)serializable)) == null) {
            object3 = (VirtualBeanPropertyWriter)ClassUtil.createInstance(serializable, mapperConfig.canOverrideAccessModifiers());
        }
        return ((VirtualBeanPropertyWriter)object3).withConfig(mapperConfig, annotatedClass, (BeanPropertyDefinition)object2, (JavaType)object);
    }

    @Override
    public PropertyName findNameForSerialization(Annotated annotated) {
        boolean bl = false;
        Annotation annotation = ((AnnotationIntrospector)object)._findAnnotation(annotated, JsonGetter.class);
        if (annotation != null) {
            String string = annotation.value();
            if (!string.isEmpty()) {
                return PropertyName.construct(string);
            }
            bl = true;
        }
        if ((annotation = ((AnnotationIntrospector)object)._findAnnotation(annotated, JsonProperty.class)) != null) {
            Object object = annotation.namespace();
            if (object != null && ((String)object).isEmpty()) {
                object = null;
            }
            return PropertyName.construct(annotation.value(), (String)object);
        }
        if (!bl && !((AnnotationIntrospector)object)._hasOneOf(annotated, ANNOTATIONS_TO_INFER_SER)) {
            return null;
        }
        return PropertyName.USE_DEFAULT;
    }

    @Override
    public Boolean hasAsKey(MapperConfig<?> mapperConfig, Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonKey.class)) == null) {
            return null;
        }
        return this.value();
    }

    @Override
    public Boolean hasAsValue(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonValue.class)) == null) {
            return null;
        }
        return this.value();
    }

    @Override
    public Boolean hasAnyGetter(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonAnyGetter.class)) == null) {
            return null;
        }
        return this.enabled();
    }

    @Override
    @Deprecated
    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._hasAnnotation(annotatedMethod, JsonAnyGetter.class);
    }

    @Override
    @Deprecated
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotatedMethod, JsonValue.class)) != null && this.value();
    }

    @Override
    public Object findDeserializer(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)((Object)this))._findAnnotation(annotated, JsonDeserialize.class)) != null && (this = this.using()) != JsonDeserializer.None.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object findKeyDeserializer(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)((Object)this))._findAnnotation(annotated, JsonDeserialize.class)) != null && (this = this.keyUsing()) != KeyDeserializer.None.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object findContentDeserializer(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)((Object)this))._findAnnotation(annotated, JsonDeserialize.class)) != null && (this = this.contentUsing()) != JsonDeserializer.None.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object findDeserializationConverter(Annotated object) {
        return (object = this._findAnnotation((Annotated)object, JsonDeserialize.class)) == null ? null : this._classIfExplicit(object.converter(), Converter.None.class);
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember object) {
        return (object = this._findAnnotation((Annotated)object, JsonDeserialize.class)) == null ? null : this._classIfExplicit(object.contentConverter(), Converter.None.class);
    }

    @Override
    public JavaType refineDeserializationType(MapperConfig<?> serializable, Annotated annotated, JavaType javaType) {
        Object[] objectArray;
        serializable = ((MapperConfig)serializable).getTypeFactory();
        Object object = objectArray._findAnnotation(annotated, JsonDeserialize.class);
        Type type = object == null ? null : objectArray._classIfExplicit(object.as());
        if (type != null && !javaType.hasRawClass((Class<?>)type) && !objectArray._primitiveAndWrapper(javaType, (Class<?>)type)) {
            try {
                javaType = ((TypeFactory)serializable).constructSpecializedType(javaType, (Class<?>)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[4];
                objectArray = objectArray3;
                objectArray[0] = javaType;
                objectArray[1] = type.getName();
                objectArray[2] = annotated.getName();
                objectArray3[3] = illegalArgumentException.getMessage();
                throw super._databindException(illegalArgumentException, String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", objectArray));
            }
        }
        if (javaType.isMapLikeType()) {
            type = javaType.getKeyType();
            Class<?> clazz = object == null ? null : objectArray._classIfExplicit(object.keyAs());
            if (clazz != null && !objectArray._primitiveAndWrapper((JavaType)type, clazz)) {
                JavaType javaType2;
                try {
                    javaType2 = javaType;
                    type = ((TypeFactory)serializable).constructSpecializedType((JavaType)type, clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Object[] objectArray4 = objectArray;
                    Object[] objectArray5 = new Object[4];
                    objectArray = objectArray5;
                    objectArray[0] = javaType;
                    objectArray[1] = clazz.getName();
                    objectArray[2] = annotated.getName();
                    objectArray5[3] = illegalArgumentException.getMessage();
                    throw super._databindException(illegalArgumentException, String.format("Failed to narrow key type of %s with concrete-type annotation (value %s), from '%s': %s", objectArray));
                }
                javaType = ((MapLikeType)javaType2).withKeyType((JavaType)type);
            }
        }
        if ((type = javaType.getContentType()) != null && (object = object == null ? null : objectArray._classIfExplicit(object.contentAs())) != null && !super._primitiveAndWrapper((JavaType)type, (Class<?>)object)) {
            try {
                javaType = javaType.withContentType(((TypeFactory)serializable).constructSpecializedType((JavaType)type, (Class<?>)object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray6 = objectArray;
                Object[] objectArray7 = new Object[4];
                objectArray = objectArray7;
                objectArray[0] = javaType;
                objectArray[1] = ((Class)object).getName();
                objectArray[2] = annotated.getName();
                objectArray7[3] = illegalArgumentException.getMessage();
                throw super._databindException(illegalArgumentException, String.format("Failed to narrow value type of %s with concrete-type annotation (value %s), from '%s': %s", objectArray));
            }
        }
        return javaType;
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationKeyType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotatedClass, JsonValueInstantiator.class)) == null ? null : this.value();
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass object) {
        return (object = this._findAnnotation((Annotated)object, JsonDeserialize.class)) == null ? null : this._classIfExplicit(object.builder());
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass object) {
        Object object2;
        if ((object2 = ((AnnotationIntrospector)object2)._findAnnotation((Annotated)object, JsonPOJOBuilder.class)) == null) {
            object2 = null;
        } else {
            JsonPOJOBuilder.Value value;
            object = value;
            value = new JsonPOJOBuilder.Value((JsonPOJOBuilder)object2);
            object2 = object;
        }
        return object2;
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated annotated) {
        boolean bl = false;
        Annotation annotation = ((AnnotationIntrospector)object)._findAnnotation(annotated, JsonSetter.class);
        if (annotation != null) {
            String string = annotation.value();
            if (string.isEmpty()) {
                bl = true;
            } else {
                return PropertyName.construct(string);
            }
        }
        if ((annotation = ((AnnotationIntrospector)object)._findAnnotation(annotated, JsonProperty.class)) != null) {
            Object object = annotation.namespace();
            if (object != null && ((String)object).isEmpty()) {
                object = null;
            }
            return PropertyName.construct(annotation.value(), (String)object);
        }
        if (!bl && !((AnnotationIntrospector)object)._hasOneOf(annotated, ANNOTATIONS_TO_INFER_DESER)) {
            return null;
        }
        return PropertyName.USE_DEFAULT;
    }

    @Override
    public Boolean hasAnySetter(Annotated annotated) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonAnySetter.class)) == null ? null : Boolean.valueOf(this.enabled());
    }

    @Override
    public JsonSetter.Value findSetterInfo(Annotated annotated) {
        return JsonSetter.Value.from(this._findAnnotation(annotated, JsonSetter.class));
    }

    @Override
    public Boolean findMergeInfo(Annotated annotated) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonMerge.class)) == null ? null : this.value().asBoolean();
    }

    @Override
    @Deprecated
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._hasAnnotation(annotatedMethod, JsonAnySetter.class);
    }

    @Override
    @Deprecated
    public boolean hasCreatorAnnotation(Annotated annotated) {
        JsonCreator jsonCreator = this._findAnnotation(annotated, JsonCreator.class);
        if (jsonCreator != null) {
            return jsonCreator.mode() != JsonCreator.Mode.DISABLED;
        }
        if (this._cfgConstructorPropertiesImpliesCreator) {
            boolean cfr_ignored_0 = annotated instanceof AnnotatedConstructor;
        }
        return false;
    }

    @Override
    @Deprecated
    public JsonCreator.Mode findCreatorBinding(Annotated annotated) {
        return (this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonCreator.class)) == null ? null : this.mode();
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> mapperConfig, Annotated annotated) {
        JsonCreator jsonCreator = this._findAnnotation(annotated, JsonCreator.class);
        if (jsonCreator != null) {
            return jsonCreator.mode();
        }
        if (this._cfgConstructorPropertiesImpliesCreator && mapperConfig.isEnabled(MapperFeature.INFER_CREATOR_FROM_CONSTRUCTOR_PROPERTIES)) {
            boolean cfr_ignored_0 = annotated instanceof AnnotatedConstructor;
        }
        return null;
    }

    public boolean _isIgnorable(Annotated annotated) {
        if ((this = ((AnnotationIntrospector)this)._findAnnotation(annotated, JsonIgnore.class)) != null) {
            return this.value();
        }
        return false;
    }

    public Class<?> _classIfExplicit(Class<?> clazz) {
        if (clazz != null && !ClassUtil.isBogusClass(clazz)) {
            return clazz;
        }
        return null;
    }

    public Class<?> _classIfExplicit(Class<?> clazz, Class<?> clazz2) {
        if ((serializable = serializable._classIfExplicit(clazz)) == null || serializable == clazz2) {
            Serializable serializable = null;
        }
        return serializable;
    }

    public PropertyName _propertyName(String string, String string2) {
        if (string.isEmpty()) {
            return PropertyName.USE_DEFAULT;
        }
        if (string2 != null && !string2.isEmpty()) {
            return PropertyName.construct(string, string2);
        }
        return PropertyName.construct(string);
    }

    public PropertyName _findConstructorName(Annotated annotated) {
        if (annotated instanceof AnnotatedParameter) {
            ((AnnotatedParameter)annotated).getOwner();
        }
        return null;
    }

    public TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> object, Annotated annotated, JavaType javaType) {
        JsonTypeInfo jsonTypeInfo = ((AnnotationIntrospector)object3)._findAnnotation(annotated, JsonTypeInfo.class);
        Object object2 = ((AnnotationIntrospector)object3)._findAnnotation(annotated, JsonTypeResolver.class);
        if (object2 != null) {
            if (jsonTypeInfo == null) {
                return null;
            }
            object2 = object.typeResolverBuilderInstance(annotated, object2.value());
        } else {
            if (jsonTypeInfo == null) {
                return null;
            }
            if (jsonTypeInfo.use() == JsonTypeInfo.Id.NONE) {
                return ((JacksonAnnotationIntrospector)object3)._constructNoTypeResolverBuilder();
            }
            object2 = ((JacksonAnnotationIntrospector)object3)._constructStdTypeResolverBuilder();
        }
        Object object3 = ((AnnotationIntrospector)object3)._findAnnotation(annotated, JsonTypeIdResolver.class);
        object3 = object3 == null ? null : object.typeIdResolverInstance(annotated, object3.value());
        if (object3 != null) {
            object3.init(javaType);
        }
        object3 = object2.init(jsonTypeInfo.use(), (TypeIdResolver)object3);
        object = jsonTypeInfo.include();
        if (object == JsonTypeInfo.As.EXTERNAL_PROPERTY && annotated instanceof AnnotatedClass) {
            object = JsonTypeInfo.As.PROPERTY;
        }
        object3 = object3.inclusion((JsonTypeInfo.As)((Object)object)).typeProperty(jsonTypeInfo.property());
        object = jsonTypeInfo.defaultImpl();
        if (object != JsonTypeInfo.None.class && !((Class)object).isAnnotation()) {
            object3 = object3.defaultImpl((Class<?>)object);
        }
        return object3.typeIdVisibility(jsonTypeInfo.visible());
    }

    public StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    public StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }
}

