/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.annotation.JacksonInject;
import com.privatefasterxml.jackson.annotation.JsonCreator;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.privatefasterxml.jackson.databind.introspect.VisibilityChecker;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final AccessorNamingStrategy _accessorNaming;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final boolean _useAnnotations;
    protected boolean _collected;
    protected LinkedHashMap<String, POJOPropertyBuilder> _properties;
    protected LinkedList<POJOPropertyBuilder> _creatorProperties;
    protected Map<PropertyName, PropertyName> _fieldRenameMappings;
    protected LinkedList<AnnotatedMember> _anyGetters;
    protected LinkedList<AnnotatedMember> _anyGetterField;
    protected LinkedList<AnnotatedMethod> _anySetters;
    protected LinkedList<AnnotatedMember> _anySetterField;
    protected LinkedList<AnnotatedMember> _jsonKeyAccessors;
    protected LinkedList<AnnotatedMember> _jsonValueAccessors;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;
    @Deprecated
    protected final boolean _stdBeanNaming;
    @Deprecated
    protected String _mutatorPrefix;

    public POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl, JavaType javaType, AnnotatedClass annotatedClass, AccessorNamingStrategy accessorNamingStrategy) {
        this._mutatorPrefix = "set";
        this._config = mapperConfig;
        this._forSerialization = bl;
        this._type = javaType;
        this._classDef = annotatedClass;
        if (mapperConfig.isAnnotationProcessingEnabled()) {
            this._useAnnotations = true;
            this._annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        } else {
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._useAnnotations = false;
            pOJOPropertiesCollector._annotationIntrospector = AnnotationIntrospector.nopInstance();
        }
        this._visibilityChecker = mapperConfig.getDefaultVisibilityChecker(javaType.getRawClass(), annotatedClass);
        this._accessorNaming = accessorNamingStrategy;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
    }

    @Deprecated
    public POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl, JavaType javaType, AnnotatedClass annotatedClass, String string) {
        POJOPropertiesCollector pOJOPropertiesCollector = accessorNamingStrategy;
        AccessorNamingStrategy accessorNamingStrategy = POJOPropertiesCollector._accessorNaming(mapperConfig, annotatedClass, string);
        pOJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, accessorNamingStrategy);
        pOJOPropertiesCollector._mutatorPrefix = string;
    }

    private static AccessorNamingStrategy _accessorNaming(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, String string) {
        if (string == null) {
            string = "set";
        }
        return new DefaultAccessorNamingStrategy.Provider().withSetterPrefix(string).forPOJO(mapperConfig, annotatedClass);
    }

    private PropertyName _propNameFromSimple(String string) {
        return PropertyName.construct(string, null);
    }

    private String _checkRenameByField(String string) {
        Map<PropertyName, PropertyName> map = ((POJOPropertiesCollector)this)._fieldRenameMappings;
        if (map != null && (this = map.get(((POJOPropertiesCollector)this)._propNameFromSimple(string))) != null) {
            return ((PropertyName)this).getSimpleName();
        }
        return string;
    }

    private boolean _anyIndexed(Collection<POJOPropertyBuilder> collection) {
        Iterator<POJOPropertyBuilder> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!((POJOPropertyBuilder)iterator.next()).getMetadata().hasIndex()) continue;
            return true;
        }
        return false;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        Object object = this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (object == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (object instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)object;
        }
        if (object instanceof Class) {
            if ((object = (Class)object) == PropertyNamingStrategy.class) {
                return null;
            }
            if (PropertyNamingStrategy.class.isAssignableFrom((Class<?>)object)) {
                Object object2 = this._config.getHandlerInstantiator();
                if (object2 != null) {
                    HandlerInstantiator handlerInstantiator = object2;
                    POJOPropertiesCollector pOJOPropertiesCollector = this;
                    object2 = pOJOPropertiesCollector._config;
                    if ((object2 = handlerInstantiator.namingStrategyInstance((MapperConfig<?>)object2, pOJOPropertiesCollector._classDef, (Class<?>)object)) != null) {
                        return object2;
                    }
                }
                return (PropertyNamingStrategy)ClassUtil.createInstance(object, this._config.canOverrideAccessModifiers());
            }
            throw new IllegalStateException(a.a((Class)object, new StringBuilder("AnnotationIntrospector returned Class "), "; expected Class<PropertyNamingStrategy>"));
        }
        throw new IllegalStateException("AnnotationIntrospector returned PropertyNamingStrategy definition of type " + object.getClass().getName() + "; expected type PropertyNamingStrategy or Class<PropertyNamingStrategy> instead");
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        Map<String, POJOPropertyBuilder> map = ((POJOPropertiesCollector)((Object)map)).getPropertyMap();
        return new ArrayList<BeanPropertyDefinition>(map.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._injectables;
    }

    public AnnotatedMember getJsonKeyAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        Object[] objectArray = this._jsonKeyAccessors;
        if (this._jsonKeyAccessors != null) {
            if (objectArray.size() > 1) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = this._jsonKeyAccessors.get(0);
                objectArray2[1] = this._jsonKeyAccessors.get(1);
                this.reportProblem("Multiple 'as-key' properties defined (%s vs %s)", objectArray);
            }
            return this._jsonKeyAccessors.get(0);
        }
        return null;
    }

    public AnnotatedMember getJsonValueAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        Object[] objectArray = this._jsonValueAccessors;
        if (this._jsonValueAccessors != null) {
            if (objectArray.size() > 1) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = this._jsonValueAccessors.get(0);
                objectArray2[1] = this._jsonValueAccessors.get(1);
                this.reportProblem("Multiple 'as-value' properties defined (%s vs %s)", objectArray);
            }
            return this._jsonValueAccessors.get(0);
        }
        return null;
    }

    @Deprecated
    public AnnotatedMember getAnyGetter() {
        return this.getAnyGetterMethod();
    }

    public AnnotatedMember getAnyGetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        Object[] objectArray = this._anyGetterField;
        if (this._anyGetterField != null) {
            if (objectArray.size() > 1) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = this._anyGetterField.get(0);
                objectArray2[1] = this._anyGetterField.get(1);
                this.reportProblem("Multiple 'any-getter' fields defined (%s vs %s)", objectArray);
            }
            return this._anyGetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnyGetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        Object[] objectArray = this._anyGetters;
        if (this._anyGetters != null) {
            if (objectArray.size() > 1) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = this._anyGetters.get(0);
                objectArray2[1] = this._anyGetters.get(1);
                this.reportProblem("Multiple 'any-getter' methods defined (%s vs %s)", objectArray);
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnySetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        Object[] objectArray = this._anySetterField;
        if (this._anySetterField != null) {
            if (objectArray.size() > 1) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = this._anySetterField.get(0);
                objectArray2[1] = this._anySetterField.get(1);
                this.reportProblem("Multiple 'any-setter' fields defined (%s vs %s)", objectArray);
            }
            return this._anySetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        Object[] objectArray = this._anySetters;
        if (this._anySetters != null) {
            if (objectArray.size() > 1) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = this._anySetters.get(0);
                objectArray2[1] = this._anySetters.get(1);
                this.reportProblem("Multiple 'any-setter' methods defined (%s vs %s)", objectArray);
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    public Map<String, POJOPropertyBuilder> getPropertyMap() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._properties;
    }

    @Deprecated
    public AnnotatedMethod getJsonValueMethod() {
        if ((this = ((POJOPropertiesCollector)this).getJsonValueAccessor()) instanceof AnnotatedMethod) {
            return (AnnotatedMethod)this;
        }
        return null;
    }

    @Deprecated
    public Class<?> findPOJOBuilderClass() {
        return this._annotationIntrospector.findPOJOBuilder(this._classDef);
    }

    public void collectAll() {
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap;
        POJOPropertiesCollector pOJOPropertiesCollector = this;
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap2 = linkedHashMap;
        pOJOPropertiesCollector._addFields(new LinkedHashMap<String, POJOPropertyBuilder>());
        pOJOPropertiesCollector._addMethods(linkedHashMap2);
        if (!pOJOPropertiesCollector._classDef.isNonStaticInnerClass()) {
            this._addCreators(linkedHashMap2);
        }
        this._removeUnwantedProperties(linkedHashMap2);
        this._removeUnwantedAccessor(linkedHashMap2);
        this._renameProperties(linkedHashMap2);
        this._addInjectables(linkedHashMap2);
        Object object = linkedHashMap2.values().iterator();
        while (object.hasNext()) {
            object.next().mergeAnnotations(this._forSerialization);
        }
        object = this._findNamingStrategy();
        if (object != null) {
            this._renameUsing(linkedHashMap2, (PropertyNamingStrategy)object);
        }
        object = linkedHashMap2.values().iterator();
        while (object.hasNext()) {
            object.next().trimByVisibility();
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers(linkedHashMap2);
        }
        this._sortProperties(linkedHashMap2);
        this._properties = linkedHashMap2;
        this._collected = true;
    }

    public void _addFields(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        boolean bl2 = this._config.isEnabled(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        Iterator<AnnotatedField> iterator = this._classDef.fields().iterator();
        while (iterator.hasNext()) {
            Serializable serializable = Boolean.TRUE;
            AnnotatedField annotatedField = iterator.next();
            if (((Boolean)serializable).equals(annotationIntrospector.hasAsKey(this._config, annotatedField))) {
                if (this._jsonKeyAccessors == null) {
                    LinkedList linkedList;
                    LinkedList linkedList2 = linkedList;
                    linkedList = new LinkedList();
                    this._jsonKeyAccessors = linkedList2;
                }
                this._jsonKeyAccessors.add(annotatedField);
            }
            if (((Boolean)serializable).equals(annotationIntrospector.hasAsValue(annotatedField))) {
                if (this._jsonValueAccessors == null) {
                    LinkedList linkedList;
                    serializable = linkedList;
                    linkedList = new LinkedList();
                    this._jsonValueAccessors = serializable;
                }
                this._jsonValueAccessors.add(annotatedField);
                continue;
            }
            boolean bl3 = ((Boolean)serializable).equals(annotationIntrospector.hasAnyGetter(annotatedField));
            boolean bl4 = ((Boolean)serializable).equals(annotationIntrospector.hasAnySetter(annotatedField));
            if (!bl3 && !bl4) {
                boolean bl5;
                boolean bl6;
                String string = annotationIntrospector.findImplicitPropertyName(annotatedField);
                if (string == null) {
                    string = annotatedField.getName();
                }
                if ((string = this._accessorNaming.modifyFieldName(annotatedField, string)) == null) continue;
                PropertyName propertyName = this._propNameFromSimple(string);
                PropertyName propertyName2 = annotationIntrospector.findRenameByField(this._config, annotatedField, propertyName);
                if (propertyName2 != null && !propertyName2.equals(propertyName)) {
                    if (this._fieldRenameMappings == null) {
                        HashMap<PropertyName, PropertyName> hashMap;
                        HashMap<PropertyName, PropertyName> hashMap2 = hashMap;
                        hashMap = new HashMap<PropertyName, PropertyName>();
                        this._fieldRenameMappings = hashMap2;
                    }
                    this._fieldRenameMappings.put(propertyName2, propertyName);
                }
                if ((bl6 = (propertyName = this._forSerialization ? annotationIntrospector.findNameForSerialization(annotatedField) : annotationIntrospector.findNameForDeserialization(annotatedField)) != null) && propertyName.isEmpty()) {
                    propertyName = this._propNameFromSimple(string);
                    bl5 = false;
                } else {
                    bl5 = bl6;
                }
                boolean bl7 = propertyName != null;
                if (!bl7) {
                    bl7 = this._visibilityChecker.isFieldVisible(annotatedField);
                }
                boolean bl8 = annotationIntrospector.hasIgnoreMarker(annotatedField);
                if (annotatedField.isTransient() && !bl6) {
                    bl7 = false;
                    if (bl2) {
                        bl8 = true;
                    }
                }
                if (bl && propertyName == null && !bl8 && Modifier.isFinal(annotatedField.getModifiers())) continue;
                this._property(map, string).addField(annotatedField, propertyName, bl5, bl7, bl8);
                continue;
            }
            if (bl3) {
                if (this._anyGetterField == null) {
                    LinkedList linkedList;
                    LinkedList linkedList3 = linkedList;
                    linkedList = new LinkedList();
                    this._anyGetterField = linkedList3;
                }
                this._anyGetterField.add(annotatedField);
            }
            if (!bl4) continue;
            if (this._anySetterField == null) {
                LinkedList linkedList;
                LinkedList linkedList4 = linkedList;
                linkedList = new LinkedList();
                this._anySetterField = linkedList4;
            }
            this._anySetterField.add(annotatedField);
        }
    }

    public void _addCreators(Map<String, POJOPropertyBuilder> map) {
        int linkedList3;
        int n2;
        if (!this._useAnnotations) {
            return;
        }
        for (AnnotatedConstructor annotatedWithParams : this._classDef.getConstructors()) {
            if (this._creatorProperties == null) {
                LinkedList linkedList;
                LinkedList linkedList2 = linkedList;
                linkedList = new LinkedList();
                this._creatorProperties = linkedList2;
            }
            n2 = annotatedWithParams.getParameterCount();
            for (linkedList3 = 0; linkedList3 < n2; ++linkedList3) {
                this._addCreatorParam(map, annotatedWithParams.getParameter(linkedList3));
            }
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.getFactoryMethods()) {
            if (this._creatorProperties == null) {
                LinkedList linkedList;
                LinkedList linkedList4 = linkedList;
                linkedList = new LinkedList();
                this._creatorProperties = linkedList4;
            }
            n2 = annotatedMethod.getParameterCount();
            for (linkedList3 = 0; linkedList3 < n2; ++linkedList3) {
                this._addCreatorParam(map, annotatedMethod.getParameter(linkedList3));
            }
        }
    }

    public void _addCreatorParam(Map<String, POJOPropertyBuilder> object, AnnotatedParameter annotatedParameter) {
        Object object2;
        boolean bl;
        String string = this._annotationIntrospector.findImplicitPropertyName(annotatedParameter);
        if (string == null) {
            string = "";
        }
        if (!(bl = (object2 = this._annotationIntrospector.findNameForDeserialization(annotatedParameter)) != null && !object2.isEmpty())) {
            if (string.isEmpty()) {
                return;
            }
            object2 = this._config;
            if ((object2 = this._annotationIntrospector.findCreatorAnnotation((MapperConfig<?>)object2, annotatedParameter.getOwner())) != null && object2 != JsonCreator.Mode.DISABLED) {
                object2 = PropertyName.construct(string);
            } else {
                return;
            }
        }
        string = this._checkRenameByField(string);
        object = bl && string.isEmpty() ? this._property((Map<String, POJOPropertyBuilder>)object, (PropertyName)object2) : this._property((Map<String, POJOPropertyBuilder>)object, string);
        ((POJOPropertyBuilder)object).addCtor(annotatedParameter, (PropertyName)object2, bl, true, false);
        this._creatorProperties.add((POJOPropertyBuilder)object);
    }

    public void _addMethods(Map<String, POJOPropertyBuilder> map) {
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n2 = annotatedMethod.getParameterCount();
            if (n2 == 0) {
                POJOPropertiesCollector pOJOPropertiesCollector = this;
                AnnotationIntrospector annotationIntrospector = pOJOPropertiesCollector._annotationIntrospector;
                pOJOPropertiesCollector._addGetterMethod(map, annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n2 == 1) {
                POJOPropertiesCollector pOJOPropertiesCollector = this;
                AnnotationIntrospector annotationIntrospector = pOJOPropertiesCollector._annotationIntrospector;
                pOJOPropertiesCollector._addSetterMethod(map, annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n2 != 2 || !Boolean.TRUE.equals(this._annotationIntrospector.hasAnySetter(annotatedMethod))) continue;
            if (this._anySetters == null) {
                LinkedList linkedList;
                LinkedList linkedList2 = linkedList;
                linkedList = new LinkedList();
                this._anySetters = linkedList2;
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    public void _addGetterMethod(Map<String, POJOPropertyBuilder> object, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        Serializable serializable = annotatedMethod.getRawReturnType();
        if (serializable != Void.TYPE && (serializable != Void.class || ((POJOPropertiesCollector)((Object)string2))._config.isEnabled(MapperFeature.ALLOW_VOID_VALUED_PROPERTIES))) {
            boolean bl;
            String string;
            serializable = Boolean.TRUE;
            if (((Boolean)serializable).equals(annotationIntrospector.hasAnyGetter(annotatedMethod))) {
                if (((POJOPropertiesCollector)((Object)string2))._anyGetters == null) {
                    LinkedList linkedList;
                    object = linkedList;
                    linkedList = new LinkedList();
                    ((POJOPropertiesCollector)((Object)string2))._anyGetters = object;
                }
                ((POJOPropertiesCollector)((Object)string2))._anyGetters.add(annotatedMethod);
                return;
            }
            if (((Boolean)serializable).equals(annotationIntrospector.hasAsKey(((POJOPropertiesCollector)((Object)string2))._config, annotatedMethod))) {
                if (((POJOPropertiesCollector)((Object)string2))._jsonKeyAccessors == null) {
                    LinkedList linkedList;
                    object = linkedList;
                    linkedList = new LinkedList();
                    ((POJOPropertiesCollector)((Object)string2))._jsonKeyAccessors = object;
                }
                ((POJOPropertiesCollector)((Object)string2))._jsonKeyAccessors.add(annotatedMethod);
                return;
            }
            if (((Boolean)serializable).equals(annotationIntrospector.hasAsValue(annotatedMethod))) {
                if (((POJOPropertiesCollector)((Object)string2))._jsonValueAccessors == null) {
                    LinkedList linkedList;
                    object = linkedList;
                    linkedList = new LinkedList();
                    ((POJOPropertiesCollector)((Object)string2))._jsonValueAccessors = object;
                }
                ((POJOPropertiesCollector)((Object)string2))._jsonValueAccessors.add(annotatedMethod);
                return;
            }
            serializable = annotationIntrospector.findNameForSerialization(annotatedMethod);
            boolean bl2 = serializable != null;
            if (!bl2) {
                string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
                if (string == null) {
                    string = ((POJOPropertiesCollector)((Object)string2))._accessorNaming.findNameForRegularGetter(annotatedMethod, annotatedMethod.getName());
                }
                if (string == null) {
                    string = ((POJOPropertiesCollector)((Object)string2))._accessorNaming.findNameForIsGetter(annotatedMethod, annotatedMethod.getName());
                    if (string == null) {
                        return;
                    }
                    bl = ((POJOPropertiesCollector)((Object)string2))._visibilityChecker.isIsGetterVisible(annotatedMethod);
                } else {
                    bl = ((POJOPropertiesCollector)((Object)string2))._visibilityChecker.isGetterVisible(annotatedMethod);
                }
            } else {
                string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
                if (string == null && (string = ((POJOPropertiesCollector)((Object)string2))._accessorNaming.findNameForRegularGetter(annotatedMethod, annotatedMethod.getName())) == null) {
                    string = ((POJOPropertiesCollector)((Object)string2))._accessorNaming.findNameForIsGetter(annotatedMethod, annotatedMethod.getName());
                }
                if (string == null) {
                    string = annotatedMethod.getName();
                }
                if (((PropertyName)serializable).isEmpty()) {
                    serializable = ((POJOPropertiesCollector)((Object)string2))._propNameFromSimple(string);
                    bl2 = false;
                }
                bl = true;
            }
            POJOPropertiesCollector pOJOPropertiesCollector = string2;
            String string2 = ((POJOPropertiesCollector)((Object)string2))._checkRenameByField(string);
            boolean bl3 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
            pOJOPropertiesCollector._property((Map<String, POJOPropertyBuilder>)object, string2).addGetter(annotatedMethod, (PropertyName)serializable, bl2, bl, bl3);
            return;
        }
    }

    public void _addSetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl;
        String string;
        PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedMethod);
        boolean bl2 = propertyName != null;
        if (!bl2) {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                AnnotatedMethod annotatedMethod2 = annotatedMethod;
                string = ((POJOPropertiesCollector)((Object)string2))._accessorNaming.findNameForMutator(annotatedMethod2, annotatedMethod2.getName());
            }
            if (string == null) {
                return;
            }
            bl = ((POJOPropertiesCollector)((Object)string2))._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                AnnotatedMethod annotatedMethod3 = annotatedMethod;
                string = ((POJOPropertiesCollector)((Object)string2))._accessorNaming.findNameForMutator(annotatedMethod3, annotatedMethod3.getName());
            }
            if (string == null) {
                string = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = ((POJOPropertiesCollector)((Object)string2))._propNameFromSimple(string);
                bl2 = false;
            }
            bl = true;
        }
        POJOPropertiesCollector pOJOPropertiesCollector = string2;
        String string2 = ((POJOPropertiesCollector)((Object)string2))._checkRenameByField(string);
        boolean bl3 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        pOJOPropertiesCollector._property(map, string2).addSetter(annotatedMethod, propertyName, bl2, bl, bl3);
    }

    public void _addInjectables(Map<String, POJOPropertyBuilder> iterator) {
        iterator = this._classDef.fields().iterator();
        while (iterator.hasNext()) {
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            AnnotatedField annotatedMember = (AnnotatedField)iterator.next();
            pOJOPropertiesCollector._doAddInjectable(pOJOPropertiesCollector._annotationIntrospector.findInjectableValue(annotatedMember), annotatedMember);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (annotatedMethod.getParameterCount() != 1) continue;
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._doAddInjectable(pOJOPropertiesCollector._annotationIntrospector.findInjectableValue(annotatedMethod), annotatedMethod);
        }
    }

    public void _doAddInjectable(JacksonInject.Value object, AnnotatedMember annotatedMember) {
        if (object == null) {
            return;
        }
        object = ((JacksonInject.Value)object).getId();
        if (((POJOPropertiesCollector)object2)._injectables == null) {
            LinkedHashMap linkedHashMap;
            LinkedHashMap linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            ((POJOPropertiesCollector)object2)._injectables = linkedHashMap2;
        }
        if ((object2 = ((AbstractMap)((POJOPropertiesCollector)object2)._injectables).put(object, annotatedMember)) != null && object2.getClass() == annotatedMember.getClass()) {
            Object object2 = object.getClass().getName();
            throw new IllegalArgumentException("Duplicate injectable value with id '" + object + "' (of type " + (String)object2 + ")");
        }
    }

    public void _removeUnwantedProperties(Map<String, POJOPropertyBuilder> object) {
        object = object.values().iterator();
        while (object.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)object.next();
            if (!pOJOPropertyBuilder.anyVisible()) {
                object.remove();
                continue;
            }
            if (!pOJOPropertyBuilder.anyIgnorals()) continue;
            if (!pOJOPropertyBuilder.anyExplicitsWithoutIgnoral()) {
                object.remove();
                this._collectIgnorals(pOJOPropertyBuilder.getName());
                continue;
            }
            POJOPropertyBuilder pOJOPropertyBuilder2 = pOJOPropertyBuilder;
            pOJOPropertyBuilder2.removeIgnored();
            if (pOJOPropertyBuilder2.couldDeserialize()) continue;
            this._collectIgnorals(pOJOPropertyBuilder.getName());
        }
    }

    public void _removeUnwantedAccessor(Map<String, POJOPropertyBuilder> map) {
        boolean bl = this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
            POJOPropertiesCollector pOJOPropertiesCollector = this._forSerialization ? null : this;
            pOJOPropertyBuilder.removeNonVisible(bl, pOJOPropertiesCollector);
        }
    }

    public void _collectIgnorals(String string) {
        if (!this._forSerialization && string != null) {
            if (this._ignoredPropertyNames == null) {
                HashSet hashSet;
                HashSet hashSet2 = hashSet;
                hashSet = new HashSet();
                this._ignoredPropertyNames = hashSet2;
            }
            this._ignoredPropertyNames.add(string);
        }
    }

    public void _renameProperties(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        Object object3 = null;
        while (iterator.hasNext()) {
            object2 = iterator.next().getValue();
            object = ((POJOPropertyBuilder)object2).findExplicitNames();
            if (object.isEmpty()) continue;
            iterator.remove();
            if (object3 == null) {
                LinkedList linkedList;
                object3 = linkedList;
                linkedList = new LinkedList();
            }
            if (object.size() == 1) {
                ((LinkedList)object3).add(((POJOPropertyBuilder)object2).withName((PropertyName)object.iterator().next()));
                continue;
            }
            ((LinkedList)object3).addAll(((POJOPropertyBuilder)object2).explode((Collection<PropertyName>)object));
        }
        if (object3 != null) {
            iterator = ((AbstractCollection)object3).iterator();
            while (iterator.hasNext()) {
                object3 = (POJOPropertyBuilder)((Object)iterator.next());
                object2 = ((POJOPropertyBuilder)object3).getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, (POJOPropertyBuilder)object3);
                } else {
                    ((POJOPropertyBuilder)object).addAll((POJOPropertyBuilder)object3);
                }
                if (!this._replaceCreatorProperty((POJOPropertyBuilder)object3, this._creatorProperties) || (object3 = this._ignoredPropertyNames) == null) continue;
                ((HashSet)object3).remove(object2);
            }
        }
    }

    public void _renameUsing(Map<String, POJOPropertyBuilder> map, PropertyNamingStrategy propertyNamingStrategy) {
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = map.values().toArray(new POJOPropertyBuilder[map.size()]);
        map.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            Object object = pOJOPropertyBuilder.getFullName();
            Object object2 = null;
            if (!pOJOPropertyBuilder.isExplicitlyNamed() || this._config.isEnabled(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING)) {
                String string;
                AnnotatedMember annotatedMember;
                if (this._forSerialization) {
                    if (pOJOPropertyBuilder.hasGetter()) {
                        object2 = this._config;
                        annotatedMember = pOJOPropertyBuilder.getGetter();
                        string = ((PropertyName)object).getSimpleName();
                        object2 = propertyNamingStrategy.nameForGetterMethod((MapperConfig<?>)object2, (AnnotatedMethod)annotatedMember, string);
                    } else if (pOJOPropertyBuilder.hasField()) {
                        object2 = this._config;
                        annotatedMember = pOJOPropertyBuilder.getField();
                        string = ((PropertyName)object).getSimpleName();
                        object2 = propertyNamingStrategy.nameForField((MapperConfig<?>)object2, (AnnotatedField)annotatedMember, string);
                    }
                } else if (pOJOPropertyBuilder.hasSetter()) {
                    object2 = this._config;
                    annotatedMember = pOJOPropertyBuilder.getSetterUnchecked();
                    string = ((PropertyName)object).getSimpleName();
                    object2 = propertyNamingStrategy.nameForSetterMethod((MapperConfig<?>)object2, (AnnotatedMethod)annotatedMember, string);
                } else if (pOJOPropertyBuilder.hasConstructorParameter()) {
                    object2 = this._config;
                    annotatedMember = pOJOPropertyBuilder.getConstructorParameter();
                    string = ((PropertyName)object).getSimpleName();
                    object2 = propertyNamingStrategy.nameForConstructorParameter((MapperConfig<?>)object2, (AnnotatedParameter)annotatedMember, string);
                } else if (pOJOPropertyBuilder.hasField()) {
                    object2 = this._config;
                    annotatedMember = pOJOPropertyBuilder.getFieldUnchecked();
                    string = ((PropertyName)object).getSimpleName();
                    object2 = propertyNamingStrategy.nameForField((MapperConfig<?>)object2, (AnnotatedField)annotatedMember, string);
                } else if (pOJOPropertyBuilder.hasGetter()) {
                    object2 = this._config;
                    annotatedMember = pOJOPropertyBuilder.getGetterUnchecked();
                    string = ((PropertyName)object).getSimpleName();
                    object2 = propertyNamingStrategy.nameForGetterMethod((MapperConfig<?>)object2, (AnnotatedMethod)annotatedMember, string);
                }
            }
            if (object2 != null && !((PropertyName)object).hasSimpleName((String)object2)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName((String)object2);
            } else {
                object2 = ((PropertyName)object).getSimpleName();
            }
            object = map.get(object2);
            if (object == null) {
                map.put((String)object2, pOJOPropertyBuilder);
            } else {
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._replaceCreatorProperty(pOJOPropertyBuilder, pOJOPropertiesCollector._creatorProperties);
        }
    }

    public void _renameWithWrappers(Map<String, POJOPropertyBuilder> map) {
        POJOPropertyBuilder pOJOPropertyBuilder;
        Object object = map.entrySet().iterator();
        Object object2 = null;
        while (object.hasNext()) {
            pOJOPropertyBuilder = object.next().getValue();
            Serializable serializable = pOJOPropertyBuilder.getPrimaryMember();
            if (serializable == null || (serializable = ((POJOPropertiesCollector)((Object)iterator))._annotationIntrospector.findWrapperName((Annotated)((Object)serializable))) == null || !((PropertyName)serializable).hasSimpleName() || ((PropertyName)serializable).equals(pOJOPropertyBuilder.getFullName())) continue;
            if (object2 == null) {
                LinkedList linkedList;
                object2 = linkedList;
                linkedList = new LinkedList();
            }
            ((LinkedList)object2).add(pOJOPropertyBuilder.withName((PropertyName)serializable));
            object.remove();
        }
        if (object2 != null) {
            Iterator iterator = ((AbstractCollection)object2).iterator();
            while (iterator.hasNext()) {
                object = (POJOPropertyBuilder)iterator.next();
                object2 = ((POJOPropertyBuilder)object).getName();
                pOJOPropertyBuilder = map.get(object2);
                if (pOJOPropertyBuilder == null) {
                    map.put((String)object2, (POJOPropertyBuilder)object);
                    continue;
                }
                pOJOPropertyBuilder.addAll((POJOPropertyBuilder)object);
            }
        }
    }

    public void _sortProperties(Map<String, POJOPropertyBuilder> map) {
        LinkedHashMap linkedHashMap;
        AbstractMap abstractMap;
        AnnotationIntrospector annotationIntrospector = ((POJOPropertiesCollector)((Object)iterator))._annotationIntrospector;
        Boolean bl = annotationIntrospector.findSerializationSortAlphabetically(((POJOPropertiesCollector)((Object)iterator))._classDef);
        boolean bl2 = bl == null ? ((POJOPropertiesCollector)((Object)iterator))._config.shouldSortPropertiesAlphabetically() : bl.booleanValue();
        POJOPropertiesCollector pOJOPropertiesCollector = iterator;
        boolean bl3 = pOJOPropertiesCollector._anyIndexed(map.values());
        Object object2 = annotationIntrospector.findSerializationPropertyOrder(pOJOPropertiesCollector._classDef);
        if (!bl2 && !bl3 && ((POJOPropertiesCollector)((Object)iterator))._creatorProperties == null && object2 == null) {
            return;
        }
        int n2 = map.size();
        if (bl2) {
            TreeMap treeMap;
            abstractMap = treeMap;
            treeMap = new TreeMap();
        } else {
            LinkedHashMap linkedHashMap2;
            abstractMap = linkedHashMap2;
            int n3 = n2;
            linkedHashMap2 = new LinkedHashMap(n3 + n3);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
            abstractMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
        }
        LinkedHashMap linkedHashMap3 = linkedHashMap;
        int n4 = n2;
        linkedHashMap = new LinkedHashMap(n4 + n4);
        if (object2 != null) {
            for (String string : object2) {
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)abstractMap.remove(string);
                if (pOJOPropertyBuilder == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : map.values()) {
                        if (!string.equals(pOJOPropertyBuilder2.getInternalName())) continue;
                        string = pOJOPropertyBuilder2.getName();
                        pOJOPropertyBuilder = pOJOPropertyBuilder2;
                        break;
                    }
                }
                if (pOJOPropertyBuilder == null) continue;
                linkedHashMap3.put(string, pOJOPropertyBuilder);
            }
        }
        if (bl3) {
            TreeMap treeMap;
            TreeMap treeMap2 = treeMap;
            treeMap = new TreeMap();
            object2 = abstractMap.entrySet().iterator();
            while (object2.hasNext()) {
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)((Map.Entry)object2.next()).getValue();
                Integer n5 = pOJOPropertyBuilder.getMetadata().getIndex();
                if (n5 == null) continue;
                treeMap2.put(n5, pOJOPropertyBuilder);
                object2.remove();
            }
            for (Object object2 : treeMap2.values()) {
                linkedHashMap3.put(((POJOPropertyBuilder)object2).getName(), object2);
            }
        }
        if (((POJOPropertiesCollector)((Object)iterator))._creatorProperties != null && (!bl2 || ((POJOPropertiesCollector)((Object)iterator))._config.isEnabled(MapperFeature.SORT_CREATOR_PROPERTIES_FIRST))) {
            Collection<POJOPropertyBuilder> collection;
            if (bl2) {
                TreeMap treeMap;
                POJOPropertiesCollector pOJOPropertiesCollector2 = iterator;
                Iterator iterator = treeMap;
                treeMap = new TreeMap();
                for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertiesCollector2._creatorProperties) {
                    ((TreeMap)((Object)iterator)).put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
                }
                collection = ((TreeMap)((Object)iterator)).values();
            } else {
                collection = ((POJOPropertiesCollector)((Object)iterator))._creatorProperties;
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : collection) {
                String string = pOJOPropertyBuilder.getName();
                if (!abstractMap.containsKey(string)) continue;
                linkedHashMap3.put(string, pOJOPropertyBuilder);
            }
        }
        Map<String, POJOPropertyBuilder> map2 = map;
        linkedHashMap3.putAll(abstractMap);
        map2.clear();
        map2.putAll(linkedHashMap3);
    }

    public void reportProblem(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string);
    }

    public POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> object, PropertyName propertyName) {
        String string = propertyName.getSimpleName();
        POJOPropertyBuilder pOJOPropertyBuilder = object.get(string);
        if (pOJOPropertyBuilder == null) {
            POJOPropertyBuilder pOJOPropertyBuilder2;
            Map<String, POJOPropertyBuilder> map = object;
            pOJOPropertyBuilder = pOJOPropertyBuilder2;
            POJOPropertiesCollector pOJOPropertiesCollector = mapperConfig;
            MapperConfig<?> mapperConfig = pOJOPropertiesCollector._config;
            object = pOJOPropertiesCollector._annotationIntrospector;
            boolean bl = pOJOPropertiesCollector._forSerialization;
            pOJOPropertyBuilder2 = new POJOPropertyBuilder(mapperConfig, (AnnotationIntrospector)object, bl, propertyName);
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    public POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> object, String string) {
        POJOPropertyBuilder pOJOPropertyBuilder = object.get(string);
        if (pOJOPropertyBuilder == null) {
            POJOPropertyBuilder pOJOPropertyBuilder2;
            Map<String, POJOPropertyBuilder> map = object;
            pOJOPropertyBuilder = pOJOPropertyBuilder2;
            POJOPropertiesCollector pOJOPropertiesCollector = mapperConfig;
            MapperConfig<?> mapperConfig = pOJOPropertiesCollector._config;
            object = pOJOPropertiesCollector._annotationIntrospector;
            boolean bl = pOJOPropertiesCollector._forSerialization;
            PropertyName propertyName = PropertyName.construct(string);
            pOJOPropertyBuilder2 = new POJOPropertyBuilder(mapperConfig, (AnnotationIntrospector)object, bl, propertyName);
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    @Deprecated
    public void _updateCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        this._replaceCreatorProperty(pOJOPropertyBuilder, list);
    }

    public boolean _replaceCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        if (list != null) {
            String string = pOJOPropertyBuilder.getInternalName();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!list.get(i2).getInternalName().equals(string)) continue;
                list.set(i2, pOJOPropertyBuilder);
                return true;
            }
        }
        return false;
    }
}

