/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.introspect;

import com.privatefasterxml.jackson.annotation.JsonAutoDetect;
import com.privatefasterxml.jackson.annotation.PropertyAccessor;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.u;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public interface VisibilityChecker<T extends VisibilityChecker<T>> {
    public T with(JsonAutoDetect var1);

    public T withOverrides(JsonAutoDetect.Value var1);

    public T with(JsonAutoDetect.Visibility var1);

    public T withVisibility(PropertyAccessor var1, JsonAutoDetect.Visibility var2);

    public T withGetterVisibility(JsonAutoDetect.Visibility var1);

    public T withIsGetterVisibility(JsonAutoDetect.Visibility var1);

    public T withSetterVisibility(JsonAutoDetect.Visibility var1);

    public T withCreatorVisibility(JsonAutoDetect.Visibility var1);

    public T withFieldVisibility(JsonAutoDetect.Visibility var1);

    public boolean isGetterVisible(Method var1);

    public boolean isGetterVisible(AnnotatedMethod var1);

    public boolean isIsGetterVisible(Method var1);

    public boolean isIsGetterVisible(AnnotatedMethod var1);

    public boolean isSetterVisible(Method var1);

    public boolean isSetterVisible(AnnotatedMethod var1);

    public boolean isCreatorVisible(Member var1);

    public boolean isCreatorVisible(AnnotatedMember var1);

    public boolean isFieldVisible(Field var1);

    public boolean isFieldVisible(AnnotatedField var1);

    public static class Std
    implements VisibilityChecker<Std>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Std DEFAULT;
        protected static final Std ALL_PUBLIC;
        protected final JsonAutoDetect.Visibility _getterMinLevel;
        protected final JsonAutoDetect.Visibility _isGetterMinLevel;
        protected final JsonAutoDetect.Visibility _setterMinLevel;
        protected final JsonAutoDetect.Visibility _creatorMinLevel;
        protected final JsonAutoDetect.Visibility _fieldMinLevel;

        public static Std defaultInstance() {
            return DEFAULT;
        }

        public static Std allPublicInstance() {
            return ALL_PUBLIC;
        }

        public Std(JsonAutoDetect jsonAutoDetect) {
            this._getterMinLevel = jsonAutoDetect.getterVisibility();
            this._isGetterMinLevel = jsonAutoDetect.isGetterVisibility();
            this._setterMinLevel = jsonAutoDetect.setterVisibility();
            this._creatorMinLevel = jsonAutoDetect.creatorVisibility();
            this._fieldMinLevel = jsonAutoDetect.fieldVisibility();
        }

        public Std(JsonAutoDetect.Visibility visibility, JsonAutoDetect.Visibility visibility2, JsonAutoDetect.Visibility visibility3, JsonAutoDetect.Visibility visibility4, JsonAutoDetect.Visibility visibility5) {
            this._getterMinLevel = visibility;
            this._isGetterMinLevel = visibility2;
            this._setterMinLevel = visibility3;
            this._creatorMinLevel = visibility4;
            this._fieldMinLevel = visibility5;
        }

        public Std(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                Std std = std2;
                Std std2 = DEFAULT;
                std._getterMinLevel = std2._getterMinLevel;
                std._isGetterMinLevel = std2._isGetterMinLevel;
                std._setterMinLevel = std2._setterMinLevel;
                std._creatorMinLevel = std2._creatorMinLevel;
                std._fieldMinLevel = std2._fieldMinLevel;
            } else {
                Std std = std2;
                std._getterMinLevel = visibility;
                std._isGetterMinLevel = visibility;
                std._setterMinLevel = visibility;
                std._creatorMinLevel = visibility;
                std._fieldMinLevel = visibility;
            }
        }

        public static Std construct(JsonAutoDetect.Value value) {
            return DEFAULT.withOverrides(value);
        }

        private JsonAutoDetect.Visibility _defaultOrOverride(JsonAutoDetect.Visibility visibility, JsonAutoDetect.Visibility visibility2) {
            if (visibility2 == JsonAutoDetect.Visibility.DEFAULT) {
                return visibility;
            }
            return visibility2;
        }

        static {
            JsonAutoDetect.Visibility visibility = JsonAutoDetect.Visibility.PUBLIC_ONLY;
            JsonAutoDetect.Visibility visibility2 = JsonAutoDetect.Visibility.ANY;
            JsonAutoDetect.Visibility visibility3 = visibility;
            JsonAutoDetect.Visibility visibility4 = visibility2;
            DEFAULT = new Std(visibility3, visibility3, visibility4, visibility4, visibility);
            JsonAutoDetect.Visibility visibility5 = visibility;
            ALL_PUBLIC = new Std(visibility5, visibility5, visibility5, visibility5, visibility5);
        }

        public Std _with(JsonAutoDetect.Visibility visibility, JsonAutoDetect.Visibility visibility2, JsonAutoDetect.Visibility visibility3, JsonAutoDetect.Visibility visibility4, JsonAutoDetect.Visibility visibility5) {
            if (visibility == this._getterMinLevel && visibility2 == this._isGetterMinLevel && visibility3 == this._setterMinLevel && visibility4 == this._creatorMinLevel && visibility5 == this._fieldMinLevel) {
                return this;
            }
            return new Std(visibility, visibility2, visibility3, visibility4, visibility5);
        }

        @Override
        public Std with(JsonAutoDetect object) {
            if (object != null) {
                Std std = object2;
                JsonAutoDetect jsonAutoDetect = object;
                Std std2 = object2;
                JsonAutoDetect jsonAutoDetect2 = object;
                Std std3 = object2;
                JsonAutoDetect jsonAutoDetect3 = object;
                Std std4 = object2;
                JsonAutoDetect jsonAutoDetect4 = object;
                Std std5 = object2;
                Object object2 = object2._getterMinLevel;
                object2 = std5._defaultOrOverride((JsonAutoDetect.Visibility)((Object)object2), object.getterVisibility());
                object = std5._isGetterMinLevel;
                object = std4._defaultOrOverride((JsonAutoDetect.Visibility)((Object)object), jsonAutoDetect4.isGetterVisibility());
                JsonAutoDetect.Visibility visibility = std4._setterMinLevel;
                visibility = std3._defaultOrOverride(visibility, jsonAutoDetect3.setterVisibility());
                JsonAutoDetect.Visibility visibility2 = std3._creatorMinLevel;
                visibility2 = std2._defaultOrOverride(visibility2, jsonAutoDetect2.creatorVisibility());
                JsonAutoDetect.Visibility visibility3 = std2._fieldMinLevel;
                visibility3 = std._defaultOrOverride(visibility3, jsonAutoDetect.fieldVisibility());
                return std._with((JsonAutoDetect.Visibility)((Object)object2), (JsonAutoDetect.Visibility)((Object)object), visibility, visibility2, visibility3);
            }
            return object2;
        }

        @Override
        public Std withOverrides(JsonAutoDetect.Value object) {
            if (object != null) {
                Std std = object2;
                JsonAutoDetect.Value value = object;
                Std std2 = object2;
                JsonAutoDetect.Value value2 = object;
                Std std3 = object2;
                JsonAutoDetect.Value value3 = object;
                Std std4 = object2;
                JsonAutoDetect.Value value4 = object;
                Std std5 = object2;
                Object object2 = object2._getterMinLevel;
                object2 = std5._defaultOrOverride((JsonAutoDetect.Visibility)((Object)object2), object.getGetterVisibility());
                object = std5._isGetterMinLevel;
                object = std4._defaultOrOverride((JsonAutoDetect.Visibility)((Object)object), value4.getIsGetterVisibility());
                JsonAutoDetect.Visibility visibility = std4._setterMinLevel;
                visibility = std3._defaultOrOverride(visibility, value3.getSetterVisibility());
                JsonAutoDetect.Visibility visibility2 = std3._creatorMinLevel;
                visibility2 = std2._defaultOrOverride(visibility2, value2.getCreatorVisibility());
                JsonAutoDetect.Visibility visibility3 = std2._fieldMinLevel;
                visibility3 = std._defaultOrOverride(visibility3, value.getFieldVisibility());
                return std._with((JsonAutoDetect.Visibility)((Object)object2), (JsonAutoDetect.Visibility)((Object)object), visibility, visibility2, visibility3);
            }
            return object2;
        }

        @Override
        public Std with(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                return DEFAULT;
            }
            return new Std(visibility);
        }

        @Override
        public Std withVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
            switch (u.a[propertyAccessor.ordinal()]) {
                default: {
                    return this;
                }
                case 6: {
                    return this.with(visibility);
                }
                case 5: {
                    return this.withIsGetterVisibility(visibility);
                }
                case 4: {
                    return this.withFieldVisibility(visibility);
                }
                case 3: {
                    return this.withCreatorVisibility(visibility);
                }
                case 2: {
                    return this.withSetterVisibility(visibility);
                }
                case 1: 
            }
            return this.withGetterVisibility(visibility);
        }

        @Override
        public Std withGetterVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._getterMinLevel;
            }
            if (object._getterMinLevel == visibility) {
                return object;
            }
            Std std = object;
            Object object = std._isGetterMinLevel;
            JsonAutoDetect.Visibility visibility2 = std._setterMinLevel;
            JsonAutoDetect.Visibility visibility3 = std._creatorMinLevel;
            JsonAutoDetect.Visibility visibility4 = std._fieldMinLevel;
            return new Std(visibility, (JsonAutoDetect.Visibility)((Object)object), visibility2, visibility3, visibility4);
        }

        @Override
        public Std withIsGetterVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._isGetterMinLevel;
            }
            if (object._isGetterMinLevel == visibility) {
                return object;
            }
            Std std = object;
            Object object = std._getterMinLevel;
            JsonAutoDetect.Visibility visibility2 = std._setterMinLevel;
            JsonAutoDetect.Visibility visibility3 = std._creatorMinLevel;
            JsonAutoDetect.Visibility visibility4 = std._fieldMinLevel;
            return new Std((JsonAutoDetect.Visibility)((Object)object), visibility, visibility2, visibility3, visibility4);
        }

        @Override
        public Std withSetterVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._setterMinLevel;
            }
            if (object._setterMinLevel == visibility) {
                return object;
            }
            Std std = object;
            Object object = std._getterMinLevel;
            JsonAutoDetect.Visibility visibility2 = std._isGetterMinLevel;
            JsonAutoDetect.Visibility visibility3 = std._creatorMinLevel;
            JsonAutoDetect.Visibility visibility4 = std._fieldMinLevel;
            return new Std((JsonAutoDetect.Visibility)((Object)object), visibility2, visibility, visibility3, visibility4);
        }

        @Override
        public Std withCreatorVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._creatorMinLevel;
            }
            if (object._creatorMinLevel == visibility) {
                return object;
            }
            Std std = object;
            Object object = std._getterMinLevel;
            JsonAutoDetect.Visibility visibility2 = std._isGetterMinLevel;
            JsonAutoDetect.Visibility visibility3 = std._setterMinLevel;
            JsonAutoDetect.Visibility visibility4 = std._fieldMinLevel;
            return new Std((JsonAutoDetect.Visibility)((Object)object), visibility2, visibility3, visibility, visibility4);
        }

        @Override
        public Std withFieldVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._fieldMinLevel;
            }
            if (object._fieldMinLevel == visibility) {
                return object;
            }
            Std std = object;
            Object object = std._getterMinLevel;
            JsonAutoDetect.Visibility visibility2 = std._isGetterMinLevel;
            JsonAutoDetect.Visibility visibility3 = std._setterMinLevel;
            JsonAutoDetect.Visibility visibility4 = std._creatorMinLevel;
            return new Std((JsonAutoDetect.Visibility)((Object)object), visibility2, visibility3, visibility4, visibility);
        }

        @Override
        public boolean isCreatorVisible(Member member) {
            return this._creatorMinLevel.isVisible(member);
        }

        @Override
        public boolean isCreatorVisible(AnnotatedMember annotatedMember) {
            return this.isCreatorVisible(annotatedMember.getMember());
        }

        @Override
        public boolean isFieldVisible(Field field) {
            return this._fieldMinLevel.isVisible(field);
        }

        @Override
        public boolean isFieldVisible(AnnotatedField annotatedField) {
            return this.isFieldVisible(annotatedField.getAnnotated());
        }

        @Override
        public boolean isGetterVisible(Method method) {
            return this._getterMinLevel.isVisible(method);
        }

        @Override
        public boolean isGetterVisible(AnnotatedMethod annotatedMethod) {
            return this.isGetterVisible(annotatedMethod.getAnnotated());
        }

        @Override
        public boolean isIsGetterVisible(Method method) {
            return this._isGetterMinLevel.isVisible(method);
        }

        @Override
        public boolean isIsGetterVisible(AnnotatedMethod annotatedMethod) {
            return this.isIsGetterVisible(annotatedMethod.getAnnotated());
        }

        @Override
        public boolean isSetterVisible(Method method) {
            return this._setterMinLevel.isVisible(method);
        }

        @Override
        public boolean isSetterVisible(AnnotatedMethod annotatedMethod) {
            return this.isSetterVisible(annotatedMethod.getAnnotated());
        }

        public String toString() {
            Object[] objectArray = new Object[5];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this._getterMinLevel;
            objectArray2[1] = this._isGetterMinLevel;
            objectArray2[2] = this._setterMinLevel;
            objectArray2[3] = this._creatorMinLevel;
            objectArray[4] = this._fieldMinLevel;
            return String.format("[Visibility: getter=%s,isGetter=%s,setter=%s,creator=%s,field=%s]", objectArray2);
        }
    }
}

