/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.json;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.json.JsonReadFeature;
import com.privatefasterxml.jackson.core.json.JsonWriteFeature;
import com.privatefasterxml.jackson.databind.ObjectMapper;
import com.privatefasterxml.jackson.databind.cfg.MapperBuilder;
import com.privatefasterxml.jackson.databind.cfg.PackageVersion;

public class JsonMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public JsonMapper() {
        JsonFactory jsonFactory;
        JsonMapper jsonMapper = versioned;
        Versioned versioned = jsonFactory;
        jsonFactory = new JsonFactory();
        jsonMapper((JsonFactory)versioned);
    }

    public JsonMapper(JsonFactory jsonFactory) {
        super(jsonFactory);
    }

    public JsonMapper(JsonMapper jsonMapper) {
        super(jsonMapper);
    }

    public static Builder builder() {
        JsonMapper jsonMapper;
        JsonMapper jsonMapper2 = jsonMapper;
        jsonMapper = new JsonMapper();
        return new Builder(jsonMapper2);
    }

    public static Builder builder(JsonFactory jsonFactory) {
        JsonMapper jsonMapper;
        JsonMapper jsonMapper2 = jsonMapper;
        jsonMapper = new JsonMapper(jsonFactory);
        return new Builder(jsonMapper2);
    }

    @Override
    public JsonMapper copy() {
        this._checkInvalidCopy(JsonMapper.class);
        return new JsonMapper(this);
    }

    public Builder rebuild() {
        return new Builder(this.copy());
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    public boolean isEnabled(JsonReadFeature jsonReadFeature) {
        return this.isEnabled(jsonReadFeature.mappedFeature());
    }

    public boolean isEnabled(JsonWriteFeature jsonWriteFeature) {
        return this.isEnabled(jsonWriteFeature.mappedFeature());
    }

    public static class Builder
    extends MapperBuilder<JsonMapper, Builder> {
        public Builder(JsonMapper jsonMapper) {
            super(jsonMapper);
        }

        public Builder enable(JsonReadFeature ... jsonReadFeatureArray) {
            for (JsonReadFeature jsonReadFeature : jsonReadFeatureArray) {
                ((JsonMapper)this._mapper).enable(jsonReadFeature.mappedFeature());
            }
            return this;
        }

        public Builder disable(JsonReadFeature ... jsonReadFeatureArray) {
            for (JsonReadFeature jsonReadFeature : jsonReadFeatureArray) {
                ((JsonMapper)this._mapper).disable(jsonReadFeature.mappedFeature());
            }
            return this;
        }

        public Builder configure(JsonReadFeature jsonReadFeature, boolean bl) {
            if (bl) {
                ((JsonMapper)this._mapper).enable(jsonReadFeature.mappedFeature());
            } else {
                ((JsonMapper)this._mapper).disable(jsonReadFeature.mappedFeature());
            }
            return this;
        }

        public Builder enable(JsonWriteFeature ... jsonWriteFeatureArray) {
            for (JsonWriteFeature jsonWriteFeature : jsonWriteFeatureArray) {
                ((JsonMapper)this._mapper).enable(jsonWriteFeature.mappedFeature());
            }
            return this;
        }

        public Builder disable(JsonWriteFeature ... jsonWriteFeatureArray) {
            for (JsonWriteFeature jsonWriteFeature : jsonWriteFeatureArray) {
                ((JsonMapper)this._mapper).disable(jsonWriteFeature.mappedFeature());
            }
            return this;
        }

        public Builder configure(JsonWriteFeature jsonWriteFeature, boolean bl) {
            if (bl) {
                ((JsonMapper)this._mapper).enable(jsonWriteFeature.mappedFeature());
            } else {
                ((JsonMapper)this._mapper).disable(jsonWriteFeature.mappedFeature());
            }
            return this;
        }
    }
}

