/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.a;
import com.privatefasterxml.jackson.databind.jsontype.b;
import com.privatefasterxml.jackson.databind.jsontype.c;
import com.privatefasterxml.jackson.databind.jsontype.d;
import com.privatefasterxml.jackson.databind.jsontype.e;
import com.privatefasterxml.jackson.databind.jsontype.f;
import com.privatefasterxml.jackson.databind.jsontype.g;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class BasicPolymorphicTypeValidator
extends PolymorphicTypeValidator.Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Set<Class<?>> _invalidBaseTypes;
    protected final TypeMatcher[] _baseTypeMatchers;
    protected final NameMatcher[] _subTypeNameMatchers;
    protected final TypeMatcher[] _subClassMatchers;

    public BasicPolymorphicTypeValidator(Set<Class<?>> set, TypeMatcher[] typeMatcherArray, NameMatcher[] nameMatcherArray, TypeMatcher[] typeMatcherArray2) {
        this._invalidBaseTypes = set;
        this._baseTypeMatchers = typeMatcherArray;
        this._subTypeNameMatchers = nameMatcherArray;
        this._subClassMatchers = typeMatcherArray2;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PolymorphicTypeValidator.Validity validateBaseType(MapperConfig<?> mapperConfig, JavaType type) {
        type = type.getRawClass();
        Set<Class<?>> set = typeMatcherArray._invalidBaseTypes;
        if (set != null && set.contains(type)) {
            return PolymorphicTypeValidator.Validity.DENIED;
        }
        TypeMatcher[] typeMatcherArray = typeMatcherArray._baseTypeMatchers;
        if (typeMatcherArray._baseTypeMatchers != null) {
            int n2 = typeMatcherArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!typeMatcherArray[i2].match(mapperConfig, (Class<?>)type)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator.Validity validateSubClassName(MapperConfig<?> mapperConfig, JavaType javaType, String string) {
        NameMatcher[] nameMatcherArray = nameMatcherArray._subTypeNameMatchers;
        if (nameMatcherArray._subTypeNameMatchers != null) {
            int n2 = nameMatcherArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!nameMatcherArray[i2].match(mapperConfig, string)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator.Validity validateSubType(MapperConfig<?> mapperConfig, JavaType typeMatcherArray, JavaType javaType) {
        if (serializable._subClassMatchers != null) {
            BasicPolymorphicTypeValidator basicPolymorphicTypeValidator = serializable;
            Serializable serializable = javaType.getRawClass();
            typeMatcherArray = basicPolymorphicTypeValidator._subClassMatchers;
            int n2 = basicPolymorphicTypeValidator._subClassMatchers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!typeMatcherArray[i2].match(mapperConfig, (Class<?>)serializable)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    public static abstract class TypeMatcher {
        public abstract boolean match(MapperConfig<?> var1, Class<?> var2);
    }

    public static abstract class NameMatcher {
        public abstract boolean match(MapperConfig<?> var1, String var2);
    }

    public static class Builder {
        protected Set<Class<?>> _invalidBaseTypes;
        protected List<TypeMatcher> _baseTypeMatchers;
        protected List<NameMatcher> _subTypeNameMatchers;
        protected List<TypeMatcher> _subTypeClassMatchers;

        public Builder allowIfBaseType(Class<?> clazz) {
            return this._appendBaseMatcher(new a(clazz));
        }

        public Builder allowIfBaseType(Pattern pattern) {
            return this._appendBaseMatcher(new b(pattern));
        }

        public Builder allowIfBaseType(String string) {
            return this._appendBaseMatcher(new c(string));
        }

        public Builder allowIfBaseType(TypeMatcher typeMatcher) {
            return this._appendBaseMatcher(typeMatcher);
        }

        public Builder denyForExactBaseType(Class<?> clazz) {
            if (this._invalidBaseTypes == null) {
                HashSet hashSet;
                HashSet hashSet2 = hashSet;
                hashSet = new HashSet();
                this._invalidBaseTypes = hashSet2;
            }
            Builder builder = this;
            builder._invalidBaseTypes.add(clazz);
            return builder;
        }

        public Builder allowIfSubType(Class<?> clazz) {
            return this._appendSubClassMatcher(new d(clazz));
        }

        public Builder allowIfSubType(Pattern pattern) {
            return this._appendSubNameMatcher(new e(pattern));
        }

        public Builder allowIfSubType(String string) {
            return this._appendSubNameMatcher(new f(string));
        }

        public Builder allowIfSubType(TypeMatcher typeMatcher) {
            return this._appendSubClassMatcher(typeMatcher);
        }

        public Builder allowIfSubTypeIsArray() {
            return this._appendSubClassMatcher(new g());
        }

        public BasicPolymorphicTypeValidator build() {
            BasicPolymorphicTypeValidator basicPolymorphicTypeValidator;
            Builder builder = object3;
            Set<Class<?>> set = builder._invalidBaseTypes;
            Object object = builder._baseTypeMatchers;
            object = builder._baseTypeMatchers == null ? null : object.toArray(new TypeMatcher[0]);
            Object object2 = object3._subTypeNameMatchers;
            object2 = object3._subTypeNameMatchers == null ? null : object2.toArray(new NameMatcher[0]);
            Object object3 = object3._subTypeClassMatchers;
            object3 = object3 == null ? null : object3.toArray(new TypeMatcher[0]);
            BasicPolymorphicTypeValidator basicPolymorphicTypeValidator2 = basicPolymorphicTypeValidator;
            basicPolymorphicTypeValidator2(set, (TypeMatcher[])object, (NameMatcher[])object2, (TypeMatcher[])object3);
            return basicPolymorphicTypeValidator2;
        }

        public Builder _appendBaseMatcher(TypeMatcher typeMatcher) {
            if (this._baseTypeMatchers == null) {
                ArrayList<TypeMatcher> arrayList;
                ArrayList<TypeMatcher> arrayList2 = arrayList;
                arrayList = new ArrayList<TypeMatcher>();
                this._baseTypeMatchers = arrayList2;
            }
            Builder builder = this;
            builder._baseTypeMatchers.add(typeMatcher);
            return builder;
        }

        public Builder _appendSubNameMatcher(NameMatcher nameMatcher) {
            if (this._subTypeNameMatchers == null) {
                ArrayList<NameMatcher> arrayList;
                ArrayList<NameMatcher> arrayList2 = arrayList;
                arrayList = new ArrayList<NameMatcher>();
                this._subTypeNameMatchers = arrayList2;
            }
            Builder builder = this;
            builder._subTypeNameMatchers.add(nameMatcher);
            return builder;
        }

        public Builder _appendSubClassMatcher(TypeMatcher typeMatcher) {
            if (this._subTypeClassMatchers == null) {
                ArrayList<TypeMatcher> arrayList;
                ArrayList<TypeMatcher> arrayList2 = arrayList;
                arrayList = new ArrayList<TypeMatcher>();
                this._subTypeClassMatchers = arrayList2;
            }
            Builder builder = this;
            builder._subTypeClassMatchers.add(typeMatcher);
            return builder;
        }
    }
}

