/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype;

import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.i;

public abstract class TypeDeserializer {
    public static Object deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType) {
        return TypeDeserializer.deserializeIfNatural(jsonParser, deserializationContext, javaType.getRawClass());
    }

    public static Object deserializeIfNatural(JsonParser jsonParser, DeserializationContext object, Class<?> clazz) {
        object = jsonParser.currentToken();
        if (object == null) {
            return null;
        }
        switch (i.a[((Enum)object).ordinal()]) {
            default: {
                break;
            }
            case 5: {
                if (!clazz.isAssignableFrom(Boolean.class)) break;
                return Boolean.FALSE;
            }
            case 4: {
                if (!clazz.isAssignableFrom(Boolean.class)) break;
                return Boolean.TRUE;
            }
            case 3: {
                if (!clazz.isAssignableFrom(Double.class)) break;
                return jsonParser.getDoubleValue();
            }
            case 2: {
                if (!clazz.isAssignableFrom(Integer.class)) break;
                return jsonParser.getIntValue();
            }
            case 1: {
                if (!clazz.isAssignableFrom(String.class)) break;
                return jsonParser.getText();
            }
        }
        return null;
    }

    public abstract TypeDeserializer forProperty(BeanProperty var1);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public abstract Class<?> getDefaultImpl();

    public boolean hasDefaultImpl() {
        return this.getDefaultImpl() != null;
    }

    public abstract Object deserializeTypedFromObject(JsonParser var1, DeserializationContext var2);

    public abstract Object deserializeTypedFromArray(JsonParser var1, DeserializationContext var2);

    public abstract Object deserializeTypedFromScalar(JsonParser var1, DeserializationContext var2);

    public abstract Object deserializeTypedFromAny(JsonParser var1, DeserializationContext var2);
}

