/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype.impl;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.TokenBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AsDeductionTypeDeserializer
extends AsPropertyTypeDeserializer {
    private static final long serialVersionUID = 1L;
    private static final BitSet EMPTY_CLASS_FINGERPRINT = new BitSet(0);
    private final Map<String, Integer> fieldBitIndex;
    private final Map<BitSet, String> subtypeFingerprints;

    public AsDeductionTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, JavaType javaType2, DeserializationConfig deserializationConfig, Collection<NamedType> collection) {
        super(javaType, typeIdResolver, null, false, javaType2, null);
        this.fieldBitIndex = new HashMap<String, Integer>();
        this.subtypeFingerprints = this.buildFingerprints(deserializationConfig, collection);
    }

    public AsDeductionTypeDeserializer(AsDeductionTypeDeserializer asDeductionTypeDeserializer, BeanProperty beanProperty) {
        super(asDeductionTypeDeserializer, beanProperty);
        this.fieldBitIndex = asDeductionTypeDeserializer.fieldBitIndex;
        this.subtypeFingerprints = asDeductionTypeDeserializer.subtypeFingerprints;
    }

    private static void prune(List<BitSet> object, int n2) {
        object = object.iterator();
        while (object.hasNext()) {
            if (((BitSet)object.next()).get(n2)) continue;
            object.remove();
        }
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        if (beanProperty != asDeductionTypeDeserializer3._property) {
            AsDeductionTypeDeserializer asDeductionTypeDeserializer;
            AsDeductionTypeDeserializer asDeductionTypeDeserializer2 = asDeductionTypeDeserializer;
            asDeductionTypeDeserializer = new AsDeductionTypeDeserializer(asDeductionTypeDeserializer3, beanProperty);
            AsDeductionTypeDeserializer asDeductionTypeDeserializer3 = asDeductionTypeDeserializer2;
        }
        return asDeductionTypeDeserializer3;
    }

    public Map<BitSet, String> buildFingerprints(DeserializationConfig deserializationConfig, Collection<NamedType> collection) {
        HashMap<BitSet, String> hashMap;
        boolean bl = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        int n2 = 0;
        HashMap<BitSet, String> hashMap2 = hashMap;
        hashMap = new HashMap<BitSet, String>();
        Iterator<NamedType> iterator = collection.iterator();
        while (iterator.hasNext()) {
            BitSet bitSet;
            DeserializationConfig deserializationConfig2 = deserializationConfig;
            NamedType namedType = iterator.next();
            Object object = deserializationConfig2.introspect(deserializationConfig2.getTypeFactory().constructType(namedType.getType())).findProperties();
            BitSet bitSet2 = bitSet;
            bitSet = new BitSet(object.size() + n2);
            object = object.iterator();
            while (object.hasNext()) {
                Integer n3;
                String string = ((BeanPropertyDefinition)object.next()).getName();
                if (bl) {
                    string = string.toLowerCase();
                }
                if ((n3 = objectArray2.fieldBitIndex.get(string)) == null) {
                    n3 = n2;
                    objectArray2.fieldBitIndex.put(string, n2++);
                }
                bitSet2.set(n3);
            }
            object = hashMap2.put(bitSet2, namedType.getType().getName());
            if (object == null) continue;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = object;
            objectArray[1] = namedType.getType().getName();
            throw new IllegalStateException(String.format("Subtypes %s and %s have the same signature and cannot be uniquely deduced.", objectArray2));
        }
        return hashMap2;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser objectArray, DeserializationContext deserializationContext) {
        Object object;
        LinkedList<BitSet> linkedList;
        Object object2;
        Object object3 = objectArray.currentToken();
        if (object3 == JsonToken.START_OBJECT) {
            object3 = objectArray.nextToken();
        } else if (object3 != JsonToken.FIELD_NAME) {
            return ((AsPropertyTypeDeserializer)object)._deserializeTypedUsingDefaultImpl((JsonParser)objectArray, deserializationContext, null, "Unexpected input");
        }
        if (object3 == JsonToken.END_OBJECT && (object2 = ((AsDeductionTypeDeserializer)object).subtypeFingerprints.get(EMPTY_CLASS_FINGERPRINT)) != null) {
            return ((AsPropertyTypeDeserializer)object)._deserializeTypedForId((JsonParser)objectArray, deserializationContext, null, (String)object2);
        }
        DeserializationContext deserializationContext2 = deserializationContext;
        object2 = linkedList;
        linkedList = new LinkedList<BitSet>(((AsDeductionTypeDeserializer)object).subtypeFingerprints.keySet());
        TokenBuffer tokenBuffer = deserializationContext2.bufferForInputBuffering((JsonParser)objectArray);
        boolean bl = deserializationContext2.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (object3 == JsonToken.FIELD_NAME) {
            object3 = objectArray.currentName();
            if (bl) {
                object3 = ((String)object3).toLowerCase();
            }
            tokenBuffer.copyCurrentStructure((JsonParser)objectArray);
            object3 = ((AsDeductionTypeDeserializer)object).fieldBitIndex.get(object3);
            if (object3 != null) {
                Object object4 = object2;
                AsDeductionTypeDeserializer.prune((List<BitSet>)object4, (Integer)object3);
                if (((LinkedList)object4).size() == 1) {
                    Object object5 = object;
                    object = ((AsDeductionTypeDeserializer)object).subtypeFingerprints.get(((LinkedList)object2).get(0));
                    return ((AsPropertyTypeDeserializer)object5)._deserializeTypedForId((JsonParser)objectArray, deserializationContext, tokenBuffer, (String)object);
                }
            }
            object3 = objectArray.nextToken();
        }
        AsDeductionTypeDeserializer asDeductionTypeDeserializer = object;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray[0] = ClassUtil.getTypeDescription(((TypeDeserializerBase)object)._baseType);
        objectArray3[1] = ((LinkedList)object2).size();
        object = String.format("Cannot deduce unique subtype of %s (%d candidates match)", objectArray);
        return asDeductionTypeDeserializer._deserializeTypedUsingDefaultImpl((JsonParser)objectArray2, deserializationContext, tokenBuffer, (String)object);
    }
}

