/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype.impl;

import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    private static final String JAVA_UTIL_PKG = "java.util.";
    protected final PolymorphicTypeValidator _subTypeValidator;

    @Deprecated
    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        ClassNameIdResolver classNameIdResolver = laissezFaireSubTypeValidator;
        LaissezFaireSubTypeValidator laissezFaireSubTypeValidator = LaissezFaireSubTypeValidator.instance;
        classNameIdResolver(javaType, typeFactory, laissezFaireSubTypeValidator);
    }

    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        super(javaType, typeFactory);
        this._subTypeValidator = polymorphicTypeValidator;
    }

    public static ClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new ClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> clazz, String string) {
    }

    @Override
    public String idFromValue(Object object) {
        ClassNameIdResolver classNameIdResolver = clazz;
        ClassNameIdResolver classNameIdResolver2 = clazz;
        Class<?> clazz = object.getClass();
        return classNameIdResolver._idFrom(object, clazz, classNameIdResolver2._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) {
        return this._typeFromId(string, databindContext);
    }

    public JavaType _typeFromId(String string, DatabindContext databindContext) {
        ClassNameIdResolver classNameIdResolver = this;
        JavaType javaType = classNameIdResolver._baseType;
        PolymorphicTypeValidator polymorphicTypeValidator = classNameIdResolver._subTypeValidator;
        if ((javaType = databindContext.resolveAndValidateSubType(javaType, string, polymorphicTypeValidator)) == null && databindContext instanceof DeserializationContext) {
            return ((DeserializationContext)databindContext).handleUnknownTypeId(this._baseType, string, this, "no such class found");
        }
        return javaType;
    }

    public String _idFrom(Object object, Class<?> clazz, TypeFactory typeFactory) {
        String string;
        if (ClassUtil.isEnumType(clazz) && !clazz.isEnum()) {
            clazz = clazz.getSuperclass();
        }
        if ((string = clazz.getName()).startsWith(JAVA_UTIL_PKG)) {
            if (object instanceof EnumSet) {
                string = typeFactory.constructCollectionType(EnumSet.class, ClassUtil.findEnumType((EnumSet)object)).toCanonical();
            } else if (object instanceof EnumMap) {
                string = typeFactory.constructMapType(EnumMap.class, ClassUtil.findEnumType((EnumMap)object), Object.class).toCanonical();
            }
        } else if (string.indexOf(36) >= 0 && ClassUtil.getOuterClass(clazz) != null && ClassUtil.getOuterClass(this._baseType.getRawClass()) == null) {
            string = this._baseType.getRawClass().getName();
        }
        return string;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

