/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype.impl;

import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.privatefasterxml.jackson.databind.type.TypeFactory;

public class MinimalClassNameIdResolver
extends ClassNameIdResolver {
    protected final String _basePackageName;
    protected final String _basePackagePrefix;

    public MinimalClassNameIdResolver(JavaType object, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        super((JavaType)object, typeFactory, polymorphicTypeValidator);
        object = ((JavaType)object).getRawClass().getName();
        int n2 = ((String)object).lastIndexOf(46);
        if (n2 < 0) {
            MinimalClassNameIdResolver minimalClassNameIdResolver = this;
            minimalClassNameIdResolver._basePackageName = "";
            minimalClassNameIdResolver._basePackagePrefix = ".";
        } else {
            this._basePackagePrefix = ((String)object).substring(0, n2 + 1);
            this._basePackageName = ((String)object).substring(0, n2);
        }
    }

    public static MinimalClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new MinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.MINIMAL_CLASS;
    }

    @Override
    public String idFromValue(Object object) {
        if (((String)(object = object.getClass().getName())).startsWith(this._basePackagePrefix)) {
            return ((String)object).substring(this._basePackagePrefix.length() - 1);
        }
        return object;
    }

    @Override
    public JavaType _typeFromId(String string, DatabindContext databindContext) {
        if (string.startsWith(".")) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            int n2 = string.length();
            stringBuilder = new StringBuilder(this._basePackageName.length() + n2);
            if (this._basePackageName.isEmpty()) {
                stringBuilder2.append(string.substring(1));
            } else {
                stringBuilder2.append(this._basePackageName).append(string);
            }
            string = stringBuilder2.toString();
        }
        return super._typeFromId(string, databindContext);
    }
}

