/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype.impl;

import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.annotation.NoClass;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsArrayTypeSerializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsDeductionTypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsExistingPropertyTypeSerializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsExternalTypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsExternalTypeSerializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.AsWrapperTypeSerializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.impl.TypeNameIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.impl.a;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.util.Collection;

public class StdTypeResolverBuilder
implements TypeResolverBuilder<StdTypeResolverBuilder> {
    protected JsonTypeInfo.Id _idType;
    protected JsonTypeInfo.As _includeAs;
    protected String _typeProperty;
    protected boolean _typeIdVisible = false;
    protected Class<?> _defaultImpl;
    protected TypeIdResolver _customIdResolver;

    public StdTypeResolverBuilder() {
    }

    public StdTypeResolverBuilder(JsonTypeInfo.Id id, JsonTypeInfo.As as, String string) {
        this._idType = id;
        this._includeAs = as;
        this._typeProperty = string;
    }

    public StdTypeResolverBuilder(StdTypeResolverBuilder stdTypeResolverBuilder, Class<?> clazz) {
        this._idType = stdTypeResolverBuilder._idType;
        this._includeAs = stdTypeResolverBuilder._includeAs;
        this._typeProperty = stdTypeResolverBuilder._typeProperty;
        this._typeIdVisible = stdTypeResolverBuilder._typeIdVisible;
        this._customIdResolver = stdTypeResolverBuilder._customIdResolver;
        this._defaultImpl = clazz;
    }

    public static StdTypeResolverBuilder noTypeInfoBuilder() {
        return new StdTypeResolverBuilder().init(JsonTypeInfo.Id.NONE, null);
    }

    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo.Id id, TypeIdResolver typeIdResolver) {
        if (id != null) {
            this._idType = id;
            this._customIdResolver = typeIdResolver;
            this._typeProperty = id.getDefaultPropertyName();
            return this;
        }
        throw new IllegalArgumentException("idType cannot be null");
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig object, JavaType javaType, Collection<NamedType> collection) {
        Object object2;
        if (((StdTypeResolverBuilder)object2)._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        if (javaType.isPrimitive() && !((StdTypeResolverBuilder)object2).allowPrimitiveTypes((MapperConfig<?>)object, javaType)) {
            return null;
        }
        StdTypeResolverBuilder stdTypeResolverBuilder = object2;
        object = stdTypeResolverBuilder.idResolver((MapperConfig<?>)object, javaType, ((StdTypeResolverBuilder)object2).subTypeValidator((MapperConfig<?>)object), collection, true, false);
        if (stdTypeResolverBuilder._idType == JsonTypeInfo.Id.DEDUCTION) {
            object2 = ((StdTypeResolverBuilder)object2)._typeProperty;
            return new AsExistingPropertyTypeSerializer((TypeIdResolver)object, null, (String)object2);
        }
        switch (a.a[((StdTypeResolverBuilder)object2)._includeAs.ordinal()]) {
            default: {
                throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)((StdTypeResolverBuilder)object2)._includeAs));
            }
            case 5: {
                object2 = ((StdTypeResolverBuilder)object2)._typeProperty;
                return new AsExistingPropertyTypeSerializer((TypeIdResolver)object, null, (String)object2);
            }
            case 4: {
                object2 = ((StdTypeResolverBuilder)object2)._typeProperty;
                return new AsExternalTypeSerializer((TypeIdResolver)object, null, (String)object2);
            }
            case 3: {
                return new AsWrapperTypeSerializer((TypeIdResolver)object, null);
            }
            case 2: {
                object2 = ((StdTypeResolverBuilder)object2)._typeProperty;
                return new AsPropertyTypeSerializer((TypeIdResolver)object, null, (String)object2);
            }
            case 1: 
        }
        return new AsArrayTypeSerializer((TypeIdResolver)object, null);
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, Collection<NamedType> object) {
        Object object2;
        if (((StdTypeResolverBuilder)object2)._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        if (javaType.isPrimitive() && !((StdTypeResolverBuilder)object2).allowPrimitiveTypes(deserializationConfig, javaType)) {
            return null;
        }
        StdTypeResolverBuilder stdTypeResolverBuilder = object2;
        TypeIdResolver typeIdResolver = ((StdTypeResolverBuilder)object2).idResolver(deserializationConfig, javaType, ((StdTypeResolverBuilder)object2).verifyBaseTypeValidity(deserializationConfig, javaType), (Collection<NamedType>)object, false, true);
        JavaType javaType2 = stdTypeResolverBuilder.defineDefaultImpl(deserializationConfig, javaType);
        if (stdTypeResolverBuilder._idType == JsonTypeInfo.Id.DEDUCTION) {
            return new AsDeductionTypeDeserializer(javaType, typeIdResolver, javaType2, deserializationConfig, (Collection<NamedType>)object);
        }
        switch (a.a[((StdTypeResolverBuilder)object2)._includeAs.ordinal()]) {
            default: {
                throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)((StdTypeResolverBuilder)object2)._includeAs));
            }
            case 4: {
                StdTypeResolverBuilder stdTypeResolverBuilder2 = object2;
                object2 = stdTypeResolverBuilder2._typeProperty;
                boolean bl = stdTypeResolverBuilder2._typeIdVisible;
                return new AsExternalTypeDeserializer(javaType, typeIdResolver, (String)object2, bl, javaType2);
            }
            case 3: {
                StdTypeResolverBuilder stdTypeResolverBuilder3 = object2;
                object2 = stdTypeResolverBuilder3._typeProperty;
                boolean bl = stdTypeResolverBuilder3._typeIdVisible;
                return new AsWrapperTypeDeserializer(javaType, typeIdResolver, (String)object2, bl, javaType2);
            }
            case 2: 
            case 5: {
                StdTypeResolverBuilder stdTypeResolverBuilder4 = object2;
                object2 = stdTypeResolverBuilder4._typeProperty;
                boolean bl = stdTypeResolverBuilder4._typeIdVisible;
                object = stdTypeResolverBuilder4._includeAs;
                return new AsPropertyTypeDeserializer(javaType, typeIdResolver, (String)object2, bl, javaType2, (JsonTypeInfo.As)((Object)object));
            }
            case 1: 
        }
        StdTypeResolverBuilder stdTypeResolverBuilder5 = object2;
        object2 = stdTypeResolverBuilder5._typeProperty;
        boolean bl = stdTypeResolverBuilder5._typeIdVisible;
        return new AsArrayTypeDeserializer(javaType, typeIdResolver, (String)object2, bl, javaType2);
    }

    public JavaType defineDefaultImpl(DeserializationConfig deserializationConfig, JavaType javaType) {
        Class<?> clazz = this._defaultImpl;
        if (clazz != null) {
            if (clazz != Void.class && clazz != NoClass.class) {
                if (javaType.hasRawClass(clazz)) {
                    return javaType;
                }
                if (javaType.isTypeOrSuperTypeOf(this._defaultImpl)) {
                    return deserializationConfig.getTypeFactory().constructSpecializedType(javaType, this._defaultImpl);
                }
                if (javaType.hasRawClass(this._defaultImpl)) {
                    return javaType;
                }
            } else {
                return deserializationConfig.getTypeFactory().constructType(this._defaultImpl);
            }
        }
        if (deserializationConfig.isEnabled(MapperFeature.USE_BASE_TYPE_AS_DEFAULT_IMPL) && !javaType.isAbstract()) {
            return javaType;
        }
        return null;
    }

    @Override
    public StdTypeResolverBuilder inclusion(JsonTypeInfo.As as) {
        if (as != null) {
            this._includeAs = as;
            return this;
        }
        throw new IllegalArgumentException("includeAs cannot be null");
    }

    @Override
    public StdTypeResolverBuilder typeProperty(String string) {
        if (string == null || string.isEmpty()) {
            string = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = string;
        return this;
    }

    @Override
    public StdTypeResolverBuilder defaultImpl(Class<?> clazz) {
        this._defaultImpl = clazz;
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeIdVisibility(boolean bl) {
        this._typeIdVisible = bl;
        return this;
    }

    @Override
    public StdTypeResolverBuilder withDefaultImpl(Class<?> clazz) {
        if (this._defaultImpl == clazz) {
            return this;
        }
        ClassUtil.verifyMustOverride(StdTypeResolverBuilder.class, this, "withDefaultImpl");
        return new StdTypeResolverBuilder(this, clazz);
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl;
    }

    public String getTypeProperty() {
        return this._typeProperty;
    }

    public boolean isTypeIdVisible() {
        return this._typeIdVisible;
    }

    public TypeIdResolver idResolver(MapperConfig<?> mapperConfig, JavaType javaType, PolymorphicTypeValidator polymorphicTypeValidator, Collection<NamedType> collection, boolean bl, boolean bl2) {
        Object object = this._customIdResolver;
        if (object != null) {
            return object;
        }
        object = this._idType;
        if (object != null) {
            switch (a.b[((Enum)object).ordinal()]) {
                default: {
                    throw new IllegalStateException("Do not know how to construct standard type id resolver for idType: " + (Object)((Object)this._idType));
                }
                case 5: {
                    return null;
                }
                case 4: {
                    return TypeNameIdResolver.construct(mapperConfig, javaType, collection, bl, bl2);
                }
                case 3: {
                    return MinimalClassNameIdResolver.construct(javaType, mapperConfig, polymorphicTypeValidator);
                }
                case 1: 
                case 2: 
            }
            return ClassNameIdResolver.construct(javaType, mapperConfig, polymorphicTypeValidator);
        }
        throw new IllegalStateException("Cannot build, 'init()' not yet called");
    }

    public PolymorphicTypeValidator subTypeValidator(MapperConfig<?> mapperConfig) {
        return mapperConfig.getPolymorphicTypeValidator();
    }

    public PolymorphicTypeValidator verifyBaseTypeValidity(MapperConfig<?> mapperConfig, JavaType javaType) {
        StdTypeResolverBuilder stdTypeResolverBuilder = this;
        PolymorphicTypeValidator polymorphicTypeValidator = stdTypeResolverBuilder.subTypeValidator(mapperConfig);
        Enum enum_ = stdTypeResolverBuilder._idType;
        if (enum_ == JsonTypeInfo.Id.CLASS || enum_ == JsonTypeInfo.Id.MINIMAL_CLASS) {
            enum_ = polymorphicTypeValidator.validateBaseType(mapperConfig, javaType);
            if (enum_ == PolymorphicTypeValidator.Validity.DENIED) {
                return this.reportInvalidBaseType(mapperConfig, javaType, polymorphicTypeValidator);
            }
            if (enum_ == PolymorphicTypeValidator.Validity.ALLOWED) {
                return LaissezFaireSubTypeValidator.instance;
            }
        }
        return polymorphicTypeValidator;
    }

    public PolymorphicTypeValidator reportInvalidBaseType(MapperConfig<?> mapperConfig, JavaType javaType, PolymorphicTypeValidator polymorphicTypeValidator) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ClassUtil.classNameOf(polymorphicTypeValidator);
        objectArray[1] = ClassUtil.classNameOf(javaType.getRawClass());
        throw new IllegalArgumentException(String.format("Configured `PolymorphicTypeValidator` (of type %s) denied resolution of all subtypes of base type %s", objectArray2));
    }

    public boolean allowPrimitiveTypes(MapperConfig<?> mapperConfig, JavaType javaType) {
        return false;
    }
}

