/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype.impl;

import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TypeDeserializerBase
extends TypeDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeIdResolver _idResolver;
    protected final JavaType _baseType;
    protected final BeanProperty _property;
    protected final JavaType _defaultImpl;
    protected final String _typePropertyName;
    protected final boolean _typeIdVisible;
    protected final Map<String, JsonDeserializer<Object>> _deserializers;
    protected JsonDeserializer<Object> _defaultImplDeserializer;

    public TypeDeserializerBase(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl, JavaType javaType2) {
        TypeDeserializerBase typeDeserializerBase = this;
        TypeDeserializerBase typeDeserializerBase2 = this;
        this._baseType = javaType;
        this._idResolver = typeIdResolver;
        this._typePropertyName = ClassUtil.nonNullString(string);
        typeDeserializerBase2._typeIdVisible = bl;
        typeDeserializerBase2._deserializers = new ConcurrentHashMap<String, JsonDeserializer<Object>>(16, 0.75f, 2);
        typeDeserializerBase._defaultImpl = javaType2;
        typeDeserializerBase._property = null;
    }

    public TypeDeserializerBase(TypeDeserializerBase typeDeserializerBase, BeanProperty beanProperty) {
        this._baseType = typeDeserializerBase._baseType;
        this._idResolver = typeDeserializerBase._idResolver;
        this._typePropertyName = typeDeserializerBase._typePropertyName;
        this._typeIdVisible = typeDeserializerBase._typeIdVisible;
        this._deserializers = typeDeserializerBase._deserializers;
        this._defaultImpl = typeDeserializerBase._defaultImpl;
        this._defaultImplDeserializer = typeDeserializerBase._defaultImplDeserializer;
        this._property = beanProperty;
    }

    @Override
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    public String baseTypeName() {
        return this._baseType.getRawClass().getName();
    }

    @Override
    public final String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return ClassUtil.rawClass(this._defaultImpl);
    }

    @Override
    public boolean hasDefaultImpl() {
        return this._defaultImpl != null;
    }

    public JavaType baseType() {
        return this._baseType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("; base-type:").append(this._baseType);
        stringBuilder.append("; id-resolver: ").append(this._idResolver);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JsonDeserializer<Object> _findDeserializer(DeserializationContext object, String string) {
        Object object2;
        block4: {
            void var2_3;
            block6: {
                Object object3;
                block7: {
                    block5: {
                        object2 = this._deserializers.get(var2_3);
                        if (object2 != null) break block4;
                        object2 = this._idResolver.typeFromId((DatabindContext)object3, (String)var2_3);
                        if (object2 != null) break block5;
                        object2 = this._findDefaultImplDeserializer((DeserializationContext)object3);
                        if (object2 != null) break block6;
                        object2 = this._handleUnknownTypeId((DeserializationContext)object3, (String)var2_3);
                        if (object2 == null) {
                            return NullifyingDeserializer.instance;
                        }
                        break block7;
                    }
                    JavaType javaType = this._baseType;
                    if (javaType != null && javaType.getClass() == object2.getClass() && !((JavaType)object2).hasGenericTypes()) {
                        try {
                            JsonDeserializer<Object> jsonDeserializer = object2;
                            object2 = this._baseType;
                            object2 = ((DeserializationContext)object3).constructSpecializedType((JavaType)object2, ((JavaType)((Object)jsonDeserializer)).getRawClass());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            JsonDeserializer<Object> jsonDeserializer = object3;
                            JavaType javaType2 = this._baseType;
                            object3 = illegalArgumentException.getMessage();
                            throw ((DeserializationContext)((Object)jsonDeserializer)).invalidTypeIdException(javaType2, (String)var2_3, (String)object3);
                        }
                    }
                }
                object2 = object3 = ((DeserializationContext)object3).findContextualValueDeserializer((JavaType)object2, this._property);
            }
            this._deserializers.put((String)var2_3, (JsonDeserializer<Object>)object2);
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JsonDeserializer<Object> _findDefaultImplDeserializer(DeserializationContext serializable) {
        JavaType javaType = this._defaultImpl;
        if (javaType == null) {
            if (!serializable.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
                return NullifyingDeserializer.instance;
            }
            return null;
        }
        if (ClassUtil.isBogusClass(javaType.getRawClass())) {
            return NullifyingDeserializer.instance;
        }
        TypeDeserializerBase typeDeserializerBase = this;
        javaType = typeDeserializerBase._defaultImpl;
        synchronized (javaType) {
            Throwable throwable2;
            block7: {
                block6: {
                    try {
                        if (typeDeserializerBase._defaultImplDeserializer != null) break block6;
                        DeserializationContext deserializationContext = serializable;
                        TypeDeserializerBase typeDeserializerBase2 = this;
                        serializable = typeDeserializerBase2._defaultImpl;
                        this._defaultImplDeserializer = deserializationContext.findContextualValueDeserializer((JavaType)serializable, typeDeserializerBase2._property);
                    }
                    catch (Throwable throwable2) {
                        break block7;
                    }
                }
                return this._defaultImplDeserializer;
            }
            throw throwable2;
        }
    }

    @Deprecated
    public Object _deserializeWithNativeTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonParser jsonParser2 = jsonParser;
        return this._deserializeWithNativeTypeId(jsonParser2, deserializationContext, jsonParser2.getTypeId());
    }

    public Object _deserializeWithNativeTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object jsonDeserializer) {
        if (jsonDeserializer == null) {
            jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
            if (jsonDeserializer == null) {
                return deserializationContext.reportInputMismatch(this.baseType(), "No (native) type id found when one was expected for polymorphic type handling", new Object[0]);
            }
        } else {
            jsonDeserializer = jsonDeserializer instanceof String ? (String)((Object)jsonDeserializer) : String.valueOf(jsonDeserializer);
            jsonDeserializer = this._findDeserializer(deserializationContext, (String)((Object)jsonDeserializer));
        }
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    public JavaType _handleUnknownTypeId(DeserializationContext object, String string) {
        String string2 = serializable._idResolver.getDescForKnownTypeIds();
        string2 = string2 == null ? "type ids are not statically known" : "known type ids = ".concat(string2);
        BeanProperty beanProperty = serializable._property;
        if (beanProperty != null) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string2;
            objectArray[1] = beanProperty.getName();
            string2 = String.format("%s (for POJO property '%s')", objectArray2);
        }
        DeserializationContext deserializationContext = object;
        TypeDeserializerBase typeDeserializerBase = serializable;
        Serializable serializable = typeDeserializerBase._baseType;
        object = typeDeserializerBase._idResolver;
        return deserializationContext.handleUnknownTypeId((JavaType)serializable, string, (TypeIdResolver)object, string2);
    }

    public JavaType _handleMissingTypeId(DeserializationContext deserializationContext, String string) {
        TypeDeserializerBase typeDeserializerBase = serializable;
        Serializable serializable = typeDeserializerBase._baseType;
        return deserializationContext.handleMissingTypeId((JavaType)serializable, typeDeserializerBase._idResolver, string);
    }
}

