/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.jsontype.impl;

import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class TypeNameIdResolver
extends TypeIdResolverBase {
    protected final MapperConfig<?> _config;
    protected final ConcurrentHashMap<String, String> _typeToId;
    protected final Map<String, JavaType> _idToType;
    protected final boolean _caseInsensitive;

    public TypeNameIdResolver(MapperConfig<?> mapperConfig, JavaType javaType, ConcurrentHashMap<String, String> concurrentHashMap, HashMap<String, JavaType> hashMap) {
        super(javaType, mapperConfig.getTypeFactory());
        this._config = mapperConfig;
        this._typeToId = concurrentHashMap;
        this._idToType = hashMap;
        this._caseInsensitive = mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
    }

    public static TypeNameIdResolver construct(MapperConfig<?> mapperConfig, JavaType javaType, Collection<NamedType> object, boolean bl, boolean bl2) {
        if (bl != bl2) {
            HashMap<String, JavaType> hashMap;
            ConcurrentHashMap<String, String> concurrentHashMap;
            if (bl) {
                ConcurrentHashMap<String, String> concurrentHashMap2;
                concurrentHashMap = concurrentHashMap2;
                concurrentHashMap2 = new ConcurrentHashMap<String, String>();
                hashMap = null;
            } else {
                ConcurrentHashMap<String, String> concurrentHashMap3;
                HashMap<String, JavaType> hashMap2;
                hashMap = hashMap2;
                hashMap2 = new HashMap<String, JavaType>();
                concurrentHashMap = concurrentHashMap3;
                concurrentHashMap3 = new ConcurrentHashMap<String, String>(4);
            }
            boolean bl3 = mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    JavaType javaType2;
                    Object object2 = (NamedType)object.next();
                    Class<?> clazz = ((NamedType)object2).getType();
                    object2 = ((NamedType)object2).hasName() ? ((NamedType)object2).getName() : TypeNameIdResolver._defaultTypeId(clazz);
                    if (bl) {
                        concurrentHashMap.put(clazz.getName(), (String)object2);
                    }
                    if (!bl2) continue;
                    if (bl3) {
                        object2 = ((String)object2).toLowerCase();
                    }
                    if ((javaType2 = hashMap.get(object2)) != null && clazz.isAssignableFrom(javaType2.getRawClass())) continue;
                    hashMap.put((String)object2, mapperConfig.constructType(clazz));
                }
            }
            return new TypeNameIdResolver(mapperConfig, javaType, concurrentHashMap, hashMap);
        }
        throw new IllegalArgumentException();
    }

    public static String _defaultTypeId(Class<?> object) {
        int n2 = ((String)(object = ((Class)object).getName())).lastIndexOf(46);
        if (n2 >= 0) {
            object = ((String)object).substring(n2 + 1);
        }
        return object;
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    @Override
    public String idFromValue(Object object) {
        return this.idFromClass(object.getClass());
    }

    public String idFromClass(Class<?> object) {
        if (object == null) {
            return null;
        }
        String string = ((Class)object).getName();
        Object object2 = this._typeToId.get(string);
        if (object2 == null) {
            TypeNameIdResolver typeNameIdResolver = this;
            object = typeNameIdResolver._typeFactory.constructType((Type)object).getRawClass();
            if (typeNameIdResolver._config.isAnnotationProcessingEnabled()) {
                TypeNameIdResolver typeNameIdResolver2 = this;
                object2 = typeNameIdResolver2._config.introspectClassAnnotations((Class<?>)object);
                object2 = typeNameIdResolver2._config.getAnnotationIntrospector().findTypeName(((BeanDescription)object2).getClassInfo());
            }
            if (object2 == null) {
                object2 = object = TypeNameIdResolver._defaultTypeId(object);
            }
            this._typeToId.put(string, (String)object2);
        }
        return object2;
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        if (object == null) {
            return this.idFromClass(clazz);
        }
        return this.idFromValue(object);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) {
        return this._typeFromId(string);
    }

    public JavaType _typeFromId(String string) {
        if (this._caseInsensitive) {
            string = string.toLowerCase();
        }
        return this._idToType.get(string);
    }

    @Override
    public String getDescForKnownTypeIds() {
        TreeSet treeSet;
        TypeNameIdResolver typeNameIdResolver = treeSet2;
        TreeSet treeSet2 = treeSet;
        treeSet = new TreeSet();
        for (Map.Entry<String, JavaType> entry : typeNameIdResolver._idToType.entrySet()) {
            if (!entry.getValue().isConcrete()) continue;
            treeSet2.add(entry.getKey());
        }
        return ((Object)treeSet2).toString();
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getClass().getName();
        objectArray[1] = this._idToType;
        return String.format("[%s; id-to-type=%s]", objectArray2);
    }
}

