/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.module;

import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.deser.Deserializers;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.ArrayType;
import com.privatefasterxml.jackson.databind.type.ClassKey;
import com.privatefasterxml.jackson.databind.type.CollectionLikeType;
import com.privatefasterxml.jackson.databind.type.CollectionType;
import com.privatefasterxml.jackson.databind.type.MapLikeType;
import com.privatefasterxml.jackson.databind.type.MapType;
import com.privatefasterxml.jackson.databind.type.ReferenceType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleDeserializers
extends Deserializers.Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected HashMap<ClassKey, JsonDeserializer<?>> _classMappings;
    protected boolean _hasEnumDeserializer;

    public SimpleDeserializers() {
        this._classMappings = null;
        this._hasEnumDeserializer = false;
    }

    public SimpleDeserializers(Map<Class<?>, JsonDeserializer<?>> map) {
        SimpleDeserializers simpleDeserializers = this;
        simpleDeserializers._classMappings = null;
        simpleDeserializers._hasEnumDeserializer = false;
        simpleDeserializers.addDeserializers(map);
    }

    private final JsonDeserializer<?> _find(JavaType javaType) {
        Serializable serializable = ((SimpleDeserializers)serializable)._classMappings;
        if (serializable == null) {
            return null;
        }
        return (JsonDeserializer)((HashMap)serializable).get(new ClassKey(javaType.getRawClass()));
    }

    public <T> void addDeserializer(Class<T> clazz, JsonDeserializer<? extends T> jsonDeserializer) {
        ClassKey classKey;
        ClassKey classKey2 = classKey;
        classKey = new ClassKey(clazz);
        if (this._classMappings == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            this._classMappings = hashMap2;
        }
        this._classMappings.put(classKey2, jsonDeserializer);
        if (clazz == Enum.class) {
            this._hasEnumDeserializer = true;
        }
    }

    public void addDeserializers(Map<Class<?>, JsonDeserializer<?>> object) {
        for (Map.Entry entry : object.entrySet()) {
            this.addDeserializer((Class)entry.getKey(), (JsonDeserializer)entry.getValue());
        }
    }

    @Override
    public JsonDeserializer<?> findArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this._find(arrayType);
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        return this._find(javaType);
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this._find(collectionType);
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this._find(collectionLikeType);
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(Class<?> clazz, DeserializationConfig object, BeanDescription beanDescription) {
        object = this._classMappings;
        if (object == null) {
            return null;
        }
        if ((object = (JsonDeserializer)((HashMap)object).get(new ClassKey(clazz))) == null && this._hasEnumDeserializer && clazz.isEnum()) {
            object = this._classMappings.get(new ClassKey(Enum.class));
        }
        return object;
    }

    @Override
    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Serializable serializable = ((SimpleDeserializers)serializable)._classMappings;
        if (serializable == null) {
            return null;
        }
        return (JsonDeserializer)((HashMap)serializable).get(new ClassKey(clazz));
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this._find(referenceType);
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this._find(mapType);
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this._find(mapLikeType);
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        Serializable serializable = ((SimpleDeserializers)serializable)._classMappings;
        return serializable != null && ((HashMap)serializable).containsKey(new ClassKey(clazz));
    }
}

