/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.module;

import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.Module;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.privatefasterxml.jackson.databind.module.SimpleDeserializers;
import com.privatefasterxml.jackson.databind.module.SimpleKeyDeserializers;
import com.privatefasterxml.jackson.databind.module.SimpleSerializers;
import com.privatefasterxml.jackson.databind.module.SimpleValueInstantiators;
import com.privatefasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleModule
extends Module
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicInteger MODULE_ID_SEQ = new AtomicInteger(1);
    protected final String _name;
    protected final Version _version;
    protected final boolean _hasExplicitName;
    protected SimpleSerializers _serializers;
    protected SimpleDeserializers _deserializers;
    protected SimpleSerializers _keySerializers;
    protected SimpleKeyDeserializers _keyDeserializers;
    protected SimpleAbstractTypeResolver _abstractTypes;
    protected SimpleValueInstantiators _valueInstantiators;
    protected BeanDeserializerModifier _deserializerModifier;
    protected BeanSerializerModifier _serializerModifier;
    protected HashMap<Class<?>, Class<?>> _mixins;
    protected LinkedHashSet<NamedType> _subtypes;
    protected PropertyNamingStrategy _namingStrategy;

    public SimpleModule() {
        SimpleModule simpleModule = this;
        simpleModule._serializers = null;
        simpleModule._deserializers = null;
        simpleModule._keySerializers = null;
        simpleModule._keyDeserializers = null;
        simpleModule._abstractTypes = null;
        simpleModule._valueInstantiators = null;
        simpleModule._deserializerModifier = null;
        simpleModule._serializerModifier = null;
        simpleModule._mixins = null;
        simpleModule._subtypes = null;
        simpleModule._namingStrategy = null;
        String string = simpleModule.getClass() == SimpleModule.class ? "SimpleModule-" + MODULE_ID_SEQ.getAndIncrement() : this.getClass().getName();
        SimpleModule simpleModule2 = this;
        simpleModule2._name = string;
        simpleModule2._version = Version.unknownVersion();
        simpleModule2._hasExplicitName = false;
    }

    public SimpleModule(String string) {
        this(string, Version.unknownVersion());
    }

    public SimpleModule(Version version) {
        this(version.getArtifactId(), version);
    }

    public SimpleModule(String string, Version version) {
        this._serializers = null;
        this._deserializers = null;
        this._keySerializers = null;
        this._keyDeserializers = null;
        this._abstractTypes = null;
        this._valueInstantiators = null;
        this._deserializerModifier = null;
        this._serializerModifier = null;
        this._mixins = null;
        this._subtypes = null;
        this._namingStrategy = null;
        this._name = string;
        this._version = version;
        this._hasExplicitName = true;
    }

    public SimpleModule(String string, Version version, Map<Class<?>, JsonDeserializer<?>> map) {
        this(string, version, map, null);
    }

    public SimpleModule(String string, Version version, List<JsonSerializer<?>> list) {
        this(string, version, null, list);
    }

    public SimpleModule(String object, Version version, Map<Class<?>, JsonDeserializer<?>> map, List<JsonSerializer<?>> list) {
        serializable._serializers = null;
        serializable._deserializers = null;
        serializable._keySerializers = null;
        serializable._keyDeserializers = null;
        serializable._abstractTypes = null;
        serializable._valueInstantiators = null;
        serializable._deserializerModifier = null;
        serializable._serializerModifier = null;
        serializable._mixins = null;
        serializable._subtypes = null;
        serializable._namingStrategy = null;
        serializable._name = object;
        serializable._hasExplicitName = true;
        serializable._version = version;
        if (map != null) {
            SimpleDeserializers simpleDeserializers;
            object = simpleDeserializers;
            simpleDeserializers = new SimpleDeserializers(map);
            serializable._deserializers = object;
        }
        if (list != null) {
            SimpleSerializers simpleSerializers;
            SimpleModule simpleModule = serializable;
            Serializable serializable = simpleSerializers;
            simpleSerializers = new SimpleSerializers(list);
            simpleModule._serializers = serializable;
        }
    }

    @Override
    public Object getTypeId() {
        if (this._hasExplicitName) {
            return this._name;
        }
        if (this.getClass() == SimpleModule.class) {
            return this._name;
        }
        return super.getTypeId();
    }

    public void setSerializers(SimpleSerializers simpleSerializers) {
        this._serializers = simpleSerializers;
    }

    public void setDeserializers(SimpleDeserializers simpleDeserializers) {
        this._deserializers = simpleDeserializers;
    }

    public void setKeySerializers(SimpleSerializers simpleSerializers) {
        this._keySerializers = simpleSerializers;
    }

    public void setKeyDeserializers(SimpleKeyDeserializers simpleKeyDeserializers) {
        this._keyDeserializers = simpleKeyDeserializers;
    }

    public void setAbstractTypes(SimpleAbstractTypeResolver simpleAbstractTypeResolver) {
        this._abstractTypes = simpleAbstractTypeResolver;
    }

    public void setValueInstantiators(SimpleValueInstantiators simpleValueInstantiators) {
        this._valueInstantiators = simpleValueInstantiators;
    }

    public SimpleModule setDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        this._deserializerModifier = beanDeserializerModifier;
        return this;
    }

    public SimpleModule setSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        this._serializerModifier = beanSerializerModifier;
        return this;
    }

    public SimpleModule setNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this._namingStrategy = propertyNamingStrategy;
        return this;
    }

    public SimpleModule addSerializer(JsonSerializer<?> jsonSerializer) {
        SimpleModule simpleModule = this;
        simpleModule._checkNotNull(jsonSerializer, "serializer");
        if (simpleModule._serializers == null) {
            SimpleSerializers simpleSerializers;
            SimpleSerializers simpleSerializers2 = simpleSerializers;
            simpleSerializers = new SimpleSerializers();
            this._serializers = simpleSerializers2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._serializers.addSerializer(jsonSerializer);
        return simpleModule2;
    }

    public <T> SimpleModule addSerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        SimpleModule simpleModule = this;
        this._checkNotNull(clazz, "type to register serializer for");
        simpleModule._checkNotNull(jsonSerializer, "serializer");
        if (simpleModule._serializers == null) {
            SimpleSerializers simpleSerializers;
            SimpleSerializers simpleSerializers2 = simpleSerializers;
            simpleSerializers = new SimpleSerializers();
            this._serializers = simpleSerializers2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._serializers.addSerializer(clazz, jsonSerializer);
        return simpleModule2;
    }

    public <T> SimpleModule addKeySerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        SimpleModule simpleModule = this;
        this._checkNotNull(clazz, "type to register key serializer for");
        simpleModule._checkNotNull(jsonSerializer, "key serializer");
        if (simpleModule._keySerializers == null) {
            SimpleSerializers simpleSerializers;
            SimpleSerializers simpleSerializers2 = simpleSerializers;
            simpleSerializers = new SimpleSerializers();
            this._keySerializers = simpleSerializers2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._keySerializers.addSerializer(clazz, jsonSerializer);
        return simpleModule2;
    }

    public <T> SimpleModule addDeserializer(Class<T> clazz, JsonDeserializer<? extends T> jsonDeserializer) {
        SimpleModule simpleModule = this;
        this._checkNotNull(clazz, "type to register deserializer for");
        simpleModule._checkNotNull(jsonDeserializer, "deserializer");
        if (simpleModule._deserializers == null) {
            SimpleDeserializers simpleDeserializers;
            SimpleDeserializers simpleDeserializers2 = simpleDeserializers;
            simpleDeserializers = new SimpleDeserializers();
            this._deserializers = simpleDeserializers2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._deserializers.addDeserializer(clazz, jsonDeserializer);
        return simpleModule2;
    }

    public SimpleModule addKeyDeserializer(Class<?> clazz, KeyDeserializer keyDeserializer) {
        SimpleModule simpleModule = this;
        this._checkNotNull(clazz, "type to register key deserializer for");
        simpleModule._checkNotNull(keyDeserializer, "key deserializer");
        if (simpleModule._keyDeserializers == null) {
            SimpleKeyDeserializers simpleKeyDeserializers;
            SimpleKeyDeserializers simpleKeyDeserializers2 = simpleKeyDeserializers;
            simpleKeyDeserializers = new SimpleKeyDeserializers();
            this._keyDeserializers = simpleKeyDeserializers2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._keyDeserializers.addDeserializer(clazz, keyDeserializer);
        return simpleModule2;
    }

    public <T> SimpleModule addAbstractTypeMapping(Class<T> clazz, Class<? extends T> clazz2) {
        SimpleModule simpleModule = this;
        this._checkNotNull(clazz, "abstract type to map");
        simpleModule._checkNotNull(clazz2, "concrete type to map to");
        if (simpleModule._abstractTypes == null) {
            SimpleAbstractTypeResolver simpleAbstractTypeResolver;
            SimpleAbstractTypeResolver simpleAbstractTypeResolver2 = simpleAbstractTypeResolver;
            simpleAbstractTypeResolver = new SimpleAbstractTypeResolver();
            this._abstractTypes = simpleAbstractTypeResolver2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._abstractTypes = simpleModule2._abstractTypes.addMapping(clazz, clazz2);
        return simpleModule2;
    }

    public SimpleModule registerSubtypes(Class<?> ... classArray) {
        if (this._subtypes == null) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet linkedHashSet2 = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            this._subtypes = linkedHashSet2;
        }
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            SimpleModule simpleModule = this;
            Class<?> clazz = classArray[i2];
            simpleModule._checkNotNull(clazz, "subtype to register");
            ((AbstractCollection)simpleModule._subtypes).add(new NamedType(clazz));
        }
        return this;
    }

    public SimpleModule registerSubtypes(NamedType ... namedTypeArray) {
        if (this._subtypes == null) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet linkedHashSet2 = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            this._subtypes = linkedHashSet2;
        }
        int n2 = namedTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            SimpleModule simpleModule = this;
            NamedType namedType = namedTypeArray[i2];
            simpleModule._checkNotNull(namedType, "subtype to register");
            ((AbstractCollection)simpleModule._subtypes).add(namedType);
        }
        return this;
    }

    public SimpleModule registerSubtypes(Collection<Class<?>> object) {
        Serializable serializable;
        if (this._subtypes == null) {
            LinkedHashSet linkedHashSet;
            serializable = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            this._subtypes = serializable;
        }
        object = object.iterator();
        while (object.hasNext()) {
            SimpleModule simpleModule = this;
            serializable = (Class)object.next();
            simpleModule._checkNotNull(serializable, "subtype to register");
            ((AbstractCollection)simpleModule._subtypes).add(new NamedType((Class<?>)serializable));
        }
        return this;
    }

    public SimpleModule addValueInstantiator(Class<?> clazz, ValueInstantiator valueInstantiator) {
        SimpleModule simpleModule = this;
        this._checkNotNull(clazz, "class to register value instantiator for");
        simpleModule._checkNotNull(valueInstantiator, "value instantiator");
        if (simpleModule._valueInstantiators == null) {
            SimpleValueInstantiators simpleValueInstantiators;
            SimpleValueInstantiators simpleValueInstantiators2 = simpleValueInstantiators;
            simpleValueInstantiators = new SimpleValueInstantiators();
            this._valueInstantiators = simpleValueInstantiators2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._valueInstantiators = simpleModule2._valueInstantiators.addValueInstantiator(clazz, valueInstantiator);
        return simpleModule2;
    }

    public SimpleModule setMixInAnnotation(Class<?> clazz, Class<?> clazz2) {
        SimpleModule simpleModule = this;
        this._checkNotNull(clazz, "target type");
        simpleModule._checkNotNull(clazz2, "mixin class");
        if (simpleModule._mixins == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            this._mixins = hashMap2;
        }
        SimpleModule simpleModule2 = this;
        simpleModule2._mixins.put(clazz, clazz2);
        return simpleModule2;
    }

    @Override
    public String getModuleName() {
        return this._name;
    }

    @Override
    public void setupModule(Module.SetupContext setupContext) {
        PropertyNamingStrategy propertyNamingStrategy;
        LinkedHashSet<NamedType> linkedHashSet;
        BeanSerializerModifier beanSerializerModifier;
        BeanDeserializerModifier beanDeserializerModifier;
        SimpleValueInstantiators simpleValueInstantiators;
        SimpleAbstractTypeResolver simpleAbstractTypeResolver;
        SimpleKeyDeserializers simpleKeyDeserializers;
        SimpleSerializers simpleSerializers;
        SimpleDeserializers simpleDeserializers;
        SimpleSerializers object2 = ((SimpleModule)this)._serializers;
        if (object2 != null) {
            setupContext.addSerializers(object2);
        }
        if ((simpleDeserializers = ((SimpleModule)this)._deserializers) != null) {
            setupContext.addDeserializers(simpleDeserializers);
        }
        if ((simpleSerializers = ((SimpleModule)this)._keySerializers) != null) {
            setupContext.addKeySerializers(simpleSerializers);
        }
        if ((simpleKeyDeserializers = ((SimpleModule)this)._keyDeserializers) != null) {
            setupContext.addKeyDeserializers(simpleKeyDeserializers);
        }
        if ((simpleAbstractTypeResolver = ((SimpleModule)this)._abstractTypes) != null) {
            setupContext.addAbstractTypeResolver(simpleAbstractTypeResolver);
        }
        if ((simpleValueInstantiators = ((SimpleModule)this)._valueInstantiators) != null) {
            setupContext.addValueInstantiators(simpleValueInstantiators);
        }
        if ((beanDeserializerModifier = ((SimpleModule)this)._deserializerModifier) != null) {
            setupContext.addBeanDeserializerModifier(beanDeserializerModifier);
        }
        if ((beanSerializerModifier = ((SimpleModule)this)._serializerModifier) != null) {
            setupContext.addBeanSerializerModifier(beanSerializerModifier);
        }
        if ((linkedHashSet = ((SimpleModule)this)._subtypes) != null && ((AbstractCollection)linkedHashSet).size() > 0) {
            LinkedHashSet<NamedType> linkedHashSet2 = ((SimpleModule)this)._subtypes;
            setupContext.registerSubtypes(((AbstractCollection)linkedHashSet2).toArray(new NamedType[((AbstractCollection)linkedHashSet2).size()]));
        }
        if ((propertyNamingStrategy = ((SimpleModule)this)._namingStrategy) != null) {
            setupContext.setNamingStrategy(propertyNamingStrategy);
        }
        if ((this = ((SimpleModule)this)._mixins) != null) {
            for (Map.Entry entry : ((HashMap)this).entrySet()) {
                setupContext.setMixInAnnotations((Class)entry.getKey(), (Class)entry.getValue());
            }
        }
    }

    @Override
    public Version version() {
        return this._version;
    }

    public void _checkNotNull(Object object, String string) {
        if (object != null) {
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        throw new IllegalArgumentException(String.format("Cannot pass `null` as %s", objectArray2));
    }
}

