/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.module;

import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.Serializers;
import com.privatefasterxml.jackson.databind.type.ArrayType;
import com.privatefasterxml.jackson.databind.type.ClassKey;
import com.privatefasterxml.jackson.databind.type.CollectionLikeType;
import com.privatefasterxml.jackson.databind.type.CollectionType;
import com.privatefasterxml.jackson.databind.type.MapLikeType;
import com.privatefasterxml.jackson.databind.type.MapType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class SimpleSerializers
extends Serializers.Base
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected HashMap<ClassKey, JsonSerializer<?>> _classMappings;
    protected HashMap<ClassKey, JsonSerializer<?>> _interfaceMappings;
    protected boolean _hasEnumSerializer;

    public SimpleSerializers() {
        this._classMappings = null;
        this._interfaceMappings = null;
        this._hasEnumSerializer = false;
    }

    public SimpleSerializers(List<JsonSerializer<?>> list) {
        SimpleSerializers simpleSerializers = this;
        simpleSerializers._classMappings = null;
        simpleSerializers._interfaceMappings = null;
        simpleSerializers._hasEnumSerializer = false;
        simpleSerializers.addSerializers(list);
    }

    public void addSerializer(JsonSerializer<?> jsonSerializer) {
        Class<?> clazz = jsonSerializer.handledType();
        if (clazz != null && clazz != Object.class) {
            this._addSerializer(clazz, jsonSerializer);
            return;
        }
        throw new IllegalArgumentException("JsonSerializer of type " + jsonSerializer.getClass().getName() + " does not define valid handledType() -- must either register with method that takes type argument  or make serializer extend 'com.privatefasterxml.jackson.databind.ser.std.StdSerializer'");
    }

    public <T> void addSerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        this._addSerializer(clazz, jsonSerializer);
    }

    public void addSerializers(List<JsonSerializer<?>> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.addSerializer((JsonSerializer)object.next());
        }
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig serializable, JavaType jsonSerializer, BeanDescription object) {
        ClassKey classKey;
        serializable = ((JavaType)((Object)jsonSerializer)).getRawClass();
        object = classKey;
        classKey = new ClassKey((Class<?>)serializable);
        if (((Class)serializable).isInterface()) {
            jsonSerializer = this._interfaceMappings;
            if (jsonSerializer != null && (jsonSerializer = (JsonSerializer)((HashMap)((Object)jsonSerializer)).get(object)) != null) {
                return jsonSerializer;
            }
        } else {
            Object object2 = this._classMappings;
            if (object2 != null) {
                if ((object2 = ((HashMap)object2).get(object)) != null) {
                    return object2;
                }
                if (this._hasEnumSerializer && ((JavaType)((Object)jsonSerializer)).isEnumType()) {
                    ((ClassKey)object).reset(Enum.class);
                    jsonSerializer = this._classMappings.get(object);
                    if (jsonSerializer != null) {
                        return jsonSerializer;
                    }
                }
                for (jsonSerializer = serializable; jsonSerializer != null; jsonSerializer = ((Class)((Object)jsonSerializer)).getSuperclass()) {
                    ((ClassKey)object).reset((Class<?>)((Object)jsonSerializer));
                    object2 = this._classMappings.get(object);
                    if (object2 == null) continue;
                    return object2;
                }
            }
        }
        if (this._interfaceMappings != null) {
            jsonSerializer = this._findInterfaceMapping((Class<?>)serializable, (ClassKey)object);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            if (!((Class)serializable).isInterface()) {
                while ((serializable = ((Class)serializable).getSuperclass()) != null) {
                    jsonSerializer = this._findInterfaceMapping((Class<?>)serializable, (ClassKey)object);
                    if (jsonSerializer == null) continue;
                    return jsonSerializer;
                }
            }
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return this.findSerializer(serializationConfig, arrayType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return this.findSerializer(serializationConfig, collectionType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig serializationConfig, CollectionLikeType collectionLikeType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return this.findSerializer(serializationConfig, collectionLikeType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        return this.findSerializer(serializationConfig, mapType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig serializationConfig, MapLikeType mapLikeType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        return this.findSerializer(serializationConfig, mapLikeType, beanDescription);
    }

    public JsonSerializer<?> _findInterfaceMapping(Class<?> classArray, ClassKey classKey) {
        for (Class<?> clazz : classArray.getInterfaces()) {
            classKey.reset(clazz);
            JsonSerializer<?> jsonSerializer = this._interfaceMappings.get(classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            JsonSerializer<?> object = this._findInterfaceMapping(clazz, classKey);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void _addSerializer(Class<?> serializable, JsonSerializer<?> jsonSerializer) {
        ClassKey classKey;
        ClassKey classKey2 = classKey;
        classKey = new ClassKey((Class<?>)serializable);
        if (serializable.isInterface()) {
            if (this._interfaceMappings == null) {
                HashMap hashMap;
                serializable = hashMap;
                hashMap = new HashMap();
                this._interfaceMappings = serializable;
            }
            this._interfaceMappings.put(classKey2, jsonSerializer);
        } else {
            if (this._classMappings == null) {
                HashMap hashMap;
                HashMap hashMap2 = hashMap;
                hashMap = new HashMap();
                this._classMappings = hashMap2;
            }
            this._classMappings.put(classKey2, jsonSerializer);
            if (serializable == Enum.class) {
                this._hasEnumSerializer = true;
            }
        }
    }
}

