/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonPointer;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.BaseJsonNode;
import com.privatefasterxml.jackson.databind.node.ContainerNode;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.node.JsonNodeType;
import com.privatefasterxml.jackson.databind.node.MissingNode;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.util.RawValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
        ArrayList arrayList;
        Iterable<JsonNode> iterable = arrayList;
        arrayList = new ArrayList();
        v1._children = iterable;
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, int n2) {
        super(jsonNodeFactory);
        ArrayList arrayList;
        Iterable<JsonNode> iterable = arrayList;
        arrayList = new ArrayList(n2);
        v1._children = iterable;
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, List<JsonNode> list) {
        super(jsonNodeFactory);
        this._children = list;
    }

    @Override
    public JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode arrayNode;
        ArrayNode arrayNode2 = arrayNode;
        arrayNode = new ArrayNode(((ContainerNode)this)._nodeFactory);
        for (JsonNode jsonNode : ((ArrayNode)this)._children) {
            arrayNode2._children.add((JsonNode)jsonNode.deepCopy());
        }
        return arrayNode2;
    }

    @Deprecated
    public ObjectNode with(String string) {
        JsonPointer jsonPointer = this._jsonPointerIfValid(string);
        if (jsonPointer != null) {
            return this.withObject(jsonPointer);
        }
        return (ObjectNode)super.with(string);
    }

    public ArrayNode withArray(String string) {
        JsonPointer jsonPointer = this._jsonPointerIfValid(string);
        if (jsonPointer != null) {
            return this.withArray(jsonPointer);
        }
        return (ArrayNode)super.withArray(string);
    }

    @Override
    public ObjectNode _withObject(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl) {
        if (jsonPointer2.matches()) {
            return null;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ObjectNode objectNode = ((BaseJsonNode)jsonNode)._withObject(jsonPointer, jsonPointer2.tail(), overwriteMode, bl);
            if (objectNode != null) {
                return objectNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl, jsonNode);
        }
        return this._withObjectAddTailElement(jsonPointer2, bl);
    }

    @Override
    public ArrayNode _withArray(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl) {
        if (jsonPointer2.matches()) {
            return this;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ArrayNode arrayNode = ((BaseJsonNode)jsonNode)._withArray(jsonPointer, jsonPointer2.tail(), overwriteMode, bl);
            if (arrayNode != null) {
                return arrayNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl, jsonNode);
        }
        return this._withArrayAddTailElement(jsonPointer2, bl);
    }

    public ObjectNode _withObjectAddTailElement(JsonPointer serializable, boolean bl) {
        int n2 = serializable.getMatchingIndex();
        if (n2 < 0) {
            return null;
        }
        if ((serializable = serializable.tail()).matches()) {
            serializable = this.objectNode();
            this._withXxxSetArrayElement(n2, (JsonNode)((Object)serializable));
            return serializable;
        }
        if (bl && serializable.mayMatchElement()) {
            ArrayNode arrayNode = this.arrayNode();
            this._withXxxSetArrayElement(n2, arrayNode);
            return arrayNode._withObjectAddTailElement((JsonPointer)serializable, bl);
        }
        ObjectNode objectNode = this.objectNode();
        this._withXxxSetArrayElement(n2, objectNode);
        return objectNode._withObjectAddTailProperty((JsonPointer)serializable, bl);
    }

    public ArrayNode _withArrayAddTailElement(JsonPointer serializable, boolean bl) {
        int n2 = serializable.getMatchingIndex();
        if (n2 < 0) {
            return null;
        }
        if ((serializable = serializable.tail()).matches()) {
            serializable = this.arrayNode();
            this._withXxxSetArrayElement(n2, (JsonNode)((Object)serializable));
            return serializable;
        }
        if (bl && serializable.mayMatchElement()) {
            ArrayNode arrayNode = this.arrayNode();
            this._withXxxSetArrayElement(n2, arrayNode);
            return arrayNode._withArrayAddTailElement((JsonPointer)serializable, bl);
        }
        ArrayNode arrayNode = this.arrayNode();
        this._withXxxSetArrayElement(n2, arrayNode);
        return arrayNode._withArrayAddTailElement((JsonPointer)serializable, bl);
    }

    public void _withXxxSetArrayElement(int n2, JsonNode jsonNode) {
        if (n2 >= this.size()) {
            int n3 = this._nodeFactory.getMaxElementIndexForInsert();
            if (n2 > n3) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = n2;
                objectArray[1] = n3;
                this._reportWrongNodeOperation("Too big Array index (%d; max %d) to use for insert with `JsonPointer`", objectArray2);
            }
            while (n2 >= this.size()) {
                this.addNull();
            }
        }
        this.set(n2, jsonNode);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return null;
    }

    @Override
    public JsonNode path(String string) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = this._children.size();
        return (JsonNode)this._reportRequiredViolation("No value at index #%d [0, %d) of `ArrayNode`", objectArray2);
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode iterable) {
        if (!(iterable instanceof ArrayNode)) {
            return false;
        }
        iterable = (ArrayNode)iterable;
        int n2 = ((ArrayNode)iterable2)._children.size();
        if (((ArrayNode)iterable).size() != n2) {
            return false;
        }
        Iterable<JsonNode> iterable2 = ((ArrayNode)iterable2)._children;
        iterable = ((ArrayNode)iterable)._children;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((JsonNode)iterable2.get(i2)).equals(comparator, (JsonNode)iterable.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        List<JsonNode> list = this._children;
        int n2 = list.size();
        jsonGenerator.writeStartArray(this, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            list.get(i2).serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        ArrayNode arrayNode = writableTypeId;
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(writableTypeId, JsonToken.START_ARRAY));
        Iterator<JsonNode> iterator = arrayNode._children.iterator();
        while (iterator.hasNext()) {
            ((BaseJsonNode)iterator.next()).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public JsonNode findValue(String string) {
        Iterator<JsonNode> iterator = ((ArrayNode)((Object)iterator))._children.iterator();
        while (iterator.hasNext()) {
            JsonNode jsonNode = ((JsonNode)iterator.next()).findValue(string);
            if (jsonNode == null) continue;
            return jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        Iterator<JsonNode> iterator = ((ArrayNode)((Object)iterator))._children.iterator();
        while (iterator.hasNext()) {
            list = ((JsonNode)iterator.next()).findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        Iterator<JsonNode> iterator = ((ArrayNode)((Object)iterator))._children.iterator();
        while (iterator.hasNext()) {
            list = ((JsonNode)iterator.next()).findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        Iterator<JsonNode> iterator = ((ArrayNode)((Object)iterator))._children.iterator();
        while (iterator.hasNext()) {
            JsonNode jsonNode = ((JsonNode)iterator.next()).findParent(string);
            if (jsonNode == null) continue;
            return (ObjectNode)jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        Iterator<JsonNode> iterator = ((ArrayNode)((Object)iterator))._children.iterator();
        while (iterator.hasNext()) {
            list = ((JsonNode)iterator.next()).findParents(string, list);
        }
        return list;
    }

    public JsonNode set(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.set(n2, jsonNode);
        }
        throw new IndexOutOfBoundsException("Illegal index " + n2 + ", array size " + this.size());
    }

    public ArrayNode add(JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        ArrayNode arrayNode = this;
        arrayNode._add(jsonNode);
        return arrayNode;
    }

    public ArrayNode addAll(ArrayNode arrayNode) {
        ArrayNode arrayNode2 = this;
        arrayNode2._children.addAll(arrayNode._children);
        return arrayNode2;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((JsonNode)object.next());
        }
        return this;
    }

    public ArrayNode insert(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        ArrayNode arrayNode = this;
        arrayNode._insert(n2, jsonNode);
        return arrayNode;
    }

    public JsonNode remove(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.remove(n2);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        ArrayNode arrayNode = this;
        arrayNode._children.clear();
        return arrayNode;
    }

    public ArrayNode addArray() {
        ArrayNode arrayNode = this.arrayNode();
        this._add(arrayNode);
        return arrayNode;
    }

    public ObjectNode addObject() {
        ObjectNode objectNode = this.objectNode();
        this._add(objectNode);
        return objectNode;
    }

    public ArrayNode addPOJO(Object object) {
        object = object == null ? this.nullNode() : this.pojoNode(object);
        return this._add((JsonNode)object);
    }

    public ArrayNode addRawValue(RawValue jsonSerializable) {
        jsonSerializable = jsonSerializable == null ? this.nullNode() : this.rawValueNode((RawValue)jsonSerializable);
        return this._add((JsonNode)jsonSerializable);
    }

    public ArrayNode addNull() {
        ArrayNode arrayNode = this;
        return arrayNode._add(arrayNode.nullNode());
    }

    public ArrayNode add(short s2) {
        ArrayNode arrayNode = this;
        return arrayNode._add(arrayNode.numberNode(s2));
    }

    public ArrayNode add(Short serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((short)serializable);
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(int n2) {
        ArrayNode arrayNode = this;
        return arrayNode._add(arrayNode.numberNode(n2));
    }

    public ArrayNode add(Integer serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((int)serializable);
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(long l2) {
        ArrayNode arrayNode = this;
        return arrayNode._add(arrayNode.numberNode(l2));
    }

    public ArrayNode add(Long serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((long)serializable);
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(float f2) {
        ArrayNode arrayNode = this;
        return arrayNode._add(arrayNode.numberNode(f2));
    }

    public ArrayNode add(Float serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode(serializable.floatValue());
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(double d2) {
        ArrayNode arrayNode = this;
        return arrayNode._add(arrayNode.numberNode(d2));
    }

    public ArrayNode add(Double serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((double)serializable);
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(BigDecimal serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigDecimal)serializable);
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(BigInteger serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigInteger)serializable);
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(String object) {
        object = object == null ? this.nullNode() : this.textNode((String)object);
        return this._add((JsonNode)object);
    }

    public ArrayNode add(boolean bl) {
        ArrayNode arrayNode = this;
        return arrayNode._add(arrayNode.booleanNode(bl));
    }

    public ArrayNode add(Boolean serializable) {
        serializable = serializable == null ? this.nullNode() : this.booleanNode((boolean)serializable);
        return this._add((JsonNode)((Object)serializable));
    }

    public ArrayNode add(byte[] object) {
        object = object == null ? (Object)this.nullNode() : (Object)this.binaryNode((byte[])object);
        return this._add((JsonNode)object);
    }

    public ArrayNode insertArray(int n2) {
        ArrayNode arrayNode = this.arrayNode();
        this._insert(n2, arrayNode);
        return arrayNode;
    }

    public ObjectNode insertObject(int n2) {
        ObjectNode objectNode = this.objectNode();
        this._insert(n2, objectNode);
        return objectNode;
    }

    public ArrayNode insertNull(int n2) {
        return this._insert(n2, this.nullNode());
    }

    public ArrayNode insertPOJO(int n2, Object object) {
        object = object == null ? this.nullNode() : this.pojoNode(object);
        return this._insert(n2, (JsonNode)object);
    }

    public ArrayNode insertRawValue(int n2, RawValue jsonSerializable) {
        jsonSerializable = jsonSerializable == null ? this.nullNode() : this.rawValueNode((RawValue)jsonSerializable);
        return this._insert(n2, (JsonNode)jsonSerializable);
    }

    public ArrayNode insert(int n2, short s2) {
        return this._insert(n2, this.numberNode(s2));
    }

    public ArrayNode insert(int n2, Short serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((short)serializable);
        return this._insert(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode insert(int n2, int n3) {
        return this._insert(n2, this.numberNode(n3));
    }

    public ArrayNode insert(int n2, Integer serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((int)serializable);
        return this._insert(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode insert(int n2, long l2) {
        return this._insert(n2, this.numberNode(l2));
    }

    public ArrayNode insert(int n2, Long serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((long)serializable);
        return this._insert(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode insert(int n2, float f2) {
        return this._insert(n2, this.numberNode(f2));
    }

    public ArrayNode insert(int n2, Float serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode(serializable.floatValue());
        return this._insert(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode insert(int n2, double d2) {
        return this._insert(n2, this.numberNode(d2));
    }

    public ArrayNode insert(int n2, Double serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((double)serializable);
        return this._insert(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode insert(int n2, BigDecimal serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigDecimal)serializable);
        return this._insert(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode insert(int n2, BigInteger serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigInteger)serializable);
        return this._insert(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode insert(int n2, String object) {
        object = object == null ? this.nullNode() : this.textNode((String)object);
        return this._insert(n2, (JsonNode)object);
    }

    public ArrayNode insert(int n2, boolean bl) {
        return this._insert(n2, this.booleanNode(bl));
    }

    public ArrayNode insert(int n2, Boolean bl) {
        if (bl == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.booleanNode(bl));
    }

    public ArrayNode insert(int n2, byte[] byArray) {
        if (byArray == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.binaryNode(byArray));
    }

    public ArrayNode setNull(int n2) {
        return this._set(n2, this.nullNode());
    }

    public ArrayNode setPOJO(int n2, Object object) {
        object = object == null ? this.nullNode() : this.pojoNode(object);
        return this._set(n2, (JsonNode)object);
    }

    public ArrayNode setRawValue(int n2, RawValue jsonSerializable) {
        jsonSerializable = jsonSerializable == null ? this.nullNode() : this.rawValueNode((RawValue)jsonSerializable);
        return this._set(n2, (JsonNode)jsonSerializable);
    }

    public ArrayNode set(int n2, short s2) {
        return this._set(n2, this.numberNode(s2));
    }

    public ArrayNode set(int n2, Short serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((short)serializable);
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, int n3) {
        return this._set(n2, this.numberNode(n3));
    }

    public ArrayNode set(int n2, Integer serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((int)serializable);
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, long l2) {
        return this._set(n2, this.numberNode(l2));
    }

    public ArrayNode set(int n2, Long serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((long)serializable);
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, float f2) {
        return this._set(n2, this.numberNode(f2));
    }

    public ArrayNode set(int n2, Float serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode(serializable.floatValue());
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, double d2) {
        return this._set(n2, this.numberNode(d2));
    }

    public ArrayNode set(int n2, Double serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((double)serializable);
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, BigDecimal serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigDecimal)serializable);
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, BigInteger serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigInteger)serializable);
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, String object) {
        object = object == null ? this.nullNode() : this.textNode((String)object);
        return this._set(n2, (JsonNode)object);
    }

    public ArrayNode set(int n2, boolean bl) {
        return this._set(n2, this.booleanNode(bl));
    }

    public ArrayNode set(int n2, Boolean serializable) {
        serializable = serializable == null ? this.nullNode() : this.booleanNode((boolean)serializable);
        return this._set(n2, (JsonNode)((Object)serializable));
    }

    public ArrayNode set(int n2, byte[] object) {
        object = object == null ? (Object)this.nullNode() : (Object)this.binaryNode((byte[])object);
        return this._set(n2, (JsonNode)object);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)object)._children);
        }
        return false;
    }

    public boolean _childrenEqual(ArrayNode arrayNode) {
        return this._children.equals(arrayNode._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    public ArrayNode _set(int n2, JsonNode jsonNode) {
        if (n2 >= 0 && n2 < this._children.size()) {
            ArrayNode arrayNode = this;
            arrayNode._children.set(n2, jsonNode);
            return arrayNode;
        }
        throw new IndexOutOfBoundsException("Illegal index " + n2 + ", array size " + this.size());
    }

    public ArrayNode _add(JsonNode jsonNode) {
        ArrayNode arrayNode = this;
        arrayNode._children.add(jsonNode);
        return arrayNode;
    }

    public ArrayNode _insert(int n2, JsonNode jsonNode) {
        if (n2 < 0) {
            this._children.add(0, jsonNode);
        } else if (n2 >= this._children.size()) {
            this._children.add(jsonNode);
        } else {
            this._children.add(n2, jsonNode);
        }
        return this;
    }
}

