/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonPointer;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.ArrayNode;
import com.privatefasterxml.jackson.databind.node.InternalNodeMapper$WrapperForSerializer;
import com.privatefasterxml.jackson.databind.node.MissingNode;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.node.TreeTraversingParser;
import com.privatefasterxml.jackson.databind.node.a;
import com.privatefasterxml.jackson.databind.node.c;
import com.privatefasterxml.jackson.databind.node.e;
import java.io.IOException;
import java.io.Serializable;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Object writeReplace() {
        try {
            return new e(c.a.writeValueAsBytes(this));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to JDK serialize `" + this.getClass().getSimpleName() + "` value: " + iOException.getMessage(), iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonNode findPath(String string) {
        void var1_2;
        JsonNode jsonNode = this.findValue((String)var1_2);
        if (jsonNode == null) {
            return MissingNode.getInstance();
        }
        return jsonNode;
    }

    public abstract int hashCode();

    @Override
    public JsonNode required(String objectArray) {
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = this.getClass().getSimpleName();
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no fields", objectArray);
    }

    @Override
    public JsonNode required(int n2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.getClass().getSimpleName();
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no indexed values", objectArray2);
    }

    @Override
    public JsonParser traverse() {
        return new TreeTraversingParser(this);
    }

    @Override
    public JsonParser traverse(ObjectCodec objectCodec) {
        return new TreeTraversingParser(this, objectCodec);
    }

    @Override
    public abstract JsonToken asToken();

    @Override
    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public ObjectNode withObject(JsonPointer jsonPointer, JsonNode.OverwriteMode object, boolean bl) {
        if (jsonPointer.matches()) {
            if (this instanceof ObjectNode) {
                return (ObjectNode)this;
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.getClass().getName();
            this._reportWrongNodeType("Can only call `withObject()` with empty JSON Pointer on `ObjectNode`, not `%s`", objectArray2);
        }
        JsonPointer jsonPointer2 = jsonPointer;
        if ((object = this._withObject(jsonPointer2, jsonPointer2, (JsonNode.OverwriteMode)((Object)object), bl)) == null) {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray[0] = this.getClass().getName();
            objectArray[1] = jsonPointer;
            this._reportWrongNodeType("Cannot replace context node (of type `%s`) using `withObject()` with  JSON Pointer '%s'", objectArray3);
        }
        return object;
    }

    public ObjectNode _withObject(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl) {
        return null;
    }

    public void _withXxxVerifyReplace(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl, JsonNode jsonNode) {
        if (!objectArray3._withXxxMayReplace(jsonNode, overwriteMode)) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[4];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = jsonNode.getClass().getName();
            objectArray2[1] = jsonPointer2.getMatchingProperty();
            objectArray2[2] = jsonPointer;
            objectArray2[3] = overwriteMode;
            objectArray._reportWrongNodeType("Cannot replace `JsonNode` of type `%s` for property \"%s\" in JSON Pointer \"%s\" (mode `OverwriteMode.%s`)", objectArray3);
        }
    }

    public boolean _withXxxMayReplace(JsonNode jsonNode, JsonNode.OverwriteMode overwriteMode) {
        int n2 = a.a[overwriteMode.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    return true;
                }
                return jsonNode.isContainerNode() ^ true;
            }
            return jsonNode.isNull();
        }
        return false;
    }

    @Override
    public ArrayNode withArray(JsonPointer jsonPointer, JsonNode.OverwriteMode object, boolean bl) {
        if (jsonPointer.matches()) {
            if (this instanceof ArrayNode) {
                return (ArrayNode)this;
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.getClass().getName();
            this._reportWrongNodeType("Can only call `withArray()` with empty JSON Pointer on `ArrayNode`, not `%s`", objectArray2);
        }
        JsonPointer jsonPointer2 = jsonPointer;
        if ((object = this._withArray(jsonPointer2, jsonPointer2, (JsonNode.OverwriteMode)((Object)object), bl)) == null) {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray[0] = this.getClass().getName();
            objectArray[1] = jsonPointer;
            this._reportWrongNodeType("Cannot replace context node (of type `%s`) using `withArray()` with  JSON Pointer '%s'", objectArray3);
        }
        return object;
    }

    public ArrayNode _withArray(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl) {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2);

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializerProvider var2, TypeSerializer var3);

    @Override
    public String toString() {
        try {
            return c.b.writeValueAsString(new InternalNodeMapper$WrapperForSerializer(this));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public String toPrettyString() {
        try {
            return c.c.writeValueAsString(new InternalNodeMapper$WrapperForSerializer(this));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public <T> T _reportWrongNodeType(String string, Object ... objectArray) {
        throw new UnsupportedOperationException(String.format(string, objectArray));
    }

    public <T> T _reportWrongNodeOperation(String string, Object ... objectArray) {
        throw new UnsupportedOperationException(String.format(string, objectArray));
    }

    public JsonPointer _jsonPointerIfValid(String string) {
        if (!string.isEmpty() && string.charAt(0) != '/') {
            return null;
        }
        return JsonPointer.compile(string);
    }
}

