/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.Base64Variants;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.node.JsonNodeType;
import com.privatefasterxml.jackson.databind.node.ValueNode;
import java.io.Serializable;
import java.util.Arrays;

public class BinaryNode
extends ValueNode {
    private static final long serialVersionUID = 2L;
    static final BinaryNode EMPTY_BINARY_NODE = new BinaryNode(new byte[0]);
    protected final byte[] _data;

    public BinaryNode(byte[] byArray) {
        this._data = byArray;
    }

    public BinaryNode(byte[] byArray, int n2, int n3) {
        if (n2 == 0 && n3 == byArray.length) {
            ((BinaryNode)object)._data = byArray;
        } else {
            BinaryNode binaryNode = object;
            byte[] byArray2 = new byte[n3];
            Object object = byArray2;
            binaryNode._data = byArray2;
            System.arraycopy(byArray, n2, object, 0, n3);
        }
    }

    public static BinaryNode valueOf(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(byArray);
    }

    public static BinaryNode valueOf(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        if (n3 == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(byArray, n2, n3);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.BINARY;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() {
        return this._data;
    }

    @Override
    public String asText() {
        return Base64Variants.getDefaultVariant().encode(this._data, false);
    }

    @Override
    public final void serialize(JsonGenerator object, SerializerProvider serializerProvider) {
        JsonGenerator jsonGenerator = object;
        BinaryNode binaryNode = serializable;
        Serializable serializable = serializerProvider.getConfig().getBase64Variant();
        object = binaryNode._data;
        int n2 = ((Object)object).length;
        jsonGenerator.writeBinary((Base64Variant)serializable, (byte[])object, 0, n2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BinaryNode)) {
            return false;
        }
        return Arrays.equals(((BinaryNode)object)._data, this._data);
    }

    @Override
    public int hashCode() {
        Object object = ((BinaryNode)object)._data;
        return ((BinaryNode)object)._data == null ? -1 : ((Object)object).length;
    }
}

