/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.io.NumberOutput;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.node.NumericNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FloatNode
extends NumericNode {
    protected final float _value;

    public FloatNode(float f2) {
        this._value = f2;
    }

    public static FloatNode valueOf(float f2) {
        return new FloatNode(f2);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.FLOAT;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean canConvertToInt() {
        float f2;
        float f3 = this._value;
        return f2 >= -2.1474836E9f && f3 <= 2.1474836E9f;
    }

    @Override
    public boolean canConvertToLong() {
        float f2;
        float f3 = this._value;
        return f2 >= -9.223372E18f && f3 <= 9.223372E18f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canConvertToExactIntegral() {
        if (Float.isNaN(this._value)) return false;
        if (Float.isInfinite(this._value)) return false;
        float f2 = this._value;
        if (f2 != (float)Math.round(f2)) return false;
        return true;
    }

    @Override
    public Number numberValue() {
        return Float.valueOf(this._value);
    }

    @Override
    public short shortValue() {
        return (short)this._value;
    }

    @Override
    public int intValue() {
        return (int)this._value;
    }

    @Override
    public long longValue() {
        return (long)this._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.decimalValue().toBigInteger();
    }

    @Override
    public String asText() {
        return NumberOutput.toString(this._value);
    }

    @Override
    public boolean isNaN() {
        return Float.isNaN(this._value) || Float.isInfinite(this._value);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof FloatNode) {
            float f2 = ((FloatNode)object)._value;
            return Float.compare(this._value, f2) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this._value);
    }
}

